/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.model.Configuration;
import com.util.StringUtils;

public class Settings
extends Configuration {
    private static final String SETTINGS_CONF = "settings.conf";

    private Settings() {
        super(SETTINGS_CONF);
        this.init();
    }

    public static Settings getInstance() {
        return SettingsHolder.instance;
    }

    public void init() {
        this.createSection("gui");
        this.setDefaultValue("gui", "width", "904");
        this.setDefaultValue("gui", "height", "475");
        this.setDefaultValue("gui", "x", "10");
        this.setDefaultValue("gui", "y", "10");
        this.setDefaultBooleanValue("gui", "maximized", false);
        this.setDefaultValue("gui", "column1width", "150");
        this.setDefaultValue("gui", "column2width", "48");
        this.setDefaultValue("gui", "column3width", "100");
        this.setDefaultValue("gui", "column4width", "100");
        this.setDefaultValue("gui", "column5width", "70");
        this.setDefaultValue("gui", "column6width", "40");
        this.setDefaultValue("gui", "column7width", "60");
        this.setDefaultValue("gui", "column8width", "60");
        this.setDefaultValue("gui", "column9width", "38");
        this.setDefaultValue("gui", "column2_1width", "300");
        this.setDefaultValue("gui", "column2_2width", "250");
        this.setDefaultValue("gui", "column2_3width", "50");
        this.setDefaultValue("gui", "column3_1width", "500");
        this.setDefaultValue("gui", "column3_2width", "50");
        this.setDefaultIntValue("gui", "sortcolumn", 0);
        this.setDefaultBooleanValue("gui", "sortascending", true);
        this.setDefaultValue("gui", "columnorder", "0 1 2 3 4 5 6 7 8");
        this.setDefaultValue("gui", "sashweights", "777 222");
        this.createSection("communication");
        this.setDefaultValue("communication", "port", "4740");
        this.createSection("profile");
        this.setDefaultValue("profile", "priority_active", "lowest lower normal higher highest pause");
        this.setDefaultValue("profile", "priority_inactive", "lowest lower normal higher highest pause");
        this.setDefaultValue("profile", "output", "ddraw direct3d overlay opengl openglhq openglnb surface");
        this.setDefaultValue("profile", "frameskip", "0 1 2 3 4 5 6 7 8 9 10");
        this.setDefaultValue("profile", "scaler", "none normal2x normal3x advmame2x advmame3x advinterp2x advinterp3x tv2x tv3x rgb2x rgb3x scan2x scan3x supereagle super2xsai 2xsai hq2x hq3x hardware2x hardware3x tv tvadvmame2x normal4x");
        this.setDefaultValue("profile", "pixelshader", "none 2xsai.fx 2xsai_srgb.fx bilinear.fx cartoon.fx gs2x.fx gs4x.fx gs4xcolor.fx gs4xcolorfilter.fx gs4xcolorscale.fx gs4xfilter.fx gs4xscale.fx matrix.fx mcgreen.fx mcorange.fx point.fx scale2x.fx scale2x_ps14.fx sketch.fx");
        this.setDefaultValue("profile", "fullresolution", "original 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
        this.setDefaultValue("profile", "windowresolution", "original 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
        this.setDefaultValue("profile", "svgachipset", "none et3000 et4000 et4000new pvga1a s3");
        this.setDefaultValue("profile", "videoram", "256 512 1024 2048 3072 4096");
        this.setDefaultValue("profile", "vsyncmode", "off on force");
        this.setDefaultValue("profile", "machine", "cga hercules pcjr tandy vga");
        this.setDefaultValue("profile", "core", "dynamic full normal simple auto");
        this.setDefaultValue("profile", "cycles", "500 750 1000 2000 3000 4000 5000 7500 10000 12500 15000 17500 20000 25000 30000 32500 35000 40000 45000 50000 55000 60000 auto max");
        this.setDefaultValue("profile", "cycles_up", "20 50 100 500 1000 2000 5000 10000");
        this.setDefaultValue("profile", "cycles_down", "20 50 100 500 1000 2000 5000 10000");
        this.setDefaultValue("profile", "memsize", "0 1 2 4 8 16 32 63");
        this.setDefaultValue("profile", "umb", "false true max");
        this.setDefaultValue("profile", "loadfix_value", "1 63 127");
        this.setDefaultValue("profile", "rate", "11025 22050 44100");
        this.setDefaultValue("profile", "blocksize", "512 1024 2048 3072 4096 8192");
        this.setDefaultValue("profile", "prebuffer", "10");
        this.setDefaultValue("profile", "mpu401", "none intelligent uart");
        this.setDefaultValue("profile", "device", "alsa default coreaudio mt32 none oss win32");
        this.setDefaultValue("profile", "mt32rate", "11025 22050 44100");
        this.setDefaultValue("profile", "sbtype", "none sb1 sb2 sbpro1 sbpro2 sb16");
        this.setDefaultValue("profile", "oplrate", "11025 22050 44100");
        this.setDefaultValue("profile", "oplmode", "auto cms opl2 dualopl2 opl3");
        this.setDefaultValue("profile", "sbbase", "210 220 240 260 280");
        this.setDefaultValue("profile", "irq", "3 5 7 10 11");
        this.setDefaultValue("profile", "dma", "0 1 3");
        this.setDefaultValue("profile", "hdma", "5 6 7");
        this.setDefaultValue("profile", "gusrate", "11025 22050 44100");
        this.setDefaultValue("profile", "gusbase", "210 220 240 260 280");
        this.setDefaultValue("profile", "irq1", "3 5 7 10 11");
        this.setDefaultValue("profile", "irq2", "3 5 7 10 11");
        this.setDefaultValue("profile", "dma1", "0 1 3");
        this.setDefaultValue("profile", "dma2", "0 1 3");
        this.setDefaultValue("profile", "pcrate", "11025 22050 44100");
        this.setDefaultValue("profile", "tandy", "auto off on");
        this.setDefaultValue("profile", "tandyrate", "11025 22050 44100");
        this.setDefaultValue("profile", "sensitivity", "10 20 30 40 50 60 70 80 90 100 125 150 175 200 250 300 350 400 450 500 550 600 700 800 900 1000");
        this.setDefaultValue("profile", "joysticktype", "none 2axis 4axis ch fcs");
        this.setDefaultValue("profile", "mount_type", "cdrom dir floppy");
        this.setDefaultValue("profile", "zipmount_type", "cdrom dir floppy");
    }

    public void setIntValues(String sectionTitle, String sectionItem, int[] values) {
        this.setValue(sectionTitle, sectionItem, StringUtils.intArrayToString(values));
    }

    public int[] getIntValues(String sectionTitle, String sectionItem) {
        return StringUtils.stringToIntArray(this.getValue(sectionTitle, sectionItem));
    }

    public String[] getValues(String sectionTitle, String sectionItem) {
        return this.getValue(sectionTitle, sectionItem).split(" ");
    }

    public void save() {
        this.saveToFile(SETTINGS_CONF, true);
    }

    /* synthetic */ Settings(Settings settings) {
        this();
    }

    private static class SettingsHolder {
        private static Settings instance = new Settings(null);

        private SettingsHolder() {
        }
    }
}

