/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.gui.StreamGobbler;
import com.model.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUtils {
    public static String getCwd() {
        try {
            return new File(".").getCanonicalPath();
        }
        catch (IOException ex) {
            System.err.println("Couldn't get current working directory!!\n");
            return null;
        }
    }

    public static void createDir(String dir) {
        if (!new File(dir).exists() && !new File(dir).mkdirs()) {
            System.err.println("Couldn't create " + dir + " directory!!\n");
        }
    }

    public static void copyFiles(String srcDir, String dstDir) {
        File[] srcFiles = new File(srcDir).listFiles();
        if (srcFiles != null) {
            File[] fileArray = srcFiles;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File src = fileArray[n];
                if (src.isFile()) {
                    FileUtils.copy(src, new File(String.valueOf(dstDir) + src.getName()));
                }
                ++n;
            }
        }
    }

    public static void copy(File source, File dest) {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            try {
                in = new FileInputStream(source).getChannel();
                out = new FileOutputStream(dest).getChannel();
                in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
            }
            catch (IOException e) {
                System.err.println("Couldn't copy file " + source + " to directory " + dest + "!!\n");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void removeFile(String filename) {
        File file = new File(filename);
        if (file.isFile()) {
            file.delete();
        }
    }

    public static void removeDir(String dirname) {
        File dir = new File(dirname);
        if (dir.isDirectory()) {
            dir.delete();
        }
    }

    public static boolean isExistingReadableFile(String filename) {
        File file = new File(filename);
        return file.isFile() && file.canRead();
    }

    public static void executeCommand(List<String> execCommands, String cwd, boolean waitFor) throws IOException {
        String[] rtCmds = new String[execCommands.size()];
        int i = 0;
        while (i < execCommands.size()) {
            rtCmds[i] = execCommands.get(i);
            System.out.print(String.valueOf(rtCmds[i]) + " ");
            ++i;
        }
        System.out.println();
        File dir = cwd != null ? new File(cwd) : null;
        Process proc = Runtime.getRuntime().exec(rtCmds, null, dir);
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "DOSBox stderr");
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "DOSBox stdout");
        outputGobbler.start();
        errorGobbler.start();
        if (waitFor) {
            try {
                proc.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void setCapturesDir(Configuration profileConf, int profileId, String srcCap) {
        String capturesDir = FileUtils.getCwd();
        if (capturesDir != null) {
            capturesDir = String.valueOf(capturesDir) + File.separatorChar + "captures" + File.separatorChar + profileId;
            profileConf.setValue("dosbox", "captures", capturesDir);
            FileUtils.createDir(capturesDir);
            if (srcCap != null) {
                FileUtils.copyFiles(srcCap, "captures" + File.separatorChar + profileId + File.separatorChar);
            }
        }
    }

    public static String getProfileConfig(String filename) {
        String result = FileUtils.getCwd();
        if (result != null) {
            result = String.valueOf(result) + File.separatorChar + "profiles" + File.separatorChar + filename;
        }
        return result;
    }
}

