/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.model.Configuration;
import com.model.Settings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class SettingsDialog
extends Dialog {
    private Text port;
    private int previousSelection = -1;
    private Text values;
    private Configuration conf;
    private List options;
    protected Object result;
    protected Shell shell;

    public SettingsDialog(Shell parent, int style) {
        super(parent, style);
    }

    public SettingsDialog(Shell parent) {
        this(parent, 0);
    }

    public Object open() {
        this.conf = new Configuration(Settings.getInstance());
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout(new BorderLayout(0, 0));
        this.shell.setSize(500, 375);
        this.shell.setText("Settings");
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText("General");
        Composite composite = new Composite(tabFolder, 0);
        composite.setLayout(new GridLayout());
        generalTabItem.setControl(composite);
        Group dosboxGroup = new Group(composite, 0);
        dosboxGroup.setText("DOSBox");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        dosboxGroup.setLayout(gridLayout);
        Label showConsoleLabel = new Label(dosboxGroup, 0);
        showConsoleLabel.setText("Hide DOSBox Status Window");
        final Button console = new Button(dosboxGroup, 32);
        console.setSelection(this.conf.getBooleanValue("dosbox", "hideconsole"));
        Group sendToGroup = new Group(composite, 0);
        sendToGroup.setText("Send To (Requires restart)");
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 2;
        sendToGroup.setLayout(gridLayout_2);
        Label enableCommunicationLabel = new Label(sendToGroup, 0);
        enableCommunicationLabel.setText("Enable communication port");
        final Button portEnabled = new Button(sendToGroup, 32);
        portEnabled.setSelection(this.conf.getBooleanValue("communication", "port_enabled"));
        portEnabled.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsDialog.this.port.setEnabled(portEnabled.getSelection());
            }
        });
        Label portnumberLabel = new Label(sendToGroup, 0);
        portnumberLabel.setText("Port");
        this.port = new Text(sendToGroup, 2048);
        this.port.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.port.setText(this.conf.getValue("communication", "port"));
        this.port.setEnabled(portEnabled.getSelection());
        TabItem dynamicOptionsTabItem = new TabItem(tabFolder, 0);
        dynamicOptionsTabItem.setText("Dynamic options");
        Composite composite_1 = new Composite(tabFolder, 0);
        composite_1.setLayout(new FillLayout());
        dynamicOptionsTabItem.setControl(composite_1);
        Group dynamicOptionsGroup = new Group(composite_1, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        dynamicOptionsGroup.setLayout(gridLayout_1);
        dynamicOptionsGroup.setText("Dynamic options");
        Label optionsLabel = new Label(dynamicOptionsGroup, 0);
        optionsLabel.setText("Options");
        Label valuesLabel = new Label(dynamicOptionsGroup, 0);
        valuesLabel.setText("Values");
        this.options = new List(dynamicOptionsGroup, 2560);
        this.options.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsDialog.this.storeValues();
                SettingsDialog.this.previousSelection = SettingsDialog.this.options.getSelectionIndex();
                SettingsDialog.this.values.setText(SettingsDialog.this.conf.getMultilineValues("profile", SettingsDialog.this.options.getItem(SettingsDialog.this.previousSelection)));
            }
        });
        this.options.setLayoutData(new GridData(4, 4, true, true));
        String[] stringArray = this.conf.getItems("profile");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String s = stringArray[n];
            this.options.add(s);
            ++n;
        }
        this.values = new Text(dynamicOptionsGroup, 2818);
        this.values.setLayoutData(new GridData(4, 4, true, true));
        Composite composite_7 = new Composite(this.shell, 0);
        composite_7.setLayout(new RowLayout());
        composite_7.setLayoutData("South");
        Button okButton = new Button(composite_7, 0);
        okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsDialog.this.conf.setBooleanValue("dosbox", "hideconsole", console.getSelection());
                SettingsDialog.this.conf.setBooleanValue("communication", "port_enabled", portEnabled.getSelection());
                SettingsDialog.this.conf.setValue("communication", "port", SettingsDialog.this.port.getText());
                SettingsDialog.this.storeValues();
                Settings settings = Settings.getInstance();
                settings.updateWithValuesFrom(SettingsDialog.this.conf);
                SettingsDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(okButton);
        RowData rowData = new RowData();
        rowData.width = 80;
        okButton.setLayoutData(rowData);
        okButton.setText("OK");
        Button cancelButton = new Button(composite_7, 0);
        RowData rowData_1 = new RowData();
        rowData_1.width = 80;
        cancelButton.setLayoutData(rowData_1);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsDialog.this.shell.close();
            }
        });
    }

    private void storeValues() {
        if (this.previousSelection != -1) {
            this.conf.setMultilineValues("profile", this.options.getItem(this.previousSelection), this.values.getText(), this.values.getLineDelimiter());
        }
    }
}

