/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeMap;

public class Configuration {
    protected HashMap<String, Section> sections = new HashMap();
    public static final String AUTOEXEC = "autoexec";

    public HashMap getSections() {
        return this.sections;
    }

    public Configuration(Configuration conf) {
        for (String key : conf.sections.keySet()) {
            this.sections.put(key, new Section(conf.sections.get(key)));
        }
    }

    public Configuration() {
    }

    public Configuration(String file) {
        this.parseConfigurationFile(file, true);
    }

    public Configuration(String file, boolean toLowerCase) {
        this.parseConfigurationFile(file, toLowerCase);
    }

    public void saveToFile(String file) {
        this.saveToFile(file, false);
    }

    public void saveToFile(String file, boolean ordered) {
        try {
            BufferedWriter configData = new BufferedWriter(new FileWriter(file));
            if (ordered) {
                configData.write(this.toStringOrdered());
            } else {
                configData.write(this.toString());
            }
            configData.flush();
            configData.close();
        }
        catch (IOException e) {
            System.err.println("Something went wrong while trying to save " + file);
            System.err.println(e.toString());
        }
    }

    public void parseConfigurationFile(String file) {
        this.parseConfigurationFile(file, true);
    }

    public void parseConfigurationFile(String file, boolean toLowerCase) {
        try {
            String textLine;
            BufferedReader configData = new BufferedReader(new FileReader(file));
            String currentSectionTitle = null;
            Section currentSection = null;
            while ((textLine = configData.readLine()) != null) {
                textLine = textLine.trim();
                String orgTextLine = textLine.trim();
                if (toLowerCase) {
                    textLine = textLine.toLowerCase();
                }
                if (textLine.length() <= 0 || textLine.startsWith("#")) continue;
                if (textLine.startsWith("[")) {
                    int start = textLine.indexOf("[");
                    int end = textLine.lastIndexOf("]");
                    if (end == -1) {
                        System.err.println("Parsing error in " + file + ", line: " + textLine);
                        continue;
                    }
                    currentSectionTitle = textLine.substring(start + 1, end);
                    if (this.sections.containsKey(currentSectionTitle)) {
                        currentSection = this.sections.get(currentSectionTitle);
                        continue;
                    }
                    currentSection = new Section();
                    this.sections.put(currentSectionTitle, currentSection);
                    continue;
                }
                if (currentSectionTitle != null) {
                    if (currentSectionTitle.equals(AUTOEXEC)) {
                        currentSection.addAutoexecItem(orgTextLine);
                        continue;
                    }
                    int end = textLine.indexOf("=");
                    if (end == -1) {
                        System.err.println("Parsing error in " + file + ", line: " + textLine);
                        continue;
                    }
                    String name = textLine.substring(0, end).trim();
                    String value = textLine.substring(end + 1).trim();
                    currentSection.sectionItems.put(name, value);
                    continue;
                }
                System.err.println("Parsing error (no section) in " + file + ", line: " + textLine);
            }
            configData.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not read " + file);
        }
        catch (IOException e) {
            System.err.println("Something went wrong while trying to read " + file);
            System.err.println(e.toString());
        }
    }

    public boolean hasValue(String sectionTitle, String sectionItem) {
        return this.sections.containsKey(sectionTitle) && this.sections.get((Object)sectionTitle).sectionItems.containsKey(sectionItem);
    }

    public String getValue(String sectionTitle, String sectionItem) {
        String result = null;
        if (this.sections.containsKey(sectionTitle)) {
            result = this.sections.get((Object)sectionTitle).sectionItems.get(sectionItem);
        }
        if (result == null) {
            return "";
        }
        return result;
    }

    public int getIntValue(String sectionTitle, String sectionItem) {
        try {
            return Integer.parseInt(this.getValue(sectionTitle, sectionItem));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean getBooleanValue(String sectionTitle, String sectionItem) {
        return Boolean.valueOf(this.getValue(sectionTitle, sectionItem));
    }

    public void createSection(String sectionTitle) {
        if (!this.sections.containsKey(sectionTitle)) {
            this.sections.put(sectionTitle, new Section());
        }
    }

    public void setDefaultValue(String sectionTitle, String sectionItem, String value) {
        if (!this.hasValue(sectionTitle, sectionItem)) {
            this.setValue(sectionTitle, sectionItem, value);
        }
    }

    public void setValue(String sectionTitle, String sectionItem, String value) {
        if (this.sections.containsKey(sectionTitle)) {
            this.sections.get((Object)sectionTitle).sectionItems.put(sectionItem, value);
        }
    }

    public void updateValue(String sectionTitle, String sectionItem, String value) {
        if (this.sections.containsKey(sectionTitle) && this.sections.get((Object)sectionTitle).sectionItems.containsKey(sectionItem)) {
            this.sections.get((Object)sectionTitle).sectionItems.put(sectionItem, value);
        }
    }

    public void setIntValue(String sectionTitle, String sectionItem, int value) {
        this.setValue(sectionTitle, sectionItem, String.valueOf(value));
    }

    public void setDefaultIntValue(String sectionTitle, String sectionItem, int value) {
        if (!this.hasValue(sectionTitle, sectionItem)) {
            this.setIntValue(sectionTitle, sectionItem, value);
        }
    }

    public void setBooleanValue(String sectionTitle, String sectionItem, boolean value) {
        this.setValue(sectionTitle, sectionItem, String.valueOf(value));
    }

    public void setDefaultBooleanValue(String sectionTitle, String sectionItem, boolean value) {
        if (!this.hasValue(sectionTitle, sectionItem)) {
            this.setBooleanValue(sectionTitle, sectionItem, value);
        }
    }

    public void removeSection(String title) {
        this.sections.remove(title);
    }

    public void removeValue(String sectionTitle, String sectionItem) {
        if (this.sections.containsKey(sectionTitle)) {
            Section sec = this.sections.get(sectionTitle);
            sec.sectionItems.remove(sectionItem);
            if (sec.sectionItems.isEmpty()) {
                this.sections.remove(sectionTitle);
            }
        }
    }

    public void substract(Configuration conf) {
        for (String key : conf.sections.keySet()) {
            if (!this.sections.containsKey(key)) continue;
            Section mysec = this.sections.get(key);
            mysec.substract(conf.sections.get(key));
            if (!mysec.sectionItems.isEmpty()) continue;
            this.sections.remove(key);
        }
    }

    public String[] getItems(String section) {
        return new TreeMap<String, String>(this.sections.get((Object)section).sectionItems).keySet().toArray(new String[0]);
    }

    public String[] getValues(String sectionTitle, String sectionItem) {
        return this.getValue(sectionTitle, sectionItem).split(" ");
    }

    public String getMultilineValues(String sectionTitle, String sectionItem) {
        return StringUtils.StringArrayToString(this.getValues(sectionTitle, sectionItem));
    }

    public void setMultilineValues(String sectionTitle, String sectionItem, String values, String delimiter) {
        this.setValue(sectionTitle, sectionItem, values.replace(delimiter, " ").trim());
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        StringBuffer autoexec = new StringBuffer();
        for (String key : this.sections.keySet()) {
            if (!key.equals(AUTOEXEC)) {
                result.append("[" + key + "]\n");
                result.append(String.valueOf(this.sections.get(key).toString()) + "\n");
                continue;
            }
            autoexec.append("[" + key + "]\n");
            autoexec.append(this.sections.get(key).toString());
        }
        return String.valueOf(result.toString()) + autoexec.toString();
    }

    public String toStringOrdered() {
        StringBuffer result = new StringBuffer();
        StringBuffer autoexec = new StringBuffer();
        for (String key : this.sections.keySet()) {
            if (!key.equals(AUTOEXEC)) {
                result.append("[" + key + "]\n");
                result.append(String.valueOf(this.sections.get(key).toStringOrdered()) + "\n");
                continue;
            }
            autoexec.append("[" + key + "]\n");
            autoexec.append(this.sections.get(key).toString());
        }
        return String.valueOf(result.toString()) + autoexec.toString();
    }

    protected class Section {
        protected HashMap<String, String> sectionItems = new HashMap();

        public Section(Section sec) {
            for (String key : sec.sectionItems.keySet()) {
                this.sectionItems.put(new String(key), new String(sec.sectionItems.get(key)));
            }
        }

        public Section() {
        }

        public void addAutoexecItem(String value) {
            if (this.sectionItems.containsKey(Configuration.AUTOEXEC)) {
                this.sectionItems.put(Configuration.AUTOEXEC, String.valueOf(this.sectionItems.get(Configuration.AUTOEXEC)) + "\n" + value);
            } else {
                this.sectionItems.put(Configuration.AUTOEXEC, value);
            }
        }

        public void substract(Section sec) {
            for (String key : sec.sectionItems.keySet()) {
                if (!this.sectionItems.containsKey(key)) continue;
                String value = sec.sectionItems.get(key);
                String thisvalue = this.sectionItems.get(key);
                if (!thisvalue.equals(value)) continue;
                this.sectionItems.remove(key);
            }
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            for (String key : this.sectionItems.keySet()) {
                String value = this.sectionItems.get(key);
                if (key.equals(Configuration.AUTOEXEC)) {
                    result.append(String.valueOf(value) + "\n");
                    continue;
                }
                result.append(String.valueOf(key) + "=" + value + "\n");
            }
            return result.toString();
        }

        public String toStringOrdered() {
            StringBuffer result = new StringBuffer();
            for (String key : new TreeMap<String, String>(this.sectionItems).keySet()) {
                String value = this.sectionItems.get(key);
                if (key.equals(Configuration.AUTOEXEC)) {
                    result.append(String.valueOf(value) + "\n");
                    continue;
                }
                result.append(String.valueOf(key) + "=" + value + "\n");
            }
            return result.toString();
        }
    }
}

