/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.gui.StreamGobbler;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.DosboxVersion;
import com.model.Profile;
import com.model.Settings;
import com.util.ListUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUtils {
    public static final String CAPTURES_DIR = "captures";
    public static final String TEMPLATES_DIR = "templates";
    public static final String PROFILES_DIR = "profiles";
    public static final String CONF_EXT = ".conf";
    public static final String DOSBOX_CONF = "dosbox.conf";
    public static final String SETUP_CONF = "setup.conf";
    public static final String DFEND_PATH = "C:/Program Files/D-Fend";
    public static final String DFEND_PROFILES = "Profiles.dat";

    public static String getCwd() {
        try {
            return new File(".").getCanonicalPath();
        }
        catch (IOException ex) {
            System.err.println("Couldn't get current working directory!!\n");
            return null;
        }
    }

    public static String getCanonicalPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return new File(path).getAbsolutePath();
        }
    }

    public static void createDir(String dir) {
        if (!new File(dir).exists() && !new File(dir).mkdirs()) {
            System.err.println("Couldn't create " + dir + " directory!!\n");
        }
    }

    public static void copyFiles(String srcDir, String dstDir) {
        File[] srcFiles = new File(srcDir).listFiles();
        if (srcFiles != null) {
            File[] fileArray = srcFiles;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File src = fileArray[n];
                if (src.isFile()) {
                    FileUtils.copy(src, new File(String.valueOf(dstDir) + src.getName()));
                }
                ++n;
            }
        }
    }

    public static void copy(File source, File dest) {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            try {
                in = new FileInputStream(source).getChannel();
                out = new FileOutputStream(dest).getChannel();
                in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
            }
            catch (IOException e) {
                System.err.println("Couldn't copy file " + source + " to directory " + dest + "!!\n");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void removeFile(String filename) {
        File file = new File(filename);
        if (!file.isFile() || !file.delete()) {
            System.err.println("Couldn't delete file " + filename);
        }
    }

    public static void removeFilesInDirAndDir(String dirname) {
        File dir;
        File[] files = new File(dirname).listFiles();
        if (files != null) {
            File file;
            File[] fileArray = files;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                file = fileArray[n];
                if (file.isDirectory()) {
                    System.err.println("Directory found inside " + dirname + ", aborting removal");
                    return;
                }
                ++n;
            }
            fileArray = files;
            n = 0;
            n2 = fileArray.length;
            while (n < n2) {
                file = fileArray[n];
                if (!file.delete()) {
                    System.err.println("Couldn't delete file " + file);
                }
                ++n;
            }
        }
        if (!(dir = new File(dirname)).isDirectory() || !dir.delete()) {
            System.err.println("Couldn't delete directory " + dirname);
        }
    }

    public static boolean isExistingReadableFile(String filename) {
        File file = new File(filename);
        return file.isFile() && file.canRead();
    }

    public static void doRunDosbox(DosboxVersion dbversion) {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-conf");
        parameters.add(DOSBOX_CONF);
        FileUtils.doRunDosbox(dbversion, parameters, false);
    }

    public static void doCreateDosboxConf(DosboxVersion dbversion) {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-c");
        parameters.add("config -writeconf dosbox.conf");
        parameters.add("-c");
        parameters.add("exit");
        FileUtils.doRunDosbox(dbversion, parameters, true);
    }

    private static void doRunDosbox(DosboxVersion dbversion, List<String> parameters, boolean waitFor) {
        try {
            ArrayList<String> commandItems = new ArrayList<String>();
            commandItems.add(dbversion.getExecutable());
            commandItems.addAll(parameters);
            FileUtils.executeCommand(commandItems, dbversion.getCanonicalPath(), waitFor);
        }
        catch (IOException e) {
            System.err.println("Dosbox could not be started!!\n");
        }
    }

    public static void doRunProfile(Profile prof, List<DosboxVersion> dbversionsList, boolean setup) {
        try {
            int dbversionIndex = ListUtils.findTIDosboxVersion(dbversionsList, prof.getDbversionId());
            DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
            ArrayList<String> confs = new ArrayList<String>();
            confs.add(dbversion.getExecutable());
            if (dbversion.isMultiConfig()) {
                confs.add("-conf");
                confs.add(DOSBOX_CONF);
            }
            String filename = String.valueOf(prof.getId()) + CONF_EXT;
            if (setup && prof.hasSetupBoolean()) {
                Configuration conf = new Configuration(PROFILES_DIR + File.separatorChar + prof.getId() + CONF_EXT);
                Autoexec autoexec = new Autoexec(conf.getValue("autoexec", "autoexec"));
                autoexec.setSetup(prof.getSetup());
                autoexec.setSetupParameters(prof.getSetupParameters());
                conf.setValue("autoexec", "autoexec", autoexec.toString(true));
                conf.saveToFile(PROFILES_DIR + File.separatorChar + SETUP_CONF);
                filename = SETUP_CONF;
            }
            confs.add("-conf");
            confs.add(FileUtils.getProfileConfig(filename));
            FileUtils.executeCommand(confs, dbversion.getCanonicalPath(), false);
        }
        catch (IOException e) {
            System.err.println("Profile could not be started!!\n");
        }
    }

    private static void executeCommand(List<String> execCommands, String cwd, boolean waitFor) throws IOException {
        if (Settings.getInstance().getBooleanValue("dosbox", "hideconsole")) {
            execCommands.add("-noconsole");
        }
        String[] rtCmds = new String[execCommands.size()];
        int i = 0;
        while (i < execCommands.size()) {
            rtCmds[i] = execCommands.get(i);
            System.out.print(String.valueOf(rtCmds[i]) + " ");
            ++i;
        }
        System.out.println();
        File dir = cwd != null ? new File(cwd) : null;
        Process proc = Runtime.getRuntime().exec(rtCmds, null, dir);
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "DOSBox stderr");
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "DOSBox stdout");
        outputGobbler.start();
        errorGobbler.start();
        if (waitFor) {
            try {
                proc.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void setCapturesDir(Configuration profileConf, int profileId, String srcCap) {
        String capturesDir = FileUtils.getCwd();
        if (capturesDir != null) {
            capturesDir = String.valueOf(capturesDir) + File.separatorChar + CAPTURES_DIR + File.separatorChar + profileId;
            profileConf.setValue("dosbox", CAPTURES_DIR, capturesDir);
            FileUtils.createDir(capturesDir);
            if (srcCap != null) {
                FileUtils.copyFiles(srcCap, CAPTURES_DIR + File.separatorChar + profileId + File.separatorChar);
            }
        }
    }

    public static String getProfileConfig(String filename) {
        String result = FileUtils.getCwd();
        if (result != null) {
            result = String.valueOf(result) + File.separatorChar + PROFILES_DIR + File.separatorChar + filename;
        }
        return result;
    }
}

