/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.db.Database;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.Developer;
import com.model.DosboxVersion;
import com.model.Genre;
import com.model.Profile;
import com.model.Publisher;
import com.model.Settings;
import com.model.Status;
import com.model.Year;
import com.util.FileUtils;
import com.util.ListUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import net.jimmc.jshortcut.JShellLink;
import org.eclipse.swt.program.Program;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlatformUtils {
    public static final boolean IS_WINDOWS = File.separatorChar == '\\';
    public static final boolean IS_LINUX = File.separatorChar == '/';
    public static final String DB_EXECUTABLE = IS_WINDOWS ? "DOSBox.exe" : "dosbox";

    public static String toNativePath(String dosboxFileLocation) {
        if (IS_LINUX) {
            return dosboxFileLocation.replace('\\', File.separatorChar);
        }
        return dosboxFileLocation;
    }

    public static String toDosboxPath(String hostFileLocation) {
        if (IS_LINUX) {
            return hostFileLocation.replace('/', '\\');
        }
        return hostFileLocation;
    }

    public static void openForEditing(String file) {
        Program p = Program.findProgram(".conf");
        if (p == null) {
            p = Program.findProgram(".txt");
        }
        if (p == null) {
            p = Program.findProgram(".inf");
        }
        if (p == null) {
            p = Program.findProgram(".ini");
        }
        if (p == null) {
            p = Program.findProgram(".cfg");
        }
        if (p == null) {
            p = Program.findProgram(".java");
        }
        if (p == null) {
            p = Program.findProgram(".doc");
        }
        if (p != null) {
            p.execute(file);
        } else {
            System.err.println("Cannot open \"" + file + "\"");
        }
    }

    public static void openForBrowsing(String url) {
        Program p = Program.findProgram(".html");
        if (p != null) {
            p.execute(url);
        } else {
            System.err.println("Cannot open \"" + url + "\"");
        }
    }

    public static void createShortcut(Profile profile, List<DosboxVersion> dbversionsList) {
        int dbversionIndex = ListUtils.findTIDosboxVersion(dbversionsList, profile.getDbversionId());
        DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
        String params = "";
        if (dbversion.isMultiConfig()) {
            params = String.valueOf(params) + "-conf dosbox.conf ";
        }
        params = String.valueOf(params) + "-conf \"" + FileUtils.getProfileConfig(String.valueOf(profile.getId()) + ".conf" + "\"");
        if (Settings.getInstance().getBooleanValue("dosbox", "hideconsole")) {
            params = String.valueOf(params) + " -noconsole";
        }
        JShellLink link = new JShellLink();
        link.setFolder(JShellLink.getDirectory((String)"desktop"));
        link.setName(profile.getTitle());
        link.setPath(dbversion.getExecutable());
        link.setArguments(params);
        link.setDescription("Run " + profile.getTitle() + " in DOSBox");
        link.save();
    }

    public static void doDFendImport(String dfendProfilesFile, boolean performCleanup, DosboxVersion defaultDBVersion, Database db) {
        Configuration standardProfile = new Configuration(defaultDBVersion.getConfigFile());
        Configuration profiles = new Configuration(dfendProfilesFile, false);
        int totalProfiles = profiles.getSections().keySet().size();
        int profileNumber = 1;
        Iterator it = profiles.getSections().keySet().iterator();
        while (it.hasNext()) {
            System.out.print("progress: " + (int)((double)profileNumber++ * 100.0 / (double)totalProfiles) + "%  ");
            String title = (String)it.next();
            String profFile = profiles.getValue(title, "prof");
            String confFile = profiles.getValue(title, "conf");
            boolean favorite = profiles.getValue(title, "fav").equals("1");
            Configuration dfendExtra = new Configuration(profFile, false);
            String setup = dfendExtra.getValue("Extra", "Setup");
            String setupParams = dfendExtra.getValue("Extra", "SetupParameters");
            String notes = dfendExtra.getValue("ExtraInfo", "Notes");
            String dev = dfendExtra.getValue("ExtraInfo", "Developer");
            String pub = dfendExtra.getValue("ExtraInfo", "Publisher");
            String gen = dfendExtra.getValue("ExtraInfo", "Genre");
            String yr = dfendExtra.getValue("ExtraInfo", "Year");
            String st = "Unknown";
            String cap = dfendExtra.getValue("dosbox", "captures");
            int devIndex = -1;
            int publIndex = -1;
            int genIndex = -1;
            int yrIndex = -1;
            int statIndex = -1;
            Iterator<Developer> devIt = db.readDevelopersList().iterator();
            Iterator<Publisher> pubIt = db.readPublishersList().iterator();
            Iterator<Genre> genIt = db.readGenresList().iterator();
            Iterator<Year> yrIt = db.readYearsList().iterator();
            Iterator<Status> statIt = db.readStatusList().iterator();
            while (devIt.hasNext()) {
                Developer developer = devIt.next();
                if (!developer.getName().equals(dev)) continue;
                devIndex = developer.getId();
                break;
            }
            while (pubIt.hasNext()) {
                Publisher publisher = pubIt.next();
                if (!publisher.getName().equals(pub)) continue;
                publIndex = publisher.getId();
                break;
            }
            while (genIt.hasNext()) {
                Genre genre = genIt.next();
                if (!genre.getName().equals(gen)) continue;
                genIndex = genre.getId();
                break;
            }
            while (yrIt.hasNext()) {
                Year year = yrIt.next();
                if (!year.getYear().equals(yr)) continue;
                yrIndex = year.getId();
                break;
            }
            while (statIt.hasNext()) {
                Status stat = statIt.next();
                if (!stat.getStat().equals(st)) continue;
                statIndex = stat.getId();
                break;
            }
            int profileId = db.addOrEditProfile(title, dev, pub, gen, yr, st, setup, setupParams, notes, "", "", favorite, devIndex, publIndex, genIndex, yrIndex, statIndex, defaultDBVersion.getId(), -1);
            Configuration dfendProfile = new Configuration(confFile);
            Autoexec autoexec = new Autoexec(dfendProfile.getValue("autoexec", "autoexec"));
            dfendProfile.setValue("autoexec", "autoexec", autoexec.toString(false));
            FileUtils.setCapturesDir(dfendProfile, profileId, cap);
            if (performCleanup) {
                dfendProfile.removeSection("directserial");
                dfendProfile.removeSection("modem");
                dfendProfile.removeSection("ipx");
                dfendProfile.removeSection("sdl");
            }
            dfendProfile.removeValue("gus", "base");
            dfendProfile.removeValue("gus", "rate");
            dfendProfile.removeValue("sblaster", "base");
            dfendProfile.removeValue("sblaster", "type");
            if (dfendProfile.getValue("midi", "mpu401").equals("true")) {
                if (dfendProfile.getValue("midi", "intelligent").equals("true")) {
                    dfendProfile.setValue("midi", "mpu401", "intelligent");
                } else if (dfendProfile.getValue("midi", "intelligent").equals("false")) {
                    dfendProfile.setValue("midi", "mpu401", "uart");
                }
            } else if (dfendProfile.getValue("midi", "mpu401").equals("false")) {
                dfendProfile.setValue("midi", "mpu401", "none");
            }
            dfendProfile.removeValue("midi", "intelligent");
            if (defaultDBVersion.isMultiConfig()) {
                dfendProfile.substract(standardProfile);
            }
            dfendProfile.saveToFile("profiles" + File.separatorChar + profileId + ".conf");
        }
    }
}

