/*
 * Decompiled with CFR 0.152.
 */
package swing2swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import swing2swt.layout.AWTLayout;

public class GridLayout
extends AWTLayout {
    private int rows;
    private int columns;
    private int hgap;
    private int vgap;

    public GridLayout() {
        this(1, 0);
    }

    public GridLayout(int rows, int columns) {
        this(rows, columns, 0, 0);
    }

    public GridLayout(int rows, int columns, int hgap, int vgap) {
        if (rows == 0 && columns == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        if (rows > 0 && columns > 0) {
            columns = 0;
        }
        this.rows = rows;
        this.columns = columns;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getRows() {
        return this.rows;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setColumns(int cols) {
        if (this.rows == 0 && this.columns == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.columns = cols;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public void setRows(int rows) {
        if (rows == 0 && this.columns == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = rows;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        int nbOfVisibleChildren = 0;
        int i = 0;
        while (i < children.length) {
            ++nbOfVisibleChildren;
            ++i;
        }
        if (nbOfVisibleChildren == 0) {
            return new Point(0, 0);
        }
        int r = this.rows;
        int c = this.columns;
        if (r == 0) {
            r = nbOfVisibleChildren / c + (nbOfVisibleChildren % c == 0 ? 0 : 1);
        } else if (c == 0) {
            c = nbOfVisibleChildren / r + (nbOfVisibleChildren % r == 0 ? 0 : 1);
        }
        int width = 0;
        int height = 0;
        int i2 = 0;
        while (i2 < children.length) {
            Point size = this.getPreferredSize(children[i2], -1, -1, flushCache);
            if (size.x > width) {
                width = size.x;
            }
            if (size.y > height) {
                height = size.y;
            }
            ++i2;
        }
        return new Point(c * width + (c - 1) * this.hgap, r * height + (r - 1) * this.vgap);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle clientArea = composite.getClientArea();
        Control[] children = composite.getChildren();
        int nbOfVisibleChildren = 0;
        int i = 0;
        while (i < children.length) {
            ++nbOfVisibleChildren;
            ++i;
        }
        if (nbOfVisibleChildren == 0) {
            return;
        }
        int r = this.rows;
        int c = this.columns;
        if (r == 0) {
            r = nbOfVisibleChildren / c + (nbOfVisibleChildren % c == 0 ? 0 : 1);
        } else if (c == 0) {
            c = nbOfVisibleChildren / r + (nbOfVisibleChildren % r == 0 ? 0 : 1);
        }
        int width = (clientArea.width - (c - 1) * this.hgap) / c;
        int height = (clientArea.height - (r - 1) * this.vgap) / r;
        int x = clientArea.x;
        int y = clientArea.y;
        int i2 = 0;
        while (i2 < children.length) {
            children[i2].setBounds(x, y, width, height);
            if ((i2 + 1) % c == 0) {
                x = clientArea.x;
                y += height + this.vgap;
            } else {
                x += width + this.hgap;
            }
            ++i2;
        }
    }
}

