/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.db.Database;
import com.gui.GeneralPurposeDialogs;
import com.model.DosboxVersion;
import com.util.FileUtils;
import com.util.PlatformUtils;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditDosboxVersionDialog
extends Dialog {
    private Text path;
    private TabItem infoTabItem;
    private Text title;
    protected Shell shell;
    private Database db;
    protected Object result;

    public EditDosboxVersionDialog(Shell parent) {
        super(parent, 0);
    }

    public void setDosboxVersion(DosboxVersion dbversion) {
        this.result = dbversion;
    }

    public Object open() {
        this.db = Database.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setSize(610, 280);
        if (this.result != null) {
            this.shell.setText("Edit Dosbox version " + ((DosboxVersion)this.result).getTitle() + " (" + ((DosboxVersion)this.result).getId() + ")");
        } else {
            this.shell.setText("Add Dosbox version");
        }
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText("Info");
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout(gridLayout);
        this.infoTabItem.setControl(composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText("Title");
        this.title = new Text(composite, 2048);
        this.title.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText("Path");
        this.path = new Text(composite, 2048);
        this.path.setLayoutData(new GridData(4, 0x1000000, true, false));
        Button browseButton = new Button(composite, 0);
        browseButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(EditDosboxVersionDialog.this.shell);
                dialog.setFilterPath(EditDosboxVersionDialog.this.path.getText());
                String result = dialog.open();
                if (result != null) {
                    EditDosboxVersionDialog.this.path.setText(result);
                }
            }
        });
        browseButton.setText("Browse..");
        Label multiconfSupportLabel = new Label(composite, 0);
        multiconfSupportLabel.setText("Multiconf support");
        final Button multiconf = new Button(composite, 32);
        new Label(composite, 0);
        Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText("Default");
        final Button defaultButton = new Button(composite, 32);
        new Label(composite, 0);
        Composite composite_7 = new Composite(this.shell, 0);
        composite_7.setLayout(new RowLayout());
        composite_7.setLayoutData("South");
        Button okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(okButton);
        RowData rowData = new RowData();
        rowData.width = 80;
        okButton.setLayoutData(rowData);
        okButton.setText("OK");
        okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditDosboxVersionDialog.this.isValid()) {
                    return;
                }
                int dbversionId = EditDosboxVersionDialog.this.db.addOrEditDosboxVersion(EditDosboxVersionDialog.this.title.getText(), EditDosboxVersionDialog.this.path.getText(), multiconf.getSelection(), defaultButton.getSelection(), EditDosboxVersionDialog.this.result != null ? ((DosboxVersion)EditDosboxVersionDialog.this.result).getId() : -1);
                EditDosboxVersionDialog.this.result = new DosboxVersion(dbversionId, EditDosboxVersionDialog.this.title.getText(), EditDosboxVersionDialog.this.path.getText(), multiconf.getSelection(), defaultButton.getSelection());
                EditDosboxVersionDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button(composite_7, 0);
        RowData rowData_1 = new RowData();
        rowData_1.width = 80;
        cancelButton.setLayoutData(rowData_1);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditDosboxVersionDialog.this.result = null;
                EditDosboxVersionDialog.this.shell.close();
            }
        });
        Label label = new Label(composite, 258);
        label.setLayoutData(new GridData(4, 0x1000000, false, false, 3, 1));
        new Label(composite, 0);
        Button editButton = new Button(composite, 0);
        editButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditDosboxVersionDialog.this.isValid()) {
                    return;
                }
                PlatformUtils.openForEditing(FileUtils.constructCanonicalDBConfLocation(EditDosboxVersionDialog.this.path.getText()));
            }
        });
        editButton.setLayoutData(new GridData(4, 0x1000000, false, false));
        editButton.setText("Edit configuration file using external editor");
        new Label(composite, 0);
        if (this.result != null) {
            this.title.setText(((DosboxVersion)this.result).getTitle());
            this.path.setText(((DosboxVersion)this.result).getPath());
            defaultButton.setSelection(((DosboxVersion)this.result).isDefaultVersion());
            multiconf.setSelection(((DosboxVersion)this.result).isMultiConfig());
        }
        this.title.setFocus();
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a dosbox version title", this.title);
        }
        if (this.path.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a path to the dosbox executable", this.path);
        }
        if (!this.path.getText().endsWith(File.separator)) {
            this.path.setText(String.valueOf(this.path.getText()) + File.separatorChar);
        }
        DosboxVersion dbversion = new DosboxVersion(-1, "", this.path.getText(), false, false);
        String executable = dbversion.getExecutable();
        String configFile = dbversion.getConfigFile();
        boolean exeAvailable = FileUtils.isExistingReadableFile(executable);
        if (!exeAvailable) {
            GeneralPurposeDialogs.addError("The dosbox executable \"" + executable + "\" is missing or unreadable", this.path);
        }
        if (!FileUtils.isExistingReadableFile(configFile) && exeAvailable && GeneralPurposeDialogs.confirmMessage(this.shell, "The dosbox configuration file \"" + configFile + "\" is missing or unreadable.\n\nWould you like to create a configuration " + "file based on this dosbox version's internal defaults?")) {
            try {
                FileUtils.doCreateDosboxConf(dbversion);
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
        if (!FileUtils.isExistingReadableFile(configFile)) {
            GeneralPurposeDialogs.addError("The dosbox configuration file \"" + configFile + "\" is missing or unreadable", this.path);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

