/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.db.Database;
import com.gui.EditMountDialog;
import com.gui.GeneralPurposeDialogs;
import com.gui.SettingsDialog;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.Developer;
import com.model.DosboxVersion;
import com.model.Genre;
import com.model.Mount;
import com.model.Profile;
import com.model.Publisher;
import com.model.Settings;
import com.model.Status;
import com.model.Template;
import com.model.Year;
import com.util.FileUtils;
import com.util.ListUtils;
import java.io.IOException;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditProfileDialog
extends Dialog {
    private Text config_file;
    private Button timed;
    private Button autofire;
    private Button swap34;
    private Button glide;
    private Text glideport;
    private Text vsyncrate;
    private Combo vsyncmode;
    private Combo videoram;
    private Combo svgachipset;
    private Text overscan;
    private Combo mt32rate;
    private Combo pixelshader;
    private TabItem mountingTabItem;
    private TabItem infoTabItem;
    private Text title;
    private Combo developer;
    private Combo publisher;
    private Combo genre;
    private Combo year;
    private Combo status;
    private Text link1;
    private Text link2;
    private Text notes;
    private Button reloadSettingsButton;
    private Combo dbversion;
    private Combo template;
    private Combo priority_inactive;
    private Combo priority_active;
    private Button waitonerror;
    private Button exit;
    private Button fullscreen;
    private Button fulldouble;
    private Button aspect;
    private Text language;
    private Text captures;
    private Combo machine;
    private Combo core;
    private Combo cycles;
    private Combo cycles_up;
    private Combo cycles_down;
    private Button timesynched;
    private Combo memsize;
    private Button xms;
    private Button ems;
    private Combo umb;
    private Button loadfix;
    private Combo loadfix_value;
    private Combo output;
    private Combo frameskip;
    private Combo scaler;
    private Combo fullresolution;
    private Combo windowresolution;
    private Combo tandy;
    private Combo tandyrate;
    private Text midi_config;
    private Combo device;
    private Combo mpu401;
    private Text ultradir;
    private Combo gusrate;
    private Combo irq2;
    private Combo dma2;
    private Combo dma1;
    private Combo irq1;
    private Combo gusbase;
    private Combo pcrate;
    private Combo hdma;
    private Combo dma;
    private Combo irq;
    private Combo sbbase;
    private Combo oplrate;
    private Combo oplmode;
    private Combo sbtype;
    private Combo prebuffer;
    private Combo blocksize;
    private Combo rate;
    private Button nosound;
    private Button mixer;
    private Button pcspeaker;
    private Button disney;
    private Button gus;
    private Button dosButton;
    private Button booterButton;
    private Button usescancodes;
    private Button autolock;
    private Combo sensitivity;
    private Text serial1;
    private Text serial2;
    private Text serial3;
    private Text serial4;
    private Combo joysticktype;
    private Text mapperfile;
    private Button ipx;
    private org.eclipse.swt.widgets.List mountingpoints;
    private Text main;
    private Text main_params;
    private Text setup;
    private Text setup_params;
    private Text img1;
    private Text img2;
    private boolean focusTitle = false;
    protected Shell shell;
    private Database db;
    private List<Developer> developersList;
    private List<Publisher> publishersList;
    private List<Genre> genresList;
    private List<Year> yearsList;
    private List<DosboxVersion> dbversionsList;
    private List<Template> templatesList;
    private List<Status> statusList;
    private Configuration profileConf;
    private Settings settings;
    protected Object result;

    public EditProfileDialog(Shell parent) {
        super(parent, 0);
    }

    public void setProfile(Profile prof) {
        this.result = prof;
    }

    public void sendToProfile(String file) {
        this.result = file;
    }

    public void focusTitle() {
        this.focusTitle = true;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.db = Database.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.developersList = this.db.readDevelopersList();
        this.publishersList = this.db.readPublishersList();
        this.genresList = this.db.readGenresList();
        this.yearsList = this.db.readYearsList();
        this.dbversionsList = this.db.readDosboxVersionsList();
        this.templatesList = this.db.readTemplatesList();
        this.statusList = this.db.readStatusList();
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setSize(610, 475);
        if (this.result instanceof Profile) {
            this.shell.setText("Edit Profile " + ((Profile)this.result).getTitle() + " (" + ((Profile)this.result).getId() + ")");
        } else if (this.result instanceof String) {
            this.shell.setText("Send " + (String)this.result + " to profile");
        } else {
            this.shell.setText("Add Profile");
        }
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText("Info");
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout(gridLayout);
        this.infoTabItem.setControl(composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText("Title");
        this.title = new Text(composite, 2048);
        this.title.setLayoutData(new GridData(4, 0x1000000, true, false, 3, 1));
        Label developerLabel = new Label(composite, 0);
        developerLabel.setText("Developer");
        this.developer = new Combo(composite, 0);
        this.developer.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.developer.setVisibleItemCount(15);
        Label publisherLabel = new Label(composite, 0);
        publisherLabel.setLayoutData(new GridData());
        publisherLabel.setText("Publisher");
        this.publisher = new Combo(composite, 0);
        this.publisher.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.publisher.setVisibleItemCount(15);
        Label genreLabel = new Label(composite, 0);
        genreLabel.setText("Genre");
        this.genre = new Combo(composite, 0);
        this.genre.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.genre.setVisibleItemCount(15);
        Label yearLabel = new Label(composite, 0);
        yearLabel.setLayoutData(new GridData());
        yearLabel.setText("Year");
        this.year = new Combo(composite, 0);
        this.year.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.year.setVisibleItemCount(15);
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText("General");
        Composite composite_1 = new Composite(tabFolder, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite_1.setLayout(gridLayout_1);
        generalTabItem.setControl(composite_1);
        Label dosboxVersionLabel = new Label(composite_1, 0);
        dosboxVersionLabel.setText("Dosbox version");
        this.dbversion = new Combo(composite_1, 8);
        GridData gridData_7 = new GridData(4, 0x1000000, true, false);
        this.dbversion.setLayoutData(gridData_7);
        this.dbversion.setVisibleItemCount(10);
        this.reloadSettingsButton = new Button(composite_1, 0);
        this.reloadSettingsButton.setText("Reload Settings");
        this.reloadSettingsButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditProfileDialog.this.profileConf = EditProfileDialog.loadDBVersionConfig((DosboxVersion)EditProfileDialog.this.dbversionsList.get(EditProfileDialog.this.dbversion.getSelectionIndex()), EditProfileDialog.this.shell);
                EditProfileDialog.this.selectSettingsByConfiguration(EditProfileDialog.this.profileConf);
            }
        });
        Label templateLabel = new Label(composite_1, 0);
        templateLabel.setText("Template");
        this.template = new Combo(composite_1, 8);
        GridData gridData_6 = new GridData(4, 0x1000000, true, false);
        this.template.setLayoutData(gridData_6);
        Button reloadSettingsButton_1 = new Button(composite_1, 0);
        reloadSettingsButton_1.setText("Reload Settings");
        reloadSettingsButton_1.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditProfileDialog.this.template.getSelectionIndex() != -1) {
                    EditProfileDialog.this.profileConf = EditProfileDialog.loadTemplateConfig((DosboxVersion)EditProfileDialog.this.dbversionsList.get(EditProfileDialog.this.dbversion.getSelectionIndex()), (Template)EditProfileDialog.this.templatesList.get(EditProfileDialog.this.template.getSelectionIndex()), EditProfileDialog.this.shell);
                    EditProfileDialog.this.selectSettingsByConfiguration(EditProfileDialog.this.profileConf);
                }
            }
        });
        Label label = new Label(composite_1, 258);
        label.setLayoutData(new GridData(4, 0x1000000, false, false, 3, 1));
        new Label(composite_1, 0);
        Label activeLabel = new Label(composite_1, 0);
        activeLabel.setText("Active");
        Label inactiveLabel = new Label(composite_1, 0);
        inactiveLabel.setText("Inactive");
        Label priorityLabel = new Label(composite_1, 0);
        priorityLabel.setText("Priority");
        this.priority_active = new Combo(composite_1, 8);
        this.priority_active.setItems(this.settings.getValues("profile", "priority_active"));
        GridData gridData_5 = new GridData(16384, 0x1000000, true, false);
        gridData_5.minimumWidth = 150;
        this.priority_active.setLayoutData(gridData_5);
        this.priority_inactive = new Combo(composite_1, 8);
        this.priority_inactive.setItems(this.settings.getValues("profile", "priority_inactive"));
        this.priority_inactive.setLayoutData(new GridData(4, 0x1000000, false, false));
        Label waitOnErrorLabel = new Label(composite_1, 0);
        waitOnErrorLabel.setText("Wait On Error");
        this.waitonerror = new Button(composite_1, 32);
        new Label(composite_1, 0);
        Label exitAfterwardsLabel = new Label(composite_1, 0);
        exitAfterwardsLabel.setText("Exit afterwards");
        this.exit = new Button(composite_1, 32);
        new Label(composite_1, 0);
        Label languageFileLabel = new Label(composite_1, 0);
        languageFileLabel.setLayoutData(new GridData());
        languageFileLabel.setText("Language File");
        this.language = new Text(composite_1, 2048);
        GridData gridData_4 = new GridData(4, 0x1000000, false, false, 2, 1);
        this.language.setLayoutData(gridData_4);
        Label capturesLabel = new Label(composite_1, 0);
        capturesLabel.setLayoutData(new GridData());
        capturesLabel.setText("Captures");
        this.captures = new Text(composite_1, 2048);
        GridData gridData_3 = new GridData(4, 0x1000000, false, false, 2, 1);
        this.captures.setLayoutData(gridData_3);
        this.captures.setEditable(false);
        this.captures.setText(this.result instanceof Profile ? ((Profile)this.result).getCaptures() : "<automatic>");
        Label configFileLabel = new Label(composite_1, 0);
        configFileLabel.setText("Config File");
        this.config_file = new Text(composite_1, 2048);
        this.config_file.setLayoutData(new GridData(4, 0x1000000, false, false, 2, 1));
        this.config_file.setEditable(false);
        this.config_file.setText(this.result instanceof Profile ? ((Profile)this.result).getConfPathAndFile() : String.valueOf(SettingsDialog.confLocations[this.settings.getIntValue("profiledefaults", "confpath")]) + ", " + SettingsDialog.confFilenames[this.settings.getIntValue("profiledefaults", "conffile")]);
        TabItem displayTabItem = new TabItem(tabFolder, 0);
        displayTabItem.setText("Display");
        Composite composite_2 = new Composite(tabFolder, 0);
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 4;
        composite_2.setLayout(gridLayout_5);
        displayTabItem.setControl(composite_2);
        Label outputLabel = new Label(composite_2, 0);
        outputLabel.setText("Output");
        this.output = new Combo(composite_2, 8);
        this.output.setItems(this.settings.getValues("profile", "output"));
        this.output.setVisibleItemCount(10);
        this.output.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label frameskipLabel = new Label(composite_2, 0);
        frameskipLabel.setText("Frameskip");
        this.frameskip = new Combo(composite_2, 8);
        this.frameskip.setItems(this.settings.getValues("profile", "frameskip"));
        this.frameskip.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label scalerLabel = new Label(composite_2, 0);
        scalerLabel.setText("Scaler");
        this.scaler = new Combo(composite_2, 8);
        this.scaler.setItems(this.settings.getValues("profile", "scaler"));
        this.scaler.setVisibleItemCount(15);
        this.scaler.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label pixelshaderLabel = new Label(composite_2, 0);
        pixelshaderLabel.setLayoutData(new GridData());
        pixelshaderLabel.setText("Pixelshader");
        this.pixelshader = new Combo(composite_2, 8);
        this.pixelshader.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.pixelshader.setVisibleItemCount(15);
        this.pixelshader.setItems(this.settings.getValues("profile", "pixelshader"));
        Label fullscreenLabel = new Label(composite_2, 0);
        fullscreenLabel.setText("Fullscreen");
        this.fullscreen = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label doubleBufferingLabel = new Label(composite_2, 0);
        doubleBufferingLabel.setText("Double Buffering");
        this.fulldouble = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label resolutionLabel = new Label(composite_2, 0);
        resolutionLabel.setText("Fullscreen Resolution");
        this.fullresolution = new Combo(composite_2, 8);
        this.fullresolution.setItems(this.settings.getValues("profile", "fullresolution"));
        this.fullresolution.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.fullresolution.setVisibleItemCount(10);
        Label windowResolutionLabel = new Label(composite_2, 0);
        windowResolutionLabel.setText("Window Resolution");
        this.windowresolution = new Combo(composite_2, 8);
        this.windowresolution.setItems(this.settings.getValues("profile", "windowresolution"));
        this.windowresolution.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.windowresolution.setVisibleItemCount(10);
        Label aspectCorrectionLabel = new Label(composite_2, 0);
        aspectCorrectionLabel.setText("Aspect Correction");
        this.aspect = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label overscanLabel = new Label(composite_2, 0);
        overscanLabel.setText("Overscan");
        this.overscan = new Text(composite_2, 2048);
        this.overscan.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label svgaChipsetLabel = new Label(composite_2, 0);
        svgaChipsetLabel.setText("SVGA Chipset");
        this.svgachipset = new Combo(composite_2, 8);
        this.svgachipset.setItems(this.settings.getValues("profile", "svgachipset"));
        this.svgachipset.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label videoRamLabel = new Label(composite_2, 0);
        videoRamLabel.setText("Video RAM in KB");
        this.videoram = new Combo(composite_2, 8);
        this.videoram.setItems(this.settings.getValues("profile", "videoram"));
        this.videoram.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label vsyncModeLabel = new Label(composite_2, 0);
        vsyncModeLabel.setText("Vsync Mode");
        this.vsyncmode = new Combo(composite_2, 8);
        this.vsyncmode.setItems(this.settings.getValues("profile", "vsyncmode"));
        this.vsyncmode.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label vsyncRateLabel = new Label(composite_2, 0);
        vsyncRateLabel.setLayoutData(new GridData());
        vsyncRateLabel.setText("Vsync Rate");
        this.vsyncrate = new Text(composite_2, 2048);
        this.vsyncrate.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label glideLabel = new Label(composite_2, 0);
        glideLabel.setText("Glide");
        this.glide = new Button(composite_2, 32);
        this.glide.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditProfileDialog.this.glideport.setEnabled(EditProfileDialog.this.glide.getSelection());
            }
        });
        Label glidePortLabel = new Label(composite_2, 0);
        glidePortLabel.setText("Glide port");
        this.glideport = new Text(composite_2, 2048);
        this.glideport.setLayoutData(new GridData(4, 0x1000000, true, false));
        TabItem machineTabItem = new TabItem(tabFolder, 0);
        machineTabItem.setText("Machine");
        Composite composite_3 = new Composite(tabFolder, 0);
        GridLayout gridLayout_2 = new GridLayout();
        composite_3.setLayout(gridLayout_2);
        machineTabItem.setControl(composite_3);
        Group cpuGroup = new Group(composite_3, 0);
        cpuGroup.setText("CPU");
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 6;
        cpuGroup.setLayout(gridLayout_3);
        Label machineLabel = new Label(cpuGroup, 0);
        machineLabel.setText("Machine");
        this.machine = new Combo(cpuGroup, 8);
        this.machine.setItems(this.settings.getValues("profile", "machine"));
        this.machine.setLayoutData(new GridData());
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        Label coreLabel = new Label(cpuGroup, 0);
        coreLabel.setText("Core");
        this.core = new Combo(cpuGroup, 8);
        this.core.setItems(this.settings.getValues("profile", "core"));
        this.core.setLayoutData(new GridData());
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        Label cyclesLabel = new Label(cpuGroup, 0);
        cyclesLabel.setText("Cycles");
        this.cycles = new Combo(cpuGroup, 0);
        this.cycles.setItems(this.settings.getValues("profile", "cycles"));
        this.cycles.setLayoutData(new GridData());
        this.cycles.setVisibleItemCount(15);
        Label upLabel = new Label(cpuGroup, 0);
        upLabel.setLayoutData(new GridData());
        upLabel.setText("Up");
        this.cycles_up = new Combo(cpuGroup, 0);
        this.cycles_up.setItems(this.settings.getValues("profile", "cycles_up"));
        this.cycles_up.setLayoutData(new GridData());
        Label downLabel = new Label(cpuGroup, 0);
        downLabel.setLayoutData(new GridData());
        downLabel.setText("Down");
        this.cycles_down = new Combo(cpuGroup, 0);
        this.cycles_down.setItems(this.settings.getValues("profile", "cycles_down"));
        this.cycles_down.setLayoutData(new GridData());
        Label timesynchedLabel = new Label(cpuGroup, 0);
        timesynchedLabel.setText("Timesynched");
        this.timesynched = new Button(cpuGroup, 32);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        Group memoryGroup = new Group(composite_3, 0);
        memoryGroup.setText("Memory");
        memoryGroup.setLayoutData(new GridData());
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        memoryGroup.setLayout(gridLayout_4);
        Label sizeLabel = new Label(memoryGroup, 0);
        sizeLabel.setText("Size");
        this.memsize = new Combo(memoryGroup, 8);
        this.memsize.setItems(this.settings.getValues("profile", "memsize"));
        this.memsize.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(memoryGroup, 0);
        new Label(memoryGroup, 0);
        Label xmsLabel = new Label(memoryGroup, 0);
        xmsLabel.setText("XMS");
        this.xms = new Button(memoryGroup, 32);
        new Label(memoryGroup, 0);
        new Label(memoryGroup, 0);
        Label emsLabel = new Label(memoryGroup, 0);
        emsLabel.setText("EMS");
        this.ems = new Button(memoryGroup, 32);
        new Label(memoryGroup, 0);
        new Label(memoryGroup, 0);
        Label umbLabel = new Label(memoryGroup, 0);
        umbLabel.setText("UMB");
        this.umb = new Combo(memoryGroup, 8);
        this.umb.setItems(this.settings.getValues("profile", "umb"));
        this.umb.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(memoryGroup, 0);
        new Label(memoryGroup, 0);
        Label loadfixLabel = new Label(memoryGroup, 0);
        loadfixLabel.setText("Loadfix");
        this.loadfix = new Button(memoryGroup, 32);
        this.loadfix.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditProfileDialog.this.loadfix_value.setEnabled(EditProfileDialog.this.loadfix.getSelection());
            }
        });
        this.loadfix_value = new Combo(memoryGroup, 0);
        this.loadfix_value.setItems(this.settings.getValues("profile", "loadfix_value"));
        this.loadfix_value.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label kbLabel = new Label(memoryGroup, 0);
        kbLabel.setText("KB");
        TabItem audioTabItem = new TabItem(tabFolder, 0);
        audioTabItem.setText("Audio");
        Composite composite_4 = new Composite(tabFolder, 0);
        GridLayout gridLayout_9 = new GridLayout();
        gridLayout_9.numColumns = 3;
        composite_4.setLayout(gridLayout_9);
        audioTabItem.setControl(composite_4);
        Group generalGroup = new Group(composite_4, 0);
        generalGroup.setLayoutData(new GridData(4, 4, true, false));
        GridLayout gridLayout_6 = new GridLayout();
        gridLayout_6.numColumns = 2;
        generalGroup.setLayout(gridLayout_6);
        generalGroup.setText("General");
        Label silentModeLabel = new Label(generalGroup, 0);
        silentModeLabel.setText("Silent Mode");
        this.nosound = new Button(generalGroup, 32);
        Label sampleRateLabel = new Label(generalGroup, 0);
        sampleRateLabel.setText("Sample Rate");
        this.rate = new Combo(generalGroup, 8);
        this.rate.setItems(this.settings.getValues("profile", "rate"));
        this.rate.setLayoutData(new GridData());
        Label blockSizeLabel = new Label(generalGroup, 0);
        blockSizeLabel.setText("Block Size");
        this.blocksize = new Combo(generalGroup, 8);
        this.blocksize.setItems(this.settings.getValues("profile", "blocksize"));
        this.blocksize.setLayoutData(new GridData());
        Label prebufferLabel = new Label(generalGroup, 0);
        prebufferLabel.setText("Prebuffer");
        this.prebuffer = new Combo(generalGroup, 0);
        this.prebuffer.setItems(this.settings.getValues("profile", "prebuffer"));
        this.prebuffer.setLayoutData(new GridData());
        Label mpu401Label = new Label(generalGroup, 0);
        mpu401Label.setText("MPU-401");
        this.mpu401 = new Combo(generalGroup, 8);
        this.mpu401.setItems(this.settings.getValues("profile", "mpu401"));
        this.mpu401.setLayoutData(new GridData());
        Label midiDeviceLabel = new Label(generalGroup, 0);
        midiDeviceLabel.setText("Midi Device");
        this.device = new Combo(generalGroup, 8);
        this.device.setItems(this.settings.getValues("profile", "device"));
        this.device.setLayoutData(new GridData());
        Label configLabel = new Label(generalGroup, 0);
        configLabel.setText("Config");
        this.midi_config = new Text(generalGroup, 2048);
        this.midi_config.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label mt32RateLabel = new Label(generalGroup, 0);
        mt32RateLabel.setText("MT-32 Rate");
        this.mt32rate = new Combo(generalGroup, 8);
        this.mt32rate.setItems(this.settings.getValues("profile", "mt32rate"));
        this.mt32rate.setLayoutData(new GridData());
        Group soundblasterGroup = new Group(composite_4, 0);
        soundblasterGroup.setLayoutData(new GridData(4, 4, false, false));
        soundblasterGroup.setText("Soundblaster");
        GridLayout gridLayout_7 = new GridLayout();
        gridLayout_7.numColumns = 2;
        soundblasterGroup.setLayout(gridLayout_7);
        Label typeLabel = new Label(soundblasterGroup, 0);
        typeLabel.setText("Type");
        this.sbtype = new Combo(soundblasterGroup, 8);
        this.sbtype.setItems(this.settings.getValues("profile", "sbtype"));
        this.sbtype.setLayoutData(new GridData());
        Label oplRateLabel = new Label(soundblasterGroup, 0);
        oplRateLabel.setText("OPL Rate");
        this.oplrate = new Combo(soundblasterGroup, 8);
        this.oplrate.setItems(this.settings.getValues("profile", "oplrate"));
        this.oplrate.setLayoutData(new GridData());
        Label oplModeLabel = new Label(soundblasterGroup, 0);
        oplModeLabel.setLayoutData(new GridData());
        oplModeLabel.setText("OPL Mode");
        this.oplmode = new Combo(soundblasterGroup, 8);
        this.oplmode.setItems(this.settings.getValues("profile", "oplmode"));
        this.oplmode.setLayoutData(new GridData());
        Label addressLabel = new Label(soundblasterGroup, 0);
        addressLabel.setText("Address");
        this.sbbase = new Combo(soundblasterGroup, 8);
        this.sbbase.setItems(this.settings.getValues("profile", "sbbase"));
        this.sbbase.setLayoutData(new GridData());
        Label irqLabel = new Label(soundblasterGroup, 0);
        irqLabel.setText("IRQ");
        this.irq = new Combo(soundblasterGroup, 8);
        this.irq.setItems(this.settings.getValues("profile", "irq"));
        this.irq.setLayoutData(new GridData());
        Label dmaLabel = new Label(soundblasterGroup, 0);
        dmaLabel.setText("DMA");
        this.dma = new Combo(soundblasterGroup, 8);
        this.dma.setItems(this.settings.getValues("profile", "dma"));
        this.dma.setLayoutData(new GridData());
        Label hdmaLabel = new Label(soundblasterGroup, 0);
        hdmaLabel.setLayoutData(new GridData());
        hdmaLabel.setText("HDMA");
        this.hdma = new Combo(soundblasterGroup, 8);
        this.hdma.setItems(this.settings.getValues("profile", "hdma"));
        this.hdma.setLayoutData(new GridData());
        Label mixerLabel = new Label(soundblasterGroup, 0);
        mixerLabel.setText("Mixer");
        this.mixer = new Button(soundblasterGroup, 32);
        Group gusGroup = new Group(composite_4, 0);
        gusGroup.setLayoutData(new GridData(4, 4, true, false));
        gusGroup.setText("Gravis Ultrasound");
        GridLayout gridLayout_8 = new GridLayout();
        gridLayout_8.numColumns = 2;
        gusGroup.setLayout(gridLayout_8);
        Label enableLabel_1 = new Label(gusGroup, 0);
        enableLabel_1.setLayoutData(new GridData());
        enableLabel_1.setText("Enable");
        this.gus = new Button(gusGroup, 32);
        this.gus.setLayoutData(new GridData());
        Label sampleRateLabel_2 = new Label(gusGroup, 0);
        sampleRateLabel_2.setText("Sample Rate");
        this.gusrate = new Combo(gusGroup, 8);
        this.gusrate.setItems(this.settings.getValues("profile", "gusrate"));
        this.gusrate.setLayoutData(new GridData());
        Label addressLabel_1 = new Label(gusGroup, 0);
        addressLabel_1.setText("Address");
        this.gusbase = new Combo(gusGroup, 8);
        this.gusbase.setItems(this.settings.getValues("profile", "gusbase"));
        this.gusbase.setLayoutData(new GridData());
        Label irqLabel_1 = new Label(gusGroup, 0);
        irqLabel_1.setText("IRQ1");
        this.irq1 = new Combo(gusGroup, 8);
        this.irq1.setItems(this.settings.getValues("profile", "irq1"));
        this.irq1.setLayoutData(new GridData());
        Label irq2Label = new Label(gusGroup, 0);
        irq2Label.setText("IRQ2");
        this.irq2 = new Combo(gusGroup, 8);
        this.irq2.setItems(this.settings.getValues("profile", "irq2"));
        this.irq2.setLayoutData(new GridData());
        Label dmaLabel_1 = new Label(gusGroup, 0);
        dmaLabel_1.setText("DMA1");
        this.dma1 = new Combo(gusGroup, 8);
        this.dma1.setItems(this.settings.getValues("profile", "dma1"));
        this.dma1.setLayoutData(new GridData());
        Label hdmaLabel_1 = new Label(gusGroup, 0);
        hdmaLabel_1.setLayoutData(new GridData());
        hdmaLabel_1.setText("DMA2");
        this.dma2 = new Combo(gusGroup, 8);
        this.dma2.setItems(this.settings.getValues("profile", "dma2"));
        this.dma2.setLayoutData(new GridData());
        Label ultradirLabel = new Label(gusGroup, 0);
        ultradirLabel.setText("Ultradir");
        this.ultradir = new Text(gusGroup, 2048);
        this.ultradir.setLayoutData(new GridData(4, 0x1000000, true, false));
        Group speakerGroup = new Group(composite_4, 0);
        speakerGroup.setLayoutData(new GridData(4, 4, true, false));
        speakerGroup.setText("PC Speaker");
        GridLayout gridLayout_10 = new GridLayout();
        gridLayout_10.numColumns = 2;
        speakerGroup.setLayout(gridLayout_10);
        Label enableLabel = new Label(speakerGroup, 0);
        enableLabel.setText("Enable");
        this.pcspeaker = new Button(speakerGroup, 32);
        Label sampleRateLabel_1 = new Label(speakerGroup, 0);
        sampleRateLabel_1.setText("Sample Rate");
        this.pcrate = new Combo(speakerGroup, 8);
        this.pcrate.setItems(this.settings.getValues("profile", "pcrate"));
        this.pcrate.setLayoutData(new GridData());
        Group tandyGroup = new Group(composite_4, 0);
        tandyGroup.setLayoutData(new GridData(4, 4, false, false));
        tandyGroup.setText("Tandy");
        GridLayout gridLayout_11 = new GridLayout();
        gridLayout_11.numColumns = 2;
        tandyGroup.setLayout(gridLayout_11);
        Label enableLabel_2 = new Label(tandyGroup, 0);
        enableLabel_2.setText("Enable");
        this.tandy = new Combo(tandyGroup, 8);
        this.tandy.setItems(this.settings.getValues("profile", "tandy"));
        this.tandy.setLayoutData(new GridData());
        Label sampleRateLabel_1_1 = new Label(tandyGroup, 0);
        sampleRateLabel_1_1.setText("Sample Rate");
        this.tandyrate = new Combo(tandyGroup, 8);
        this.tandyrate.setItems(this.settings.getValues("profile", "tandyrate"));
        this.tandyrate.setLayoutData(new GridData());
        Group disneyGroup = new Group(composite_4, 0);
        disneyGroup.setLayoutData(new GridData(4, 4, true, false));
        disneyGroup.setText("Disney Sound Source");
        GridLayout gridLayout_12 = new GridLayout();
        gridLayout_12.numColumns = 2;
        disneyGroup.setLayout(gridLayout_12);
        Label enableLabel_3 = new Label(disneyGroup, 0);
        enableLabel_3.setText("Enable");
        this.disney = new Button(disneyGroup, 32);
        TabItem inputTabItem = new TabItem(tabFolder, 0);
        inputTabItem.setText("I/O");
        Composite composite_5 = new Composite(tabFolder, 0);
        GridLayout gridLayout_17 = new GridLayout();
        gridLayout_17.numColumns = 3;
        composite_5.setLayout(gridLayout_17);
        inputTabItem.setControl(composite_5);
        Group mouseGroup = new Group(composite_5, 0);
        mouseGroup.setLayoutData(new GridData(4, 4, false, false));
        mouseGroup.setText("Mouse");
        GridLayout gridLayout_13 = new GridLayout();
        gridLayout_13.numColumns = 2;
        mouseGroup.setLayout(gridLayout_13);
        Label autolockLabel = new Label(mouseGroup, 0);
        autolockLabel.setText("Autolock");
        this.autolock = new Button(mouseGroup, 32);
        Label sensitivityLabel = new Label(mouseGroup, 0);
        sensitivityLabel.setText("Sensitivity");
        this.sensitivity = new Combo(mouseGroup, 8);
        this.sensitivity.setItems(this.settings.getValues("profile", "sensitivity"));
        this.sensitivity.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.sensitivity.setVisibleItemCount(20);
        Group keyboardGroup = new Group(composite_5, 0);
        keyboardGroup.setLayoutData(new GridData(4, 4, true, false));
        keyboardGroup.setText("Keyboard");
        GridLayout gridLayout_14 = new GridLayout();
        gridLayout_14.numColumns = 2;
        keyboardGroup.setLayout(gridLayout_14);
        Label useScancodesLabel = new Label(keyboardGroup, 0);
        useScancodesLabel.setText("Use Scancodes");
        this.usescancodes = new Button(keyboardGroup, 32);
        Label mapperFileLabel = new Label(keyboardGroup, 0);
        mapperFileLabel.setText("Mapper File");
        this.mapperfile = new Text(keyboardGroup, 2048);
        this.mapperfile.setLayoutData(new GridData(4, 0x1000000, true, false));
        Group joystickGroup = new Group(composite_5, 0);
        joystickGroup.setLayoutData(new GridData(4, 4, false, false));
        joystickGroup.setText("Joystick");
        GridLayout gridLayout_15 = new GridLayout();
        gridLayout_15.numColumns = 2;
        joystickGroup.setLayout(gridLayout_15);
        Label typeLabel_1 = new Label(joystickGroup, 0);
        typeLabel_1.setText("Type");
        this.joysticktype = new Combo(joystickGroup, 8);
        this.joysticktype.setItems(this.settings.getValues("profile", "joysticktype"));
        this.joysticktype.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label timedEmulationLabel = new Label(joystickGroup, 0);
        timedEmulationLabel.setText("Timed emulation");
        this.timed = new Button(joystickGroup, 32);
        Label autofireLabel = new Label(joystickGroup, 0);
        autofireLabel.setText("Autofire");
        this.autofire = new Button(joystickGroup, 32);
        Label swapAxes3Label = new Label(joystickGroup, 0);
        swapAxes3Label.setText("Swap axes 3&&4");
        this.swap34 = new Button(joystickGroup, 32);
        Group modemGroup = new Group(composite_5, 0);
        modemGroup.setLayoutData(new GridData(4, 0x1000000, false, false, 2, 1));
        modemGroup.setText("Modem");
        GridLayout gridLayout_16 = new GridLayout();
        gridLayout_16.numColumns = 2;
        modemGroup.setLayout(gridLayout_16);
        Label serial1Label = new Label(modemGroup, 0);
        serial1Label.setText("Serial 1");
        this.serial1 = new Text(modemGroup, 2048);
        this.serial1.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label serial2Label = new Label(modemGroup, 0);
        serial2Label.setText("Serial 2");
        this.serial2 = new Text(modemGroup, 2048);
        this.serial2.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label serial3Label = new Label(modemGroup, 0);
        serial3Label.setText("Serial 3");
        this.serial3 = new Text(modemGroup, 2048);
        this.serial3.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label serial4Label = new Label(modemGroup, 0);
        serial4Label.setText("Serial 4");
        this.serial4 = new Text(modemGroup, 2048);
        this.serial4.setLayoutData(new GridData(4, 0x1000000, true, false));
        Group networkGroup = new Group(composite_5, 0);
        networkGroup.setLayoutData(new GridData(4, 4, false, false));
        networkGroup.setText("Network");
        GridLayout gridLayout_20 = new GridLayout();
        gridLayout_20.numColumns = 2;
        networkGroup.setLayout(gridLayout_20);
        Label ipxLabel = new Label(networkGroup, 0);
        ipxLabel.setText("Enable IPX");
        this.ipx = new Button(networkGroup, 32);
        new Label(composite_5, 0);
        this.mountingTabItem = new TabItem(tabFolder, 0);
        this.mountingTabItem.setText("Mounting");
        Composite composite_6 = new Composite(tabFolder, 0);
        composite_6.setLayout(new GridLayout());
        this.mountingTabItem.setControl(composite_6);
        Group mountGroup = new Group(composite_6, 0);
        mountGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        mountGroup.setText("Mounting Overview");
        GridLayout gridLayout_19 = new GridLayout();
        gridLayout_19.numColumns = 2;
        mountGroup.setLayout(gridLayout_19);
        this.mountingpoints = new org.eclipse.swt.widgets.List(mountGroup, 2560);
        GridData gridData_2 = new GridData(4, 4, true, false, 1, 3);
        this.mountingpoints.setLayoutData(gridData_2);
        Button addButton = new Button(mountGroup, 0);
        addButton.setLayoutData(new GridData(4, 0x1000000, false, false));
        addButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String mount;
                EditMountDialog addMountDialog = new EditMountDialog(EditProfileDialog.this.shell);
                List<Character> freeDriveletters = Mount.getFreeDriveletters(false, EditProfileDialog.this.mountingpoints.getItems());
                if (freeDriveletters.size() > 0) {
                    addMountDialog.setDefaultDriveletter(freeDriveletters.get(0).charValue());
                }
                if ((mount = (String)addMountDialog.open()) != null) {
                    EditProfileDialog.this.mountingpoints.add(mount);
                    EditProfileDialog.this.mountingpoints.select(EditProfileDialog.this.mountingpoints.getItemCount() - 1);
                }
            }
        });
        addButton.setText("Add");
        Button editButton = new Button(mountGroup, 0);
        editButton.setLayoutData(new GridData(4, 0x1000000, false, false));
        editButton.setText("Edit");
        editButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditProfileDialog.this.mountingpoints.getSelectionIndex() != -1) {
                    EditMountDialog editMountDialog = new EditMountDialog(EditProfileDialog.this.shell);
                    editMountDialog.setMount(EditProfileDialog.this.mountingpoints.getItem(EditProfileDialog.this.mountingpoints.getSelectionIndex()));
                    String mount = (String)editMountDialog.open();
                    if (mount != null) {
                        EditProfileDialog.this.mountingpoints.setItem(EditProfileDialog.this.mountingpoints.getSelectionIndex(), mount);
                    }
                }
            }
        });
        Button removeButton = new Button(mountGroup, 0);
        removeButton.setText("Remove");
        removeButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditProfileDialog.this.mountingpoints.getSelectionIndex() != -1) {
                    EditProfileDialog.this.mountingpoints.remove(EditProfileDialog.this.mountingpoints.getSelectionIndex());
                } else if (EditProfileDialog.this.mountingpoints.getItemCount() == 1) {
                    EditProfileDialog.this.mountingpoints.removeAll();
                }
            }
        });
        Group executeGroup = new Group(composite_6, 0);
        executeGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        executeGroup.setText("Execute");
        GridLayout gridLayout_18 = new GridLayout();
        gridLayout_18.numColumns = 6;
        executeGroup.setLayout(gridLayout_18);
        this.dosButton = new Button(executeGroup, 16);
        this.dosButton.setText("Dos");
        Label mainExeLabel = new Label(executeGroup, 0);
        mainExeLabel.setText("Main");
        this.main = new Text(executeGroup, 2048);
        GridData gridData_1 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.main.setLayoutData(gridData_1);
        Button mainBrowseButton = new Button(executeGroup, 0);
        mainBrowseButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EditProfileDialog.this.shell, 4096);
                dialog.setFilterNames(new String[]{"Executables", "CD Images", "Zip files"});
                dialog.setFilterExtensions(new String[]{"*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT", "*.iso;*.ISO;*.cue;*.CUE", "*.zip;*.ZIP"});
                dialog.setFilterPath(EditProfileDialog.this.main.getText());
                String result = dialog.open();
                if (result != null) {
                    EditProfileDialog.this.main.setText(result);
                    EditProfileDialog.this.addMountIfNoMounts(result);
                }
            }
        });
        mainBrowseButton.setText("Browse..");
        Button grabButton = new Button(executeGroup, 0);
        grabButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditProfileDialog.this.doGrab(EditProfileDialog.this.main);
            }
        });
        grabButton.setText("Grab");
        new Label(executeGroup, 0);
        new Label(executeGroup, 0);
        Label parametersLabel = new Label(executeGroup, 0);
        parametersLabel.setLayoutData(new GridData());
        parametersLabel.setText("Parameters");
        this.main_params = new Text(executeGroup, 2048);
        this.main_params.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(executeGroup, 0);
        new Label(executeGroup, 0);
        new Label(executeGroup, 0);
        Label setupLabel = new Label(executeGroup, 0);
        setupLabel.setLayoutData(new GridData());
        setupLabel.setText("Setup");
        this.setup = new Text(executeGroup, 2048);
        this.setup.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        Button setupBrowseButton = new Button(executeGroup, 0);
        setupBrowseButton.setText("Browse..");
        setupBrowseButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EditProfileDialog.this.shell, 4096);
                dialog.setFilterNames(new String[]{"Executables", "CD Images", "Zip files"});
                dialog.setFilterExtensions(new String[]{"*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT", "*.iso;*.ISO;*.cue;*.CUE", "*.zip;*.ZIP"});
                if (!EditProfileDialog.this.setup.getText().equals("")) {
                    dialog.setFilterPath(EditProfileDialog.this.setup.getText());
                } else {
                    dialog.setFilterPath(EditProfileDialog.this.main.getText());
                }
                String result = dialog.open();
                if (result != null) {
                    EditProfileDialog.this.setup.setText(result);
                    EditProfileDialog.this.addMountIfNoMounts(result);
                }
            }
        });
        Button grabButton_1 = new Button(executeGroup, 0);
        grabButton_1.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditProfileDialog.this.doGrab(EditProfileDialog.this.setup);
            }
        });
        grabButton_1.setText("Grab");
        new Label(executeGroup, 0);
        new Label(executeGroup, 0);
        Label parametersLabel_1 = new Label(executeGroup, 0);
        parametersLabel_1.setLayoutData(new GridData());
        parametersLabel_1.setText("Parameters");
        this.setup_params = new Text(executeGroup, 2048);
        this.setup_params.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(executeGroup, 0);
        new Label(executeGroup, 0);
        Label label_1 = new Label(executeGroup, 258);
        label_1.setLayoutData(new GridData(4, 0x1000000, false, false, 6, 1));
        this.booterButton = new Button(executeGroup, 16);
        this.booterButton.setText("Booter");
        Label image1Label = new Label(executeGroup, 0);
        image1Label.setText("Image 1");
        this.img1 = new Text(executeGroup, 2048);
        this.img1.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        Button img1BrowseButton = new Button(executeGroup, 0);
        img1BrowseButton.setLayoutData(new GridData());
        img1BrowseButton.setText("Browse..");
        img1BrowseButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EditProfileDialog.this.shell, 4096);
                dialog.setFilterNames(new String[]{"Booter Disk Images", "*.*"});
                dialog.setFilterExtensions(new String[]{"*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*.*"});
                dialog.setFilterPath(EditProfileDialog.this.img1.getText());
                String result = dialog.open();
                if (result != null) {
                    EditProfileDialog.this.img1.setText(result);
                    EditProfileDialog.this.addMountIfNoMounts(result);
                }
            }
        });
        Button grabButton_2 = new Button(executeGroup, 0);
        grabButton_2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditProfileDialog.this.doGrab(EditProfileDialog.this.img1);
            }
        });
        grabButton_2.setText("Grab");
        new Label(executeGroup, 0);
        Label image2Label = new Label(executeGroup, 0);
        image2Label.setText("Image 2");
        this.img2 = new Text(executeGroup, 2048);
        this.img2.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        Button img2BrowseButton = new Button(executeGroup, 0);
        img2BrowseButton.setText("Browse..");
        img2BrowseButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EditProfileDialog.this.shell, 4096);
                dialog.setFilterNames(new String[]{"Booter Disk Images", "*.*"});
                dialog.setFilterExtensions(new String[]{"*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*.*"});
                if (!EditProfileDialog.this.img2.getText().equals("")) {
                    dialog.setFilterPath(EditProfileDialog.this.img2.getText());
                } else {
                    dialog.setFilterPath(EditProfileDialog.this.img1.getText());
                }
                String result = dialog.open();
                if (result != null) {
                    EditProfileDialog.this.img2.setText(result);
                    EditProfileDialog.this.addMountIfNoMounts(result);
                }
            }
        });
        Button grabButton_3 = new Button(executeGroup, 0);
        grabButton_3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditProfileDialog.this.doGrab(EditProfileDialog.this.img2);
            }
        });
        grabButton_3.setText("Grab");
        Composite composite_7 = new Composite(this.shell, 0);
        composite_7.setLayout(new RowLayout());
        composite_7.setLayoutData("South");
        Button okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(okButton);
        RowData rowData = new RowData();
        rowData.width = 80;
        okButton.setLayoutData(rowData);
        okButton.setText("OK");
        Button cancelButton = new Button(composite_7, 0);
        RowData rowData_1 = new RowData();
        rowData_1.width = 80;
        cancelButton.setLayoutData(rowData_1);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditProfileDialog.this.result = null;
                EditProfileDialog.this.shell.close();
            }
        });
        Label link1Label = new Label(composite, 0);
        link1Label.setText("Link 1");
        this.link1 = new Text(composite, 2048);
        this.link1.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label link2Label = new Label(composite, 0);
        link2Label.setLayoutData(new GridData());
        link2Label.setText("Link 2");
        this.link2 = new Text(composite, 2048);
        this.link2.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label statusLabel = new Label(composite, 0);
        statusLabel.setText("Status");
        this.status = new Combo(composite, 0);
        this.status.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.status.setVisibleItemCount(10);
        Label favoriteLabel = new Label(composite, 0);
        favoriteLabel.setText("Favorite");
        final Button favorite = new Button(composite, 32);
        Label notesLabel = new Label(composite, 0);
        notesLabel.setText("Notes");
        this.notes = new Text(composite, 2626);
        GridData gridData = new GridData(4, 4, true, true, 3, 1);
        this.notes.setLayoutData(gridData);
        for (Developer dev : this.developersList) {
            this.developer.add(dev.getName());
        }
        for (Publisher publ : this.publishersList) {
            this.publisher.add(publ.getName());
        }
        for (Genre gen : this.genresList) {
            this.genre.add(gen.getName());
        }
        for (Year yr : this.yearsList) {
            this.year.add(yr.getYear());
        }
        for (Status stat : this.statusList) {
            this.status.add(stat.getStat());
        }
        for (DosboxVersion dbv : this.dbversionsList) {
            this.dbversion.add(dbv.getTitle());
        }
        for (Template templ : this.templatesList) {
            this.template.add(templ.getTitle());
        }
        if (this.result instanceof Profile) {
            this.title.setText(((Profile)this.result).getTitle());
            this.developer.setText(((Profile)this.result).getDeveloperName());
            this.publisher.setText(((Profile)this.result).getPublisherName());
            this.genre.setText(((Profile)this.result).getGenre());
            this.year.setText(((Profile)this.result).getYear());
            this.link1.setText(((Profile)this.result).getLink1());
            this.link2.setText(((Profile)this.result).getLink2());
            this.status.setText(((Profile)this.result).getStatus());
            favorite.setSelection(((Profile)this.result).isFavorite());
            this.notes.setText(((Profile)this.result).getNotes());
            int tableIndexVersionIndex = ListUtils.findTIDosboxVersion(this.dbversionsList, ((Profile)this.result).getDbversionId());
            this.dbversion.select(tableIndexVersionIndex);
            this.setup.setText(((Profile)this.result).getSetup());
            this.setup_params.setText(((Profile)this.result).getSetupParameters());
            if (this.focusTitle) {
                this.title.selectAll();
                this.title.setFocus();
            }
            this.profileConf = EditProfileDialog.loadExistingConfig(this.dbversionsList.get(tableIndexVersionIndex), ((Profile)this.result).getConfPathAndFile(), this.shell);
        } else {
            int index;
            this.title.setFocus();
            int defaultDosboxVersionIndex = ListUtils.findTIDefaultDosboxVersion(this.dbversionsList);
            int defaultTemplateIndex = ListUtils.findTIDefaultTemplate(this.templatesList);
            this.dbversion.select(defaultDosboxVersionIndex);
            if (defaultTemplateIndex != -1) {
                this.template.select(defaultTemplateIndex);
                this.profileConf = EditProfileDialog.loadTemplateConfig(this.dbversionsList.get(defaultDosboxVersionIndex), this.templatesList.get(defaultTemplateIndex), this.shell);
            } else {
                this.profileConf = EditProfileDialog.loadDBVersionConfig(this.dbversionsList.get(defaultDosboxVersionIndex), this.shell);
                this.profileConf.setValue("autoexec", "autoexec", "exit");
            }
            if (this.result instanceof String && (index = ((String)this.result).lastIndexOf(46)) != -1) {
                String ext = ((String)this.result).substring(index + 1).toLowerCase();
                if (ext.equals("com") || ext.equals("exe") || ext.equals("bat")) {
                    this.main.setText((String)this.result);
                } else if (ext.equals("cp2") || ext.equals("dcf") || ext.equals("img") || ext.equals("jrc") || ext.equals("td0")) {
                    this.img1.setText((String)this.result);
                } else if (ext.equals("conf")) {
                    this.profileConf = EditProfileDialog.loadExistingConfig(this.dbversionsList.get(defaultDosboxVersionIndex), (String)this.result, this.shell);
                }
            }
        }
        this.main.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditProfileDialog.this.dosButton.setSelection(true);
                EditProfileDialog.this.booterButton.setSelection(false);
            }
        });
        this.main_params.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditProfileDialog.this.dosButton.setSelection(true);
                EditProfileDialog.this.booterButton.setSelection(false);
            }
        });
        this.setup.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditProfileDialog.this.dosButton.setSelection(true);
                EditProfileDialog.this.booterButton.setSelection(false);
            }
        });
        this.setup_params.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditProfileDialog.this.dosButton.setSelection(true);
                EditProfileDialog.this.booterButton.setSelection(false);
            }
        });
        this.img1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditProfileDialog.this.dosButton.setSelection(false);
                EditProfileDialog.this.booterButton.setSelection(true);
            }
        });
        this.img2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditProfileDialog.this.dosButton.setSelection(false);
                EditProfileDialog.this.booterButton.setSelection(true);
            }
        });
        okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditProfileDialog.this.isValid()) {
                    return;
                }
                int profileId = -1;
                int devIndex = -1;
                int publIndex = -1;
                int genIndex = -1;
                int yrIndex = -1;
                int statIndex = -1;
                if (EditProfileDialog.this.developer.getSelectionIndex() == -1) {
                    EditProfileDialog.this.developer.select(EditProfileDialog.this.developer.indexOf(EditProfileDialog.this.developer.getText()));
                }
                if (EditProfileDialog.this.developer.getSelectionIndex() != -1) {
                    devIndex = ((Developer)EditProfileDialog.this.developersList.get(EditProfileDialog.this.developer.getSelectionIndex())).getId();
                }
                if (EditProfileDialog.this.publisher.getSelectionIndex() == -1) {
                    EditProfileDialog.this.publisher.select(EditProfileDialog.this.publisher.indexOf(EditProfileDialog.this.publisher.getText()));
                }
                if (EditProfileDialog.this.publisher.getSelectionIndex() != -1) {
                    publIndex = ((Publisher)EditProfileDialog.this.publishersList.get(EditProfileDialog.this.publisher.getSelectionIndex())).getId();
                }
                if (EditProfileDialog.this.genre.getSelectionIndex() == -1) {
                    EditProfileDialog.this.genre.select(EditProfileDialog.this.genre.indexOf(EditProfileDialog.this.genre.getText()));
                }
                if (EditProfileDialog.this.genre.getSelectionIndex() != -1) {
                    genIndex = ((Genre)EditProfileDialog.this.genresList.get(EditProfileDialog.this.genre.getSelectionIndex())).getId();
                }
                if (EditProfileDialog.this.year.getSelectionIndex() == -1) {
                    EditProfileDialog.this.year.select(EditProfileDialog.this.year.indexOf(EditProfileDialog.this.year.getText()));
                }
                if (EditProfileDialog.this.year.getSelectionIndex() != -1) {
                    yrIndex = ((Year)EditProfileDialog.this.yearsList.get(EditProfileDialog.this.year.getSelectionIndex())).getId();
                }
                if (EditProfileDialog.this.status.getSelectionIndex() == -1) {
                    EditProfileDialog.this.status.select(EditProfileDialog.this.status.indexOf(EditProfileDialog.this.status.getText()));
                }
                if (EditProfileDialog.this.status.getSelectionIndex() != -1) {
                    statIndex = ((Status)EditProfileDialog.this.statusList.get(EditProfileDialog.this.status.getSelectionIndex())).getId();
                }
                int dbversionId = ((DosboxVersion)EditProfileDialog.this.dbversionsList.get(EditProfileDialog.this.dbversion.getSelectionIndex())).getId();
                profileId = EditProfileDialog.this.db.addOrEditProfile(EditProfileDialog.this.title.getText(), EditProfileDialog.this.developer.getText(), EditProfileDialog.this.publisher.getText(), EditProfileDialog.this.genre.getText(), EditProfileDialog.this.year.getText(), EditProfileDialog.this.status.getText(), EditProfileDialog.this.setup.getText(), EditProfileDialog.this.setup_params.getText(), EditProfileDialog.this.notes.getText(), EditProfileDialog.this.link1.getText(), EditProfileDialog.this.link2.getText(), favorite.getSelection(), devIndex, publIndex, genIndex, yrIndex, statIndex, dbversionId, EditProfileDialog.this.result instanceof Profile ? ((Profile)EditProfileDialog.this.result).getId() : -1);
                DosboxVersion selectedDBVersion = (DosboxVersion)EditProfileDialog.this.dbversionsList.get(EditProfileDialog.this.dbversion.getSelectionIndex());
                Configuration dosboxConf = EditProfileDialog.loadDBVersionConfig((DosboxVersion)EditProfileDialog.this.dbversionsList.get(EditProfileDialog.this.dbversion.getSelectionIndex()), EditProfileDialog.this.shell);
                EditProfileDialog.this.getConfigurationBySettings(EditProfileDialog.this.profileConf, false);
                String confFile = null;
                confFile = EditProfileDialog.this.result instanceof Profile ? ((Profile)EditProfileDialog.this.result).getConfPathAndFile() : FileUtils.constructUniqueConfigFile(profileId, EditProfileDialog.this.title.getText(), EditProfileDialog.this.profileConf.getGameLocation());
                String captures = null;
                if (EditProfileDialog.this.result instanceof Profile) {
                    captures = ((Profile)EditProfileDialog.this.result).getCaptures();
                } else {
                    captures = FileUtils.constructCapturesDir(profileId);
                    FileUtils.createDir(captures);
                    EditProfileDialog.this.profileConf.setValue("dosbox", "captures", FileUtils.constructCanonicalCapturesDir(profileId));
                }
                if (selectedDBVersion.isMultiConfig()) {
                    EditProfileDialog.this.profileConf.substract(dosboxConf);
                }
                EditProfileDialog.saveConfig(EditProfileDialog.this.profileConf, confFile, EditProfileDialog.this.shell);
                if (!(EditProfileDialog.this.result instanceof Profile)) {
                    EditProfileDialog.this.db.updateProfileConf(confFile, captures, profileId);
                }
                EditProfileDialog.this.result = new Profile(profileId, EditProfileDialog.this.title.getText(), EditProfileDialog.this.developer.getText(), EditProfileDialog.this.publisher.getText(), EditProfileDialog.this.genre.getText(), EditProfileDialog.this.year.getText(), dbversionId, EditProfileDialog.this.setup.getText(), EditProfileDialog.this.setup_params.getText(), EditProfileDialog.this.notes.getText(), EditProfileDialog.this.link1.getText(), EditProfileDialog.this.link2.getText(), favorite.getSelection(), EditProfileDialog.this.status.getText(), confFile, captures);
                EditProfileDialog.this.shell.close();
            }
        });
        this.selectSettingsByConfiguration(this.profileConf);
    }

    private String getAutoexecSectionBySettings(boolean isSetup) {
        if (this.dosButton.getSelection()) {
            return new Autoexec(this.mountingpoints.getItems(), this.loadfix.getSelection(), this.loadfix_value.getText(), this.main.getText(), this.setup.getText(), this.main_params.getText(), this.setup_params.getText(), "", "", this.exit.getSelection()).toString(isSetup);
        }
        return new Autoexec(this.mountingpoints.getItems(), this.loadfix.getSelection(), this.loadfix_value.getText(), "", "", "", "", this.img1.getText(), this.img2.getText(), this.exit.getSelection()).toString(isSetup);
    }

    private void selectSettingsByAutoexec(Configuration profileConf) {
        Autoexec autoexec = new Autoexec(profileConf.getValue("autoexec", "autoexec"));
        this.exit.setSelection(autoexec.isExit());
        this.loadfix.setSelection(autoexec.isLoadfix());
        this.loadfix_value.setText(autoexec.getLoadfixValue());
        this.loadfix_value.setEnabled(autoexec.isLoadfix());
        if (this.mountingpoints.getItemCount() == 0) {
            this.mountingpoints.setItems(autoexec.getMountingpoints());
            this.mountingpoints.setSelection(0);
        }
        if (this.main.getText().equals("") && !autoexec.getMain().equals("")) {
            this.main.setText(autoexec.getMain());
            this.main_params.setText(autoexec.getMainParameters());
        }
        if (this.img1.getText().equals("") && !autoexec.getImg1().equals("")) {
            this.img1.setText(autoexec.getImg1());
            this.img2.setText(autoexec.getImg2());
        }
        this.dosButton.setSelection(!autoexec.isBooter());
        this.booterButton.setSelection(autoexec.isBooter());
    }

    private void selectSettingsByConfiguration(Configuration profileConf) {
        String priority = profileConf.getValue("sdl", "priority");
        String[] priorities = priority.split(",");
        if (priorities != null && priorities.length == 2) {
            this.priority_active.setText(priorities[0]);
            this.priority_inactive.setText(priorities[1]);
        }
        this.waitonerror.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "waitonerror")));
        this.language.setText(profileConf.getValue("dosbox", "language"));
        this.output.setText(profileConf.getValue("sdl", "output"));
        this.frameskip.setText(profileConf.getValue("render", "frameskip"));
        this.scaler.setText(profileConf.getValue("render", "scaler"));
        this.pixelshader.setText(profileConf.getValue("sdl", "pixelshader"));
        this.pixelshader.setEnabled(profileConf.hasValue("sdl", "pixelshader"));
        this.fullscreen.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "fullscreen")));
        this.fulldouble.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "fulldouble")));
        this.fullresolution.setText(profileConf.getValue("sdl", "fullresolution"));
        this.windowresolution.setText(profileConf.getValue("sdl", "windowresolution"));
        this.aspect.setSelection(Boolean.valueOf(profileConf.getValue("render", "aspect")));
        this.overscan.setText(profileConf.getValue("sdl", "overscan"));
        this.overscan.setEnabled(profileConf.hasValue("sdl", "overscan"));
        this.svgachipset.setText(profileConf.getValue("vga", "svgachipset"));
        this.svgachipset.setEnabled(profileConf.hasValue("vga", "svgachipset"));
        this.videoram.setText(profileConf.getValue("vga", "videoram"));
        this.videoram.setEnabled(profileConf.hasValue("vga", "videoram"));
        this.vsyncmode.setText(profileConf.getValue("vsync", "vsyncmode"));
        this.vsyncmode.setEnabled(profileConf.hasValue("vsync", "vsyncmode"));
        this.vsyncrate.setText(profileConf.getValue("vsync", "vsyncrate"));
        this.vsyncrate.setEnabled(profileConf.hasValue("vsync", "vsyncrate"));
        this.glide.setSelection(Boolean.valueOf(profileConf.getValue("glide", "glide")));
        this.glide.setEnabled(profileConf.hasValue("glide", "glide"));
        this.glideport.setText(profileConf.getValue("glide", "port"));
        this.glideport.setEnabled(profileConf.hasValue("glide", "port") && this.glide.getSelection());
        this.machine.setText(profileConf.getValue("dosbox", "machine"));
        this.core.setText(profileConf.getValue("cpu", "core"));
        this.cycles.setText(profileConf.getValue("cpu", "cycles"));
        this.cycles_up.setText(profileConf.getValue("cpu", "cycleup"));
        this.cycles_down.setText(profileConf.getValue("cpu", "cycledown"));
        this.timesynched.setSelection(Boolean.valueOf(profileConf.getValue("cpu", "timesynched")));
        this.timesynched.setEnabled(profileConf.hasValue("cpu", "timesynched"));
        this.memsize.setText(profileConf.getValue("dosbox", "memsize"));
        this.xms.setSelection(Boolean.valueOf(profileConf.getValue("dos", "xms")));
        this.ems.setSelection(Boolean.valueOf(profileConf.getValue("dos", "ems")));
        this.umb.setText(profileConf.getValue("dos", "umb"));
        this.nosound.setSelection(Boolean.valueOf(profileConf.getValue("mixer", "nosound")));
        this.rate.setText(profileConf.getValue("mixer", "rate"));
        this.mt32rate.setText(profileConf.getValue("midi", "mt32rate"));
        this.mt32rate.setEnabled(profileConf.hasValue("midi", "mt32rate"));
        this.blocksize.setText(profileConf.getValue("mixer", "blocksize"));
        this.prebuffer.setText(profileConf.getValue("mixer", "prebuffer"));
        this.mpu401.setText(profileConf.getValue("midi", "mpu401"));
        this.device.setText(profileConf.getValue("midi", "device"));
        this.midi_config.setText(profileConf.getValue("midi", "config"));
        this.sbtype.setText(profileConf.getValue("sblaster", "sbtype"));
        this.oplmode.setText(profileConf.getValue("sblaster", "oplmode"));
        this.oplrate.setText(profileConf.getValue("sblaster", "oplrate"));
        this.sbbase.setText(profileConf.getValue("sblaster", "sbbase"));
        this.irq.setText(profileConf.getValue("sblaster", "irq"));
        this.dma.setText(profileConf.getValue("sblaster", "dma"));
        this.hdma.setText(profileConf.getValue("sblaster", "hdma"));
        this.mixer.setSelection(Boolean.valueOf(profileConf.getValue("sblaster", "mixer")));
        this.gus.setSelection(Boolean.valueOf(profileConf.getValue("gus", "gus")));
        this.gusrate.setText(profileConf.getValue("gus", "gusrate"));
        this.gusbase.setText(profileConf.getValue("gus", "gusbase"));
        this.irq1.setText(profileConf.getValue("gus", "irq1"));
        this.irq2.setText(profileConf.getValue("gus", "irq2"));
        this.dma1.setText(profileConf.getValue("gus", "dma1"));
        this.dma2.setText(profileConf.getValue("gus", "dma2"));
        this.ultradir.setText(profileConf.getValue("gus", "ultradir"));
        this.pcspeaker.setSelection(Boolean.valueOf(profileConf.getValue("speaker", "pcspeaker")));
        this.pcrate.setText(profileConf.getValue("speaker", "pcrate"));
        this.tandy.setText(profileConf.getValue("speaker", "tandy"));
        this.tandyrate.setText(profileConf.getValue("speaker", "tandyrate"));
        this.disney.setSelection(Boolean.valueOf(profileConf.getValue("speaker", "disney")));
        this.autolock.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "autolock")));
        this.sensitivity.setText(profileConf.getValue("sdl", "sensitivity"));
        this.usescancodes.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "usescancodes")));
        this.mapperfile.setText(profileConf.getValue("sdl", "mapperfile"));
        String joy = profileConf.getValue("bios", "joysticktype");
        String[] joys = joy.split(" ");
        if (joys != null && joys.length >= 1) {
            this.joysticktype.setText(joys[0]);
            int i = 1;
            while (i < joys.length) {
                if (joys[i].equals("timed")) {
                    this.timed.setSelection(true);
                } else if (joys[i].equals("autofire")) {
                    this.autofire.setSelection(true);
                } else if (joys[i].equals("swap34")) {
                    this.swap34.setSelection(true);
                }
                ++i;
            }
        }
        this.serial1.setText(profileConf.getValue("serial", "serial1"));
        this.serial2.setText(profileConf.getValue("serial", "serial2"));
        this.serial3.setText(profileConf.getValue("serial", "serial3"));
        this.serial4.setText(profileConf.getValue("serial", "serial4"));
        this.ipx.setSelection(Boolean.valueOf(profileConf.getValue("ipx", "ipx")));
        this.selectSettingsByAutoexec(profileConf);
    }

    private void getConfigurationBySettings(Configuration profileConf, boolean isSetup) {
        profileConf.setValue("sdl", "priority", String.valueOf(this.priority_active.getText()) + "," + this.priority_inactive.getText());
        profileConf.setValue("sdl", "waitonerror", String.valueOf(this.waitonerror.getSelection()));
        profileConf.setValue("dosbox", "language", this.language.getText());
        profileConf.setValue("sdl", "output", this.output.getText());
        profileConf.setValue("render", "frameskip", this.frameskip.getText());
        profileConf.setValue("render", "scaler", this.scaler.getText());
        profileConf.updateValue("sdl", "pixelshader", this.pixelshader.getText());
        profileConf.setValue("sdl", "fullscreen", String.valueOf(this.fullscreen.getSelection()));
        profileConf.setValue("sdl", "fulldouble", String.valueOf(this.fulldouble.getSelection()));
        profileConf.setValue("sdl", "fullresolution", this.fullresolution.getText());
        profileConf.setValue("sdl", "windowresolution", this.windowresolution.getText());
        profileConf.setValue("render", "aspect", String.valueOf(this.aspect.getSelection()));
        profileConf.updateValue("sdl", "overscan", this.overscan.getText());
        profileConf.updateValue("vga", "svgachipset", this.svgachipset.getText());
        profileConf.updateValue("vga", "videoram", this.videoram.getText());
        profileConf.updateValue("vsync", "vsyncmode", this.vsyncmode.getText());
        profileConf.updateValue("vsync", "vsyncrate", this.vsyncrate.getText());
        profileConf.updateValue("glide", "glide", String.valueOf(this.glide.getSelection()));
        profileConf.updateValue("glide", "port", this.glideport.getText());
        profileConf.setValue("dosbox", "machine", this.machine.getText());
        profileConf.setValue("cpu", "core", this.core.getText());
        profileConf.setValue("cpu", "cycles", this.cycles.getText());
        profileConf.setValue("cpu", "cycleup", this.cycles_up.getText());
        profileConf.setValue("cpu", "cycledown", this.cycles_down.getText());
        profileConf.updateValue("cpu", "timesynched", String.valueOf(this.timesynched.getSelection()));
        profileConf.setValue("dosbox", "memsize", this.memsize.getText());
        profileConf.setValue("dos", "xms", String.valueOf(this.xms.getSelection()));
        profileConf.setValue("dos", "ems", String.valueOf(this.ems.getSelection()));
        profileConf.setValue("dos", "umb", this.umb.getText());
        profileConf.setValue("mixer", "nosound", String.valueOf(this.nosound.getSelection()));
        profileConf.setValue("mixer", "rate", this.rate.getText());
        profileConf.updateValue("midi", "mt32rate", this.mt32rate.getText());
        profileConf.setValue("mixer", "blocksize", this.blocksize.getText());
        profileConf.setValue("mixer", "prebuffer", this.prebuffer.getText());
        profileConf.setValue("midi", "mpu401", this.mpu401.getText());
        profileConf.setValue("midi", "device", this.device.getText());
        profileConf.setValue("midi", "config", this.midi_config.getText());
        profileConf.setValue("sblaster", "sbtype", this.sbtype.getText());
        profileConf.setValue("sblaster", "oplmode", this.oplmode.getText());
        profileConf.setValue("sblaster", "sbbase", this.sbbase.getText());
        profileConf.setValue("sblaster", "irq", this.irq.getText());
        profileConf.setValue("sblaster", "dma", this.dma.getText());
        profileConf.setValue("sblaster", "hdma", this.hdma.getText());
        profileConf.setValue("sblaster", "mixer", String.valueOf(this.mixer.getSelection()));
        profileConf.setValue("gus", "gus", String.valueOf(this.gus.getSelection()));
        profileConf.setValue("gus", "gusrate", this.gusrate.getText());
        profileConf.setValue("gus", "gusbase", this.gusbase.getText());
        profileConf.setValue("gus", "irq1", this.irq1.getText());
        profileConf.setValue("gus", "irq2", this.irq2.getText());
        profileConf.setValue("gus", "dma1", this.dma1.getText());
        profileConf.setValue("gus", "dma2", this.dma2.getText());
        profileConf.setValue("gus", "ultradir", this.ultradir.getText());
        profileConf.setValue("speaker", "pcspeaker", String.valueOf(this.pcspeaker.getSelection()));
        profileConf.setValue("speaker", "pcrate", this.pcrate.getText());
        profileConf.setValue("speaker", "tandy", this.tandy.getText());
        profileConf.setValue("speaker", "tandyrate", this.tandyrate.getText());
        profileConf.setValue("speaker", "disney", String.valueOf(this.disney.getSelection()));
        profileConf.setValue("sdl", "autolock", String.valueOf(this.autolock.getSelection()));
        profileConf.setValue("sdl", "sensitivity", this.sensitivity.getText());
        profileConf.setValue("sdl", "usescancodes", String.valueOf(this.usescancodes.getSelection()));
        profileConf.setValue("sdl", "mapperfile", this.mapperfile.getText());
        String joy = this.joysticktype.getText();
        if (this.timed.getSelection()) {
            joy = String.valueOf(joy) + " timed";
        }
        if (this.autofire.getSelection()) {
            joy = String.valueOf(joy) + " autofire";
        }
        if (this.swap34.getSelection()) {
            joy = String.valueOf(joy) + " swap34";
        }
        profileConf.setValue("bios", "joysticktype", joy);
        profileConf.setValue("serial", "serial1", this.serial1.getText());
        profileConf.setValue("serial", "serial2", this.serial2.getText());
        profileConf.setValue("serial", "serial3", this.serial3.getText());
        profileConf.setValue("serial", "serial4", this.serial4.getText());
        profileConf.setValue("ipx", "ipx", String.valueOf(this.ipx.getSelection()));
        profileConf.setValue("autoexec", "autoexec", this.getAutoexecSectionBySettings(isSetup));
    }

    private void addMountIfNoMounts(String hostFileLocation) {
        Mount mount;
        if (this.mountingpoints.getItemCount() == 0 && !(mount = new Mount(this.booterButton.getSelection(), hostFileLocation, this.mountingpoints.getItems())).getPath().equals("")) {
            this.mountingpoints.add(mount.toString());
        }
    }

    private boolean isValid() {
        Autoexec autoexec = new Autoexec(this.getAutoexecSectionBySettings(false));
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a profile title", this.title, this.infoTabItem);
        }
        if (this.dosButton.getSelection()) {
            Mount mount;
            if (this.main.getText().equals("") || !this.main.getText().toLowerCase().endsWith(".com") && !this.main.getText().toLowerCase().endsWith(".exe") && !this.main.getText().toLowerCase().endsWith(".bat")) {
                GeneralPurposeDialogs.addError("You must enter a valid profile executable", this.main, this.mountingTabItem);
            } else if (autoexec.getMain().equals("") && !(mount = new Mount(false, this.main.getText(), this.mountingpoints.getItems())).getPath().equals("") && GeneralPurposeDialogs.confirmMessage(this.shell, "Would you like to add the mount location \"" + mount.getPath() + "\"?")) {
                this.mountingpoints.add(mount.toString());
                autoexec = new Autoexec(this.getAutoexecSectionBySettings(false));
            }
            if (autoexec.getMain().equals("")) {
                GeneralPurposeDialogs.addError("You must enter a valid mount location", this.mountingpoints, this.mountingTabItem);
            }
        } else if (this.booterButton.getSelection()) {
            Mount mount;
            if (this.img1.getText().equals("")) {
                GeneralPurposeDialogs.addError("You must enter a profile booter image", this.img1, this.mountingTabItem);
            } else if (autoexec.getImg1().equals("") && !(mount = new Mount(true, this.img1.getText(), this.mountingpoints.getItems())).getPath().equals("") && GeneralPurposeDialogs.confirmMessage(this.shell, "Would you like to add the mount location \"" + mount.getPath() + "\"?")) {
                this.mountingpoints.add(mount.toString());
                autoexec = new Autoexec(this.getAutoexecSectionBySettings(false));
            }
            if (autoexec.getImg1().equals("")) {
                GeneralPurposeDialogs.addError("You must enter a valid mount location", this.mountingpoints, this.mountingTabItem);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private void doGrab(Text textWidget) {
        int index = this.mountingpoints.getSelectionIndex();
        if (index != -1) {
            Mount mount = new Mount(this.mountingpoints.getItem(index));
            textWidget.setText(mount.getPath());
            textWidget.selectAll();
            textWidget.setFocus();
        }
    }

    public static Configuration loadDBVersionConfig(DosboxVersion dbversion, Shell shell) {
        Configuration result;
        try {
            result = new Configuration(dbversion.getConfigFile());
        }
        catch (IOException ex) {
            GeneralPurposeDialogs.warningMessage(shell, ex.getMessage());
            result = new Configuration();
        }
        if (result.hasParsingProblems()) {
            GeneralPurposeDialogs.warningMessage(shell, result.getParsingProblems());
        }
        return result;
    }

    public static Configuration loadTemplateConfig(DosboxVersion dbversion, Template template, Shell shell) {
        return EditProfileDialog.loadExistingConfig(dbversion, FileUtils.constructTemplateFileLocation(template.getId()), shell);
    }

    public static Configuration loadExistingConfig(DosboxVersion dbversion, String file, Shell shell) {
        Configuration result = EditProfileDialog.loadDBVersionConfig(dbversion, shell);
        try {
            result.parseConfigurationFile(file);
        }
        catch (IOException ex) {
            GeneralPurposeDialogs.warningMessage(shell, ex.getMessage());
        }
        if (result.hasParsingProblems()) {
            GeneralPurposeDialogs.warningMessage(shell, result.getParsingProblems());
        }
        return result;
    }

    public static void saveConfig(Configuration conf, String file, Shell shell) {
        try {
            conf.saveToFile(file);
        }
        catch (IOException ex) {
            GeneralPurposeDialogs.warningMessage(shell, ex.getMessage());
        }
    }
}

