/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.GeneralPurposeDialogs;
import com.model.Mount;
import com.model.Settings;
import com.util.StringUtils;
import java.io.File;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditMountDialog
extends Dialog {
    private char defaultDriveletter = (char)67;
    private Combo driveletter;
    private Button mountZipButton;
    private Button mountImageButton;
    private Button mountDirectoryButton;
    private Text mount_dir;
    private Text mount_label;
    private Combo mount_type;
    private Text imgmount_image;
    private Text zipmount_write;
    private Text zipmount_zip;
    private Text zipmount_label;
    private Combo zipmount_type;
    private Settings settings;
    protected Object result;
    protected Shell shell;

    public EditMountDialog(Shell parent) {
        super(parent, 0);
    }

    public void setMount(String mount) {
        this.result = mount;
    }

    public void setDefaultDriveletter(char driveletter) {
        this.defaultDriveletter = driveletter;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setSize(480, 440);
        if (this.result != null) {
            this.shell.setText("Edit Mount Point");
        } else {
            this.shell.setText("Add Mount Point");
        }
        Composite composite = new Composite(this.shell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout(gridLayout);
        Label driveLetterLabel = new Label(composite, 0);
        driveLetterLabel.setText("Drive Letter");
        this.driveletter = new Combo(composite, 8);
        this.driveletter.setItems(new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y"});
        this.driveletter.setLayoutData(new GridData());
        this.driveletter.select(this.defaultDriveletter - 65);
        new Label(composite, 0);
        new Label(composite, 0);
        this.mountDirectoryButton = new Button(composite, 16);
        this.mountDirectoryButton.setText("Mount Directory");
        this.mount_dir = new Text(composite, 2048);
        this.mount_dir.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.mount_dir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditMountDialog.this.mountDirectoryButton.setSelection(true);
                EditMountDialog.this.mountImageButton.setSelection(false);
                EditMountDialog.this.mountZipButton.setSelection(false);
            }
        });
        Button browseButton = new Button(composite, 0);
        browseButton.setLayoutData(new GridData());
        browseButton.setText("Browse..");
        browseButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(EditMountDialog.this.shell);
                dialog.setFilterPath(EditMountDialog.this.mount_dir.getText());
                String result = dialog.open();
                if (result != null) {
                    EditMountDialog.this.mount_dir.setText(result);
                }
            }
        });
        new Label(composite, 0);
        Label asLabel = new Label(composite, 0);
        asLabel.setLayoutData(new GridData());
        asLabel.setText("As");
        this.mount_type = new Combo(composite, 8);
        this.mount_type.setItems(this.settings.getValues("profile", "mount_type"));
        this.mount_type.add("", 0);
        this.mount_type.setLayoutData(new GridData(16384, 0x1000000, false, false, 2, 1));
        new Label(composite, 0);
        Label label = new Label(composite, 0);
        label.setLayoutData(new GridData());
        label.setText("Label");
        this.mount_label = new Text(composite, 2048);
        this.mount_label.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        new Label(composite, 0);
        Label lowlevelCdLabel = new Label(composite, 0);
        lowlevelCdLabel.setLayoutData(new GridData());
        lowlevelCdLabel.setText("Force ioctl");
        final Button ioctlButton = new Button(composite, 32);
        ioctlButton.setLayoutData(new GridData());
        new Label(composite, 0);
        Label label_1 = new Label(composite, 258);
        label_1.setLayoutData(new GridData(4, 0x1000000, true, false, 4, 1));
        this.mountImageButton = new Button(composite, 16);
        this.mountImageButton.setText("Mount CD-Image(s)");
        this.imgmount_image = new Text(composite, 2818);
        this.imgmount_image.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.imgmount_image.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditMountDialog.this.mountDirectoryButton.setSelection(false);
                EditMountDialog.this.mountImageButton.setSelection(true);
                EditMountDialog.this.mountZipButton.setSelection(false);
            }
        });
        Button browseButton_1 = new Button(composite, 0);
        browseButton_1.setLayoutData(new GridData());
        browseButton_1.setText("Browse..");
        browseButton_1.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EditMountDialog.this.shell, 4098);
                dialog.setFilterNames(new String[]{"CD Images", "*.*"});
                dialog.setFilterExtensions(new String[]{"*.iso;*.ISO;*.cue;*.CUE", "*.*"});
                String fPath = EditMountDialog.this.imgmount_image.getText().split(EditMountDialog.this.imgmount_image.getLineDelimiter())[0];
                dialog.setFilterPath(fPath);
                String result = dialog.open();
                if (result != null) {
                    String path = StringUtils.fixDir(dialog.getFilterPath());
                    String images = "";
                    String[] stringArray = dialog.getFileNames();
                    int n = 0;
                    int n2 = stringArray.length;
                    while (n < n2) {
                        String file = stringArray[n];
                        images = String.valueOf(images) + path + File.separatorChar + file + "\n";
                        ++n;
                    }
                    EditMountDialog.this.imgmount_image.setText(images);
                }
            }
        });
        Label label_2 = new Label(composite, 258);
        label_2.setLayoutData(new GridData(4, 0x1000000, true, false, 4, 1));
        this.mountZipButton = new Button(composite, 16);
        this.mountZipButton.setText("Mount Zip");
        Label zipLabel = new Label(composite, 0);
        zipLabel.setLayoutData(new GridData());
        zipLabel.setText("Zip");
        this.zipmount_zip = new Text(composite, 2048);
        this.zipmount_zip.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.zipmount_zip.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditMountDialog.this.mountDirectoryButton.setSelection(false);
                EditMountDialog.this.mountImageButton.setSelection(false);
                EditMountDialog.this.mountZipButton.setSelection(true);
            }
        });
        Button browseButton_2 = new Button(composite, 0);
        browseButton_2.setLayoutData(new GridData());
        browseButton_2.setText("Browse..");
        browseButton_2.setText("Browse..");
        browseButton_2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EditMountDialog.this.shell, 4096);
                dialog.setFilterNames(new String[]{"Zip files", "*.*"});
                dialog.setFilterExtensions(new String[]{"*.zip;*.ZIP", "*.*"});
                dialog.setFilterPath(EditMountDialog.this.zipmount_zip.getText());
                String result = dialog.open();
                if (result != null) {
                    EditMountDialog.this.zipmount_zip.setText(result);
                }
            }
        });
        new Label(composite, 0);
        Label writeLabel = new Label(composite, 0);
        writeLabel.setLayoutData(new GridData());
        writeLabel.setText("Write");
        this.zipmount_write = new Text(composite, 2048);
        this.zipmount_write.setLayoutData(new GridData(4, 0x1000000, true, false));
        Button browseButton_3 = new Button(composite, 0);
        browseButton_3.setLayoutData(new GridData());
        browseButton_3.setText("Browse..");
        browseButton_3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(EditMountDialog.this.shell);
                dialog.setFilterPath(EditMountDialog.this.zipmount_write.getText());
                String result = dialog.open();
                if (result != null) {
                    EditMountDialog.this.zipmount_write.setText(result);
                }
            }
        });
        new Label(composite, 0);
        Label asLabel_1 = new Label(composite, 0);
        asLabel_1.setLayoutData(new GridData());
        asLabel_1.setText("As");
        this.zipmount_type = new Combo(composite, 8);
        this.zipmount_type.setItems(this.settings.getValues("profile", "zipmount_type"));
        this.zipmount_type.add("", 0);
        this.zipmount_type.setLayoutData(new GridData());
        new Label(composite, 0);
        new Label(composite, 0);
        Label label_3 = new Label(composite, 0);
        label_3.setLayoutData(new GridData());
        label_3.setText("Label");
        this.zipmount_label = new Text(composite, 2048);
        this.zipmount_label.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        Composite composite_1 = new Composite(this.shell, 0);
        composite_1.setLayout(new RowLayout());
        composite_1.setLayoutData("South");
        Button okButton = new Button(composite_1, 0);
        RowData rowData = new RowData();
        rowData.width = 80;
        okButton.setLayoutData(rowData);
        this.shell.setDefaultButton(okButton);
        okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditMountDialog.this.isValid()) {
                    return;
                }
                Mount mount = null;
                if (EditMountDialog.this.mountDirectoryButton.getSelection()) {
                    mount = new Mount(Mount.MountingType.DIR, EditMountDialog.this.mount_type.getText(), EditMountDialog.this.driveletter.getText(), EditMountDialog.this.mount_dir.getText(), EditMountDialog.this.mount_label.getText(), ioctlButton.getSelection(), "");
                } else if (EditMountDialog.this.mountImageButton.getSelection()) {
                    mount = new Mount(Mount.MountingType.IMAGE, "iso", EditMountDialog.this.driveletter.getText(), EditMountDialog.this.imgmount_image.getText().replaceAll(EditMountDialog.this.imgmount_image.getLineDelimiter(), "\n"), "", false, "");
                } else if (EditMountDialog.this.mountZipButton.getSelection()) {
                    mount = new Mount(Mount.MountingType.PHYSFS, EditMountDialog.this.zipmount_type.getText(), EditMountDialog.this.driveletter.getText(), EditMountDialog.this.zipmount_zip.getText(), EditMountDialog.this.zipmount_label.getText(), false, EditMountDialog.this.zipmount_write.getText());
                }
                EditMountDialog.this.result = mount.toString();
                EditMountDialog.this.shell.close();
            }
        });
        okButton.setText("OK");
        Button cancelButton = new Button(composite_1, 0);
        RowData rowData_1 = new RowData();
        rowData_1.width = 80;
        cancelButton.setLayoutData(rowData_1);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMountDialog.this.result = null;
                EditMountDialog.this.shell.close();
            }
        });
        this.mount_dir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditMountDialog.this.mountDirectoryButton.setSelection(true);
                EditMountDialog.this.mountImageButton.setSelection(false);
                EditMountDialog.this.mountZipButton.setSelection(false);
            }
        });
        this.imgmount_image.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditMountDialog.this.mountDirectoryButton.setSelection(false);
                EditMountDialog.this.mountImageButton.setSelection(true);
                EditMountDialog.this.mountZipButton.setSelection(false);
            }
        });
        this.zipmount_zip.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditMountDialog.this.mountDirectoryButton.setSelection(false);
                EditMountDialog.this.mountImageButton.setSelection(false);
                EditMountDialog.this.mountZipButton.setSelection(true);
            }
        });
        if (this.result != null) {
            Mount mount = new Mount((String)this.result);
            this.driveletter.setText(mount.getDriveletterString());
            switch (mount.getMountingType()) {
                case DIR: {
                    this.mountDirectoryButton.setSelection(true);
                    this.mount_dir.setText(mount.getPath());
                    if (!mount.getMountAs().equals("")) {
                        this.mount_type.setText(mount.getMountAs());
                    }
                    this.mount_label.setText(mount.getLabel());
                    ioctlButton.setSelection(mount.isIoctl());
                    break;
                }
                case PHYSFS: {
                    this.mountZipButton.setSelection(true);
                    this.zipmount_zip.setText(mount.getPath());
                    this.zipmount_write.setText(mount.getWrite());
                    if (!mount.getMountAs().equals("")) {
                        this.zipmount_type.setText(mount.getMountAs());
                    }
                    this.zipmount_label.setText(mount.getLabel());
                    break;
                }
                case IMAGE: {
                    this.mountImageButton.setSelection(true);
                    this.imgmount_image.setText(mount.getPath());
                }
            }
        } else {
            this.mountDirectoryButton.setSelection(true);
        }
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.mountDirectoryButton.getSelection() && this.mount_dir.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a path to mount", this.mount_dir);
        } else if (this.mountImageButton.getSelection() && this.imgmount_image.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter at least one image to mount", this.imgmount_image);
        } else if (this.mountZipButton.getSelection() && this.zipmount_zip.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter an zip to mount", this.zipmount_zip);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

