/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.GeneralPurposeDialogs;
import com.util.FileUtils;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class BrowseArchiveDialog
extends Dialog {
    private List files;
    private String archive = null;
    protected Object result;
    protected Shell shell;

    public BrowseArchiveDialog(Shell parent, int style) {
        super(parent, style);
    }

    public BrowseArchiveDialog(Shell parent) {
        this(parent, 0);
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.shell.setLayout(gridLayout);
        this.shell.setSize(400, 375);
        this.shell.setText("Archive Browser");
        this.files = new List(this.shell, 2560);
        this.files.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        try {
            this.files.setItems(FileUtils.getExecutablesInZip(this.archive));
            if (this.files.getItemCount() <= 0) {
                GeneralPurposeDialogs.warningMessage(this.shell, "The archive doesn't appear to contain any executables.");
                return;
            }
            this.files.setSelection(0);
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, "Could not read contents of archive: " + e.getMessage());
            return;
        }
        this.files.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                BrowseArchiveDialog.this.result = String.valueOf(BrowseArchiveDialog.this.archive) + ':' + File.separatorChar + BrowseArchiveDialog.this.files.getItem(BrowseArchiveDialog.this.files.getSelectionIndex());
                BrowseArchiveDialog.this.shell.close();
            }
        });
        Button okButton = new Button(this.shell, 0);
        okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseArchiveDialog.this.result = String.valueOf(BrowseArchiveDialog.this.archive) + ':' + File.separatorChar + BrowseArchiveDialog.this.files.getItem(BrowseArchiveDialog.this.files.getSelectionIndex());
                BrowseArchiveDialog.this.shell.close();
            }
        });
        GridData gridData = new GridData(80, -1);
        okButton.setLayoutData(gridData);
        this.shell.setDefaultButton(okButton);
        okButton.setText("OK");
        Button cancelButton = new Button(this.shell, 0);
        GridData gridData_1 = new GridData(80, -1);
        cancelButton.setLayoutData(gridData_1);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseArchiveDialog.this.shell.close();
            }
        });
    }
}

