/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.connect.Messaging;
import com.db.Database;
import com.gui.DFendImportDialog;
import com.gui.EditDosboxVersionDialog;
import com.gui.EditProfileDialog;
import com.gui.EditTemplateDialog;
import com.gui.ExportListDialog;
import com.gui.GeneralPurposeDialogs;
import com.gui.MigrateDialog;
import com.gui.SettingsDialog;
import com.gui.Thumb;
import com.model.DosboxVersion;
import com.model.OrderingVector;
import com.model.Profile;
import com.model.Settings;
import com.model.Template;
import com.swtdesigner.SWTImageManager;
import com.util.FileUtils;
import com.util.PlatformUtils;
import com.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import swing2swt.layout.BorderLayout;

public final class MainWindow {
    public static final String PROGRAM_VERSION = "0.64";
    public static final String PROGRAM_NAME_FULL = "DOSBox Game Launcher";
    public static final String PROGRAM_NAME = "DOSBox Game Launcher v0.64";
    public static final int RO_COLUMN_NAMES = 10;
    public static final int EDIT_COLUMN_NAMES = 10;
    public static String[] columnNames;
    private Display display;
    private Shell shell;
    private OrderingVector orderingVector = null;
    private List<Profile> profilesList;
    private List<DosboxVersion> dbversionsList;
    private List<Template> templatesList;
    private Database dbase = null;
    private Settings settings = null;
    private File currentThumbFile = null;
    private int thumbHeight;
    private int[] columnIds;
    private Table template_table;
    private Table dbversion_table;
    private Table profile_table;
    private Text notesField;
    private ToolBar thumbsToolBar;
    private Link[] link;
    private Menu runWithSubMenu;
    private Menu setupWithSubMenu;

    public static void main(String[] args) {
        try {
            MainWindow window = new MainWindow();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        this.display = Display.getDefault();
        this.createContents();
        Messaging mess = null;
        if (this.settings.getBooleanValue("communication", "port_enabled")) {
            mess = new Messaging(this.settings.getIntValue("communication", "port"), this);
            mess.start();
        }
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        SWTImageManager.dispose();
        this.display.dispose();
        if (mess != null) {
            mess.close();
        }
        try {
            this.settings.save();
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        try {
            this.dbase.shutdown();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void createContents() {
        this.initColumnIds();
        this.orderingVector = new OrderingVector(this.settings.getIntValues("gui", "sortcolumn"), this.settings.getBooleanValues("gui", "sortascending"));
        this.shell = new Shell();
        try {
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause());
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            this.templatesList = this.dbase.readTemplatesList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.shell.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                boolean isMaximized = MainWindow.this.shell.getMaximized();
                if (!isMaximized) {
                    Rectangle rec = MainWindow.this.shell.getBounds();
                    MainWindow.this.settings.setIntValue("gui", "width", rec.width);
                    MainWindow.this.settings.setIntValue("gui", "height", rec.height);
                    MainWindow.this.settings.setIntValue("gui", "x", rec.x);
                    MainWindow.this.settings.setIntValue("gui", "y", rec.y);
                }
                MainWindow.this.settings.setBooleanValue("gui", "maximized", isMaximized);
            }
        });
        this.shell.addControlListener(new ControlAdapter(){

            public void controlMoved(ControlEvent event) {
                if (!MainWindow.this.shell.getMaximized()) {
                    Rectangle rec = MainWindow.this.shell.getBounds();
                    MainWindow.this.settings.setIntValue("gui", "x", rec.x);
                    MainWindow.this.settings.setIntValue("gui", "y", rec.y);
                }
            }
        });
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setMaximized(this.settings.getBooleanValue("gui", "maximized"));
        this.shell.setLocation(this.settings.getIntValue("gui", "x"), this.settings.getIntValue("gui", "y"));
        this.shell.setSize(this.settings.getIntValue("gui", "width"), this.settings.getIntValue("gui", "height"));
        this.shell.setText(this.settings.msg("main.title", new Object[]{PROGRAM_VERSION}));
        Menu menu = new Menu(this.shell, 2);
        this.shell.setMenuBar(menu);
        MenuItem fileMenuItem = new MenuItem(menu, 64);
        fileMenuItem.setText(this.settings.msg("dialog.main.menu.file"));
        Menu menu_1 = new Menu(fileMenuItem);
        fileMenuItem.setMenu(menu_1);
        if (PlatformUtils.IS_WINDOWS) {
            MenuItem dfendImportItem = new MenuItem(menu_1, 0);
            dfendImportItem.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MainWindow.this.doDFendImport();
                }
            });
            dfendImportItem.setText(this.settings.msg("dialog.main.menu.importdfendprofiles"));
            new MenuItem(menu_1, 2);
        }
        MenuItem migrateMenuItem = new MenuItem(menu_1, 0);
        migrateMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doMigrate();
            }
        });
        migrateMenuItem.setText(this.settings.msg("dialog.main.menu.migrateprofiles"));
        MenuItem exportMenuItem = new MenuItem(menu_1, 0);
        exportMenuItem.setText(this.settings.msg("dialog.main.menu.exportprofileslist"));
        exportMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doExportProfilesList();
            }
        });
        MenuItem confImportItem = new MenuItem(menu_1, 0);
        confImportItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doImportConfigfile();
            }
        });
        confImportItem.setText(this.settings.msg("dialog.main.menu.importprofile"));
        new MenuItem(menu_1, 2);
        MenuItem cleanupDatabaseItem = new MenuItem(menu_1, 0);
        cleanupDatabaseItem.setText(this.settings.msg("dialog.main.menu.databasecleanup"));
        cleanupDatabaseItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (GeneralPurposeDialogs.confirmMessage(MainWindow.this.shell, MainWindow.this.settings.msg("dialog.main.confirm.databasecleanup"))) {
                        int itemsRemoved = MainWindow.this.dbase.cleanup();
                        GeneralPurposeDialogs.infoMessage(MainWindow.this.shell, MainWindow.this.settings.msg("dialog.main.notice.databasecleanupok", new Object[]{itemsRemoved}));
                    }
                }
                catch (SQLException ex) {
                    GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, ex.getMessage());
                }
            }
        });
        new MenuItem(menu_1, 2);
        MenuItem settingsMenuItem = new MenuItem(menu_1, 0);
        settingsMenuItem.setText(this.settings.msg("dialog.main.menu.adjustsettings"));
        settingsMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doOpenSettingsDialog();
            }
        });
        MenuItem exitMenuItem = new MenuItem(menu_1, 0);
        exitMenuItem.setText(this.settings.msg("dialog.main.menu.exit"));
        exitMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.shell.close();
            }
        });
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        TabItem profilesTabItem = new TabItem(tabFolder, 0);
        profilesTabItem.setText(this.settings.msg("dialog.main.profiles"));
        Composite composite = new Composite(tabFolder, 0);
        composite.setLayout((Layout)new BorderLayout(0, 0));
        profilesTabItem.setControl(composite);
        ToolBar toolBar = new ToolBar(composite, 0);
        toolBar.setLayoutData("North");
        SelectionAdapter addProfileAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddProfile();
            }
        };
        SelectionAdapter editProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditProfile();
            }
        };
        SelectionAdapter removeProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveProfile();
            }
        };
        ToolItem newItemToolItem = new ToolItem(toolBar, 8);
        newItemToolItem.setText(this.settings.msg("dialog.main.addprofile"));
        newItemToolItem.addSelectionListener(addProfileAdapter);
        ToolItem newItemToolItem_2 = new ToolItem(toolBar, 8);
        newItemToolItem_2.setText(this.settings.msg("dialog.main.editprofile"));
        newItemToolItem_2.addSelectionListener(editProfAdapter);
        ToolItem newItemToolItem_1 = new ToolItem(toolBar, 8);
        newItemToolItem_1.setText(this.settings.msg("dialog.main.removeprofile"));
        newItemToolItem_1.addSelectionListener(removeProfAdapter);
        final SashForm sashForm = new SashForm(composite, 0);
        this.profile_table = new Table(sashForm, 67584);
        Composite informationGroup = new Composite(sashForm, 0);
        informationGroup.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings.setIntValues("gui", "sashweights", sashForm.getWeights());
            }
        });
        informationGroup.setLayout((Layout)new BorderLayout(0, 0));
        this.notesField = new Text(informationGroup, 2634);
        Composite composite_2 = new Composite(informationGroup, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        gridLayout.verticalSpacing = 1;
        composite_2.setLayout(gridLayout);
        composite_2.setLayoutData("South");
        this.link = new Link[4];
        int i = 0;
        while (i < this.link.length) {
            this.link[i] = new Link(composite_2, 0);
            this.link[i].setLayoutData(new GridData(4, 0x1000000, true, false));
            this.link[i].setText(" ");
            this.link[i].addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PlatformUtils.openForBrowsing(event.text);
                }
            });
            ++i;
        }
        this.thumbHeight = this.settings.getIntValue("gui", "screenshotsheight");
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2304);
        scrolledComposite.setMinHeight(this.thumbHeight + 20);
        scrolledComposite.setLayoutData("South");
        this.thumbsToolBar = new ToolBar(scrolledComposite, 0);
        this.thumbsToolBar.addMouseListener(new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                MainWindow.this.currentThumbFile = new File(MainWindow.this.thumbsToolBar.getItem(new Point(event.x, event.y)).getToolTipText());
            }
        });
        scrolledComposite.setContent(this.thumbsToolBar);
        Menu menu_thumb = new Menu(this.thumbsToolBar);
        this.thumbsToolBar.setMenu(menu_thumb);
        MenuItem thumbMenuItem1 = new MenuItem(menu_thumb, 0);
        thumbMenuItem1.setText(this.settings.msg("dialog.main.thumb.remove"));
        thumbMenuItem1.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveThumb();
            }
        });
        new MenuItem(menu_thumb, 2);
        MenuItem thumbMenuItem2 = new MenuItem(menu_thumb, 0);
        thumbMenuItem2.setText(this.settings.msg("dialog.main.thumb.openfolder"));
        thumbMenuItem2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PlatformUtils.openDirForViewing(MainWindow.this.currentThumbFile.getParentFile());
            }
        });
        MenuItem thumbMenuItem3 = new MenuItem(menu_thumb, 0);
        thumbMenuItem3.setText(this.settings.msg("dialog.main.thumb.refresh"));
        thumbMenuItem3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SWTImageManager.dispose();
                MainWindow.this.displayProfileInformation();
            }
        });
        this.profile_table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    MainWindow.this.doRemoveProfile();
                } else if (event.keyCode == 0x1000009) {
                    MainWindow.this.doAddProfile();
                } else if (event.keyCode == 0x100000B) {
                    MainWindow.this.doEditProfile(true);
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleFavoriteProfile();
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 100) {
                    MainWindow.this.doDuplicateProfile();
                }
            }
        });
        this.profile_table.setLayoutData("West");
        this.profile_table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == 262144 && event.detail == 4) {
                    MainWindow.this.doEditProfile();
                } else if (event.stateMask == 131072 && event.detail == 4) {
                    MainWindow.this.doRunProfile(true);
                } else if (event.detail == 4) {
                    MainWindow.this.doRunProfile(false);
                }
            }
        });
        this.profile_table.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doRunProfile(false);
            }
        });
        this.profile_table.setLinesVisible(true);
        this.profile_table.setHeaderVisible(true);
        int i2 = 0;
        while (i2 < this.columnIds.length) {
            this.addProfileColumn(columnNames[this.columnIds[i2]], i2);
            ++i2;
        }
        this.profile_table.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.displayProfileInformation();
            }
        });
        Menu menu_2 = new Menu(this.profile_table);
        this.profile_table.setMenu(menu_2);
        MenuItem runMenuItem = new MenuItem(menu_2, 0);
        runMenuItem.setText(this.settings.msg("dialog.main.profile.run"));
        runMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunProfile(false);
            }
        });
        MenuItem runWithMenuItem = new MenuItem(menu_2, 64);
        runWithMenuItem.setText(this.settings.msg("dialog.main.profile.runwith"));
        this.runWithSubMenu = new Menu(runWithMenuItem);
        runWithMenuItem.setMenu(this.runWithSubMenu);
        this.updateProfileDbversionsSubmenu();
        final MenuItem setupMenuItem = new MenuItem(menu_2, 0);
        setupMenuItem.setText(this.settings.msg("dialog.main.profile.setup"));
        setupMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunProfile(true);
            }
        });
        final MenuItem setupWithMenuItem = new MenuItem(menu_2, 64);
        setupWithMenuItem.setText(this.settings.msg("dialog.main.profile.setupwith"));
        this.setupWithSubMenu = new Menu(setupWithMenuItem);
        setupWithMenuItem.setMenu(this.setupWithSubMenu);
        this.updateSetupDbversionsSubmenu();
        new MenuItem(menu_2, 2);
        MenuItem addMenuItem = new MenuItem(menu_2, 0);
        addMenuItem.setText(this.settings.msg("dialog.main.profile.add"));
        addMenuItem.addSelectionListener(addProfileAdapter);
        MenuItem editMenuItem = new MenuItem(menu_2, 0);
        editMenuItem.setText(this.settings.msg("dialog.main.profile.edit"));
        editMenuItem.addSelectionListener(editProfAdapter);
        MenuItem duplicateMenuItem = new MenuItem(menu_2, 0);
        duplicateMenuItem.setText(this.settings.msg("dialog.main.profile.duplicate"));
        duplicateMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doDuplicateProfile();
            }
        });
        MenuItem removeMenuItem = new MenuItem(menu_2, 0);
        removeMenuItem.setText(this.settings.msg("dialog.main.profile.remove"));
        removeMenuItem.addSelectionListener(removeProfAdapter);
        new MenuItem(menu_2, 2);
        MenuItem toggleMenuItem = new MenuItem(menu_2, 0);
        toggleMenuItem.setText(this.settings.msg("dialog.main.profile.togglefavorite"));
        toggleMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleFavoriteProfile();
            }
        });
        if (PlatformUtils.IS_WINDOWS) {
            new MenuItem(menu_2, 2);
            MenuItem shortcutMenuItem = new MenuItem(menu_2, 0);
            shortcutMenuItem.setText(this.settings.msg("dialog.main.profile.createshortcut"));
            shortcutMenuItem.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MainWindow.this.doCreateShortcut();
                }
            });
        }
        menu_2.addMenuListener(new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                if (MainWindow.this.profile_table.getSelectionIndex() != -1) {
                    boolean hasSetup = ((Profile)MainWindow.this.profilesList.get(MainWindow.this.profile_table.getSelectionIndex())).hasSetup();
                    setupMenuItem.setEnabled(hasSetup);
                    setupWithMenuItem.setEnabled(hasSetup);
                }
            }
        });
        sashForm.setWeights(this.settings.getIntValues("gui", "sashweights"));
        TabItem dosboxTabItem = new TabItem(tabFolder, 0);
        dosboxTabItem.setText(this.settings.msg("dialog.main.dosboxversions"));
        Composite composite_1 = new Composite(tabFolder, 0);
        composite_1.setLayout((Layout)new BorderLayout(0, 0));
        dosboxTabItem.setControl(composite_1);
        ToolBar toolBar_1 = new ToolBar(composite_1, 0);
        toolBar_1.setLayoutData("North");
        SelectionAdapter addDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddDosboxVersion();
            }
        };
        SelectionAdapter editDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditDosboxVersion();
            }
        };
        SelectionAdapter removeDbAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveDosboxVersion();
            }
        };
        ToolItem newItemToolItem_3 = new ToolItem(toolBar_1, 8);
        newItemToolItem_3.addSelectionListener(addDosboxAdapter);
        newItemToolItem_3.setText(this.settings.msg("dialog.main.addversion"));
        ToolItem newItemToolItem_4 = new ToolItem(toolBar_1, 8);
        newItemToolItem_4.addSelectionListener(editDosboxAdapter);
        newItemToolItem_4.setText(this.settings.msg("dialog.main.editversion"));
        ToolItem newItemToolItem_5 = new ToolItem(toolBar_1, 8);
        newItemToolItem_5.addSelectionListener(removeDbAdapter);
        newItemToolItem_5.setText(this.settings.msg("dialog.main.removeversion"));
        this.dbversion_table = new Table(composite_1, 67584);
        this.dbversion_table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    MainWindow.this.doRemoveDosboxVersion();
                } else if (event.keyCode == 0x1000009) {
                    MainWindow.this.doAddDosboxVersion();
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultVersion();
                }
            }
        });
        this.dbversion_table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == 262144 && event.detail == 4) {
                    MainWindow.this.doEditDosboxVersion();
                } else if (event.detail == 4) {
                    MainWindow.this.doRunDosbox();
                }
            }
        });
        this.dbversion_table.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doRunDosbox();
            }
        });
        this.dbversion_table.setLinesVisible(true);
        this.dbversion_table.setHeaderVisible(true);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.title"), 0);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.version"), 1);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.path"), 2);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.default"), 3);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.id"), 4);
        Menu menu_4 = new Menu(this.dbversion_table);
        this.dbversion_table.setMenu(menu_4);
        MenuItem runDBMenuItem = new MenuItem(menu_4, 0);
        runDBMenuItem.setText(this.settings.msg("dialog.main.dosboxversion.run"));
        runDBMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunDosbox();
            }
        });
        new MenuItem(menu_4, 2);
        MenuItem addDBMenuItem = new MenuItem(menu_4, 0);
        addDBMenuItem.setText(this.settings.msg("dialog.main.dosboxversion.add"));
        addDBMenuItem.addSelectionListener(addDosboxAdapter);
        MenuItem editDBMenuItem = new MenuItem(menu_4, 0);
        editDBMenuItem.setText(this.settings.msg("dialog.main.dosboxversion.edit"));
        editDBMenuItem.addSelectionListener(editDosboxAdapter);
        MenuItem removeDBMenuItem = new MenuItem(menu_4, 0);
        removeDBMenuItem.setText(this.settings.msg("dialog.main.dosboxversion.remove"));
        removeDBMenuItem.addSelectionListener(removeDbAdapter);
        new MenuItem(menu_4, 2);
        MenuItem toggleDefaultItem = new MenuItem(menu_4, 0);
        toggleDefaultItem.setText(this.settings.msg("dialog.main.dosboxversion.toggledefault"));
        toggleDefaultItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleDefaultVersion();
            }
        });
        new MenuItem(menu_4, 2);
        MenuItem openFolderItem = new MenuItem(menu_4, 0);
        openFolderItem.setText(this.settings.msg("dialog.main.dosboxversion.openfolder"));
        openFolderItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = MainWindow.this.dbversion_table.getSelectionIndex();
                if (index != -1) {
                    PlatformUtils.openDirForViewing(((DosboxVersion)MainWindow.this.dbversionsList.get(index)).getCanonicalConfFile().getParentFile());
                }
            }
        });
        TabItem templatesTabItem = new TabItem(tabFolder, 0);
        templatesTabItem.setText(this.settings.msg("dialog.main.templates"));
        Composite composite_1_1 = new Composite(tabFolder, 0);
        composite_1_1.setLayout((Layout)new BorderLayout(0, 0));
        templatesTabItem.setControl(composite_1_1);
        ToolBar toolBar_1_1 = new ToolBar(composite_1_1, 0);
        toolBar_1_1.setLayoutData("North");
        SelectionAdapter addTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddTemplate();
            }
        };
        SelectionAdapter editTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditTemplate();
            }
        };
        SelectionAdapter remTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveTemplate();
            }
        };
        ToolItem newItemToolItem_6 = new ToolItem(toolBar_1_1, 8);
        newItemToolItem_6.setText(this.settings.msg("dialog.main.addtemplate"));
        newItemToolItem_6.addSelectionListener(addTemplAdapter);
        ToolItem newItemToolItem_7 = new ToolItem(toolBar_1_1, 8);
        newItemToolItem_7.setText(this.settings.msg("dialog.main.edittemplate"));
        newItemToolItem_7.addSelectionListener(editTemplAdapter);
        ToolItem newItemToolItem_8 = new ToolItem(toolBar_1_1, 8);
        newItemToolItem_8.setText(this.settings.msg("dialog.main.removetemplate"));
        newItemToolItem_8.addSelectionListener(remTemplAdapter);
        this.template_table = new Table(composite_1_1, 67584);
        this.template_table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    MainWindow.this.doRemoveTemplate();
                } else if (event.keyCode == 0x1000009) {
                    MainWindow.this.doAddTemplate();
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultTemplate();
                }
            }
        });
        this.template_table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == 262144 && event.detail == 4) {
                    MainWindow.this.doEditTemplate();
                }
            }
        });
        this.template_table.setLinesVisible(true);
        this.template_table.setHeaderVisible(true);
        this.addTemplateColumn(this.settings.msg("dialog.main.templates.column.title"), 0);
        this.addTemplateColumn(this.settings.msg("dialog.main.templates.column.default"), 1);
        Menu menu_3 = new Menu(this.template_table);
        this.template_table.setMenu(menu_3);
        MenuItem addTemplItem = new MenuItem(menu_3, 0);
        addTemplItem.setText(this.settings.msg("dialog.main.template.add"));
        addTemplItem.addSelectionListener(addTemplAdapter);
        MenuItem editTemplItem = new MenuItem(menu_3, 0);
        editTemplItem.setText(this.settings.msg("dialog.main.template.edit"));
        editTemplItem.addSelectionListener(editTemplAdapter);
        MenuItem removeTemplItem = new MenuItem(menu_3, 0);
        removeTemplItem.setText(this.settings.msg("dialog.main.template.remove"));
        removeTemplItem.addSelectionListener(remTemplAdapter);
        new MenuItem(menu_3, 2);
        MenuItem toggleTemplItem = new MenuItem(menu_3, 0);
        toggleTemplItem.setText(this.settings.msg("dialog.main.template.toggledefault"));
        toggleTemplItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleDefaultTemplate();
            }
        });
        for (Profile prof : this.profilesList) {
            this.addProfileToTable(prof);
        }
        for (DosboxVersion dbversion : this.dbversionsList) {
            this.addDosboxVersionToTable(dbversion);
        }
        for (Template template : this.templatesList) {
            this.addTemplateToTable(template);
        }
        this.profile_table.setSortColumn(this.profile_table.getColumn(this.findColumnById(this.settings.getIntValues("gui", "sortcolumn")[0])));
        this.profile_table.setSortDirection(this.settings.getBooleanValues("gui", "sortascending")[0] ? 128 : 1024);
        this.profile_table.setColumnOrder(this.settings.getIntValues("gui", "columnorder"));
        this.profile_table.setSelection(this.settings.getIntValue("gui", "selectedprofile"));
        this.profile_table.setFocus();
        this.displayProfileInformation();
    }

    private void doReorderProfiles(int columnId, SelectionEvent event) {
        TableColumn sortColumn = this.profile_table.getSortColumn();
        TableColumn currentColumn = (TableColumn)event.widget;
        int dir = this.profile_table.getSortDirection();
        if (sortColumn.equals(currentColumn)) {
            dir = dir == 128 ? 1024 : 128;
        } else {
            this.profile_table.setSortColumn(currentColumn);
            dir = 128;
        }
        int currentProfileId = -1;
        if (this.profile_table.getSelectionIndex() != -1) {
            currentProfileId = this.profilesList.get(this.profile_table.getSelectionIndex()).getId();
        }
        try {
            this.orderingVector.addOrdering(this.columnIds[columnId], dir == 128);
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause());
        }
        catch (SQLException ex) {
            GeneralPurposeDialogs.warningMessage(this.shell, ex.getMessage());
        }
        int i = 0;
        while (i < this.profilesList.size()) {
            this.setTableItem(this.profile_table.getItem(i), this.profilesList.get(i));
            ++i;
        }
        this.profile_table.setSortDirection(dir);
        if (currentProfileId != -1) {
            this.profile_table.setSelection(Profile.findById(this.profilesList, currentProfileId));
        }
        this.settings.setIntValues("gui", "sortcolumn", this.orderingVector.getColumns());
        this.settings.setBooleanValues("gui", "sortascending", this.orderingVector.getAscendings());
    }

    private void displayNotes(String notes) {
        this.notesField.setText(notes);
    }

    private void displayLinks(String[] p_link) {
        int i = 0;
        while (i < this.link.length) {
            if (p_link[i] == null || "".equals(p_link[i])) {
                this.link[i].setText(" ");
                this.link[i].setToolTipText(null);
            } else {
                String url = p_link[i];
                String tag = p_link[i];
                if (url.indexOf("://") == -1) {
                    url = "file://" + FileUtils.canonicalToData(url).getPath();
                    tag = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToData(tag)).getPath();
                }
                StringBuffer text = new StringBuffer("<a href=\"").append(url).append("\">").append(tag).append("</a>");
                this.link[i].setText(text.toString());
                this.link[i].setToolTipText(url);
            }
            ++i;
        }
    }

    private void displayScreenshots(Profile prof) {
        File path;
        File[] files;
        ToolItem[] toolItems = this.thumbsToolBar.getItems();
        int i = 0;
        while (i < toolItems.length) {
            toolItems[i].dispose();
            ++i;
        }
        if (prof != null && (files = (path = prof.getCanonicalCaptures()).listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().toLowerCase().endsWith(".png")) {
                    final ToolItem toolItem = new ToolItem(this.thumbsToolBar, 8);
                    toolItem.setToolTipText(file.getPath());
                    toolItem.setText(file.getName());
                    toolItem.setImage(SWTImageManager.getResizedImage(this.display, this.thumbHeight, file.getPath()));
                    toolItem.addSelectionListener(new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            Thumb thumbDialog = new Thumb(MainWindow.this.shell);
                            thumbDialog.setThumb(toolItem.getToolTipText());
                            thumbDialog.open();
                        }
                    });
                }
                ++n2;
            }
        }
        this.thumbsToolBar.setVisible(this.thumbsToolBar.getItemCount() != 0);
        this.thumbsToolBar.pack();
    }

    private void doAddProfile() {
        this.doAddProfile(null);
    }

    private void doAddProfile(String file) {
        if (this.checkDefaultDBVersion() == null) {
            return;
        }
        EditProfileDialog addProfileDialog = new EditProfileDialog(this.shell);
        if (file != null) {
            addProfileDialog.sendToProfile(file);
        }
        this.updateWithAddedProfile((Profile)addProfileDialog.open());
    }

    public void addProfile(final String file) {
        this.display.syncExec(new Runnable(){

            public void run() {
                MainWindow.this.doAddProfile(file);
            }
        });
    }

    private void doAddDosboxVersion() {
        EditDosboxVersionDialog addVersionDialog = new EditDosboxVersionDialog(this.shell);
        DosboxVersion dbversion = (DosboxVersion)addVersionDialog.open();
        if (dbversion != null) {
            this.updateDosboxVersionList(dbversion);
        }
    }

    private void doAddTemplate() {
        if (this.checkDefaultDBVersion() == null) {
            return;
        }
        EditTemplateDialog addTemplateDialog = new EditTemplateDialog(this.shell);
        Template template = (Template)addTemplateDialog.open();
        if (template != null) {
            this.updateTemplateList(template);
        }
    }

    private void doToggleFavoriteProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile profile = this.profilesList.get(index);
            try {
                this.dbase.toggleFavorite(profile.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
            profile.toggleDefault();
            this.profilesList.set(index, profile);
            this.setTableItem(this.profile_table.getItem(index), profile);
        }
    }

    private void doToggleDefaultVersion() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1) {
            DosboxVersion ver = this.dbversionsList.get(index);
            ver.toggleDefault();
            try {
                this.dbase.addOrEditDosboxVersion(ver.getTitle(), ver.getPath(), ver.isMultiConfig(), ver.isDefault(), ver.getParameters(), ver.getVersion(), ver.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
            this.updateDosboxVersionList(ver);
        }
    }

    private void doToggleDefaultTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            Template temp = this.templatesList.get(index);
            temp.toggleDefault();
            try {
                this.dbase.addOrEditTemplate(temp.getTitle(), temp.getdbversionId(), temp.isDefault(), temp.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
            this.updateTemplateList(temp);
        }
    }

    private void doEditProfile() {
        this.doEditProfile(false);
    }

    private void doEditProfile(boolean focusTitle) {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile profile;
            EditProfileDialog editProfileDialog = new EditProfileDialog(this.shell);
            editProfileDialog.setProfile(this.profilesList.get(index));
            if (focusTitle) {
                editProfileDialog.focusTitle();
            }
            if ((profile = (Profile)editProfileDialog.open()) != null) {
                boolean quickUpdate = true;
                if (this.settings.getBooleanValue("gui", "autosortonupdate")) {
                    try {
                        this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause());
                        if (index != Profile.findById(this.profilesList, profile.getId())) {
                            quickUpdate = false;
                        }
                    }
                    catch (SQLException e) {
                        GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
                    }
                }
                if (quickUpdate) {
                    this.profilesList.set(index, profile);
                    this.setTableItem(this.profile_table.getItem(index), profile);
                } else {
                    this.updateProfilesList(profile);
                }
                this.displayProfileInformation();
            }
        }
    }

    private void doDuplicateProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile orgProf = this.profilesList.get(index);
            this.updateWithAddedProfile(EditProfileDialog.duplicateProfile(orgProf, this.dbversionsList, this.dbase, this.shell));
        }
    }

    private void updateWithAddedProfile(Profile profile) {
        if (profile != null) {
            if (this.settings.getBooleanValue("gui", "autosortonupdate")) {
                this.updateProfilesList(profile);
            } else {
                this.profilesList.add(profile);
                this.addProfileToTable(profile);
                this.profile_table.setSelection(this.profile_table.getItemCount() - 1);
                this.profile_table.setFocus();
            }
            this.displayProfileInformation();
        }
    }

    private void doEditDosboxVersion() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1) {
            EditDosboxVersionDialog editVersionDialog = new EditDosboxVersionDialog(this.shell);
            editVersionDialog.setDosboxVersion(this.dbversionsList.get(index));
            DosboxVersion dbversion = (DosboxVersion)editVersionDialog.open();
            if (dbversion != null) {
                this.updateDosboxVersionList(dbversion);
            }
        }
    }

    private void updateProfilesList(Profile profile) {
        try {
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause());
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.profile_table.setRedraw(false);
        this.profile_table.removeAll();
        for (Profile prof : this.profilesList) {
            this.addProfileToTable(prof);
        }
        if (profile != null) {
            this.profile_table.setSelection(Profile.findById(this.profilesList, profile.getId()));
        }
        this.profile_table.setRedraw(true);
        this.profile_table.setFocus();
    }

    private void updateDosboxVersionList(DosboxVersion dbversion) {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.dbversion_table.removeAll();
        for (DosboxVersion version : this.dbversionsList) {
            this.addDosboxVersionToTable(version);
        }
        this.dbversion_table.setSelection(DosboxVersion.findById(this.dbversionsList, dbversion.getId()));
        this.dbversion_table.setFocus();
        this.updateProfileDbversionsSubmenu();
        this.updateSetupDbversionsSubmenu();
    }

    private void updateTemplateList(Template template) {
        try {
            this.templatesList = this.dbase.readTemplatesList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.template_table.removeAll();
        for (Template temp : this.templatesList) {
            this.addTemplateToTable(temp);
        }
        this.template_table.setSelection(Template.findById(this.templatesList, template.getId()));
        this.template_table.setFocus();
    }

    private void doEditTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            EditTemplateDialog editTemplDialog = new EditTemplateDialog(this.shell);
            editTemplDialog.setTemplate(this.templatesList.get(index));
            Template template = (Template)editTemplDialog.open();
            if (template != null) {
                this.updateTemplateList(template);
            }
        }
    }

    private void doRemoveProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removeprofile"))) {
            Profile prof = this.profilesList.get(index);
            try {
                this.dbase.removeProfile(prof.getId());
                this.profile_table.remove(index);
                this.profilesList.remove(index);
                this.displayProfileInformation();
                SWTImageManager.dispose();
                if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removeprofileconf", new Object[]{prof.getConfPathAndFile()}))) {
                    FileUtils.removeFile(prof.getCanonicalConfFile());
                }
                if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removeprofilecaptures", new Object[]{prof.getCaptures()}))) {
                    FileUtils.removeFilesInDirAndDir(prof.getCanonicalCaptures());
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void doRemoveDosboxVersion() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removedosboxversion"))) {
            try {
                this.dbase.removeDosboxVersion(this.dbversionsList.get(index).getId());
                this.dbversion_table.remove(index);
                this.dbversionsList.remove(index);
                this.updateProfileDbversionsSubmenu();
                this.updateSetupDbversionsSubmenu();
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void doRemoveTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removetemplate"))) {
            int templateId = this.templatesList.get(index).getId();
            try {
                this.dbase.removeTemplate(templateId);
                this.template_table.remove(index);
                this.templatesList.remove(index);
                File conffile = FileUtils.constructCanonicalTemplateFileLocation(templateId);
                if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removetemplateconf", new Object[]{conffile}))) {
                    FileUtils.removeFile(conffile);
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void addProfileToTable(Profile prof) {
        TableItem newItemTableItem = new TableItem(this.profile_table, 2048);
        this.setTableItem(newItemTableItem, prof);
    }

    private void addDosboxVersionToTable(DosboxVersion dbversion) {
        TableItem newItemTableItem = new TableItem(this.dbversion_table, 2048);
        this.setTableItem(newItemTableItem, dbversion);
    }

    private void addTemplateToTable(Template template) {
        TableItem newItemTableItem = new TableItem(this.template_table, 2048);
        this.setTableItem(newItemTableItem, template);
    }

    private void setTableItem(TableItem newItemTableItem, Profile prof) {
        int i = 0;
        while (i < this.columnIds.length) {
            String value;
            switch (this.columnIds[i]) {
                case 0: {
                    value = prof.getTitle();
                    break;
                }
                case 1: {
                    value = prof.hasSetupString();
                    break;
                }
                case 2: {
                    value = prof.getDeveloperName();
                    break;
                }
                case 3: {
                    value = prof.getPublisherName();
                    break;
                }
                case 4: {
                    value = prof.getGenre();
                    break;
                }
                case 5: {
                    value = prof.getYear();
                    break;
                }
                case 6: {
                    value = prof.getStatus();
                    break;
                }
                case 7: {
                    value = prof.isDefaultString();
                    break;
                }
                case 8: {
                    value = String.valueOf(prof.getId());
                    break;
                }
                case 9: {
                    value = String.valueOf(prof.getDbversionId());
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    value = prof.getCustomString(this.columnIds[i] - 10);
                    break;
                }
                case 18: {
                    value = String.valueOf(prof.getCustomInt(0)) + " %";
                    break;
                }
                case 19: {
                    value = String.valueOf(prof.getCustomInt(1));
                    break;
                }
                default: {
                    value = "";
                }
            }
            newItemTableItem.setText(i, value);
            ++i;
        }
    }

    private void setTableItem(TableItem newItemTableItem, DosboxVersion dbversion) {
        newItemTableItem.setText(0, dbversion.getTitle());
        newItemTableItem.setText(1, dbversion.getVersion());
        newItemTableItem.setText(2, dbversion.getPath());
        newItemTableItem.setText(3, dbversion.isDefaultString());
        newItemTableItem.setText(4, String.valueOf(dbversion.getId()));
    }

    private void setTableItem(TableItem newItemTableItem, Template template) {
        newItemTableItem.setText(0, template.getTitle());
        newItemTableItem.setText(1, template.isDefaultString());
    }

    private void doRunProfile(boolean setup) {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile prof = this.profilesList.get(index);
            if (!setup || prof.hasSetup()) {
                try {
                    FileUtils.doRunProfile(prof, this.dbversionsList, setup);
                }
                catch (IOException e) {
                    GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
                }
            }
        }
    }

    private void doRunDosbox() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1) {
            try {
                FileUtils.doRunDosbox(this.dbversionsList.get(index));
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private DosboxVersion checkDefaultDBVersion() {
        int defaultVersionIdx = DosboxVersion.findDefault(this.dbversionsList);
        if (defaultVersionIdx == -1) {
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.required.defaultdosboxversion"));
            return null;
        }
        return this.dbversionsList.get(defaultVersionIdx);
    }

    private void doDFendImport() {
        DosboxVersion defaultDbversion = this.checkDefaultDBVersion();
        if (defaultDbversion == null) {
            return;
        }
        if (this.settings.getIntValue("profiledefaults", "confpath") == 1) {
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.notice.dfendimportconflocation", new Object[]{SettingsDialog.confLocations[0]}));
        }
        DFendImportDialog importDialog = new DFendImportDialog(this.shell);
        importDialog.setDefaultDosboxVersion(defaultDbversion);
        if (importDialog.open() != null) {
            try {
                this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause());
                this.profile_table.removeAll();
                for (Profile prof : this.profilesList) {
                    this.addProfileToTable(prof);
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void doMigrate() {
        GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.notice.premigration"));
        String from = (String)new MigrateDialog(this.shell).open();
        if (from != null) {
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.notice.postmigration", new Object[]{from, FileUtils.getDosRoot()}));
        }
    }

    private void displayProfileInformation() {
        int index = this.profile_table.getSelectionIndex();
        if (index == -1) {
            this.displayScreenshots(null);
            this.displayNotes("");
            this.displayLinks(new String[4]);
        } else {
            this.settings.setIntValue("gui", "selectedprofile", index);
            Profile prof = this.profilesList.get(index);
            this.displayScreenshots(prof);
            this.displayNotes(prof.getNotes());
            this.displayLinks(prof.getLinks());
        }
    }

    private void doRemoveThumb() {
        if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removethumb", new Object[]{this.currentThumbFile}))) {
            FileUtils.removeFile(this.currentThumbFile);
            this.displayProfileInformation();
        }
        this.currentThumbFile = null;
    }

    private void doCreateShortcut() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            PlatformUtils.createShortcut(this.profilesList.get(index), this.dbversionsList);
        }
    }

    private void addProfileColumn(String title, final int colIndex) {
        final String width = "column" + (this.columnIds[colIndex] + 1) + "width";
        final TableColumn column = new TableColumn(this.profile_table, 0);
        column.setWidth(this.settings.getIntValue("gui", width));
        column.setMoveable(true);
        column.setText(title);
        if (this.columnIds[colIndex] == 8 || this.columnIds[colIndex] == 9 || this.columnIds[colIndex] == 18 || this.columnIds[colIndex] == 19) {
            column.setAlignment(131072);
        }
        column.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doReorderProfiles(colIndex, event);
            }
        });
        column.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings.setIntValue("gui", width, column.getWidth());
            }

            public void controlMoved(ControlEvent event) {
                MainWindow.this.settings.setIntValues("gui", "columnorder", MainWindow.this.profile_table.getColumnOrder());
            }
        });
    }

    private void addDBColumn(String title, int colIndex) {
        final String width = "column2_" + (colIndex + 1) + "width";
        final TableColumn column = new TableColumn(this.dbversion_table, 0);
        column.setWidth(this.settings.getIntValue("gui", width));
        column.setText(title);
        column.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings.setIntValue("gui", width, column.getWidth());
            }
        });
    }

    private void addTemplateColumn(String title, int colIndex) {
        final String width = "column3_" + (colIndex + 1) + "width";
        final TableColumn column = new TableColumn(this.template_table, 0);
        column.setWidth(this.settings.getIntValue("gui", width));
        column.setText(title);
        column.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings.setIntValue("gui", width, column.getWidth());
            }
        });
    }

    private void doOpenSettingsDialog() {
        SettingsDialog sDialog = new SettingsDialog(this.shell);
        if (((Boolean)sDialog.open()).booleanValue()) {
            int index = this.profile_table.getSelectionIndex();
            int nrColumns = this.profile_table.getColumnCount();
            String order = this.settings.getValue("gui", "columnorder");
            this.profile_table.removeAll();
            StringBuffer cols = new StringBuffer();
            int i = 0;
            while (i < nrColumns) {
                cols.append(i).append(' ');
                ++i;
            }
            this.profile_table.setColumnOrder(StringUtils.stringToIntArray(cols.toString()));
            i = nrColumns - 1;
            while (i >= 0) {
                this.profile_table.getColumn(i).dispose();
                --i;
            }
            this.initColumnIds();
            i = 0;
            while (i < this.columnIds.length) {
                this.addProfileColumn(columnNames[this.columnIds[i]], i);
                ++i;
            }
            this.profile_table.setSortColumn(this.profile_table.getColumn(this.findColumnById(this.settings.getIntValues("gui", "sortcolumn")[0])));
            this.profile_table.setSortDirection(this.settings.getBooleanValues("gui", "sortascending")[0] ? 128 : 1024);
            this.settings.setValue("gui", "columnorder", order);
            this.orderingVector = new OrderingVector(this.settings.getIntValues("gui", "sortcolumn"), this.settings.getBooleanValues("gui", "sortascending"));
            Profile prof = index == -1 ? null : this.profilesList.get(index);
            this.updateProfilesList(prof);
        }
    }

    private void doImportConfigfile() {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterNames(new String[]{this.settings.msg("filetype.conf"), String.valueOf(this.settings.msg("filetype.exe")) + ", " + this.settings.msg("filetype.booterimage"), "*"});
        dialog.setFilterExtensions(new String[]{"*.conf;*.CONF", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"});
        String result = dialog.open();
        if (result != null) {
            this.doAddProfile(result);
        }
    }

    private void initColumnIds() {
        columnNames = new String[20];
        MainWindow.columnNames[0] = this.settings.msg("dialog.main.profiles.column.title");
        MainWindow.columnNames[1] = this.settings.msg("dialog.main.profiles.column.setup");
        MainWindow.columnNames[2] = this.settings.msg("dialog.main.profiles.column.developer");
        MainWindow.columnNames[3] = this.settings.msg("dialog.main.profiles.column.publisher");
        MainWindow.columnNames[4] = this.settings.msg("dialog.main.profiles.column.genre");
        MainWindow.columnNames[5] = this.settings.msg("dialog.main.profiles.column.year");
        MainWindow.columnNames[6] = this.settings.msg("dialog.main.profiles.column.status");
        MainWindow.columnNames[7] = this.settings.msg("dialog.main.profiles.column.favorite");
        MainWindow.columnNames[8] = this.settings.msg("dialog.main.profiles.column.id");
        MainWindow.columnNames[9] = this.settings.msg("dialog.main.profiles.column.dosboxversionid");
        int i = 0;
        while (i < 10) {
            MainWindow.columnNames[i + 10] = this.settings.getValue("gui", "custom" + (i + 1));
            ++i;
        }
        int amount = 0;
        int i2 = 0;
        while (i2 < columnNames.length) {
            if (this.settings.getBooleanValue("gui", "column" + (i2 + 1) + "visible")) {
                ++amount;
            }
            ++i2;
        }
        int cNr = 0;
        this.columnIds = new int[amount];
        int i3 = 0;
        while (i3 < columnNames.length) {
            if (this.settings.getBooleanValue("gui", "column" + (i3 + 1) + "visible")) {
                this.columnIds[cNr++] = i3;
            }
            ++i3;
        }
    }

    private int findColumnById(int id) {
        int i = 0;
        while (i < this.columnIds.length) {
            if (this.columnIds[i] == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void updateProfileDbversionsSubmenu() {
        MenuItem parent = this.runWithSubMenu.getParentItem();
        this.runWithSubMenu.dispose();
        this.runWithSubMenu = new Menu(parent);
        parent.setMenu(this.runWithSubMenu);
        int i = 0;
        while (i < this.dbversionsList.size()) {
            final MenuItem runWithMenuItem = new MenuItem(this.runWithSubMenu, 0);
            runWithMenuItem.setText(this.dbversionsList.get(i).getTitle());
            runWithMenuItem.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int index = MainWindow.this.profile_table.getSelectionIndex();
                    if (index != -1) {
                        Profile prof = (Profile)MainWindow.this.profilesList.get(index);
                        DosboxVersion dbversion = (DosboxVersion)MainWindow.this.dbversionsList.get(MainWindow.this.runWithSubMenu.indexOf(runWithMenuItem));
                        try {
                            FileUtils.doRunProfile(prof, dbversion, false);
                        }
                        catch (IOException exc) {
                            GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, exc.getMessage());
                        }
                    }
                }
            });
            ++i;
        }
    }

    private void updateSetupDbversionsSubmenu() {
        MenuItem parent = this.setupWithSubMenu.getParentItem();
        this.setupWithSubMenu.dispose();
        this.setupWithSubMenu = new Menu(parent);
        parent.setMenu(this.setupWithSubMenu);
        int i = 0;
        while (i < this.dbversionsList.size()) {
            final MenuItem setupWithMenuItem = new MenuItem(this.setupWithSubMenu, 0);
            setupWithMenuItem.setText(this.dbversionsList.get(i).getTitle());
            setupWithMenuItem.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int index = MainWindow.this.profile_table.getSelectionIndex();
                    if (index != -1) {
                        Profile prof = (Profile)MainWindow.this.profilesList.get(index);
                        DosboxVersion dbversion = (DosboxVersion)MainWindow.this.dbversionsList.get(MainWindow.this.setupWithSubMenu.indexOf(setupWithMenuItem));
                        try {
                            FileUtils.doRunProfile(prof, dbversion, true);
                        }
                        catch (IOException exc) {
                            GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, exc.getMessage());
                        }
                    }
                }
            });
            ++i;
        }
    }

    private void doExportProfilesList() {
        new ExportListDialog(this.shell, this.dbversionsList, this.profilesList).open();
    }
}

