/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.model.Settings;
import com.swtdesigner.SWTImageManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class Thumb
extends Dialog {
    private static final double THUMB_FACTOR = 2.0;
    private Shell shell;
    private Display display;
    private Image thumbImage = null;

    public Thumb(Shell parent, int style) {
        super(parent, style);
        this.display = parent.getDisplay();
    }

    public Thumb(Shell parent) {
        this(parent, 0);
    }

    public void setThumb(String filename) {
        Image orgthumb = SWTImageManager.getImage(this.display, filename);
        ImageData bigThumb = orgthumb.getImageData();
        int width = bigThumb.width;
        int height = bigThumb.height;
        if (width <= 400 && height <= 350) {
            bigThumb = bigThumb.scaledTo((int)((double)width * 2.0), (int)((double)height * 2.0));
        }
        this.thumbImage = new Image((Device)this.display, bigThumb);
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        if (this.thumbImage != null && !this.thumbImage.isDisposed()) {
            this.thumbImage.dispose();
        }
        return null;
    }

    protected void createContents() {
        if (this.thumbImage != null) {
            this.shell = new Shell(this.getParent(), 67680);
            this.shell.setLayout(new FillLayout());
            this.shell.setSize(this.thumbImage.getImageData().width + 24, this.thumbImage.getImageData().height + 50);
            this.shell.setText(Settings.getInstance().msg("dialog.screenshot.title"));
            Button button = new Button(this.shell, 0x800000);
            button.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Thumb.this.shell.close();
                }
            });
            button.setImage(this.thumbImage);
            button.pack();
        }
    }
}

