/*
 * Decompiled with CFR 0.152.
 */
package com.loopy.impl;

import com.loopy.iface.FileEntry;
import com.loopy.iface.VolumeDescriptorSet;
import com.loopy.impl.AbstractFileSystem;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBlockFileSystem
extends AbstractFileSystem {
    private final int blockSize;
    private final int reservedBlocks;
    private VolumeDescriptorSet volumeDescriptorSet;

    protected AbstractBlockFileSystem(File file, int blockSize, int reservedBlocks) throws IOException {
        super(file);
        if (blockSize <= 0) {
            throw new IllegalArgumentException("'blockSize' must be > 0");
        }
        if (reservedBlocks < 0) {
            throw new IllegalArgumentException("'reservedBlocks' must be >= 0");
        }
        this.blockSize = blockSize;
        this.reservedBlocks = reservedBlocks;
        this.loadVolumeDescriptors();
    }

    @Override
    public Enumeration<FileEntry> getEntries() {
        this.ensureOpen();
        return this.enumerate(this.volumeDescriptorSet.getRootEntry());
    }

    protected void loadVolumeDescriptors() throws IOException {
        byte[] buffer = new byte[this.blockSize];
        this.volumeDescriptorSet = this.createVolumeDescriptorSet();
        int block = this.reservedBlocks;
        while (this.readBlock(block, buffer) && !this.volumeDescriptorSet.deserialize(buffer)) {
            ++block;
        }
    }

    protected boolean readBlock(long block, byte[] buffer) throws IOException {
        int bytesRead = this.readData(block * (long)this.blockSize, buffer, 0, this.blockSize);
        if (bytesRead <= 0) {
            return false;
        }
        if (this.blockSize != bytesRead) {
            throw new IOException("Could not deserialize a complete block");
        }
        return true;
    }

    protected synchronized int readData(long startPos, byte[] buffer, int offset, int len) throws IOException {
        this.seek(startPos);
        return this.read(buffer, offset, len);
    }

    protected VolumeDescriptorSet getVolumeDescriptorSet() {
        return this.volumeDescriptorSet;
    }

    protected abstract Enumeration<FileEntry> enumerate(FileEntry var1);

    protected abstract VolumeDescriptorSet createVolumeDescriptorSet();
}

