/*
 * Decompiled with CFR 0.152.
 */
package com.loopy.iso9660;

import com.loopy.exception.LoopyException;
import com.loopy.iface.FileEntry;
import com.loopy.iface.VolumeDescriptorSet;
import com.loopy.iso9660.ISO9660FileEntry;
import com.loopy.iso9660.ISO9660FileSystem;
import com.loopy.util.Util;
import java.io.IOException;

public class ISO9660VolumeDescriptorSet
implements VolumeDescriptorSet {
    private static final int TYPE_BOOTRECORD = 0;
    private static final int TYPE_PRIMARY_DESCRIPTOR = 1;
    private static final int TYPE_SUPPLEMENTARY_DESCRIPTOR = 2;
    private static final int TYPE_PARTITION_DESCRIPTOR = 3;
    private static final int TYPE_TERMINATOR = 255;
    private final ISO9660FileSystem fileSystem;
    private ISO9660FileEntry rootDirectoryEntry;
    private String encoding = "US-ASCII";
    private boolean hasPrimary = false;
    private boolean hasSupplementary = false;

    public ISO9660VolumeDescriptorSet(ISO9660FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public boolean deserialize(byte[] descriptor) throws IOException {
        int type = Util.getUInt8(descriptor, 1);
        boolean terminator = false;
        switch (type) {
            case 255: {
                if (!this.hasPrimary) {
                    throw new LoopyException("No primary volume descriptor found");
                }
                terminator = true;
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                this.deserializePrimary(descriptor);
                break;
            }
            case 2: {
                this.deserializeSupplementary(descriptor);
                break;
            }
        }
        return terminator;
    }

    private void deserializePrimary(byte[] descriptor) throws IOException {
        if (this.hasPrimary) {
            return;
        }
        this.validateBlockSize(descriptor);
        if (!this.hasSupplementary) {
            this.deserializeCommon(descriptor);
        }
        this.hasPrimary = true;
    }

    private void deserializeSupplementary(byte[] descriptor) throws IOException {
        if (this.hasSupplementary) {
            return;
        }
        this.validateBlockSize(descriptor);
        String escapeSequences = Util.getDChars(descriptor, 89, 32);
        String enc = this.getEncoding(escapeSequences);
        if (enc != null) {
            this.encoding = enc;
            this.deserializeCommon(descriptor);
            this.hasSupplementary = true;
        }
    }

    private void deserializeCommon(byte[] descriptor) throws IOException {
        this.rootDirectoryEntry = new ISO9660FileEntry(this.fileSystem, descriptor, 157);
    }

    private void validateBlockSize(byte[] descriptor) throws IOException {
        int blockSize = Util.getUInt16Both(descriptor, 129);
        if (blockSize != 2048) {
            throw new LoopyException("Invalid block size: " + blockSize);
        }
    }

    private String getEncoding(String escapeSequences) {
        String encoding = null;
        if (escapeSequences.equals("%/@")) {
            encoding = "UTF-16BE";
        } else if (escapeSequences.equals("%/C")) {
            encoding = "UTF-16BE";
        } else if (escapeSequences.equals("%/E")) {
            encoding = "UTF-16BE";
        }
        return encoding;
    }

    public FileEntry getRootEntry() {
        return this.rootDirectoryEntry;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

