/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.model.DosboxVersion;
import com.model.Profile;
import com.util.FileUtils;
import com.util.PlatformUtils;
import com.util.XmlUtils;
import java.io.File;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpProfile
extends Profile {
    private final String fullConfig;
    private final String incrConfig;
    private final File gameDir;

    public ExpProfile(int id, String fConf, String iConf, File gDir, Profile prof) {
        super(id, String.valueOf(FileUtils.PROFILES_DIR) + id + ".conf", String.valueOf(FileUtils.CAPTURES_DIR) + id, prof);
        this.fullConfig = fConf;
        this.incrConfig = iConf;
        this.gameDir = gDir;
    }

    public String getFullConfig() {
        return this.fullConfig;
    }

    public String getIncrConfig() {
        return this.incrConfig;
    }

    public void setDbversionId(int id) {
        this.dbversionId = id;
    }

    public Element getXml(Document xmldoc, List<DosboxVersion> dbversionsList) {
        Element profEmt = xmldoc.createElement("profile");
        XmlUtils.addElement(xmldoc, profEmt, "title", this.getTitle());
        XmlUtils.addElement(xmldoc, profEmt, "id", String.valueOf(this.getId()));
        Element captures = xmldoc.createElement("captures");
        XmlUtils.addElement(xmldoc, captures, "raw", this.getCaptures());
        XmlUtils.addElement(xmldoc, captures, "url", this.getCapturesAsUrl());
        profEmt.appendChild(captures);
        Element config = xmldoc.createElement("config-file");
        XmlUtils.addElement(xmldoc, config, "raw", this.getConfPathAndFile());
        XmlUtils.addElement(xmldoc, config, "url", this.getConfFileAsUrl());
        profEmt.appendChild(config);
        XmlUtils.addElement(xmldoc, profEmt, "setup", this.getSetup());
        XmlUtils.addElement(xmldoc, profEmt, "setup-parameters", this.getSetupParameters());
        Element meta = xmldoc.createElement("meta-info");
        XmlUtils.addElement(xmldoc, meta, "developer", this.getDeveloperName());
        XmlUtils.addElement(xmldoc, meta, "publisher", this.getPublisherName());
        XmlUtils.addElement(xmldoc, meta, "year", this.getYear());
        XmlUtils.addElement(xmldoc, meta, "genre", this.getGenre());
        XmlUtils.addElement(xmldoc, meta, "status", this.getStatus());
        XmlUtils.addElement(xmldoc, meta, "favorite", String.valueOf(this.isDefault()));
        XmlUtils.addCDataElement(xmldoc, meta, "notes", this.getNotes());
        int i = 0;
        while (i < 8) {
            XmlUtils.addElement(xmldoc, meta, "custom" + (i + 1), this.getCustomString(i));
            ++i;
        }
        i = 0;
        while (i < 2) {
            XmlUtils.addElement(xmldoc, meta, "custom" + (i + 9), String.valueOf(this.getCustomInt(i)));
            ++i;
        }
        i = 0;
        while (i < 4) {
            Element link = xmldoc.createElement("link" + (i + 1));
            XmlUtils.addElement(xmldoc, link, "raw", this.getLink(i));
            XmlUtils.addElement(xmldoc, link, "url", this.getLinkAsUrl(i));
            meta.appendChild(link);
            ++i;
        }
        profEmt.appendChild(meta);
        if (this.fullConfig != null) {
            XmlUtils.addCDataElement(xmldoc, profEmt, "full-configuration", this.fullConfig);
        }
        if (this.incrConfig != null) {
            XmlUtils.addCDataElement(xmldoc, profEmt, "incremental-configuration", this.incrConfig);
        }
        int index = DosboxVersion.findById(dbversionsList, this.getDbversionId());
        DosboxVersion dbv = dbversionsList.get(index);
        Element dosbox = xmldoc.createElement("dosbox");
        XmlUtils.addElement(xmldoc, dosbox, "title", dbv.getValue());
        XmlUtils.addElement(xmldoc, dosbox, "version", dbv.getVersion());
        if (this.gameDir != null) {
            XmlUtils.addElement(xmldoc, dosbox, "game-dir", PlatformUtils.toDosboxPath(this.gameDir.getPath()));
        }
        profEmt.appendChild(dosbox);
        return profEmt;
    }
}

