/*
 * Decompiled with CFR 0.152.
 */
package com.swtdesigner;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class SWTImageManager {
    private static final Map<String, Image> imageMap = new HashMap<String, Image>();

    public static void dispose() {
        for (Image image : imageMap.values()) {
            image.dispose();
        }
        imageMap.clear();
    }

    public static Image getImage(Display display, String path) {
        try {
            return new Image((Device)display, path);
        }
        catch (Exception e) {
            Image image = new Image((Device)display, 10, 10);
            GC graphc = new GC(image);
            graphc.setBackground(display.getSystemColor(3));
            graphc.fillRectangle(0, 0, 10, 10);
            graphc.dispose();
            return image;
        }
    }

    public static Image getResizedImage(Display display, int height, String path) {
        Image image = imageMap.get(path);
        if (image == null) {
            Image orgImage = SWTImageManager.getImage(display, path);
            int orgW = orgImage.getBounds().width;
            int orgH = orgImage.getBounds().height;
            double factor = (double)height / (double)orgH;
            int widthFactor = (int)((double)orgW * factor);
            image = new Image((Device)display, widthFactor, height);
            GC graphc = new GC(image);
            graphc.setAntialias(1);
            graphc.drawImage(orgImage, 0, 0, orgW, orgH, 0, 0, widthFactor, height);
            graphc.dispose();
            imageMap.put(path, image);
        }
        return image;
    }
}

