/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.model.DosboxVersion;
import com.model.ExpProfile;
import com.model.Profile;
import com.model.Settings;
import com.model.conf.CompositeConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    private static final String XML_FORMAT_VERSION = "1.0";

    public static Element addElement(Document dom, Element el, String name, String value) {
        Element newElement = dom.createElement(name);
        newElement.appendChild(dom.createTextNode(value));
        el.appendChild(newElement);
        return el;
    }

    public static Element addCDataElement(Document dom, Element el, String name, String value) {
        Element newElement = dom.createElement(name);
        newElement.appendChild(dom.createCDATASection(value));
        el.appendChild(newElement);
        return el;
    }

    public static void saveDomSource(DOMSource source, File target, File xslt) throws TransformerException, IOException {
        TransformerFactory transFact = TransformerFactory.newInstance();
        transFact.setAttribute("indent-number", 2);
        Transformer trans = xslt == null ? transFact.newTransformer() : transFact.newTransformer(new StreamSource(xslt));
        trans.setOutputProperty("indent", "yes");
        FileOutputStream fos = new FileOutputStream(target);
        trans.transform(source, new StreamResult(new OutputStreamWriter((OutputStream)fos, "utf-8")));
        fos.close();
    }

    public static Document getProfilesXML(List<Profile> profs, List<DosboxVersion> dbversions) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xmldoc = builder.newDocument();
        Element root = xmldoc.createElement("document");
        root.appendChild(XmlUtils.getExportElement(xmldoc, Settings.getInstance().msg("exportlist.title"), "", false, false));
        for (Profile profile : profs) {
            ExpProfile expProf = new ExpProfile(profile.getId(), null, null, null, profile);
            Element profElement = expProf.getXml(xmldoc, dbversions);
            root.appendChild(profElement);
        }
        xmldoc.appendChild(root);
        return xmldoc;
    }

    public static Document getFullProfilesXML(List<Profile> profs, List<DosboxVersion> dbversions, String title, String notes, boolean captures, boolean gameData) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xmldoc = builder.newDocument();
        Element root = xmldoc.createElement("document");
        root.appendChild(XmlUtils.getExportElement(xmldoc, title, notes, captures, gameData));
        int profileNumber = 0;
        for (Profile profile : profs) {
            int dbversionIndex = DosboxVersion.findById(dbversions, profile.getDbversionId());
            DosboxVersion dbversion = dbversions.get(dbversionIndex);
            CompositeConfiguration compConf = new CompositeConfiguration(dbversion, profile, true, null);
            ExpProfile expProf = new ExpProfile(profileNumber, compConf.getFullConf(), compConf.getIncrConf(), compConf.getExportGameDir(profileNumber), profile);
            Element profElement = expProf.getXml(xmldoc, dbversions);
            root.appendChild(profElement);
            ++profileNumber;
        }
        xmldoc.appendChild(root);
        return xmldoc;
    }

    private static Element getExportElement(Document xmldoc, String title, String notes, boolean captures, boolean gameData) {
        Element export = xmldoc.createElement("export");
        XmlUtils.addElement(xmldoc, export, "format-version", XML_FORMAT_VERSION);
        XmlUtils.addElement(xmldoc, export, "title", title);
        XmlUtils.addCDataElement(xmldoc, export, "notes", notes);
        XmlUtils.addElement(xmldoc, export, "generator-title", "DOSBox Game Launcher");
        XmlUtils.addElement(xmldoc, export, "generator-version", "0.64");
        Settings settings = Settings.getInstance();
        int i = 0;
        while (i < 10) {
            String s = settings.getValue("gui", "custom" + (i + 1));
            XmlUtils.addElement(xmldoc, export, "custom" + (i + 1), s);
            ++i;
        }
        XmlUtils.addElement(xmldoc, export, "captures-available", String.valueOf(captures));
        XmlUtils.addElement(xmldoc, export, "gamedata-available", String.valueOf(gameData));
        return export;
    }
}

