/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.db.Database;
import com.gui.EditMountDialog;
import com.gui.GeneralPurposeDialogs;
import com.gui.SizeControlAdapter;
import com.model.DosboxVersion;
import com.model.Mount;
import com.model.Settings;
import com.model.Template;
import com.model.conf.CompositeConfiguration;
import com.model.conf.Configuration;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditTemplateDialog
extends Dialog {
    protected Text title;
    protected Button defaultButton;
    protected Combo dbversion;
    protected Button setButton;
    protected Button reloadButton;
    protected Combo priority_active;
    protected Combo priority_inactive;
    protected Button waitonerror;
    protected Button exit;
    protected Text language;
    protected Text captures;
    protected Combo output;
    protected Combo frameskip;
    protected Combo scaler;
    protected Combo pixelshader;
    protected Button fulldouble;
    protected Button fullscreen;
    protected Combo fullresolution;
    protected Combo windowresolution;
    protected Button aspect;
    protected Text overscan;
    protected Combo svgachipset;
    protected Combo videoram;
    protected Combo vsyncmode;
    protected Text vsyncrate;
    protected Button glide;
    protected Text glideport;
    protected Combo machine;
    protected Combo cpu_type;
    protected Combo core;
    protected Combo cycles;
    protected Combo cycles_up;
    protected Combo cycles_down;
    protected Button timesynched;
    protected Combo memsize;
    protected Button xms;
    protected Button ems;
    protected Combo umb;
    protected Button nosound;
    protected Combo rate;
    protected Combo blocksize;
    protected Combo prebuffer;
    protected Combo mpu401;
    protected Combo midi_device;
    protected Text midi_config;
    protected Text mixer_config;
    protected Combo mt32rate;
    protected Combo sbtype;
    protected Combo oplrate;
    protected Combo oplmode;
    protected Combo oplemu;
    protected Combo sbbase;
    protected Combo irq;
    protected Combo dma;
    protected Combo hdma;
    protected Button sbmixer;
    protected Button gus;
    protected Combo gusrate;
    protected Combo gusbase;
    protected Combo gusdma1;
    protected Combo gusdma2;
    protected Combo gusirq1;
    protected Combo gusirq2;
    protected Text ultradir;
    protected Button pcspeaker;
    protected Combo pcrate;
    protected Combo tandy;
    protected Combo tandyrate;
    protected Button disney;
    protected Button usescancodes;
    protected Text mapperfile;
    protected Text keyboard_layout;
    protected Text keyb;
    protected Button autolock;
    protected Combo sensitivity;
    protected Combo joysticktype;
    protected Button timed;
    protected Button autofire;
    protected Button swap34;
    protected Button buttonwrap;
    protected Text serial1;
    protected Text serial2;
    protected Text serial3;
    protected Text serial4;
    protected Button ipx;
    protected Text ipxnet;
    protected org.eclipse.swt.widgets.List mountingpoints;
    protected Button booterButton;
    protected Button dosButton;
    protected Group memoryGroup;
    protected Group associationGroup;
    protected Group miscGroup;
    protected Group executeGroup;
    protected TabItem infoTabItem;
    protected TabItem mountingTabItem;
    protected int dbversionIndex = -1;
    protected Shell shell;
    protected List<DosboxVersion> dbversionsList;
    protected Database dbase;
    protected CompositeConfiguration compConf;
    protected Settings settings;
    protected Object result;

    public EditTemplateDialog(Shell parent) {
        super(parent, 0);
    }

    public void setTemplate(Template template) {
        this.result = template;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.dbase = Database.getInstance();
        if (this.init()) {
            this.createContents();
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        return this.result;
    }

    protected boolean init() {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e.getMessage());
            return false;
        }
        if (this.result == null) {
            this.dbversionIndex = DosboxVersion.findDefault(this.dbversionsList);
            this.compConf = new CompositeConfiguration(this.dbversionsList.get(this.dbversionIndex), true, this.getParent());
        } else {
            this.dbversionIndex = DosboxVersion.findById(this.dbversionsList, ((Template)this.result).getdbversionId());
            this.compConf = new CompositeConfiguration(this.dbversionsList.get(this.dbversionIndex), (Template)this.result, true, this.getParent());
        }
        return true;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener(new SizeControlAdapter(this.shell, "templatedialog"));
        if (this.result == null) {
            this.shell.setText(this.settings.msg("dialog.template.title.add"));
        } else {
            this.shell.setText(this.settings.msg("dialog.template.title.edit", new Object[]{((Template)this.result).getTitle(), ((Template)this.result).getId()}));
        }
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        this.createInfoTab(tabFolder);
        this.createGeneralTab(tabFolder);
        this.createDisplayTab(tabFolder);
        this.createMachineTab(tabFolder);
        this.createAudioTab(tabFolder);
        this.createIOTab(tabFolder);
        this.createMountingTab(tabFolder);
        Button okButton = this.createOkCancelButtons();
        okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditTemplateDialog.this.isValid()) {
                    return;
                }
                try {
                    if (EditTemplateDialog.this.setButton.isEnabled()) {
                        EditTemplateDialog.this.doLoadTemplateConf(EditTemplateDialog.this.setButton, true, false);
                    }
                    int templateId = EditTemplateDialog.this.dbase.addOrEditTemplate(EditTemplateDialog.this.title.getText(), EditTemplateDialog.this.compConf.getDbversionId(), EditTemplateDialog.this.defaultButton.getSelection(), EditTemplateDialog.this.result == null ? -1 : ((Template)EditTemplateDialog.this.result).getId());
                    EditTemplateDialog.this.compConf.setCompositeConf(EditTemplateDialog.this.getConfigurationBySettings());
                    EditTemplateDialog.this.result = new Template(templateId, EditTemplateDialog.this.title.getText(), EditTemplateDialog.this.compConf.getDbversionId(), EditTemplateDialog.this.defaultButton.getSelection());
                    EditTemplateDialog.this.compConf.save((Template)EditTemplateDialog.this.result, EditTemplateDialog.this.shell);
                }
                catch (SQLException e1) {
                    GeneralPurposeDialogs.warningMessage(EditTemplateDialog.this.shell, e1.getMessage());
                }
                EditTemplateDialog.this.shell.close();
            }
        });
        for (DosboxVersion dbv : this.dbversionsList) {
            this.dbversion.add(dbv.getTitle());
        }
        this.dbversion.select(this.dbversionIndex);
        if (this.result == null) {
            this.title.setFocus();
        } else {
            this.title.setText(((Template)this.result).getTitle());
            this.defaultButton.setSelection(((Template)this.result).isDefault());
        }
        this.enableSettingsByConfiguration();
        this.selectSettingsByConfiguration();
    }

    protected Button createOkCancelButtons() {
        Composite composite_7 = new Composite(this.shell, 0);
        composite_7.setLayout(new RowLayout());
        composite_7.setLayoutData("South");
        Button okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(okButton);
        RowData rowData = new RowData();
        rowData.width = 80;
        okButton.setLayoutData(rowData);
        okButton.setText(this.settings.msg("button.ok"));
        Button cancelButton = new Button(composite_7, 0);
        RowData rowData_1 = new RowData();
        rowData_1.width = 80;
        cancelButton.setLayoutData(rowData_1);
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.result = null;
                EditTemplateDialog.this.shell.close();
            }
        });
        return okButton;
    }

    protected void createMountingTab(TabFolder tabFolder) {
        this.mountingTabItem = new TabItem(tabFolder, 0);
        this.mountingTabItem.setText(this.settings.msg("dialog.template.tab.mounting"));
        Composite composite = new Composite(tabFolder, 0);
        composite.setLayout(new GridLayout());
        this.mountingTabItem.setControl(composite);
        this.createMountingGroup(composite);
        this.createExecuteGroup(composite);
    }

    protected void createExecuteGroup(Composite composite) {
        this.executeGroup = new Group(composite, 0);
        this.executeGroup.setLayoutData(new GridData());
        this.executeGroup.setText(this.settings.msg("dialog.template.execute"));
        GridLayout gridLayout_18 = new GridLayout();
        this.executeGroup.setLayout(gridLayout_18);
        this.dosButton = new Button(this.executeGroup, 16);
        this.dosButton.setText(this.settings.msg("dialog.template.dos"));
        Label label_1 = new Label(this.executeGroup, 258);
        label_1.setLayoutData(new GridData(4, 0x1000000, false, false));
        this.booterButton = new Button(this.executeGroup, 16);
        this.booterButton.setText(this.settings.msg("dialog.template.booter"));
    }

    protected void createMountingGroup(Composite composite) {
        Group mountGroup = new Group(composite, 0);
        mountGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        mountGroup.setText(this.settings.msg("dialog.template.mountingoverview"));
        GridLayout gridLayout_19 = new GridLayout();
        gridLayout_19.numColumns = 2;
        mountGroup.setLayout(gridLayout_19);
        this.mountingpoints = new org.eclipse.swt.widgets.List(mountGroup, 2560);
        GridData gridData_2 = new GridData(4, 4, true, false, 1, 3);
        this.mountingpoints.setLayoutData(gridData_2);
        this.mountingpoints.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (EditTemplateDialog.this.mountingpoints.getSelectionIndex() == -1) {
                    EditTemplateDialog.this.doAddMount();
                } else {
                    EditTemplateDialog.this.doEditMount();
                }
            }
        });
        Button addButton = new Button(mountGroup, 0);
        addButton.setLayoutData(new GridData(4, 0x1000000, false, false));
        addButton.setText(this.settings.msg("dialog.template.mount.add"));
        addButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doAddMount();
            }
        });
        Button editButton = new Button(mountGroup, 0);
        editButton.setLayoutData(new GridData(4, 0x1000000, false, false));
        editButton.setText(this.settings.msg("dialog.template.mount.edit"));
        editButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doEditMount();
            }
        });
        Button removeButton = new Button(mountGroup, 0);
        removeButton.setLayoutData(new GridData(4, 0x1000000, false, false));
        removeButton.setText(this.settings.msg("dialog.template.mount.remove"));
        removeButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doRemoveMount();
            }
        });
    }

    protected void createIOTab(TabFolder tabFolder) {
        TabItem inputTabItem = new TabItem(tabFolder, 0);
        inputTabItem.setText(this.settings.msg("dialog.template.tab.io"));
        Composite composite_5 = new Composite(tabFolder, 0);
        GridLayout gridLayout_17 = new GridLayout();
        gridLayout_17.numColumns = 3;
        composite_5.setLayout(gridLayout_17);
        inputTabItem.setControl(composite_5);
        Group mouseGroup = new Group(composite_5, 0);
        mouseGroup.setLayoutData(new GridData(4, 4, false, false));
        mouseGroup.setText(this.settings.msg("dialog.template.mouse"));
        GridLayout gridLayout_13 = new GridLayout();
        gridLayout_13.numColumns = 2;
        mouseGroup.setLayout(gridLayout_13);
        Label autolockLabel = new Label(mouseGroup, 0);
        autolockLabel.setText(this.settings.msg("dialog.template.autolock"));
        this.autolock = new Button(mouseGroup, 32);
        Label sensitivityLabel = new Label(mouseGroup, 0);
        sensitivityLabel.setText(this.settings.msg("dialog.template.sensitivity"));
        this.sensitivity = new Combo(mouseGroup, 8);
        this.sensitivity.setItems(this.settings.getValues("profile", "sensitivity"));
        this.sensitivity.setLayoutData(new GridData(4, 0x1000000, false, false));
        this.sensitivity.setVisibleItemCount(20);
        Group keyboardGroup = new Group(composite_5, 0);
        keyboardGroup.setLayoutData(new GridData(4, 4, true, false));
        keyboardGroup.setText(this.settings.msg("dialog.template.keyboard"));
        GridLayout gridLayout_14 = new GridLayout();
        gridLayout_14.numColumns = 2;
        keyboardGroup.setLayout(gridLayout_14);
        Label useScancodesLabel = new Label(keyboardGroup, 0);
        useScancodesLabel.setText(this.settings.msg("dialog.template.usescancodes"));
        this.usescancodes = new Button(keyboardGroup, 32);
        Label mapperFileLabel = new Label(keyboardGroup, 0);
        mapperFileLabel.setText(this.settings.msg("dialog.template.mapperfile"));
        this.mapperfile = new Text(keyboardGroup, 2048);
        this.mapperfile.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label layoutLabel = new Label(keyboardGroup, 0);
        layoutLabel.setText(this.settings.msg("dialog.template.keyboardlayout"));
        this.keyboard_layout = new Text(keyboardGroup, 2048);
        this.keyboard_layout.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label keybLabel = new Label(keyboardGroup, 0);
        keybLabel.setText(this.settings.msg("dialog.template.keybcommand"));
        this.keyb = new Text(keyboardGroup, 2048);
        this.keyb.setLayoutData(new GridData(4, 0x1000000, true, false));
        Group joystickGroup = new Group(composite_5, 0);
        joystickGroup.setLayoutData(new GridData(4, 4, false, false));
        joystickGroup.setText(this.settings.msg("dialog.template.joystick"));
        GridLayout gridLayout_15 = new GridLayout();
        gridLayout_15.numColumns = 2;
        joystickGroup.setLayout(gridLayout_15);
        Label typeLabel_1 = new Label(joystickGroup, 0);
        typeLabel_1.setText(this.settings.msg("dialog.template.joysticktype"));
        this.joysticktype = new Combo(joystickGroup, 8);
        this.joysticktype.setItems(this.settings.getValues("profile", "joysticktype"));
        this.joysticktype.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label timedLabel = new Label(joystickGroup, 0);
        timedLabel.setText(this.settings.msg("dialog.template.timedemulation"));
        this.timed = new Button(joystickGroup, 32);
        Label autofireLabel = new Label(joystickGroup, 0);
        autofireLabel.setText(this.settings.msg("dialog.template.autofire"));
        this.autofire = new Button(joystickGroup, 32);
        Label swapAxes3Label = new Label(joystickGroup, 0);
        swapAxes3Label.setText(this.settings.msg("dialog.template.swap34"));
        this.swap34 = new Button(joystickGroup, 32);
        Label buttonWrapLabel = new Label(joystickGroup, 0);
        buttonWrapLabel.setText(this.settings.msg("dialog.template.buttonwrapping"));
        this.buttonwrap = new Button(joystickGroup, 32);
        Group modemGroup = new Group(composite_5, 0);
        modemGroup.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        modemGroup.setText(this.settings.msg("dialog.template.modem"));
        GridLayout gridLayout_16 = new GridLayout();
        gridLayout_16.numColumns = 2;
        modemGroup.setLayout(gridLayout_16);
        Label serial1Label = new Label(modemGroup, 0);
        serial1Label.setText(this.settings.msg("dialog.template.serial1"));
        this.serial1 = new Text(modemGroup, 2048);
        this.serial1.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label serial2Label = new Label(modemGroup, 0);
        serial2Label.setText(this.settings.msg("dialog.template.serial2"));
        this.serial2 = new Text(modemGroup, 2048);
        this.serial2.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label serial3Label = new Label(modemGroup, 0);
        serial3Label.setText(this.settings.msg("dialog.template.serial3"));
        this.serial3 = new Text(modemGroup, 2048);
        this.serial3.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label serial4Label = new Label(modemGroup, 0);
        serial4Label.setText(this.settings.msg("dialog.template.serial4"));
        this.serial4 = new Text(modemGroup, 2048);
        this.serial4.setLayoutData(new GridData(4, 0x1000000, true, false));
        Group networkGroup = new Group(composite_5, 0);
        networkGroup.setLayoutData(new GridData(4, 4, false, false));
        networkGroup.setText(this.settings.msg("dialog.template.network"));
        GridLayout gridLayout_20 = new GridLayout();
        gridLayout_20.numColumns = 2;
        networkGroup.setLayout(gridLayout_20);
        Label ipxLabel = new Label(networkGroup, 0);
        ipxLabel.setText(this.settings.msg("dialog.template.enableipx"));
        this.ipx = new Button(networkGroup, 32);
        this.ipx.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.ipxnet.setEnabled(EditTemplateDialog.this.ipx.getSelection());
            }
        });
        Label ipxnetCommandLabel = new Label(networkGroup, 0);
        ipxnetCommandLabel.setText(this.settings.msg("dialog.template.ipxnetcommand"));
        new Label(networkGroup, 0);
        this.ipxnet = new Text(networkGroup, 2048);
        this.ipxnet.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
    }

    protected void createAudioTab(TabFolder tabFolder) {
        TabItem audioTabItem = new TabItem(tabFolder, 0);
        audioTabItem.setText(this.settings.msg("dialog.template.tab.audio"));
        Composite composite_4 = new Composite(tabFolder, 0);
        GridLayout gridLayout_9 = new GridLayout();
        gridLayout_9.numColumns = 3;
        composite_4.setLayout(gridLayout_9);
        audioTabItem.setControl(composite_4);
        Group generalGroup = new Group(composite_4, 0);
        generalGroup.setLayoutData(new GridData(4, 4, true, false));
        GridLayout gridLayout_6 = new GridLayout();
        gridLayout_6.numColumns = 2;
        generalGroup.setLayout(gridLayout_6);
        generalGroup.setText(this.settings.msg("dialog.template.general"));
        Label silentModeLabel = new Label(generalGroup, 0);
        silentModeLabel.setText(this.settings.msg("dialog.template.silentmode"));
        this.nosound = new Button(generalGroup, 32);
        Label sampleRateLabel = new Label(generalGroup, 0);
        sampleRateLabel.setText(this.settings.msg("dialog.template.samplerate"));
        this.rate = new Combo(generalGroup, 8);
        this.rate.setVisibleItemCount(10);
        this.rate.setItems(this.settings.getValues("profile", "rate"));
        this.rate.setLayoutData(new GridData());
        Label blockSizeLabel = new Label(generalGroup, 0);
        blockSizeLabel.setText(this.settings.msg("dialog.template.blocksize"));
        this.blocksize = new Combo(generalGroup, 8);
        this.blocksize.setItems(this.settings.getValues("profile", "blocksize"));
        this.blocksize.setLayoutData(new GridData());
        Label prebufferLabel = new Label(generalGroup, 0);
        prebufferLabel.setText(this.settings.msg("dialog.template.prebuffer"));
        this.prebuffer = new Combo(generalGroup, 0);
        this.prebuffer.setItems(this.settings.getValues("profile", "prebuffer"));
        this.prebuffer.setLayoutData(new GridData(70, -1));
        Label mpu401Label = new Label(generalGroup, 0);
        mpu401Label.setText(this.settings.msg("dialog.template.mpu401"));
        this.mpu401 = new Combo(generalGroup, 8);
        this.mpu401.setItems(this.settings.getValues("profile", "mpu401"));
        this.mpu401.setLayoutData(new GridData());
        Label midiDeviceLabel = new Label(generalGroup, 0);
        midiDeviceLabel.setText(this.settings.msg("dialog.template.mididevice"));
        this.midi_device = new Combo(generalGroup, 8);
        this.midi_device.setVisibleItemCount(10);
        this.midi_device.setItems(this.settings.getValues("profile", "device"));
        this.midi_device.setLayoutData(new GridData());
        Label configLabel = new Label(generalGroup, 0);
        configLabel.setText(this.settings.msg("dialog.template.midiconfig"));
        this.midi_config = new Text(generalGroup, 2048);
        this.midi_config.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label mixerConfigLabel = new Label(generalGroup, 0);
        mixerConfigLabel.setText(this.settings.msg("dialog.template.mixercommand"));
        this.mixer_config = new Text(generalGroup, 2048);
        this.mixer_config.setLayoutData(new GridData(4, 0x1000000, true, false));
        Group soundblasterGroup = new Group(composite_4, 0);
        soundblasterGroup.setLayoutData(new GridData(4, 4, false, false));
        soundblasterGroup.setText(this.settings.msg("dialog.template.soundblaster"));
        GridLayout gridLayout_7 = new GridLayout();
        gridLayout_7.numColumns = 2;
        soundblasterGroup.setLayout(gridLayout_7);
        Label typeLabel = new Label(soundblasterGroup, 0);
        typeLabel.setText(this.settings.msg("dialog.template.sbtype"));
        this.sbtype = new Combo(soundblasterGroup, 8);
        this.sbtype.setVisibleItemCount(10);
        this.sbtype.setItems(this.settings.getValues("profile", "sbtype"));
        this.sbtype.setLayoutData(new GridData());
        Label oplRateLabel = new Label(soundblasterGroup, 0);
        oplRateLabel.setText(this.settings.msg("dialog.template.sboplrate"));
        this.oplrate = new Combo(soundblasterGroup, 8);
        this.oplrate.setVisibleItemCount(10);
        this.oplrate.setItems(this.settings.getValues("profile", "oplrate"));
        this.oplrate.setLayoutData(new GridData());
        Label oplModeLabel = new Label(soundblasterGroup, 0);
        oplModeLabel.setLayoutData(new GridData());
        oplModeLabel.setText(this.settings.msg("dialog.template.sboplmode"));
        this.oplmode = new Combo(soundblasterGroup, 8);
        this.oplmode.setItems(this.settings.getValues("profile", "oplmode"));
        this.oplmode.setLayoutData(new GridData());
        Label oplEmuLabel = new Label(soundblasterGroup, 0);
        oplEmuLabel.setLayoutData(new GridData());
        oplEmuLabel.setText(this.settings.msg("dialog.template.sboplemu"));
        this.oplemu = new Combo(soundblasterGroup, 8);
        this.oplemu.setItems(this.settings.getValues("profile", "oplemu"));
        this.oplemu.setLayoutData(new GridData());
        Label addressLabel = new Label(soundblasterGroup, 0);
        addressLabel.setText(this.settings.msg("dialog.template.sbaddress"));
        this.sbbase = new Combo(soundblasterGroup, 8);
        this.sbbase.setItems(this.settings.getValues("profile", "sbbase"));
        this.sbbase.setLayoutData(new GridData());
        Label irqLabel = new Label(soundblasterGroup, 0);
        irqLabel.setText(this.settings.msg("dialog.template.sbirq"));
        this.irq = new Combo(soundblasterGroup, 8);
        this.irq.setItems(this.settings.getValues("profile", "irq"));
        this.irq.setLayoutData(new GridData());
        Label dmaLabel = new Label(soundblasterGroup, 0);
        dmaLabel.setText(this.settings.msg("dialog.template.sbdma"));
        this.dma = new Combo(soundblasterGroup, 8);
        this.dma.setItems(this.settings.getValues("profile", "dma"));
        this.dma.setLayoutData(new GridData());
        Label hdmaLabel = new Label(soundblasterGroup, 0);
        hdmaLabel.setLayoutData(new GridData());
        hdmaLabel.setText(this.settings.msg("dialog.template.sbhdma"));
        this.hdma = new Combo(soundblasterGroup, 8);
        this.hdma.setItems(this.settings.getValues("profile", "hdma"));
        this.hdma.setLayoutData(new GridData());
        Label mixerLabel = new Label(soundblasterGroup, 0);
        mixerLabel.setText(this.settings.msg("dialog.template.mixer"));
        this.sbmixer = new Button(soundblasterGroup, 32);
        Group gusGroup = new Group(composite_4, 0);
        gusGroup.setLayoutData(new GridData(4, 4, true, false));
        gusGroup.setText(this.settings.msg("dialog.template.gravisultrasound"));
        GridLayout gridLayout_8 = new GridLayout();
        gridLayout_8.numColumns = 2;
        gusGroup.setLayout(gridLayout_8);
        Label enableLabel_1 = new Label(gusGroup, 0);
        enableLabel_1.setLayoutData(new GridData());
        enableLabel_1.setText(this.settings.msg("dialog.template.enablegus"));
        this.gus = new Button(gusGroup, 32);
        this.gus.setLayoutData(new GridData());
        Label sampleRateLabel_2 = new Label(gusGroup, 0);
        sampleRateLabel_2.setText(this.settings.msg("dialog.template.gusrate"));
        this.gusrate = new Combo(gusGroup, 8);
        this.gusrate.setVisibleItemCount(10);
        this.gusrate.setItems(this.settings.getValues("profile", "gusrate"));
        this.gusrate.setLayoutData(new GridData());
        Label addressLabel_1 = new Label(gusGroup, 0);
        addressLabel_1.setText(this.settings.msg("dialog.template.gusaddress"));
        this.gusbase = new Combo(gusGroup, 8);
        this.gusbase.setItems(this.settings.getValues("profile", "gusbase"));
        this.gusbase.setLayoutData(new GridData());
        Label irqLabel_1 = new Label(gusGroup, 0);
        irqLabel_1.setText(this.settings.msg("dialog.template.gusirq1"));
        this.gusirq1 = new Combo(gusGroup, 8);
        this.gusirq1.setItems(this.settings.getValues("profile", "irq1"));
        this.gusirq1.setLayoutData(new GridData());
        Label irq2Label = new Label(gusGroup, 0);
        irq2Label.setText(this.settings.msg("dialog.template.gusirq2"));
        this.gusirq2 = new Combo(gusGroup, 8);
        this.gusirq2.setItems(this.settings.getValues("profile", "irq2"));
        this.gusirq2.setLayoutData(new GridData());
        Label dmaLabel_1 = new Label(gusGroup, 0);
        dmaLabel_1.setText(this.settings.msg("dialog.template.gusdma1"));
        this.gusdma1 = new Combo(gusGroup, 8);
        this.gusdma1.setItems(this.settings.getValues("profile", "dma1"));
        this.gusdma1.setLayoutData(new GridData());
        Label hdmaLabel_1 = new Label(gusGroup, 0);
        hdmaLabel_1.setLayoutData(new GridData());
        hdmaLabel_1.setText(this.settings.msg("dialog.template.gusdma2"));
        this.gusdma2 = new Combo(gusGroup, 8);
        this.gusdma2.setItems(this.settings.getValues("profile", "dma2"));
        this.gusdma2.setLayoutData(new GridData());
        Label ultradirLabel = new Label(gusGroup, 0);
        ultradirLabel.setText(this.settings.msg("dialog.template.ultradir"));
        this.ultradir = new Text(gusGroup, 2048);
        this.ultradir.setLayoutData(new GridData(4, 0x1000000, true, false));
        Group speakerGroup = new Group(composite_4, 0);
        speakerGroup.setLayoutData(new GridData(4, 4, true, false));
        speakerGroup.setText(this.settings.msg("dialog.template.pcspeaker"));
        GridLayout gridLayout_10 = new GridLayout();
        gridLayout_10.numColumns = 2;
        speakerGroup.setLayout(gridLayout_10);
        Label enableLabel = new Label(speakerGroup, 0);
        enableLabel.setText(this.settings.msg("dialog.template.enablepcspeaker"));
        this.pcspeaker = new Button(speakerGroup, 32);
        Label sampleRateLabel_1 = new Label(speakerGroup, 0);
        sampleRateLabel_1.setText(this.settings.msg("dialog.template.pcrate"));
        this.pcrate = new Combo(speakerGroup, 8);
        this.pcrate.setVisibleItemCount(10);
        this.pcrate.setItems(this.settings.getValues("profile", "pcrate"));
        this.pcrate.setLayoutData(new GridData());
        Group tandyGroup = new Group(composite_4, 0);
        tandyGroup.setLayoutData(new GridData(4, 4, false, false));
        tandyGroup.setText(this.settings.msg("dialog.template.tandy"));
        GridLayout gridLayout_11 = new GridLayout();
        gridLayout_11.numColumns = 2;
        tandyGroup.setLayout(gridLayout_11);
        Label enableLabel_2 = new Label(tandyGroup, 0);
        enableLabel_2.setText(this.settings.msg("dialog.template.enabletandy"));
        this.tandy = new Combo(tandyGroup, 8);
        this.tandy.setItems(this.settings.getValues("profile", "tandy"));
        this.tandy.setLayoutData(new GridData());
        Label sampleLabel2 = new Label(tandyGroup, 0);
        sampleLabel2.setText(this.settings.msg("dialog.template.tandyrate"));
        this.tandyrate = new Combo(tandyGroup, 8);
        this.tandyrate.setVisibleItemCount(10);
        this.tandyrate.setItems(this.settings.getValues("profile", "tandyrate"));
        this.tandyrate.setLayoutData(new GridData());
        Group disneyGroup = new Group(composite_4, 0);
        disneyGroup.setLayoutData(new GridData(4, 4, true, false));
        disneyGroup.setText(this.settings.msg("dialog.template.miscellaneous"));
        GridLayout gridLayout_12 = new GridLayout();
        gridLayout_12.numColumns = 2;
        disneyGroup.setLayout(gridLayout_12);
        Label enableLabel_3 = new Label(disneyGroup, 0);
        enableLabel_3.setText(this.settings.msg("dialog.template.enablesoundsource"));
        this.disney = new Button(disneyGroup, 32);
        Composite composite2 = new Composite(disneyGroup, 0);
        composite2.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.numColumns = 2;
        composite2.setLayout(gridLayout2);
        Label mt32RateLabel = new Label(composite2, 0);
        mt32RateLabel.setText(this.settings.msg("dialog.template.mt32rate"));
        this.mt32rate = new Combo(composite2, 8);
        this.mt32rate.setVisibleItemCount(10);
        this.mt32rate.setItems(this.settings.getValues("profile", "mt32rate"));
    }

    protected void createMachineTab(TabFolder tabFolder) {
        TabItem machineTabItem = new TabItem(tabFolder, 0);
        machineTabItem.setText(this.settings.msg("dialog.template.tab.machine"));
        Composite composite_3 = new Composite(tabFolder, 0);
        GridLayout gridLayout_2 = new GridLayout();
        composite_3.setLayout(gridLayout_2);
        machineTabItem.setControl(composite_3);
        Group cpuGroup = new Group(composite_3, 0);
        cpuGroup.setText(this.settings.msg("dialog.template.cpu"));
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 6;
        cpuGroup.setLayout(gridLayout_3);
        Label machineLabel = new Label(cpuGroup, 0);
        machineLabel.setText(this.settings.msg("dialog.template.machine"));
        this.machine = new Combo(cpuGroup, 8);
        this.machine.setItems(this.settings.getValues("profile", "machine"));
        this.machine.setLayoutData(new GridData());
        this.machine.setVisibleItemCount(10);
        Label cputypeLabel = new Label(cpuGroup, 0);
        cputypeLabel.setText(this.settings.msg("dialog.template.cputype"));
        this.cpu_type = new Combo(cpuGroup, 8);
        this.cpu_type.setItems(this.settings.getValues("profile", "cputype"));
        this.cpu_type.setLayoutData(new GridData());
        this.cpu_type.setVisibleItemCount(10);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        Label coreLabel = new Label(cpuGroup, 0);
        coreLabel.setText(this.settings.msg("dialog.template.core"));
        this.core = new Combo(cpuGroup, 8);
        this.core.setItems(this.settings.getValues("profile", "core"));
        this.core.setLayoutData(new GridData());
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        Label cyclesLabel = new Label(cpuGroup, 0);
        cyclesLabel.setText(this.settings.msg("dialog.template.cycles"));
        this.cycles = new Combo(cpuGroup, 0);
        this.cycles.setItems(this.settings.getValues("profile", "cycles"));
        this.cycles.setLayoutData(new GridData(100, -1));
        this.cycles.setVisibleItemCount(15);
        Label upLabel = new Label(cpuGroup, 0);
        upLabel.setLayoutData(new GridData());
        upLabel.setText(this.settings.msg("dialog.template.up"));
        this.cycles_up = new Combo(cpuGroup, 0);
        this.cycles_up.setItems(this.settings.getValues("profile", "cycles_up"));
        this.cycles_up.setLayoutData(new GridData(75, -1));
        Label downLabel = new Label(cpuGroup, 0);
        downLabel.setLayoutData(new GridData());
        downLabel.setText(this.settings.msg("dialog.template.down"));
        this.cycles_down = new Combo(cpuGroup, 0);
        this.cycles_down.setItems(this.settings.getValues("profile", "cycles_down"));
        this.cycles_down.setLayoutData(new GridData(75, -1));
        Label timesynchedLabel = new Label(cpuGroup, 0);
        timesynchedLabel.setText(this.settings.msg("dialog.template.timesynched"));
        this.timesynched = new Button(cpuGroup, 32);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        this.memoryGroup = new Group(composite_3, 0);
        this.memoryGroup.setText(this.settings.msg("dialog.template.memory"));
        this.memoryGroup.setLayoutData(new GridData());
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        this.memoryGroup.setLayout(gridLayout_4);
        Label sizeLabel = new Label(this.memoryGroup, 0);
        sizeLabel.setText(this.settings.msg("dialog.template.memorysize"));
        this.memsize = new Combo(this.memoryGroup, 8);
        this.memsize.setItems(this.settings.getValues("profile", "memsize"));
        this.memsize.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(this.memoryGroup, 0);
        new Label(this.memoryGroup, 0);
        Label xmsLabel = new Label(this.memoryGroup, 0);
        xmsLabel.setText(this.settings.msg("dialog.template.xms"));
        this.xms = new Button(this.memoryGroup, 32);
        new Label(this.memoryGroup, 0);
        new Label(this.memoryGroup, 0);
        Label emsLabel = new Label(this.memoryGroup, 0);
        emsLabel.setText(this.settings.msg("dialog.template.ems"));
        this.ems = new Button(this.memoryGroup, 32);
        new Label(this.memoryGroup, 0);
        new Label(this.memoryGroup, 0);
        Label umbLabel = new Label(this.memoryGroup, 0);
        umbLabel.setText(this.settings.msg("dialog.template.umb"));
        this.umb = new Combo(this.memoryGroup, 8);
        this.umb.setItems(this.settings.getValues("profile", "umb"));
        this.umb.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(this.memoryGroup, 0);
        new Label(this.memoryGroup, 0);
    }

    protected void createDisplayTab(TabFolder tabFolder) {
        TabItem displayTabItem = new TabItem(tabFolder, 0);
        displayTabItem.setText(this.settings.msg("dialog.template.tab.display"));
        Composite composite_2 = new Composite(tabFolder, 0);
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 4;
        composite_2.setLayout(gridLayout_5);
        displayTabItem.setControl(composite_2);
        Label outputLabel = new Label(composite_2, 0);
        outputLabel.setText(this.settings.msg("dialog.template.output"));
        this.output = new Combo(composite_2, 8);
        this.output.setItems(this.settings.getValues("profile", "output"));
        this.output.setVisibleItemCount(10);
        this.output.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label frameskipLabel = new Label(composite_2, 0);
        frameskipLabel.setText(this.settings.msg("dialog.template.frameskip"));
        this.frameskip = new Combo(composite_2, 8);
        this.frameskip.setItems(this.settings.getValues("profile", "frameskip"));
        this.frameskip.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label scalerLabel = new Label(composite_2, 0);
        scalerLabel.setText(this.settings.msg("dialog.template.scaler"));
        this.scaler = new Combo(composite_2, 8);
        this.scaler.setItems(this.settings.getValues("profile", "scaler"));
        this.scaler.setVisibleItemCount(15);
        this.scaler.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label pixelshaderLabel = new Label(composite_2, 0);
        pixelshaderLabel.setLayoutData(new GridData());
        pixelshaderLabel.setText(this.settings.msg("dialog.template.pixelshader"));
        this.pixelshader = new Combo(composite_2, 8);
        this.pixelshader.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.pixelshader.setVisibleItemCount(15);
        this.pixelshader.setItems(this.settings.getValues("profile", "pixelshader"));
        Label fullscreenLabel = new Label(composite_2, 0);
        fullscreenLabel.setText(this.settings.msg("dialog.template.fullscreen"));
        this.fullscreen = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label doubleBuffLabel = new Label(composite_2, 0);
        doubleBuffLabel.setText(this.settings.msg("dialog.template.doublebuffering"));
        this.fulldouble = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label resolutionLabel = new Label(composite_2, 0);
        resolutionLabel.setText(this.settings.msg("dialog.template.fullscreenresolution"));
        this.fullresolution = new Combo(composite_2, 8);
        this.fullresolution.setItems(this.settings.getValues("profile", "fullresolution"));
        this.fullresolution.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.fullresolution.setVisibleItemCount(10);
        Label windowResLabel = new Label(composite_2, 0);
        windowResLabel.setText(this.settings.msg("dialog.template.windowresolution"));
        this.windowresolution = new Combo(composite_2, 8);
        this.windowresolution.setItems(this.settings.getValues("profile", "windowresolution"));
        this.windowresolution.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.windowresolution.setVisibleItemCount(10);
        Label aspectLabel = new Label(composite_2, 0);
        aspectLabel.setText(this.settings.msg("dialog.template.aspectcorrection"));
        this.aspect = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label overscanLabel = new Label(composite_2, 0);
        overscanLabel.setText(this.settings.msg("dialog.template.overscan"));
        this.overscan = new Text(composite_2, 2048);
        this.overscan.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label svgaChipsetLabel = new Label(composite_2, 0);
        svgaChipsetLabel.setText(this.settings.msg("dialog.template.svgachipset"));
        this.svgachipset = new Combo(composite_2, 8);
        this.svgachipset.setItems(this.settings.getValues("profile", "svgachipset"));
        this.svgachipset.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label videoRamLabel = new Label(composite_2, 0);
        videoRamLabel.setText(this.settings.msg("dialog.template.videoram"));
        this.videoram = new Combo(composite_2, 8);
        this.videoram.setItems(this.settings.getValues("profile", "videoram"));
        this.videoram.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label vsyncModeLabel = new Label(composite_2, 0);
        vsyncModeLabel.setText(this.settings.msg("dialog.template.vsyncmode"));
        this.vsyncmode = new Combo(composite_2, 8);
        this.vsyncmode.setItems(this.settings.getValues("profile", "vsyncmode"));
        this.vsyncmode.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label vsyncRateLabel = new Label(composite_2, 0);
        vsyncRateLabel.setLayoutData(new GridData());
        vsyncRateLabel.setText(this.settings.msg("dialog.template.vsyncrate"));
        this.vsyncrate = new Text(composite_2, 2048);
        this.vsyncrate.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label glideLabel = new Label(composite_2, 0);
        glideLabel.setText(this.settings.msg("dialog.template.glide"));
        this.glide = new Button(composite_2, 32);
        this.glide.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.glideport.setEnabled(EditTemplateDialog.this.glide.getSelection());
            }
        });
        Label glidePortLabel = new Label(composite_2, 0);
        glidePortLabel.setText(this.settings.msg("dialog.template.glideport"));
        this.glideport = new Text(composite_2, 2048);
        this.glideport.setLayoutData(new GridData(4, 0x1000000, true, false));
    }

    protected void createGeneralTab(TabFolder tabFolder) {
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText(this.settings.msg("dialog.template.tab.general"));
        Composite composite_1 = new Composite(tabFolder, 0);
        GridLayout gridLayout_1 = new GridLayout();
        composite_1.setLayout(gridLayout_1);
        generalTabItem.setControl(composite_1);
        this.associationGroup = new Group(composite_1, 0);
        this.associationGroup.setText(this.settings.msg("dialog.template.association"));
        this.associationGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        this.associationGroup.setLayout(gridLayout_4);
        Label dbversionLabel = new Label(this.associationGroup, 0);
        dbversionLabel.setText(this.settings.msg("dialog.template.dosboxversion"));
        this.dbversion = new Combo(this.associationGroup, 8);
        this.dbversion.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.dbversion.setVisibleItemCount(20);
        this.setButton = new Button(this.associationGroup, 0);
        this.setButton.setText(this.settings.msg("dialog.template.set"));
        this.setButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doLoadTemplateConf(EditTemplateDialog.this.setButton, true, false);
            }
        });
        this.setButton.setEnabled(false);
        this.dbversion.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.setButton.setEnabled(true);
            }
        });
        this.reloadButton = new Button(this.associationGroup, 0);
        this.reloadButton.setText(this.settings.msg("dialog.template.reloadsettings"));
        this.reloadButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doLoadTemplateConf(EditTemplateDialog.this.setButton, false, false);
            }
        });
        this.miscGroup = new Group(composite_1, 0);
        this.miscGroup.setText(this.settings.msg("dialog.template.miscellaneous"));
        this.miscGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 3;
        this.miscGroup.setLayout(gridLayout_5);
        new Label(this.miscGroup, 0);
        Label activeLabel = new Label(this.miscGroup, 0);
        activeLabel.setText(this.settings.msg("dialog.template.active"));
        Label inactiveLabel = new Label(this.miscGroup, 0);
        inactiveLabel.setText(this.settings.msg("dialog.template.inactive"));
        Label priorityLabel = new Label(this.miscGroup, 0);
        priorityLabel.setText(this.settings.msg("dialog.template.priority"));
        this.priority_active = new Combo(this.miscGroup, 8);
        this.priority_active.setItems(this.settings.getValues("profile", "priority_active"));
        this.priority_active.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.priority_inactive = new Combo(this.miscGroup, 8);
        this.priority_inactive.setItems(this.settings.getValues("profile", "priority_inactive"));
        this.priority_inactive.setLayoutData(new GridData(16384, 0x1000000, false, false));
        Label waitOnErrorLabel = new Label(this.miscGroup, 0);
        waitOnErrorLabel.setText(this.settings.msg("dialog.template.waitonerror"));
        this.waitonerror = new Button(this.miscGroup, 32);
        new Label(this.miscGroup, 0);
        Label exitLabel = new Label(this.miscGroup, 0);
        exitLabel.setText(this.settings.msg("dialog.template.exitafterwards"));
        this.exit = new Button(this.miscGroup, 32);
        new Label(this.miscGroup, 0);
        Label languageFileLabel = new Label(this.miscGroup, 0);
        languageFileLabel.setLayoutData(new GridData());
        languageFileLabel.setText(this.settings.msg("dialog.template.languagefile"));
        this.language = new Text(this.miscGroup, 2048);
        this.language.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        Label capturesLabel = new Label(this.miscGroup, 0);
        capturesLabel.setLayoutData(new GridData());
        capturesLabel.setText(this.settings.msg("dialog.template.captures"));
        this.captures = new Text(this.miscGroup, 2048);
        this.captures.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.captures.setEditable(false);
    }

    protected void createInfoTab(TabFolder tabFolder) {
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText(this.settings.msg("dialog.template.tab.info"));
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout(gridLayout);
        this.infoTabItem.setControl(composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(this.settings.msg("dialog.template.title"));
        this.title = new Text(composite, 2048);
        this.title.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText(this.settings.msg("dialog.template.default"));
        this.defaultButton = new Button(composite, 32);
    }

    protected void selectSettingsByConfiguration() {
        Configuration conf = this.compConf.getCompositeConf();
        String priority = conf.getValue("sdl", "priority");
        String[] priorities = priority.split(",");
        if (priorities != null && priorities.length >= 2) {
            this.priority_active.setText(priorities[0]);
            this.priority_inactive.setText(priorities[1]);
        }
        EditTemplateDialog.setIfEnabled(conf, "sdl", "waitonerror", this.waitonerror);
        EditTemplateDialog.setIfEnabled(conf, "dosbox", "language", this.language);
        EditTemplateDialog.setIfEnabled(conf, "dosbox", "captures", this.captures);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "output", this.output);
        EditTemplateDialog.setIfEnabled(conf, "render", "frameskip", this.frameskip);
        EditTemplateDialog.setIfEnabled(conf, "render", "scaler", this.scaler);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "pixelshader", this.pixelshader);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "fullscreen", this.fullscreen);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "fulldouble", this.fulldouble);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "fullresolution", this.fullresolution);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "windowresolution", this.windowresolution);
        EditTemplateDialog.setIfEnabled(conf, "render", "aspect", this.aspect);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "overscan", this.overscan);
        EditTemplateDialog.setIfEnabled(conf, "vga", "svgachipset", this.svgachipset);
        EditTemplateDialog.setIfEnabled(conf, "vga", "videoram", this.videoram);
        EditTemplateDialog.setIfEnabled(conf, "vsync", "vsyncmode", this.vsyncmode);
        EditTemplateDialog.setIfEnabled(conf, "vsync", "vsyncrate", this.vsyncrate);
        EditTemplateDialog.setIfEnabled(conf, "glide", "glide", this.glide);
        EditTemplateDialog.setIfEnabled(conf, "glide", "port", this.glideport);
        EditTemplateDialog.setIfEnabled(conf, "dosbox", "machine", this.machine);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "cputype", this.cpu_type);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "core", this.core);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "cycles", this.cycles);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "cycleup", this.cycles_up);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "cycledown", this.cycles_down);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "timesynched", this.timesynched);
        EditTemplateDialog.setIfEnabled(conf, "dosbox", "memsize", this.memsize);
        EditTemplateDialog.setIfEnabled(conf, "dos", "xms", this.xms);
        EditTemplateDialog.setIfEnabled(conf, "dos", "ems", this.ems);
        EditTemplateDialog.setIfEnabled(conf, "dos", "umb", this.umb);
        EditTemplateDialog.setIfEnabled(conf, "mixer", "nosound", this.nosound);
        EditTemplateDialog.setIfEnabled(conf, "mixer", "rate", this.rate);
        EditTemplateDialog.setIfEnabled(conf, "midi", "mt32rate", this.mt32rate);
        EditTemplateDialog.setIfEnabled(conf, "mixer", "blocksize", this.blocksize);
        EditTemplateDialog.setIfEnabled(conf, "mixer", "prebuffer", this.prebuffer);
        EditTemplateDialog.setIfEnabled(conf, "midi", "mpu401", this.mpu401);
        EditTemplateDialog.setIfEnabled(conf, "midi", "device", "mididevice", this.midi_device);
        EditTemplateDialog.setIfEnabled(conf, "midi", "config", "midiconfig", this.midi_config);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "type", "sbtype", this.sbtype);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "oplmode", this.oplmode);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "oplrate", this.oplrate);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "oplemu", this.oplemu);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "base", "sbbase", this.sbbase);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "irq", this.irq);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "dma", this.dma);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "hdma", this.hdma);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "mixer", "sbmixer", this.sbmixer);
        EditTemplateDialog.setIfEnabled(conf, "gus", "gus", this.gus);
        EditTemplateDialog.setIfEnabled(conf, "gus", "rate", "gusrate", this.gusrate);
        EditTemplateDialog.setIfEnabled(conf, "gus", "base", "gusbase", this.gusbase);
        EditTemplateDialog.setIfEnabled(conf, "gus", "irq1", "gusirq", this.gusirq1);
        EditTemplateDialog.setIfEnabled(conf, "gus", "irq2", "gusirq", this.gusirq2);
        EditTemplateDialog.setIfEnabled(conf, "gus", "dma1", "gusdma", this.gusdma1);
        EditTemplateDialog.setIfEnabled(conf, "gus", "dma2", "gusdma", this.gusdma2);
        EditTemplateDialog.setIfEnabled(conf, "gus", "ultradir", this.ultradir);
        EditTemplateDialog.setIfEnabled(conf, "speaker", "pcspeaker", this.pcspeaker);
        EditTemplateDialog.setIfEnabled(conf, "speaker", "pcrate", this.pcrate);
        EditTemplateDialog.setIfEnabled(conf, "speaker", "tandy", this.tandy);
        EditTemplateDialog.setIfEnabled(conf, "speaker", "tandyrate", this.tandyrate);
        EditTemplateDialog.setIfEnabled(conf, "speaker", "disney", this.disney);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "autolock", this.autolock);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "sensitivity", this.sensitivity);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "usescancodes", this.usescancodes);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "mapperfile", this.mapperfile);
        EditTemplateDialog.setIfEnabled(conf, "dos", "keyboardlayout", this.keyboard_layout);
        if (conf.hasValue("joystick", "joysticktype")) {
            EditTemplateDialog.setIfEnabled(conf, "joystick", "joysticktype", this.joysticktype);
            EditTemplateDialog.setIfEnabled(conf, "joystick", "timed", this.timed);
            EditTemplateDialog.setIfEnabled(conf, "joystick", "autofire", this.autofire);
            EditTemplateDialog.setIfEnabled(conf, "joystick", "swap34", this.swap34);
            EditTemplateDialog.setIfEnabled(conf, "joystick", "buttonwrap", this.buttonwrap);
        } else {
            EditTemplateDialog.setIfEnabled(conf, "bios", "joysticktype", this.joysticktype);
        }
        EditTemplateDialog.setIfEnabled(conf, "serial", "serial1", this.serial1);
        EditTemplateDialog.setIfEnabled(conf, "serial", "serial2", this.serial2);
        EditTemplateDialog.setIfEnabled(conf, "serial", "serial3", this.serial3);
        EditTemplateDialog.setIfEnabled(conf, "serial", "serial4", this.serial4);
        EditTemplateDialog.setIfEnabled(conf, "ipx", "ipx", this.ipx);
        this.exit.setSelection(conf.isExit());
        this.mixer_config.setText(conf.getMixer());
        this.keyb.setText(conf.getKeyb());
        this.ipxnet.setEnabled(this.ipx.getSelection());
        this.ipxnet.setText(conf.getIpxnet());
        this.mountingpoints.setItems(conf.getMountingpoints());
        this.dosButton.setSelection(!conf.isBooter());
        this.booterButton.setSelection(conf.isBooter());
    }

    protected Configuration getConfigurationBySettings() {
        Configuration base = this.compConf.getBaseConf();
        Configuration conf = new Configuration(this.compConf.getCompositeConf(), false, null, false);
        conf.updateValue("sdl", "priority", String.valueOf(this.priority_active.getText()) + "," + this.priority_inactive.getText());
        conf.updateValue("sdl", "waitonerror", String.valueOf(this.waitonerror.getSelection()));
        conf.updateValue("dosbox", "language", this.language.getText());
        conf.updateValue("dosbox", "captures", this.captures.getText());
        conf.updateValue("sdl", "output", this.output.getText());
        conf.updateValue("render", "frameskip", this.frameskip.getText());
        conf.updateValue("render", "scaler", this.scaler.getText());
        conf.updateValue("sdl", "pixelshader", this.pixelshader.getText());
        conf.updateValue("sdl", "fullscreen", String.valueOf(this.fullscreen.getSelection()));
        conf.updateValue("sdl", "fulldouble", String.valueOf(this.fulldouble.getSelection()));
        conf.updateValue("sdl", "fullresolution", this.fullresolution.getText());
        conf.updateValue("sdl", "windowresolution", this.windowresolution.getText());
        conf.updateValue("render", "aspect", String.valueOf(this.aspect.getSelection()));
        conf.updateValue("sdl", "overscan", this.overscan.getText());
        conf.updateValue("vga", "svgachipset", this.svgachipset.getText());
        conf.updateValue("vga", "videoram", this.videoram.getText());
        conf.updateValue("vsync", "vsyncmode", this.vsyncmode.getText());
        conf.updateValue("vsync", "vsyncrate", this.vsyncrate.getText());
        conf.updateValue("glide", "glide", String.valueOf(this.glide.getSelection()));
        conf.updateValue("glide", "port", this.glideport.getText());
        conf.updateValue("dosbox", "machine", this.machine.getText());
        conf.updateValue("cpu", "cputype", this.cpu_type.getText());
        conf.updateValue("cpu", "core", this.core.getText());
        conf.updateValue("cpu", "cycles", this.cycles.getText());
        conf.updateValue("cpu", "cycleup", this.cycles_up.getText());
        conf.updateValue("cpu", "cycledown", this.cycles_down.getText());
        conf.updateValue("cpu", "timesynched", String.valueOf(this.timesynched.getSelection()));
        conf.updateValue("dosbox", "memsize", this.memsize.getText());
        conf.updateValue("dos", "xms", String.valueOf(this.xms.getSelection()));
        conf.updateValue("dos", "ems", String.valueOf(this.ems.getSelection()));
        conf.updateValue("dos", "umb", this.umb.getText());
        conf.updateValue("mixer", "nosound", String.valueOf(this.nosound.getSelection()));
        conf.updateValue("mixer", "rate", this.rate.getText());
        conf.updateValue("midi", "mt32rate", this.mt32rate.getText());
        conf.updateValue("mixer", "blocksize", this.blocksize.getText());
        conf.updateValue("mixer", "prebuffer", this.prebuffer.getText());
        conf.updateValue("midi", "mpu401", this.mpu401.getText());
        conf.updateValue("midi", "device", "mididevice", this.midi_device.getText(), base);
        conf.updateValue("midi", "config", "midiconfig", this.midi_config.getText(), base);
        conf.updateValue("sblaster", "type", "sbtype", this.sbtype.getText(), base);
        conf.updateValue("sblaster", "oplmode", this.oplmode.getText());
        conf.updateValue("sblaster", "oplrate", this.oplrate.getText());
        conf.updateValue("sblaster", "oplemu", this.oplemu.getText());
        conf.updateValue("sblaster", "base", "sbbase", this.sbbase.getText(), base);
        conf.updateValue("sblaster", "sbbase", this.sbbase.getText());
        conf.updateValue("sblaster", "irq", this.irq.getText());
        conf.updateValue("sblaster", "dma", this.dma.getText());
        conf.updateValue("sblaster", "hdma", this.hdma.getText());
        conf.updateValue("sblaster", "mixer", "sbmixer", String.valueOf(this.sbmixer.getSelection()), base);
        conf.updateValue("gus", "gus", String.valueOf(this.gus.getSelection()));
        conf.updateValue("gus", "rate", "gusrate", this.gusrate.getText(), base);
        conf.updateValue("gus", "base", "gusbase", this.gusbase.getText(), base);
        conf.updateValue("gus", "irq1", "gusirq", this.gusirq1.getText(), base);
        conf.updateValue("gus", "irq2", this.gusirq2.getText());
        conf.updateValue("gus", "dma1", "gusdma", this.gusdma1.getText(), base);
        conf.updateValue("gus", "dma2", this.gusdma2.getText());
        conf.updateValue("gus", "ultradir", this.ultradir.getText());
        conf.updateValue("speaker", "pcspeaker", String.valueOf(this.pcspeaker.getSelection()));
        conf.updateValue("speaker", "pcrate", this.pcrate.getText());
        conf.updateValue("speaker", "tandy", this.tandy.getText());
        conf.updateValue("speaker", "tandyrate", this.tandyrate.getText());
        conf.updateValue("speaker", "disney", String.valueOf(this.disney.getSelection()));
        conf.updateValue("sdl", "autolock", String.valueOf(this.autolock.getSelection()));
        conf.updateValue("sdl", "sensitivity", this.sensitivity.getText());
        conf.updateValue("sdl", "usescancodes", String.valueOf(this.usescancodes.getSelection()));
        conf.updateValue("sdl", "mapperfile", this.mapperfile.getText());
        conf.updateValue("dos", "keyboardlayout", this.keyboard_layout.getText());
        if (base.hasValue("joystick", "joysticktype")) {
            conf.updateValue("joystick", "joysticktype", this.joysticktype.getText());
            conf.updateValue("joystick", "timed", String.valueOf(this.timed.getSelection()));
            conf.updateValue("joystick", "autofire", String.valueOf(this.autofire.getSelection()));
            conf.updateValue("joystick", "swap34", String.valueOf(this.swap34.getSelection()));
            conf.updateValue("joystick", "buttonwrap", String.valueOf(this.buttonwrap.getSelection()));
        } else {
            conf.updateValue("bios", "joysticktype", this.joysticktype.getText());
        }
        conf.updateValue("serial", "serial1", this.serial1.getText());
        conf.updateValue("serial", "serial2", this.serial2.getText());
        conf.updateValue("serial", "serial3", this.serial3.getText());
        conf.updateValue("serial", "serial4", this.serial4.getText());
        conf.updateValue("ipx", "ipx", String.valueOf(this.ipx.getSelection()));
        conf.setAutoexecSettings(this.exit.getSelection(), this.mixer_config.getText(), this.keyb.getText(), this.ipx.getSelection() ? this.ipxnet.getText() : "", this.booterButton.getSelection());
        return conf;
    }

    protected void doAddMount() {
        EditMountDialog addMountDialog = new EditMountDialog(this.shell);
        try {
            addMountDialog.setDefaultDriveletter(Mount.getFreeDriveletter(this.booterButton.getSelection(), this.mountingpoints.getItems()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String mount = (String)addMountDialog.open();
        if (mount != null) {
            this.mountingpoints.setItems(this.compConf.addMount(mount));
            this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
        }
    }

    protected void doEditMount() {
        int mounts = this.mountingpoints.getItemCount();
        int sel = this.mountingpoints.getSelectionIndex();
        if (sel != -1) {
            EditMountDialog editMountDialog = new EditMountDialog(this.shell);
            editMountDialog.setMount(this.mountingpoints.getItem(sel));
            String mount = (String)editMountDialog.open();
            if (mount != null) {
                this.mountingpoints.setItems(this.compConf.editMount(sel, mount));
                if (this.mountingpoints.getItemCount() == mounts) {
                    this.mountingpoints.select(sel);
                } else {
                    this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
                }
            }
        }
    }

    protected void doRemoveMount() {
        int mounts = this.mountingpoints.getItemCount();
        int sel = this.mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) {
            sel = 0;
            this.mountingpoints.select(sel);
        }
        if (sel != -1) {
            this.mountingpoints.setItems(this.compConf.removeMount(sel));
            if (this.mountingpoints.getItemCount() == mounts) {
                this.mountingpoints.select(sel);
            } else if (this.mountingpoints.getItemCount() > 0) {
                this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
            }
        }
    }

    protected void enableSettingsByConfiguration() {
        Configuration conf = this.compConf.getBaseConf();
        if (conf.hasValue("cpu", "cputype")) {
            this.machine.setItems(this.settings.getValues("profile", "machine073"));
        } else {
            this.machine.setItems(this.settings.getValues("profile", "machine"));
        }
        EditTemplateDialog.enableDisableControl(conf, "cpu", "cputype", this.cpu_type, true);
        EditTemplateDialog.enableDisableControl(conf, "sdl", "pixelshader", this.pixelshader, true);
        EditTemplateDialog.enableDisableControl(conf, "sdl", "overscan", this.overscan, true);
        EditTemplateDialog.enableDisableControl(conf, "vga", "svgachipset", this.svgachipset, true);
        EditTemplateDialog.enableDisableControl(conf, "vga", "videoram", this.videoram, true);
        EditTemplateDialog.enableDisableControl(conf, "vsync", "vsyncmode", this.vsyncmode, true);
        EditTemplateDialog.enableDisableControl(conf, "vsync", "vsyncrate", this.vsyncrate, true);
        EditTemplateDialog.enableDisableControl(conf, "glide", "glide", this.glide, true);
        EditTemplateDialog.enableDisableControl(conf, "glide", "port", this.glideport, this.glide.getSelection());
        EditTemplateDialog.enableDisableControl(conf, "cpu", "timesynched", this.timesynched, true);
        EditTemplateDialog.enableDisableControl(conf, "sblaster", "oplemu", this.oplemu, true);
        EditTemplateDialog.enableDisableControl(conf, "gus", "irq2", this.gusirq2, true);
        EditTemplateDialog.enableDisableControl(conf, "gus", "dma2", this.gusdma2, true);
        EditTemplateDialog.enableDisableControl(conf, "midi", "mt32rate", this.mt32rate, true);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "timed", this.timed, true);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "autofire", this.autofire, true);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "swap34", this.swap34, true);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "buttonwrap", this.buttonwrap, true);
        EditTemplateDialog.enableDisableControl(conf, "dos", "keyboardlayout", this.keyboard_layout, true);
    }

    protected void doLoadTemplateConf(Button setButton, boolean keepValues, boolean isTemplate) {
        this.compConf.setCompositeConf(this.getConfigurationBySettings());
        CompositeConfiguration newCompConf = this.obtainNewConf(keepValues, isTemplate);
        if (newCompConf.getCompositeConf() == null) {
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.template.notice.noloadnochanges"));
        } else {
            this.compConf = newCompConf;
            this.enableSettingsByConfiguration();
            this.selectSettingsByConfiguration();
            setButton.setEnabled(false);
        }
    }

    protected CompositeConfiguration obtainNewConf(boolean keepValues, boolean isTemplate) {
        return new CompositeConfiguration(this.compConf, this.dbversionsList.get(this.dbversion.getSelectionIndex()), keepValues, true, this.shell);
    }

    protected static void enableDisableControl(Configuration dbConf, String section, String item, Control control, boolean extraCondition) {
        control.setEnabled(dbConf.hasValue(section, item) && extraCondition);
    }

    protected static void setIfEnabled(Configuration conf, String section, String item, Control control) {
        if (control.isEnabled()) {
            if (control instanceof Text) {
                ((Text)control).setText(conf.getValue(section, item));
            } else if (control instanceof Combo) {
                ((Combo)control).setText(conf.getValue(section, item));
            } else if (control instanceof Button) {
                ((Button)control).setSelection(conf.getBooleanValue(section, item));
            }
        }
    }

    protected static void setIfEnabled(Configuration conf, String section, String oldItem, String newItem, Control control) {
        if (conf.hasValue(section, newItem)) {
            EditTemplateDialog.setIfEnabled(conf, section, newItem, control);
        } else {
            EditTemplateDialog.setIfEnabled(conf, section, oldItem, control);
        }
    }

    protected boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.template.required.title"), this.title, this.infoTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

