/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.BrowseButton;
import com.gui.GeneralPurposeDialogs;
import com.gui.SizeControlAdapter;
import com.model.Settings;
import com.util.FileUtils;
import com.util.MigrateThread;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class MigrateDialog
extends Dialog {
    private Text from;
    private Text logText;
    private MigrateThread migrateThread;
    private Button cancelButton;
    private Label profileLabel;
    private String result = null;
    private Shell shell;
    private Settings settings;

    public MigrateDialog(Shell parent, int style) {
        super(parent, style);
    }

    public MigrateDialog(Shell parent) {
        this(parent, 0);
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (this.migrateThread != null && !this.migrateThread.isAlive() && !this.cancelButton.getText().equals(this.settings.msg("button.close"))) {
                GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.migration.notice.migrationok"));
                this.profileLabel.setText(this.settings.msg("dialog.migration.reviewlog"));
                this.profileLabel.pack();
                this.cancelButton.setText(this.settings.msg("button.close"));
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout(new GridLayout());
        this.shell.addControlListener(new SizeControlAdapter(this.shell, "migratedialog"));
        this.shell.setText(this.settings.msg("dialog.migration.title"));
        Group optionsGroup = new Group(this.shell, 0);
        optionsGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        optionsGroup.setText(this.settings.msg("dialog.migration.options"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        optionsGroup.setLayout(gridLayout);
        Label fromLocationLabel = new Label(optionsGroup, 0);
        fromLocationLabel.setText(this.settings.msg("dialog.migration.from"));
        this.from = new Text(optionsGroup, 2048);
        this.from.setLayoutData(new GridData(4, 0x1000000, true, false));
        final BrowseButton fromBrowseButton = new BrowseButton(optionsGroup, 0);
        fromBrowseButton.connect(this.shell, this.from, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, null);
        Label toLabel = new Label(optionsGroup, 0);
        toLabel.setText(this.settings.msg("dialog.migration.to"));
        Text toDosRoot = new Text(optionsGroup, 2056);
        toDosRoot.setLayoutData(new GridData(4, 0x1000000, true, false));
        toDosRoot.setText(FileUtils.getDosRoot());
        new Label(optionsGroup, 0);
        final Button startButton = new Button(optionsGroup, 0);
        this.shell.setDefaultButton(startButton);
        startButton.setLayoutData(new GridData(120, -1));
        startButton.setText(this.settings.msg("dialog.migration.startmigration"));
        this.cancelButton = new Button(optionsGroup, 0);
        this.cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MigrateDialog.this.shell.close();
            }
        });
        this.cancelButton.setLayoutData(new GridData(80, -1));
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        new Label(optionsGroup, 0);
        Group progressGroup = new Group(this.shell, 0);
        progressGroup.setLayoutData(new GridData(4, 4, true, true));
        progressGroup.setText(this.settings.msg("dialog.migration.progress"));
        progressGroup.setLayout(new GridLayout());
        final ProgressBar progressBar = new ProgressBar(progressGroup, 0);
        progressBar.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.profileLabel = new Label(progressGroup, 0);
        this.logText = new Text(progressGroup, 2826);
        this.logText.setLayoutData(new GridData(4, 4, true, true));
        startButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!MigrateDialog.this.isValid()) {
                    return;
                }
                try {
                    MigrateDialog.this.migrateThread = new MigrateThread(new File(MigrateDialog.this.from.getText()), MigrateDialog.this.logText, progressBar, MigrateDialog.this.profileLabel);
                    MigrateDialog.this.from.setEnabled(false);
                    MigrateDialog.this.result = MigrateDialog.this.from.getText();
                    fromBrowseButton.setEnabled(false);
                    startButton.setEnabled(false);
                    MigrateDialog.this.migrateThread.start();
                }
                catch (IOException ex) {
                    GeneralPurposeDialogs.warningMessage(MigrateDialog.this.shell, ex.getMessage());
                    MigrateDialog.this.migrateThread = null;
                }
            }
        });
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.from.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.migration.required.from"), this.from);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

