/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.model.KeyValuePair;
import com.model.Settings;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTitleDefault
extends KeyValuePair {
    private boolean defaultChoice;

    public KeyTitleDefault(int id, String value, boolean isDefault) {
        super(id, value);
        this.defaultChoice = isDefault;
    }

    public String getTitle() {
        return this.getValue();
    }

    public boolean isDefault() {
        return this.defaultChoice;
    }

    public String isDefaultString() {
        return this.defaultChoice ? Settings.getInstance().msg("general.yes") : Settings.getInstance().msg("general.no");
    }

    public void toggleDefault() {
        this.defaultChoice = !this.defaultChoice;
    }

    public static <T extends KeyTitleDefault> int findDefault(List<T> list) {
        int result = 0;
        for (KeyTitleDefault element : list) {
            if (element.defaultChoice) {
                return result;
            }
            ++result;
        }
        return -1;
    }
}

