/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.DOCINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    public int handle;
    PrinterData data;
    boolean isGCCreated = false;
    static TCHAR profile = new TCHAR(0, "PrinterPorts", true);
    static TCHAR appName = new TCHAR(0, "windows", true);
    static TCHAR keyName = new TCHAR(0, "device", true);

    public static PrinterData[] getPrinterList() {
        TCHAR tCHAR = new TCHAR(0, 1);
        int n = 1024;
        TCHAR tCHAR2 = new TCHAR(0, n);
        int n2 = OS.GetProfileString(profile, null, tCHAR, tCHAR2, n);
        if (n2 == 0) {
            return new PrinterData[0];
        }
        String[] stringArray = new String[5];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            if (tCHAR2.tcharAt(n5) == 0) {
                if (n3 == stringArray.length) {
                    String[] stringArray2 = new String[stringArray.length + 5];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray = stringArray2;
                }
                stringArray[n3] = tCHAR2.toString(n4, n5 - n4);
                ++n3;
                n4 = n5 + 1;
            }
            ++n5;
        }
        PrinterData[] printerDataArray = new PrinterData[n3];
        int n6 = 0;
        while (n6 < n3) {
            String string = stringArray[n6];
            String string2 = "";
            if (OS.GetProfileString(profile, new TCHAR(0, string, true), tCHAR, tCHAR2, n) > 0) {
                int n7 = 0;
                while (tCHAR2.tcharAt(n7) != 44 && n7 < n) {
                    ++n7;
                }
                if (n7 < n) {
                    string2 = tCHAR2.toString(0, n7);
                }
            }
            printerDataArray[n6] = new PrinterData(string2, string);
            ++n6;
        }
        return printerDataArray;
    }

    public static PrinterData getDefaultPrinterData() {
        String string = null;
        TCHAR tCHAR = new TCHAR(0, 1);
        int n = 1024;
        TCHAR tCHAR2 = new TCHAR(0, n);
        int n2 = OS.GetProfileString(appName, keyName, tCHAR, tCHAR2, n);
        if (n2 == 0) {
            return null;
        }
        int n3 = 0;
        while (tCHAR2.tcharAt(n3) != 44 && n3 < n) {
            ++n3;
        }
        if (n3 < n) {
            string = tCHAR2.toString(0, n3);
        }
        String string2 = "";
        if (OS.GetProfileString(profile, new TCHAR(0, string, true), tCHAR, tCHAR2, n) > 0) {
            n3 = 0;
            while (tCHAR2.tcharAt(n3) != 44 && n3 < n) {
                ++n3;
            }
            if (n3 < n) {
                string2 = tCHAR2.toString(0, n3);
            }
        }
        return new PrinterData(string2, string);
    }

    static DeviceData checkNull(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        if (printerData.driver == null || printerData.name == null) {
            PrinterData printerData2 = Printer.getDefaultPrinterData();
            if (printerData2 == null) {
                SWT.error(2);
            }
            printerData.driver = printerData2.driver;
            printerData.name = printerData2.name;
        }
        return printerData;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData printerData) {
        super(Printer.checkNull(printerData));
    }

    protected void create(DeviceData deviceData) {
        this.data = (PrinterData)deviceData;
        TCHAR tCHAR = new TCHAR(0, this.data.driver, true);
        TCHAR tCHAR2 = new TCHAR(0, this.data.name, true);
        int n = 0;
        byte[] byArray = this.data.otherData;
        int n2 = OS.GetProcessHeap();
        if (byArray != null && byArray.length != 0) {
            n = OS.HeapAlloc(n2, 8, byArray.length);
            OS.MoveMemory(n, byArray, byArray.length);
        }
        this.handle = OS.CreateDC(tCHAR, tCHAR2, 0, n);
        if (n != 0) {
            OS.HeapFree(n2, 0, n);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    public int internal_new_GC(GCData gCData) {
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (gCData != null) {
            int n;
            if (this.isGCCreated) {
                SWT.error(5);
            }
            if ((gCData.style & (n = 0x6000000)) != 0) {
                gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.font = Font.win32_new(this, OS.GetCurrentObject(this.handle, 6));
            this.isGCCreated = true;
        }
        return this.handle;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        if (gCData != null) {
            this.isGCCreated = false;
        }
    }

    public boolean startJob(String string) {
        int n;
        this.checkDevice();
        DOCINFO dOCINFO = new DOCINFO();
        dOCINFO.cbSize = DOCINFO.sizeof;
        int n2 = OS.GetProcessHeap();
        int n3 = 0;
        if (string != null && string.length() != 0) {
            TCHAR tCHAR = new TCHAR(0, string, true);
            n = tCHAR.length() * TCHAR.sizeof;
            n3 = OS.HeapAlloc(n2, 8, n);
            OS.MoveMemory(n3, tCHAR, n);
            dOCINFO.lpszDocName = n3;
        }
        int n4 = 0;
        if (this.data.printToFile && this.data.fileName != null) {
            TCHAR tCHAR = new TCHAR(0, this.data.fileName, true);
            int n5 = tCHAR.length() * TCHAR.sizeof;
            n4 = OS.HeapAlloc(n2, 8, n5);
            OS.MoveMemory(n4, tCHAR, n5);
            dOCINFO.lpszOutput = n4;
        }
        n = OS.StartDoc(this.handle, dOCINFO);
        if (n3 != 0) {
            OS.HeapFree(n2, 0, n3);
        }
        if (n4 != 0) {
            OS.HeapFree(n2, 0, n4);
        }
        return n > 0;
    }

    public void endJob() {
        this.checkDevice();
        OS.EndDoc(this.handle);
    }

    public void cancelJob() {
        this.checkDevice();
        OS.AbortDoc(this.handle);
    }

    public boolean startPage() {
        this.checkDevice();
        int n = OS.StartPage(this.handle);
        if (n <= 0) {
            OS.AbortDoc(this.handle);
        }
        return n > 0;
    }

    public void endPage() {
        this.checkDevice();
        OS.EndPage(this.handle);
    }

    public Point getDPI() {
        this.checkDevice();
        int n = OS.GetDeviceCaps(this.handle, 88);
        int n2 = OS.GetDeviceCaps(this.handle, 90);
        return new Point(n, n2);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int n = OS.GetDeviceCaps(this.handle, 110);
        int n2 = OS.GetDeviceCaps(this.handle, 111);
        return new Rectangle(0, 0, n, n2);
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        int n = OS.GetDeviceCaps(this.handle, 8);
        int n2 = OS.GetDeviceCaps(this.handle, 10);
        return new Rectangle(0, 0, n, n2);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkDevice();
        int n5 = -OS.GetDeviceCaps(this.handle, 112);
        int n6 = -OS.GetDeviceCaps(this.handle, 113);
        int n7 = OS.GetDeviceCaps(this.handle, 8);
        int n8 = OS.GetDeviceCaps(this.handle, 10);
        int n9 = OS.GetDeviceCaps(this.handle, 110);
        int n10 = OS.GetDeviceCaps(this.handle, 111);
        int n11 = n9 - n7;
        int n12 = n10 - n8;
        return new Rectangle(n + n5, n2 + n6, n3 + n11, n4 + n12);
    }

    public PrinterData getPrinterData() {
        return this.data;
    }

    protected void checkDevice() {
        if (this.handle == 0) {
            SWT.error(45);
        }
    }

    protected void release() {
        super.release();
        this.data = null;
    }

    protected void destroy() {
        if (this.handle != 0) {
            OS.DeleteDC(this.handle);
        }
        this.handle = 0;
    }
}

