/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.util.ArrayList;
import java.util.List;

public class OrderingVector {
    private static final int MAX_ORDERING_COLS = 8;
    private static final String[] GAME_LIST_ORDER = new String[]{"LOWER(GAM.TITLE)", "GAM.SETUP", "LOWER(DEV.NAME)", "LOWER(PUBL.NAME)", "LOWER(GEN.NAME)", "YR.YEAR", "LOWER(STAT.STAT)", "GAM.FAVORITE", "GAM.ID", "GAM.DBVERSION_ID", "LOWER(CUST1.VALUE)", "LOWER(CUST2.VALUE)", "LOWER(CUST3.VALUE)", "LOWER(CUST4.VALUE)", "LOWER(GAM.CUSTOM5)", "LOWER(GAM.CUSTOM6)", "LOWER(GAM.CUSTOM7)", "LOWER(GAM.CUSTOM8)", "GAM.CUSTOM9", "GAM.CUSTOM10", "LOWER(GAM.CAPTURES)"};
    private final List<OrderingElement> vector = new ArrayList<OrderingElement>();

    public OrderingVector(int[] columnArray, boolean[] ascendingArray) {
        for (int i = 0; i < columnArray.length; ++i) {
            this.vector.add(new OrderingElement(columnArray[i], ascendingArray[i]));
        }
    }

    public void addOrdering(int column, boolean ascending) {
        OrderingElement newOrdering = new OrderingElement(column, ascending);
        int existingIndex = this.vector.indexOf(newOrdering);
        if (existingIndex != -1) {
            this.vector.remove(existingIndex);
        }
        this.vector.add(0, newOrdering);
        if (this.vector.size() > 8) {
            this.vector.remove(8);
        }
    }

    public int[] getColumns() {
        int[] columnArray = new int[this.vector.size()];
        for (int i = 0; i < columnArray.length; ++i) {
            columnArray[i] = this.vector.get(i).column;
        }
        return columnArray;
    }

    public boolean[] getAscendings() {
        boolean[] ascendingArray = new boolean[this.vector.size()];
        for (int i = 0; i < ascendingArray.length; ++i) {
            ascendingArray[i] = this.vector.get(i).ascending;
        }
        return ascendingArray;
    }

    public String toClause() {
        StringBuffer orderingClause = new StringBuffer();
        for (int index = 0; index < this.vector.size(); ++index) {
            OrderingElement element = this.vector.get(index);
            orderingClause.append(element.toString());
            if (index + 1 >= this.vector.size()) continue;
            orderingClause.append(',');
        }
        return orderingClause.toString();
    }

    private class OrderingElement {
        private final int column;
        private final boolean ascending;

        OrderingElement(int col, boolean asc) {
            this.column = col;
            this.ascending = asc;
        }

        public boolean equals(Object obj) {
            return this.column == ((OrderingElement)obj).column;
        }

        public String toString() {
            return GAME_LIST_ORDER[this.column] + (this.ascending ? " ASC" : " DESC");
        }
    }
}

