/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

public final class StringUtils {
    public static String[] textAreaToStringArray(String contents, String del) {
        int start;
        int length = del.length();
        int finish = contents.length();
        for (start = 0; contents.indexOf(del, start) == start; start += length) {
        }
        while (finish >= length && contents.indexOf(del, finish - length) == finish - length) {
            finish -= length;
        }
        return contents.substring(start, finish).split(del);
    }

    public static String[] mountToStringArray(String paths) {
        if (paths.length() <= 0) {
            return new String[0];
        }
        return paths.split("\" \"");
    }

    public static String intArrayToString(int[] list) {
        StringBuffer result = new StringBuffer();
        for (int value : list) {
            result.append(value).append(' ');
        }
        return result.toString();
    }

    public static String booleanArrayToString(boolean[] list) {
        StringBuffer result = new StringBuffer();
        for (boolean value : list) {
            result.append(value).append(' ');
        }
        return result.toString();
    }

    public static String stringArrayToString(String[] list, String delimiter) {
        StringBuffer result = new StringBuffer();
        for (String value : list) {
            result.append(value).append(delimiter);
        }
        return result.toString();
    }

    public static int[] stringToIntArray(String input) {
        if (input.length() <= 0) {
            return new int[0];
        }
        String[] values = input.split(" ");
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                result[i] = Integer.parseInt(values[i]);
                continue;
            }
            catch (NumberFormatException e) {
                result[i] = -1;
            }
        }
        return result;
    }

    public static boolean[] stringToBooleanArray(String input) {
        if (input.length() <= 0) {
            return new boolean[0];
        }
        String[] values = input.split(" ");
        boolean[] result = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Boolean.parseBoolean(values[i]);
        }
        return result;
    }

    public static int countCharacters(String string, char charToCount) {
        int result = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != charToCount) continue;
            ++result;
        }
        return result;
    }

    public static String shorten(String s, int length) {
        if (s == null || s.length() <= length) {
            return s;
        }
        return new StringBuffer(s.substring(0, length / 2 - 2)).append("....").append(s.substring(s.length() - length / 2 + 2)).toString();
    }
}

