/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.Filter;
import org.dbgl.model.Profile;
import org.dbgl.model.Settings;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public final class EditFilterDialog
extends Dialog {
    private Text filter;
    private Text title;
    private String prevTitle;
    private Database dbase;
    private Object result;
    private Shell shell;
    private Settings settings;

    public EditFilterDialog(Shell parent) {
        super(parent, 0);
    }

    public void setFilter(Filter filter) {
        this.result = filter;
    }

    public Object open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "filterdialog"));
        if (this.result == null) {
            this.shell.setText(this.settings.msg("dialog.filter.title.add"));
        } else {
            this.shell.setText(this.settings.msg("dialog.filter.title.edit", new Object[]{((Filter)this.result).getTitle(), ((Filter)this.result).getId()}));
        }
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem infoTabItem = new TabItem(tabFolder, 0);
        infoTabItem.setText(this.settings.msg("dialog.filter.tab.info"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        infoTabItem.setControl((Control)composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(this.settings.msg("dialog.filter.title"));
        this.title = new Text(composite, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label filterLabel = new Label(composite, 0);
        filterLabel.setText(this.settings.msg("dialog.filter.filter"));
        this.filter = new Text(composite, 2818);
        this.filter.setLayoutData((Object)new GridData(4, 4, true, true));
        Label resultLabel = new Label(composite, 0);
        resultLabel.setText(this.settings.msg("dialog.filter.result"));
        final Text results = new Text(composite, 2056);
        results.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite composite_7 = new Composite((Composite)this.shell, 0);
        composite_7.setLayout((Layout)new GridLayout(2, true));
        composite_7.setLayoutData((Object)"South");
        final Button okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        okButton.setLayoutData((Object)gridData);
        okButton.setText(this.settings.msg("button.ok"));
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditFilterDialog.this.isValid()) {
                    return;
                }
                try {
                    int filterId = EditFilterDialog.this.dbase.addOrEditFilter(EditFilterDialog.this.title.getText(), EditFilterDialog.this.filter.getText(), EditFilterDialog.this.result == null ? -1 : ((Filter)EditFilterDialog.this.result).getId());
                    EditFilterDialog.this.result = new Filter(filterId, EditFilterDialog.this.title.getText(), EditFilterDialog.this.filter.getText());
                }
                catch (SQLException e1) {
                    GeneralPurposeDialogs.warningMessage(EditFilterDialog.this.shell, e1.getMessage());
                }
                EditFilterDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button(composite_7, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = 4;
        cancelButton.setLayoutData((Object)gridData_1);
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditFilterDialog.this.result = null;
                EditFilterDialog.this.shell.close();
            }
        });
        this.title.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (EditFilterDialog.this.filter.getText().equals("") || EditFilterDialog.this.filter.getText().equals("UPPER(GAM.TITLE) LIKE '%" + EditFilterDialog.this.prevTitle.toUpperCase() + "%'")) {
                    if (EditFilterDialog.this.title.getText().length() == 0) {
                        EditFilterDialog.this.filter.setText("");
                    } else {
                        EditFilterDialog.this.filter.setText("UPPER(GAM.TITLE) LIKE '%" + EditFilterDialog.this.title.getText().toUpperCase() + "%'");
                    }
                }
                EditFilterDialog.this.prevTitle = EditFilterDialog.this.title.getText();
            }
        });
        this.filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                try {
                    List<Profile> tmpList = EditFilterDialog.this.dbase.readProfilesList("", EditFilterDialog.this.filter.getText());
                    results.setText(EditFilterDialog.this.settings.msg("dialog.filter.notice.results", new Object[]{tmpList.size()}));
                    okButton.setEnabled(true);
                }
                catch (SQLException e) {
                    results.setText(EditFilterDialog.this.settings.msg("dialog.filter.error.invalidcondition"));
                    okButton.setEnabled(false);
                }
            }
        });
        if (this.result != null) {
            this.title.setText(((Filter)this.result).getTitle());
            this.filter.setText(((Filter)this.result).getFilter());
        }
        this.title.setFocus();
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.filter.required.title"), (Control)this.title);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

