/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.IOException;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.MigrateThread;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class MigrateDialog
extends Dialog {
    private Text from;
    private Text logText;
    private MigrateThread migrateThread;
    private Button cancelButton;
    private Label profileLabel;
    private String result = null;
    private Shell shell;
    private Settings settings;

    public MigrateDialog(Shell parent, int style) {
        super(parent, style);
    }

    public MigrateDialog(Shell parent) {
        this(parent, 0);
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (this.migrateThread != null && !this.migrateThread.isAlive() && !this.cancelButton.getText().equals(this.settings.msg("button.close"))) {
                GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.migration.notice.migrationok"));
                this.profileLabel.setText(this.settings.msg("dialog.migration.reviewlog"));
                this.profileLabel.pack();
                this.cancelButton.setText(this.settings.msg("button.close"));
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "migratedialog"));
        this.shell.setText(this.settings.msg("dialog.migration.title"));
        Group optionsGroup = new Group((Composite)this.shell, 0);
        optionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        optionsGroup.setText(this.settings.msg("dialog.migration.options"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        optionsGroup.setLayout((Layout)gridLayout);
        Label fromLocationLabel = new Label((Composite)optionsGroup, 0);
        fromLocationLabel.setText(this.settings.msg("dialog.migration.from"));
        this.from = new Text((Composite)optionsGroup, 2048);
        this.from.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final BrowseButton fromBrowseButton = new BrowseButton((Composite)optionsGroup, 0);
        fromBrowseButton.connect(this.shell, this.from, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        Label toLabel = new Label((Composite)optionsGroup, 0);
        toLabel.setText(this.settings.msg("dialog.migration.to"));
        Text toDosRoot = new Text((Composite)optionsGroup, 2056);
        toDosRoot.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toDosRoot.setText(FileUtils.getDosRoot());
        new Label((Composite)optionsGroup, 0);
        final Button startButton = new Button((Composite)optionsGroup, 0);
        this.shell.setDefaultButton(startButton);
        startButton.setLayoutData((Object)new GridData(120, -1));
        startButton.setText(this.settings.msg("dialog.migration.startmigration"));
        this.cancelButton = new Button((Composite)optionsGroup, 0);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MigrateDialog.this.shell.close();
            }
        });
        this.cancelButton.setLayoutData((Object)new GridData(120, -1));
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        new Label((Composite)optionsGroup, 0);
        Group progressGroup = new Group((Composite)this.shell, 0);
        progressGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        progressGroup.setText(this.settings.msg("dialog.migration.progress"));
        progressGroup.setLayout((Layout)new GridLayout());
        final ProgressBar progressBar = new ProgressBar((Composite)progressGroup, 0);
        progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.profileLabel = new Label((Composite)progressGroup, 0);
        this.logText = new Text((Composite)progressGroup, 2826);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
        startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!MigrateDialog.this.isValid()) {
                    return;
                }
                try {
                    MigrateDialog.this.migrateThread = new MigrateThread(new File(MigrateDialog.this.from.getText()), MigrateDialog.this.logText, progressBar, MigrateDialog.this.profileLabel);
                    MigrateDialog.this.from.setEnabled(false);
                    MigrateDialog.this.result = MigrateDialog.this.from.getText();
                    fromBrowseButton.setEnabled(false);
                    startButton.setEnabled(false);
                    MigrateDialog.this.migrateThread.start();
                }
                catch (IOException ex) {
                    GeneralPurposeDialogs.warningMessage(MigrateDialog.this.shell, ex.getMessage());
                    MigrateDialog.this.migrateThread = null;
                }
            }
        });
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.from.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.migration.required.from"), (Control)this.from);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

