/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpGame
extends Profile {
    private String fullConfig;
    private String incrConfig;
    private File gameDir;
    private static final XPathFactory xfactory = XPathFactory.newInstance();
    private static final XPath xPath = xfactory.newXPath();

    public ExpGame(int id, String confFile, String captures, String setup, String fc, String ic, File gd, Profile prof) {
        super(id, confFile, captures, prof);
        this.fullConfig = fc;
        this.incrConfig = ic;
        this.setup = setup;
        this.gameDir = gd;
    }

    public ExpGame(Node n, Set<DosboxVersion> dbSet) throws XPathExpressionException {
        super(xPath.evaluate("title", n), Boolean.valueOf(xPath.evaluate("meta-info/favorite", n)));
        this.developerName = xPath.evaluate("meta-info/developer", n);
        this.publisherName = xPath.evaluate("meta-info/publisher", n);
        this.year = xPath.evaluate("meta-info/year", n);
        this.genre = xPath.evaluate("meta-info/genre", n);
        this.status = xPath.evaluate("meta-info/status", n);
        this.notes = xPath.evaluate("meta-info/notes", n);
        this.customString = new String[]{xPath.evaluate("meta-info/custom1", n), xPath.evaluate("meta-info/custom2", n), xPath.evaluate("meta-info/custom3", n), xPath.evaluate("meta-info/custom4", n), xPath.evaluate("meta-info/custom5", n), xPath.evaluate("meta-info/custom6", n), xPath.evaluate("meta-info/custom7", n), xPath.evaluate("meta-info/custom8", n)};
        this.customInt = new int[]{Integer.valueOf(xPath.evaluate("meta-info/custom9", n)), Integer.valueOf(xPath.evaluate("meta-info/custom10", n))};
        this.link = new String[]{xPath.evaluate("meta-info/link1", n), xPath.evaluate("meta-info/link2", n), xPath.evaluate("meta-info/link3", n), xPath.evaluate("meta-info/link4", n)};
        this.setup = xPath.evaluate("dosbox/setup", n);
        this.setupParams = xPath.evaluate("dosbox/setup-parameters", n);
        this.captures = xPath.evaluate("dosbox/captures", n);
        this.gameDir = new File(xPath.evaluate("dosbox/game-dir", n));
        for (DosboxVersion db : dbSet) {
            String dbTitle = xPath.evaluate("dosbox/title", n);
            String dbVersion = xPath.evaluate("dosbox/version", n);
            if (!db.getVersion().equals(dbVersion) || !db.getTitle().equals(dbTitle)) continue;
            this.dbversionId = db.getId();
        }
        this.fullConfig = xPath.evaluate("full-configuration", n);
        this.incrConfig = xPath.evaluate("incremental-configuration", n);
    }

    public String getFullConfig() {
        return this.fullConfig;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public void setGameDir(File gameDir) {
        this.gameDir = gameDir;
    }

    public String getIncrConfig() {
        return this.incrConfig;
    }

    public void setDbversionId(int id) {
        this.dbversionId = id;
    }

    public Element getXml(Document xmldoc, List<DosboxVersion> dbversionsList) {
        int i;
        Element el = xmldoc.createElement("profile");
        XmlUtils.addElement(xmldoc, el, "title", this.getTitle());
        Element meta = xmldoc.createElement("meta-info");
        XmlUtils.addElement(xmldoc, meta, "developer", this.getDeveloperName());
        XmlUtils.addElement(xmldoc, meta, "publisher", this.getPublisherName());
        XmlUtils.addElement(xmldoc, meta, "year", this.getYear());
        XmlUtils.addElement(xmldoc, meta, "genre", this.getGenre());
        XmlUtils.addElement(xmldoc, meta, "status", this.getStatus());
        XmlUtils.addElement(xmldoc, meta, "favorite", String.valueOf(this.isDefault()));
        XmlUtils.addCDataElement(xmldoc, meta, "notes", this.getNotes());
        for (i = 0; i < 8; ++i) {
            XmlUtils.addElement(xmldoc, meta, "custom" + (i + 1), this.getCustomString(i));
        }
        for (i = 0; i < 2; ++i) {
            XmlUtils.addElement(xmldoc, meta, "custom" + (i + 9), String.valueOf(this.getCustomInt(i)));
        }
        for (i = 0; i < 4; ++i) {
            XmlUtils.addElement(xmldoc, meta, "link" + (i + 1), this.getLink(i));
        }
        el.appendChild(meta);
        XmlUtils.addCDataElement(xmldoc, el, "full-configuration", this.fullConfig);
        XmlUtils.addCDataElement(xmldoc, el, "incremental-configuration", this.incrConfig);
        int index = DosboxVersion.findById(dbversionsList, this.getDbversionId());
        DosboxVersion dbv = dbversionsList.get(index);
        Element dosbox = xmldoc.createElement("dosbox");
        XmlUtils.addElement(xmldoc, dosbox, "title", dbv.getValue());
        XmlUtils.addElement(xmldoc, dosbox, "version", dbv.getVersion());
        XmlUtils.addElement(xmldoc, dosbox, "captures", this.getCaptures());
        XmlUtils.addElement(xmldoc, dosbox, "setup", PlatformUtils.toDosboxPath(this.getSetup()));
        XmlUtils.addElement(xmldoc, dosbox, "setup-parameters", this.getSetupParameters());
        XmlUtils.addElement(xmldoc, dosbox, "game-dir", PlatformUtils.toDosboxPath(this.gameDir.getPath()));
        el.appendChild(dosbox);
        return el;
    }
}

