/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.EditProfileDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.Settings;
import org.dbgl.model.conf.CompositeConfiguration;
import org.dbgl.util.MobyGamesThread;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditMultiProfileDialog
extends EditProfileDialog {
    private Label profileLabel;
    private ProgressBar progressBar;
    private Text logText;
    private Button consultMobyGames;
    private static final int AMOUNT_OF_THREADS = 4;
    private Thread[] mbt = new Thread[4];

    public EditMultiProfileDialog(Shell parent) {
        super(parent);
    }

    public void setProfiles(List<Profile> profs) {
        this.result = profs;
    }

    @Override
    public Object open() {
        this.settings = Settings.getInstance();
        this.dbase = Database.getInstance();
        if (this.init()) {
            this.createContents();
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                boolean alldone = true;
                if (this.mbt != null) {
                    for (int i = 0; i < 4; ++i) {
                        alldone &= this.mbt[i] != null && !this.mbt[i].isAlive();
                    }
                }
                if (alldone) {
                    if (this.logText.getCharCount() > 0 && !this.cancelButton.getText().equals(this.settings.msg("button.close"))) {
                        GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.multiprofile.reviewlog"));
                        this.profileLabel.setText(this.settings.msg("dialog.multiprofile.reviewlog"));
                        this.profileLabel.pack();
                        this.cancelButton.setText(this.settings.msg("button.close"));
                        this.progressBar.setSelection(this.progressBar.getMaximum());
                        this.mbt = new Thread[4];
                    } else {
                        this.shell.close();
                    }
                }
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        return this.result;
    }

    @Override
    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout(new BorderLayout(0, 0));
        this.shell.addControlListener(new SizeControlAdapter(this.shell, "multiprofiledialog"));
        final List profs = (List)this.result;
        this.shell.setText(this.settings.msg("dialog.multiprofile.title.edit", new Object[]{profs.size()}));
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        this.createInfoTab(tabFolder);
        this.createCustomTab(tabFolder);
        this.createGeneralTab(tabFolder);
        this.createDisplayTab(tabFolder);
        this.createMachineTab(tabFolder);
        this.createAudioTab(tabFolder);
        this.createIOTab(tabFolder);
        this.createMountingTab(tabFolder);
        for (DosboxVersion dbv : this.dbversionsList) {
            this.dbversion.add(dbv.getTitle());
        }
        this.createOkCancelButtons();
        this.okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditMultiProfileDialog.this.okButton.setEnabled(false);
                int tasks = 0;
                if (EditMultiProfileDialog.this.dbversion.getSelectionIndex() != -1) {
                    tasks += profs.size();
                }
                if (EditMultiProfileDialog.this.consultMobyGames.getSelection()) {
                    tasks += profs.size();
                }
                EditMultiProfileDialog.this.progressBar.setMaximum(tasks);
                if (EditMultiProfileDialog.this.dbversion.getSelectionIndex() != -1) {
                    int profileNumber = 0;
                    for (Profile prof : profs) {
                        StringBuffer messageLog = new StringBuffer();
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        PrintStream ps = new PrintStream(bos);
                        EditMultiProfileDialog.this.profileLabel.setText(Settings.getInstance().msg("dialog.multiprofile.updating", new Object[]{prof.getTitle()}));
                        EditMultiProfileDialog.this.profileLabel.pack();
                        try {
                            int dbversionIndex = DosboxVersion.findById(EditMultiProfileDialog.this.dbversionsList, prof.getDbversionId());
                            DosboxVersion orgDbversion = (DosboxVersion)EditMultiProfileDialog.this.dbversionsList.get(dbversionIndex);
                            DosboxVersion newDbversion = (DosboxVersion)EditMultiProfileDialog.this.dbversionsList.get(EditMultiProfileDialog.this.dbversion.getSelectionIndex());
                            if (orgDbversion.getId() != newDbversion.getId()) {
                                CompositeConfiguration compConf = new CompositeConfiguration(orgDbversion, prof, true, null, ps);
                                if (compConf.getCompositeConf().isIncomplete()) {
                                    if (bos.size() > 0) {
                                        messageLog.append(prof.getTitle()).append(": ").append(bos.toString());
                                    }
                                    messageLog.append(prof.getTitle()).append(": ").append(EditMultiProfileDialog.this.settings.msg("dialog.multiprofile.error.profileincomplete"));
                                } else if ((compConf = new CompositeConfiguration(compConf, newDbversion, true, false, null, ps)).getCompositeConf() == null) {
                                    if (bos.size() > 0) {
                                        messageLog.append(prof.getTitle()).append(": ").append(bos.toString());
                                    }
                                    messageLog.append(prof.getTitle()).append(": ").append(EditMultiProfileDialog.this.settings.msg("dialog.template.notice.noloadnochanges"));
                                } else {
                                    compConf.save(prof, null, ps);
                                    EditMultiProfileDialog.this.dbase.updateProfileDosboxversion(newDbversion, prof.getId());
                                    if (bos.size() > 0) {
                                        messageLog.append(prof.getTitle()).append(": ").append(bos.toString());
                                    }
                                }
                            }
                        }
                        catch (SQLException se) {
                            messageLog.append(se.getMessage());
                        }
                        if (messageLog.length() > 0) {
                            EditMultiProfileDialog.this.logText.append(messageLog.append('\n').toString());
                        }
                        EditMultiProfileDialog.this.progressBar.setSelection(++profileNumber);
                    }
                }
                if (EditMultiProfileDialog.this.consultMobyGames.getSelection()) {
                    for (int i = 0; i < 4; ++i) {
                        try {
                            ((EditMultiProfileDialog)EditMultiProfileDialog.this).mbt[i] = new MobyGamesThread(Collections.synchronizedList(profs), EditMultiProfileDialog.this.logText, EditMultiProfileDialog.this.progressBar, EditMultiProfileDialog.this.profileLabel);
                            EditMultiProfileDialog.this.mbt[i].start();
                            continue;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                } else {
                    EditMultiProfileDialog.access$402(EditMultiProfileDialog.this, null);
                }
            }
        });
    }

    @Override
    protected void createInfoTab(TabFolder tabFolder) {
    }

    @Override
    protected void createCustomTab(TabFolder tabFolder) {
    }

    @Override
    protected void createGeneralTab(TabFolder tabFolder) {
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText(this.settings.msg("dialog.template.tab.general"));
        Composite composite_1 = new Composite(tabFolder, 0);
        GridLayout gridLayout_1 = new GridLayout();
        composite_1.setLayout(gridLayout_1);
        generalTabItem.setControl(composite_1);
        this.associationGroup = new Group(composite_1, 0);
        this.associationGroup.setText(this.settings.msg("dialog.template.association"));
        this.associationGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        this.associationGroup.setLayout(gridLayout_4);
        Label dbversionLabel = new Label(this.associationGroup, 0);
        dbversionLabel.setText(this.settings.msg("dialog.template.dosboxversion"));
        this.dbversion = new Combo(this.associationGroup, 8);
        this.dbversion.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.dbversion.setVisibleItemCount(20);
        this.dbversion.select(0);
        Group mobygamesGroup = new Group(composite_1, 0);
        mobygamesGroup.setText(this.settings.msg("dialog.template.tab.info"));
        mobygamesGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 4;
        mobygamesGroup.setLayout(gridLayout_5);
        Label waitOnErrorLabel = new Label(mobygamesGroup, 0);
        waitOnErrorLabel.setText(this.settings.msg("dialog.profile.consultmobygames"));
        this.consultMobyGames = new Button(mobygamesGroup, 32);
        Group progressGroup = new Group(composite_1, 0);
        progressGroup.setLayoutData(new GridData(4, 4, true, true));
        progressGroup.setText(this.settings.msg("dialog.dfendimport.progress"));
        progressGroup.setLayout(new GridLayout());
        this.progressBar = new ProgressBar(progressGroup, 0);
        this.progressBar.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.profileLabel = new Label(progressGroup, 0);
        this.logText = new Text(progressGroup, 2826);
        this.logText.setLayoutData(new GridData(4, 4, true, true));
    }

    @Override
    protected void createDisplayTab(TabFolder tabFolder) {
    }

    @Override
    protected void createMachineTab(TabFolder tabFolder) {
    }

    @Override
    protected void createAudioTab(TabFolder tabFolder) {
    }

    @Override
    protected void createIOTab(TabFolder tabFolder) {
    }

    @Override
    protected void createMountingTab(TabFolder tabFolder) {
    }

    static /* synthetic */ Thread[] access$402(EditMultiProfileDialog x0, Thread[] x1) {
        x0.mbt = x1;
        return x1;
    }
}

