/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import org.dbgl.db.Database;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.Settings;
import org.dbgl.model.conf.Configuration;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public final class DFendImportThread
extends Thread {
    public static final String[] CUST_STRINGS = new String[]{"", "", "", "", "", "", "", ""};
    public static final int[] CUST_INTS = new int[]{0, 0};
    public static final int[] CUST_IDS = new int[]{0, 0, 0, 0};
    private static final String[] LINKS = new String[]{"", "", "", ""};
    private final DosboxVersion defaultDBVersion;
    private final Configuration standardProfile;
    private final Configuration profiles;
    private final Text log;
    private final ProgressBar progressBar;
    private final Label profileLabel;
    private final boolean performCleanup;
    private final Display display;
    private String title;
    private int profileNumber;

    public DFendImportThread(File dfendProfilesFile, boolean performCleanup, DosboxVersion defaultDBVersion, Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
        this.performCleanup = performCleanup;
        this.defaultDBVersion = defaultDBVersion;
        this.standardProfile = new Configuration(defaultDBVersion.getCanonicalConfFile(), true);
        this.log = log;
        this.progressBar = progressBar;
        this.profileLabel = profileLabel;
        this.display = log.getShell().getDisplay();
        this.profiles = new Configuration(dfendProfilesFile, false);
        this.progressBar.setMaximum(this.profiles.getSectionKeys().size());
        this.profileNumber = 0;
    }

    public void run() {
        Database dbase = Database.getInstance();
        final StringBuffer displayedLog = new StringBuffer();
        final StringBuffer messageLog = new StringBuffer();
        try {
            Iterator<String> i$ = this.profiles.getSectionKeys().iterator();
            while (i$.hasNext()) {
                String titleLoop;
                this.title = titleLoop = i$.next();
                String profFile = this.profiles.getValue(this.title, "prof");
                String confFile = this.profiles.getValue(this.title, "conf");
                boolean favorite = this.profiles.getValue(this.title, "fav").equals("1");
                try {
                    Configuration dfendExtra = new Configuration(new File(profFile), false);
                    String setup = dfendExtra.getValue("Extra", "Setup");
                    String setupParams = dfendExtra.getValue("Extra", "SetupParameters");
                    String notes = dfendExtra.getValue("ExtraInfo", "Notes");
                    String dev = dfendExtra.getValue("ExtraInfo", "Developer");
                    String pub = dfendExtra.getValue("ExtraInfo", "Publisher");
                    String gen = dfendExtra.getValue("ExtraInfo", "Genre");
                    String year = dfendExtra.getValue("ExtraInfo", "Year");
                    String status = Settings.getInstance().msg("dialog.dfendimport.defaultprofilestatus");
                    String cap = dfendExtra.getValue("dosbox", "captures");
                    int devId = KeyValuePair.findIdByValue(dbase.readDevelopersList(), dev);
                    int publId = KeyValuePair.findIdByValue(dbase.readPublishersList(), pub);
                    int genId = KeyValuePair.findIdByValue(dbase.readGenresList(), gen);
                    int yrId = KeyValuePair.findIdByValue(dbase.readYearsList(), year);
                    int statId = KeyValuePair.findIdByValue(dbase.readStatusList(), status);
                    try {
                        int profileId = dbase.addOrEditProfile(this.title, dev, pub, gen, year, status, setup, setupParams, notes, favorite, devId, publId, genId, yrId, statId, this.defaultDBVersion.getId(), LINKS, CUST_STRINGS, CUST_INTS, CUST_IDS, LINKS, -1);
                        Configuration dfendProfile = new Configuration(new File(confFile), true);
                        String dstCap = FileUtils.constructCapturesDir(profileId);
                        String dstCapRelative = FileUtils.constructRelativeCapturesDir(profileId);
                        File dstCapAbsolute = FileUtils.canonicalToData(dstCap);
                        FileUtils.createDir(dstCapAbsolute);
                        FileUtils.copyFiles(new File(cap), dstCapAbsolute);
                        dfendProfile.setValue("dosbox", "captures", dstCapRelative);
                        if (this.performCleanup) {
                            dfendProfile.removeSection("directserial");
                            dfendProfile.removeSection("modem");
                            dfendProfile.removeSection("ipx");
                            dfendProfile.removeSection("sdl");
                        }
                        this.standardProfile.update(dfendProfile);
                        if (this.defaultDBVersion.isMultiConfig()) {
                            dfendProfile.substract(this.standardProfile);
                        }
                        String newConfFile = FileUtils.constructUniqueConfigFileString(profileId, this.title, dfendProfile);
                        dfendProfile.saveToFile(FileUtils.canonicalToData(newConfFile), false, null);
                        dbase.updateProfileConf(newConfFile, dstCap, profileId);
                        messageLog.append(dfendExtra.getParsingProblems());
                        messageLog.append(dfendProfile.getParsingProblems());
                    }
                    catch (SQLException se) {
                        messageLog.append(se.getMessage()).append('\n');
                    }
                }
                catch (IOException e) {
                    messageLog.append(e.getMessage()).append('\n');
                }
                if (!(this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed())) {
                    this.display.asyncExec(new Runnable(){

                        public void run() {
                            DFendImportThread.this.profileLabel.setText(Settings.getInstance().msg("dialog.dfendimport.importing", new Object[]{DFendImportThread.this.title}));
                            DFendImportThread.this.profileLabel.pack();
                            if (messageLog.length() > displayedLog.length()) {
                                String newOutput = messageLog.substring(displayedLog.length());
                                DFendImportThread.this.log.append(newOutput);
                                displayedLog.append(newOutput);
                            }
                            DFendImportThread.this.progressBar.setSelection(DFendImportThread.this.profileNumber++);
                        }
                    });
                    continue;
                }
                break;
            }
        }
        catch (SQLException se) {
            messageLog.append(se.getMessage());
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (messageLog.length() > displayedLog.length()) {
                        String newOutput = messageLog.substring(displayedLog.length());
                        DFendImportThread.this.log.append(newOutput);
                        displayedLog.append(newOutput);
                    }
                }
            });
        }
    }
}

