/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExportThread
extends Thread {
    private List<ExpProfile> profs;
    private Document xmlDoc;
    private boolean exportCaptures;
    private boolean exportGameData;
    private File target;
    private Text log;
    private ProgressBar progressBar;
    private Label status;
    private Display display;

    public ExportThread(List<ExpProfile> p, Document doc, boolean captures, boolean gamedata, File zipfile, Text log, ProgressBar progressBar, Label status) throws IOException {
        this.profs = p;
        this.xmlDoc = doc;
        this.exportCaptures = captures;
        this.exportGameData = gamedata;
        this.target = zipfile;
        this.log = log;
        this.progressBar = progressBar;
        this.progressBar.setMaximum(this.profs.size());
        this.status = status;
        this.display = log.getShell().getDisplay();
    }

    @Override
    public void run() {
        final Settings settings = Settings.getInstance();
        final StringBuffer messageLog = new StringBuffer();
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this.target));
            XmlUtils.domToZipOutputStream(this.xmlDoc, new File("profiles.xml"), zos);
            for (final ExpProfile prof : this.profs) {
                if (this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed()) break;
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        ExportThread.this.status.setText(settings.msg("dialog.export.exporting", new Object[]{prof.getTitle()}));
                        ExportThread.this.status.pack();
                    }
                });
                File relativeGameDir = prof.getGameDir();
                File relativeGameDirInZip = new File(FileUtils.DOSROOT_DIR, new File(String.valueOf(prof.getId()), relativeGameDir.getPath()).getPath());
                if (this.exportCaptures) {
                    File captures = new File(FileUtils.constructCapturesDir(prof.getId()));
                    try {
                        FileUtils.zipDir(prof.getCanonicalCaptures(), zos, captures);
                    }
                    catch (IOException e) {
                        messageLog.append(settings.msg("dialog.export.error.exportcaptures", new Object[]{prof.getTitle(), e.getMessage()})).append('\n');
                    }
                }
                if (this.exportGameData) {
                    try {
                        boolean uniqueGameFolder = true;
                        for (ExpProfile prof2 : this.profs) {
                            if (prof == prof2 || !prof.getGameDir().equals(prof2.getGameDir()) || prof.getId() <= prof2.getId()) continue;
                            uniqueGameFolder = false;
                        }
                        if (uniqueGameFolder) {
                            FileUtils.zipDir(FileUtils.canonicalToDosroot(relativeGameDir.getPath()), zos, relativeGameDirInZip);
                        }
                    }
                    catch (IOException e) {
                        messageLog.append(settings.msg("dialog.export.error.exportgamedata", new Object[]{prof.getTitle(), e.getMessage()})).append('\n');
                    }
                }
                if (this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed()) break;
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        ExportThread.this.log.setText(messageLog.toString());
                        ExportThread.this.progressBar.setSelection(ExportThread.this.progressBar.getSelection() + 1);
                    }
                });
            }
            zos.close();
        }
        catch (Exception e) {
            messageLog.append(e.getMessage() + '\n');
            this.display.asyncExec(new Runnable(){

                public void run() {
                    ExportThread.this.log.setText(messageLog.toString());
                }
            });
        }
    }
}

