/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dbgl.connect.Messaging;
import org.dbgl.db.Database;
import org.dbgl.gui.DFendImportDialog;
import org.dbgl.gui.EditDosboxVersionDialog;
import org.dbgl.gui.EditFilterDialog;
import org.dbgl.gui.EditMultiProfileDialog;
import org.dbgl.gui.EditProfileDialog;
import org.dbgl.gui.EditTemplateDialog;
import org.dbgl.gui.ExportDialog;
import org.dbgl.gui.ExportListDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.ImportDialog;
import org.dbgl.gui.MigrateDialog;
import org.dbgl.gui.SettingsDialog;
import org.dbgl.gui.Thumb;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Filter;
import org.dbgl.model.OrderingVector;
import org.dbgl.model.Profile;
import org.dbgl.model.Settings;
import org.dbgl.model.Template;
import org.dbgl.model.conf.CompositeConfiguration;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MainWindow {
    public static final String PROGRAM_VERSION = "0.69";
    public static final String PROGRAM_NAME_FULL = "DOSBox Game Launcher";
    public static final String PROGRAM_NAME = "DOSBox Game Launcher v0.69";
    public static final int RO_COLUMN_NAMES = 10;
    public static final int EDIT_COLUMN_NAMES = 10;
    public static String[] columnNames;
    private Display display;
    private Shell shell;
    private OrderingVector orderingVector = null;
    private String filterClause = null;
    private List<Profile> profilesList;
    private List<DosboxVersion> dbversionsList;
    private List<Template> templatesList;
    private List<Filter> filtersList;
    private Database dbase = null;
    private Settings settings = null;
    private File currentThumbFile = null;
    private int thumbHeight;
    private int[] columnIds;
    private Table profile_table;
    private Table dbversion_table;
    private Table template_table;
    private CTabFolder filterFolder;
    private ToolItem setupToolItem;
    private Text notesField;
    private Composite thumbsToolBar;
    private Menu menu_thumb;
    private Link[] link;
    private Menu runWithSubMenu;
    private Menu setupWithSubMenu;
    private Menu viewLinkSubMenu;
    private Listener paintListener;
    private Listener measureListener;

    public static void main(String[] args) {
        try {
            MainWindow window = new MainWindow();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        if (PlatformUtils.IS_OSX) {
            Display.setAppName("DBGL");
        }
        this.display = Display.getDefault();
        this.createContents();
        Messaging mess = null;
        if (this.settings.getBooleanValue("communication", "port_enabled")) {
            mess = new Messaging(this.settings.getIntValue("communication", "port"), this);
            mess.start();
        }
        this.shell.open();
        this.shell.layout();
        this.profile_table.setSelection(this.settings.getIntValue("gui", "selectedprofile"));
        this.displayProfileInformation();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        SWTImageManager.dispose();
        this.display.dispose();
        if (mess != null) {
            mess.close();
        }
        try {
            this.settings.save();
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        try {
            this.dbase.shutdown();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void createContents() {
        this.initColumnIds();
        this.orderingVector = new OrderingVector(this.settings.getIntValues("gui", "sortcolumn"), this.settings.getBooleanValues("gui", "sortascending"));
        this.measureListener = new Listener(){

            public void handleEvent(Event event) {
                event.height = Math.max(event.height, MainWindow.this.settings.getIntValue("gui", "screenshotscolumnheight"));
            }
        };
        this.paintListener = new Listener(){

            public void handleEvent(Event event) {
                File[] files;
                Table t = (Table)event.widget;
                Integer sc = (Integer)t.getData();
                if (sc != null && event.index == sc && (files = ((File)((TableItem)event.item).getData()).listFiles()) != null && files.length > 0) {
                    if (PlatformUtils.IS_LINUX) {
                        Arrays.sort(files, new Comparator<File>(){

                            @Override
                            public int compare(File f1, File f2) {
                                return f1.getName().compareTo(f2.getName());
                            }
                        });
                    }
                    if (FileUtils.isPicture(files[0].getName())) {
                        Image image = SWTImageManager.getResizedImage(MainWindow.this.display, MainWindow.this.settings.getIntValue("gui", "screenshotscolumnheight"), files[0].getPath(), null);
                        int columnWidth = t.getColumn(sc).getWidth();
                        int offset = Math.max(0, (columnWidth - image.getBounds().width - 2) / 2);
                        event.gc.drawImage(image, event.x + offset, event.y);
                    }
                }
            }
        };
        this.shell = new Shell();
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            this.templatesList = this.dbase.readTemplatesList();
            this.filtersList = this.dbase.readFiltersList();
            this.filtersList.add(0, new Filter(-1, this.settings.msg("dialog.main.allprofiles"), null));
            this.filterClause = this.filtersList.get(this.settings.getIntValue("gui", "filtertab")).getFilter();
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.shell.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                boolean isMaximized = MainWindow.this.shell.getMaximized();
                if (!isMaximized) {
                    Rectangle rec = MainWindow.this.shell.getBounds();
                    MainWindow.this.settings.setIntValue("gui", "width", rec.width);
                    MainWindow.this.settings.setIntValue("gui", "height", rec.height);
                    MainWindow.this.settings.setIntValue("gui", "x", rec.x);
                    MainWindow.this.settings.setIntValue("gui", "y", rec.y);
                }
                MainWindow.this.settings.setBooleanValue("gui", "maximized", isMaximized);
            }
        });
        this.shell.addControlListener(new ControlAdapter(){

            public void controlMoved(ControlEvent event) {
                if (!MainWindow.this.shell.getMaximized()) {
                    Rectangle rec = MainWindow.this.shell.getBounds();
                    MainWindow.this.settings.setIntValue("gui", "x", rec.x);
                    MainWindow.this.settings.setIntValue("gui", "y", rec.y);
                }
            }
        });
        this.shell.setLayout(new BorderLayout(0, 0));
        this.shell.setLocation(this.settings.getIntValue("gui", "x"), this.settings.getIntValue("gui", "y"));
        if (this.settings.getBooleanValue("gui", "maximized")) {
            this.shell.setMaximized(true);
        } else {
            this.shell.setSize(this.settings.getIntValue("gui", "width"), this.settings.getIntValue("gui", "height"));
        }
        this.shell.setText(this.settings.msg("main.title", new Object[]{PROGRAM_VERSION}));
        this.createFileMenu();
        final TabFolder tabFolder = new TabFolder(this.shell, 0);
        this.createProfilesTab(tabFolder);
        this.createDosboxVersionsTab(tabFolder);
        this.createTemplatesTab(tabFolder);
        this.shell.addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent arg0) {
            }

            public void shellDeiconified(ShellEvent arg0) {
            }

            public void shellDeactivated(ShellEvent arg0) {
            }

            public void shellClosed(ShellEvent arg0) {
            }

            public void shellActivated(ShellEvent arg0) {
                if (tabFolder.getSelectionIndex() == 0) {
                    MainWindow.this.profile_table.setFocus();
                    MainWindow.this.displayProfileInformation();
                }
            }
        });
        for (Profile prof : this.profilesList) {
            this.addProfileToTable(prof);
        }
        for (DosboxVersion dbversion : this.dbversionsList) {
            this.addDosboxVersionToTable(dbversion);
        }
        for (Template template : this.templatesList) {
            this.addTemplateToTable(template);
        }
        this.profile_table.setSortColumn(this.profile_table.getColumn(this.findColumnById(this.settings.getIntValues("gui", "sortcolumn")[0])));
        this.profile_table.setSortDirection(this.settings.getBooleanValues("gui", "sortascending")[0] ? 128 : 1024);
        this.profile_table.setColumnOrder(this.settings.getIntValues("gui", "columnorder"));
        this.profile_table.setFocus();
    }

    private void doReorderProfiles(int columnId, SelectionEvent event) {
        TableColumn sortColumn = this.profile_table.getSortColumn();
        TableColumn currentColumn = (TableColumn)event.widget;
        int dir = this.profile_table.getSortDirection();
        if (sortColumn.equals(currentColumn)) {
            dir = dir == 128 ? 1024 : 128;
        } else {
            this.profile_table.setSortColumn(currentColumn);
            dir = 128;
        }
        Set<Integer> selectedProfiles = this.getSelectedProfiles();
        try {
            this.orderingVector.addOrdering(this.columnIds[columnId], dir == 128);
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
        }
        catch (SQLException ex) {
            GeneralPurposeDialogs.warningMessage(this.shell, ex.getMessage());
        }
        for (int i = 0; i < this.profilesList.size(); ++i) {
            this.setTableItem(this.profile_table.getItem(i), this.profilesList.get(i));
        }
        this.profile_table.setSortDirection(dir);
        this.profile_table.setSelection(this.getIndicesByIds(selectedProfiles));
        this.settings.setIntValues("gui", "sortcolumn", this.orderingVector.getColumns());
        this.settings.setBooleanValues("gui", "sortascending", this.orderingVector.getAscendings());
    }

    private void displayLinks(String[] p_link, String[] p_linkTitle) {
        for (int i = 0; i < this.link.length; ++i) {
            if (p_link[i] == null || "".equals(p_link[i])) {
                this.link[i].setText("");
                this.link[i].setToolTipText(null);
                ((GridData)this.link[i].getLayoutData()).exclude = true;
                this.link[i].pack();
                continue;
            }
            String url = p_link[i];
            String tag = p_link[i];
            if (url.indexOf("://") == -1) {
                url = "file://" + FileUtils.canonicalToData(url).getPath();
                tag = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToData(tag)).getPath();
            }
            if (p_linkTitle[i] != null && !"".equals(p_linkTitle[i])) {
                tag = p_linkTitle[i];
            }
            StringBuffer text = new StringBuffer("<a href=\"").append(url).append("\">").append(tag).append("</a>");
            this.link[i].setText(text.toString());
            this.link[i].setToolTipText(url);
            ((GridData)this.link[i].getLayoutData()).exclude = false;
        }
        this.link[0].getParent().layout();
        this.link[0].getParent().getParent().layout();
    }

    private void displayScreenshots(Profile prof) {
        File path;
        File[] files;
        for (Control c : this.thumbsToolBar.getChildren()) {
            c.setMenu(null);
            c.dispose();
        }
        this.thumbsToolBar.pack();
        if (prof != null && (files = (path = prof.getCanonicalCaptures()).listFiles()) != null) {
            if (PlatformUtils.IS_LINUX) {
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return f1.getName().compareTo(f2.getName());
                    }
                });
            }
            for (File file : files) {
                String label = file.getName().toLowerCase();
                if (!FileUtils.isPicture(label)) continue;
                label = this.settings.getBooleanValue("gui", "screenshotsfilename") ? ' ' + label.substring(0, label.lastIndexOf(46)) + ' ' : null;
                final Button buttonItem = new Button(this.thumbsToolBar, 0x800000);
                buttonItem.setToolTipText(file.getPath());
                buttonItem.setImage(SWTImageManager.getResizedImage(this.display, this.thumbHeight, file.getPath(), label));
                buttonItem.pack();
                buttonItem.addSelectionListener(new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Thumb thumbDialog = new Thumb(MainWindow.this.shell);
                        thumbDialog.setThumb(buttonItem.getToolTipText());
                        thumbDialog.open();
                    }
                });
                buttonItem.addMouseListener(new MouseAdapter(){

                    public void mouseDown(MouseEvent arg0) {
                        MainWindow.this.currentThumbFile = new File(buttonItem.getToolTipText());
                    }
                });
                buttonItem.setMenu(this.menu_thumb);
            }
        }
        this.thumbsToolBar.setVisible(this.thumbsToolBar.getChildren().length != 0);
        this.thumbsToolBar.pack();
    }

    private void doAddProfile() {
        this.doAddProfile(null);
    }

    private void doAddProfile(String filename) {
        if (this.checkDefaultDBVersion() == null) {
            return;
        }
        if (filename == null || FileUtils.isBooterImage(filename) || FileUtils.isExecutable(filename) || FileUtils.isConfFile(filename)) {
            EditProfileDialog addProfileDialog = new EditProfileDialog(this.shell);
            if (filename != null) {
                addProfileDialog.sendToProfile(filename);
            }
            this.updateWithAddedProfile((Profile)addProfileDialog.open());
        } else if (FileUtils.isArchive(filename)) {
            ImportDialog importDialog = new ImportDialog(this.shell, this.dbversionsList, new File(filename));
            Boolean updateCustomFields = (Boolean)importDialog.open();
            if (updateCustomFields != null) {
                if (updateCustomFields.booleanValue()) {
                    this.rebuildProfilesTable();
                } else {
                    this.updateProfilesList(this.getSelectedProfiles());
                }
                this.displayProfileInformation();
            }
        } else {
            GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("general.error.cannotimportunknownfile"));
        }
    }

    public void addProfile(final String file) {
        this.display.syncExec(new Runnable(){

            public void run() {
                MainWindow.this.doAddProfile(file);
            }
        });
    }

    private void doAddDosboxVersion() {
        EditDosboxVersionDialog addVersionDialog = new EditDosboxVersionDialog(this.shell);
        DosboxVersion dbversion = (DosboxVersion)addVersionDialog.open();
        if (dbversion != null) {
            this.updateDosboxVersionList(dbversion);
        }
    }

    private void doAddTemplate() {
        if (this.checkDefaultDBVersion() == null) {
            return;
        }
        EditTemplateDialog addTemplateDialog = new EditTemplateDialog(this.shell);
        Template template = (Template)addTemplateDialog.open();
        if (template != null) {
            this.updateTemplateList(template);
        }
    }

    private void doAddFilter() {
        EditFilterDialog addFilterDialog = new EditFilterDialog(this.shell);
        Filter filter = (Filter)addFilterDialog.open();
        if (filter != null) {
            this.filtersList.add(filter);
            this.addFilterTab(filter);
            this.filterFolder.setSelection(this.filterFolder.getItemCount() - 1);
            this.updateProfilesAfterTabAction();
        }
    }

    private void doToggleFavoriteProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile profile = this.profilesList.get(index);
            try {
                this.dbase.toggleFavorite(profile.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
            profile.toggleDefault();
            this.profilesList.set(index, profile);
            this.setTableItem(this.profile_table.getItem(index), profile);
        }
    }

    private void doToggleDefaultVersion() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1) {
            DosboxVersion ver = this.dbversionsList.get(index);
            ver.toggleDefault();
            try {
                this.dbase.addOrEditDosboxVersion(ver.getTitle(), ver.getPath(), ver.isMultiConfig(), ver.isUsingCurses(), ver.isDefault(), ver.getParameters(), ver.getVersion(), ver.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
            this.updateDosboxVersionList(ver);
        }
    }

    private void doToggleDefaultTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            Template temp = this.templatesList.get(index);
            temp.toggleDefault();
            try {
                this.dbase.addOrEditTemplate(temp.getTitle(), temp.getDbversionId(), temp.isDefault(), temp.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
            this.updateTemplateList(temp);
        }
    }

    private void doEditProfile() {
        this.doEditProfile(false);
    }

    private void doEditProfile(boolean focusTitle) {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            if (this.profile_table.getSelectionCount() > 1) {
                EditMultiProfileDialog editMultiProfileDialog = new EditMultiProfileDialog(this.shell);
                ArrayList<Profile> profs = new ArrayList<Profile>();
                for (int i : this.profile_table.getSelectionIndices()) {
                    profs.add(this.profilesList.get(i));
                }
                editMultiProfileDialog.setProfiles(profs);
                if (editMultiProfileDialog.open() != null) {
                    this.updateProfilesList(this.getSelectedProfiles());
                    this.displayProfileInformation();
                }
            } else {
                Profile profile;
                EditProfileDialog editProfileDialog = new EditProfileDialog(this.shell);
                editProfileDialog.setProfile(this.profilesList.get(index));
                if (focusTitle) {
                    editProfileDialog.focusTitle();
                }
                if ((profile = (Profile)editProfileDialog.open()) != null) {
                    boolean quickUpdate = true;
                    if (this.settings.getBooleanValue("gui", "autosortonupdate") || this.filterFolder.getSelectionIndex() > 0) {
                        try {
                            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
                            if (index != Profile.findById(this.profilesList, profile.getId())) {
                                quickUpdate = false;
                            }
                        }
                        catch (SQLException e) {
                            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
                        }
                    }
                    if (quickUpdate) {
                        this.profilesList.set(index, profile);
                        this.setTableItem(this.profile_table.getItem(index), profile);
                    } else {
                        this.updateProfilesList(new HashSet<Integer>(Arrays.asList(profile.getId())));
                    }
                    this.displayProfileInformation();
                }
            }
        }
    }

    private void doDuplicateProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile orgProf = this.profilesList.get(index);
            this.updateWithAddedProfile(EditProfileDialog.duplicateProfile(orgProf, this.dbversionsList, this.dbase, this.shell));
        }
    }

    private void updateWithAddedProfile(Profile profile) {
        if (profile != null) {
            if (this.settings.getBooleanValue("gui", "autosortonupdate") || this.filterFolder.getSelectionIndex() > 0) {
                this.updateProfilesList(new HashSet<Integer>(Arrays.asList(profile.getId())));
            } else {
                this.profilesList.add(profile);
                this.addProfileToTable(profile);
                this.profile_table.setSelection(this.profile_table.getItemCount() - 1);
                this.profile_table.setFocus();
            }
            this.displayProfileInformation();
        }
    }

    private void doEditDosboxVersion() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1) {
            EditDosboxVersionDialog editVersionDialog = new EditDosboxVersionDialog(this.shell);
            editVersionDialog.setDosboxVersion(this.dbversionsList.get(index));
            DosboxVersion dbversion = (DosboxVersion)editVersionDialog.open();
            if (dbversion != null) {
                this.updateDosboxVersionList(dbversion);
            }
        }
    }

    private void doEditFilter() {
        int index = this.filterFolder.getSelectionIndex();
        if (index > 0) {
            EditFilterDialog editFilterDialog = new EditFilterDialog(this.shell);
            editFilterDialog.setFilter(this.filtersList.get(index));
            Filter filter = (Filter)editFilterDialog.open();
            if (filter != null) {
                this.filtersList.set(index, filter);
                this.filterFolder.getSelection().setText("    " + filter.getTitle() + "    ");
                this.updateProfilesAfterTabAction();
            }
        }
    }

    private void updateProfilesList(Set<Integer> profileIds) {
        try {
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.profile_table.setRedraw(false);
        this.profile_table.removeAll();
        for (Profile prof : this.profilesList) {
            this.addProfileToTable(prof);
        }
        this.profile_table.setSelection(this.getIndicesByIds(profileIds));
        this.profile_table.setRedraw(true);
        this.profile_table.setFocus();
    }

    private void updateDosboxVersionList(DosboxVersion dbversion) {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.dbversion_table.removeAll();
        for (DosboxVersion version : this.dbversionsList) {
            this.addDosboxVersionToTable(version);
        }
        this.dbversion_table.setSelection(DosboxVersion.findById(this.dbversionsList, dbversion.getId()));
        this.dbversion_table.setFocus();
        this.updateProfileDbversionsSubmenu();
        this.updateSetupDbversionsSubmenu();
    }

    private void updateTemplateList(Template template) {
        try {
            this.templatesList = this.dbase.readTemplatesList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.template_table.removeAll();
        for (Template temp : this.templatesList) {
            this.addTemplateToTable(temp);
        }
        this.template_table.setSelection(Template.findById(this.templatesList, template.getId()));
        this.template_table.setFocus();
    }

    private void doEditTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            EditTemplateDialog editTemplDialog = new EditTemplateDialog(this.shell);
            editTemplDialog.setTemplate(this.templatesList.get(index));
            Template template = (Template)editTemplDialog.open();
            if (template != null) {
                this.updateTemplateList(template);
            }
        }
    }

    private void doRemoveProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removeprofile"))) {
            Profile prof = this.profilesList.get(index);
            try {
                this.dbase.removeProfile(prof.getId());
                this.profile_table.remove(index);
                this.profilesList.remove(index);
                this.displayProfileInformation();
                SWTImageManager.dispose();
                if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removeprofileconf", new Object[]{prof.getConfPathAndFile()}))) {
                    FileUtils.removeFile(prof.getCanonicalConfFile());
                }
                if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removeprofilecaptures", new Object[]{prof.getCaptures()}))) {
                    FileUtils.removeFilesInDirAndDir(prof.getCanonicalCaptures());
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void doRemoveDosboxVersion() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removedosboxversion"))) {
            try {
                this.dbase.removeDosboxVersion(this.dbversionsList.get(index).getId());
                this.dbversion_table.remove(index);
                this.dbversionsList.remove(index);
                this.updateProfileDbversionsSubmenu();
                this.updateSetupDbversionsSubmenu();
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void doRemoveTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removetemplate"))) {
            int templateId = this.templatesList.get(index).getId();
            try {
                this.dbase.removeTemplate(templateId);
                this.template_table.remove(index);
                this.templatesList.remove(index);
                File conffile = FileUtils.constructCanonicalTemplateFileLocation(templateId);
                if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removetemplateconf", new Object[]{conffile}))) {
                    FileUtils.removeFile(conffile);
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void addProfileToTable(Profile prof) {
        TableItem newItemTableItem = new TableItem(this.profile_table, 2048);
        this.setTableItem(newItemTableItem, prof);
    }

    private void addDosboxVersionToTable(DosboxVersion dbversion) {
        TableItem newItemTableItem = new TableItem(this.dbversion_table, 2048);
        this.setTableItem(newItemTableItem, dbversion);
    }

    private void addTemplateToTable(Template template) {
        TableItem newItemTableItem = new TableItem(this.template_table, 2048);
        this.setTableItem(newItemTableItem, template);
    }

    private void setTableItem(TableItem newItemTableItem, Profile prof) {
        for (int i = 0; i < this.columnIds.length; ++i) {
            String value;
            switch (this.columnIds[i]) {
                case 0: {
                    value = prof.getTitle();
                    break;
                }
                case 1: {
                    value = prof.hasSetupString();
                    break;
                }
                case 2: {
                    value = prof.getDeveloperName();
                    break;
                }
                case 3: {
                    value = prof.getPublisherName();
                    break;
                }
                case 4: {
                    value = prof.getGenre();
                    break;
                }
                case 5: {
                    value = prof.getYear();
                    break;
                }
                case 6: {
                    value = prof.getStatus();
                    break;
                }
                case 7: {
                    value = prof.isDefaultString();
                    break;
                }
                case 8: {
                    value = String.valueOf(prof.getId());
                    break;
                }
                case 9: {
                    value = String.valueOf(prof.getDbversionId());
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    value = prof.getCustomString(this.columnIds[i] - 10);
                    break;
                }
                case 18: {
                    value = prof.getCustomInt(0) + " %";
                    break;
                }
                case 19: {
                    value = String.valueOf(prof.getCustomInt(1));
                    break;
                }
                case 21: {
                    value = this.dbversionsList.get(DosboxVersion.findById(this.dbversionsList, prof.getDbversionId())).getTitle();
                    break;
                }
                default: {
                    value = "";
                }
            }
            if (this.columnIds[i] == 20) {
                newItemTableItem.setData(prof.getCanonicalCaptures());
                continue;
            }
            newItemTableItem.setText(i, value);
        }
    }

    private void setTableItem(TableItem newItemTableItem, DosboxVersion dbversion) {
        newItemTableItem.setText(0, dbversion.getTitle());
        newItemTableItem.setText(1, dbversion.getVersion());
        newItemTableItem.setText(2, dbversion.getPath());
        newItemTableItem.setText(3, dbversion.isDefaultString());
        newItemTableItem.setText(4, String.valueOf(dbversion.getId()));
    }

    private void setTableItem(TableItem newItemTableItem, Template template) {
        newItemTableItem.setText(0, template.getTitle());
        newItemTableItem.setText(1, template.isDefaultString());
    }

    private void doRunProfile(boolean setup) {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile prof = this.profilesList.get(index);
            if (!setup || prof.hasSetup()) {
                try {
                    FileUtils.doRunProfile(prof, this.dbversionsList, MainWindow.getEnv(this.settings), setup);
                }
                catch (IOException e) {
                    GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
                }
            }
        }
    }

    private void doRunDosbox() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1) {
            try {
                FileUtils.doRunDosbox(this.dbversionsList.get(index), MainWindow.getEnv(this.settings));
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void doRunTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            Template template = this.templatesList.get(index);
            try {
                FileUtils.doRunTemplate(template, this.dbversionsList, MainWindow.getEnv(this.settings));
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private DosboxVersion checkDefaultDBVersion() {
        int defaultVersionIdx = DosboxVersion.findDefault(this.dbversionsList);
        if (defaultVersionIdx == -1) {
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.required.defaultdosboxversion"));
            return null;
        }
        return this.dbversionsList.get(defaultVersionIdx);
    }

    private void doDFendImport() {
        DosboxVersion defaultDbversion = this.checkDefaultDBVersion();
        if (defaultDbversion == null) {
            return;
        }
        if (this.settings.getIntValue("profiledefaults", "confpath") == 1) {
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.notice.dfendimportconflocation", new Object[]{SettingsDialog.confLocations[0]}));
        }
        DFendImportDialog importDialog = new DFendImportDialog(this.shell);
        importDialog.setDefaultDosboxVersion(defaultDbversion);
        if (importDialog.open() != null) {
            try {
                this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
                this.profile_table.removeAll();
                for (Profile prof : this.profilesList) {
                    this.addProfileToTable(prof);
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void doMigrate() {
        GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.notice.premigration"));
        String from = (String)new MigrateDialog(this.shell).open();
        if (from != null) {
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.notice.postmigration", new Object[]{from, FileUtils.getDosRoot()}));
        }
    }

    private void displayProfileInformation() {
        int index = this.profile_table.getSelectionIndex();
        if (index == -1) {
            this.displayScreenshots(null);
            this.notesField.setText("");
            this.displayLinks(new String[]{null, null, null, null}, new String[]{null, null, null, null});
            this.updateViewLinkSubmenu(null);
        } else {
            this.settings.setIntValue("gui", "selectedprofile", index);
            Profile prof = this.profilesList.get(index);
            this.displayScreenshots(prof);
            this.notesField.setText(prof.getNotes());
            this.displayLinks(prof.getLinks(), prof.getLinkTitles());
            this.updateViewLinkSubmenu(prof);
            this.setupToolItem.setEnabled(this.profilesList.get(this.profile_table.getSelectionIndex()).hasSetup());
        }
    }

    private void doRemoveThumb() {
        if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removethumb", new Object[]{this.currentThumbFile}))) {
            FileUtils.removeFile(this.currentThumbFile);
            this.displayProfileInformation();
        }
        this.currentThumbFile = null;
    }

    private void doCreateShortcut() {
        int[] selectedProfiles = this.profile_table.getSelectionIndices();
        for (int i = 0; i < selectedProfiles.length; ++i) {
            try {
                PlatformUtils.createShortcut(this.profilesList.get(selectedProfiles[i]), this.dbversionsList);
                continue;
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void addProfileColumn(String title, final int colIndex) {
        final String width = "column" + (this.columnIds[colIndex] + 1) + "width";
        final TableColumn column = new TableColumn(this.profile_table, 0);
        column.setWidth(this.settings.getIntValue("gui", width));
        column.setMoveable(true);
        column.setText(title);
        if (this.columnIds[colIndex] == 8 || this.columnIds[colIndex] == 9 || this.columnIds[colIndex] == 18 || this.columnIds[colIndex] == 19) {
            column.setAlignment(131072);
        }
        if (this.columnIds[colIndex] == 20) {
            column.setAlignment(0x1000000);
            this.profile_table.setData(new Integer(colIndex));
            this.profile_table.addListener(41, this.measureListener);
            this.profile_table.addListener(42, this.paintListener);
        }
        column.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doReorderProfiles(colIndex, event);
            }
        });
        column.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings.setIntValue("gui", width, column.getWidth());
            }

            public void controlMoved(ControlEvent event) {
                if (event.time != 0) {
                    MainWindow.this.settings.setIntValues("gui", "columnorder", MainWindow.this.profile_table.getColumnOrder());
                }
            }
        });
    }

    private void addDBColumn(String title, int colIndex) {
        final String width = "column2_" + (colIndex + 1) + "width";
        final TableColumn column = new TableColumn(this.dbversion_table, 0);
        column.setWidth(this.settings.getIntValue("gui", width));
        column.setText(title);
        column.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings.setIntValue("gui", width, column.getWidth());
            }
        });
    }

    private void addTemplateColumn(String title, int colIndex) {
        final String width = "column3_" + (colIndex + 1) + "width";
        final TableColumn column = new TableColumn(this.template_table, 0);
        column.setWidth(this.settings.getIntValue("gui", width));
        column.setText(title);
        column.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings.setIntValue("gui", width, column.getWidth());
            }
        });
    }

    private void doOpenSettingsDialog() {
        SettingsDialog sDialog = new SettingsDialog(this.shell);
        if (((Boolean)sDialog.open()).booleanValue()) {
            this.rebuildProfilesTable();
        }
    }

    private void rebuildProfilesTable() {
        int i;
        Set<Integer> selectedProfiles = this.getSelectedProfiles();
        int nrColumns = this.profile_table.getColumnCount();
        String order = this.settings.getValue("gui", "columnorder");
        this.profile_table.removeAll();
        StringBuffer cols = new StringBuffer();
        for (i = 0; i < nrColumns; ++i) {
            cols.append(i).append(' ');
        }
        this.profile_table.setColumnOrder(StringUtils.stringToIntArray(cols.toString()));
        for (i = nrColumns - 1; i >= 0; --i) {
            this.profile_table.getColumn(i).dispose();
        }
        this.profile_table.setData(null);
        this.profile_table.removeListener(41, this.measureListener);
        this.profile_table.removeListener(42, this.paintListener);
        this.initColumnIds();
        for (i = 0; i < this.columnIds.length; ++i) {
            this.addProfileColumn(columnNames[this.columnIds[i]], i);
        }
        this.profile_table.setSortColumn(this.profile_table.getColumn(this.findColumnById(this.settings.getIntValues("gui", "sortcolumn")[0])));
        this.profile_table.setSortDirection(this.settings.getBooleanValues("gui", "sortascending")[0] ? 128 : 1024);
        this.settings.setValue("gui", "columnorder", order);
        this.orderingVector = new OrderingVector(this.settings.getIntValues("gui", "sortcolumn"), this.settings.getBooleanValues("gui", "sortascending"));
        this.updateProfilesList(selectedProfiles);
    }

    private void doImportConfigfile() {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterNames(new String[]{this.settings.msg("filetype.conf"), this.settings.msg("filetype.exe") + ", " + this.settings.msg("filetype.booterimage"), "*"});
        dialog.setFilterExtensions(new String[]{"*.conf;*.CONF", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"});
        String result = dialog.open();
        if (result != null) {
            this.doAddProfile(result);
        }
    }

    private void initColumnIds() {
        columnNames = new String[22];
        MainWindow.columnNames[0] = this.settings.msg("dialog.main.profiles.column.title");
        MainWindow.columnNames[1] = this.settings.msg("dialog.main.profiles.column.setup");
        MainWindow.columnNames[2] = this.settings.msg("dialog.main.profiles.column.developer");
        MainWindow.columnNames[3] = this.settings.msg("dialog.main.profiles.column.publisher");
        MainWindow.columnNames[4] = this.settings.msg("dialog.main.profiles.column.genre");
        MainWindow.columnNames[5] = this.settings.msg("dialog.main.profiles.column.year");
        MainWindow.columnNames[6] = this.settings.msg("dialog.main.profiles.column.status");
        MainWindow.columnNames[7] = this.settings.msg("dialog.main.profiles.column.favorite");
        MainWindow.columnNames[8] = this.settings.msg("dialog.main.profiles.column.id");
        MainWindow.columnNames[9] = this.settings.msg("dialog.main.profiles.column.dosboxversionid");
        for (int i = 0; i < 10; ++i) {
            MainWindow.columnNames[i + 10] = this.settings.getValue("gui", "custom" + (i + 1));
        }
        MainWindow.columnNames[20] = this.settings.msg("dialog.main.profiles.column.screenshot");
        MainWindow.columnNames[21] = this.settings.msg("dialog.main.profiles.column.dosboxversiontitle");
        int amount = 0;
        for (int i = 0; i < columnNames.length; ++i) {
            if (!this.settings.getBooleanValue("gui", "column" + (i + 1) + "visible")) continue;
            ++amount;
        }
        int cNr = 0;
        this.columnIds = new int[amount];
        for (int i = 0; i < columnNames.length; ++i) {
            if (!this.settings.getBooleanValue("gui", "column" + (i + 1) + "visible")) continue;
            this.columnIds[cNr++] = i;
        }
    }

    private int findColumnById(int id) {
        for (int i = 0; i < this.columnIds.length; ++i) {
            if (this.columnIds[i] != id) continue;
            return i;
        }
        return -1;
    }

    private void updateProfileDbversionsSubmenu() {
        MenuItem parent = this.runWithSubMenu.getParentItem();
        this.runWithSubMenu.dispose();
        this.runWithSubMenu = new Menu(parent);
        parent.setMenu(this.runWithSubMenu);
        for (int i = 0; i < this.dbversionsList.size(); ++i) {
            final MenuItem runWithMenuItem = new MenuItem(this.runWithSubMenu, 0);
            runWithMenuItem.setText(this.dbversionsList.get(i).getTitle());
            runWithMenuItem.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int index = MainWindow.this.profile_table.getSelectionIndex();
                    if (index != -1) {
                        Profile prof = (Profile)MainWindow.this.profilesList.get(index);
                        DosboxVersion dbversion = (DosboxVersion)MainWindow.this.dbversionsList.get(MainWindow.this.runWithSubMenu.indexOf(runWithMenuItem));
                        try {
                            FileUtils.doRunProfile(prof, dbversion, (Map<String, String>)MainWindow.getEnv(MainWindow.this.settings), false);
                        }
                        catch (IOException exc) {
                            GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, exc.getMessage());
                        }
                    }
                }
            });
        }
    }

    private void updateSetupDbversionsSubmenu() {
        MenuItem parent = this.setupWithSubMenu.getParentItem();
        this.setupWithSubMenu.dispose();
        this.setupWithSubMenu = new Menu(parent);
        parent.setMenu(this.setupWithSubMenu);
        for (int i = 0; i < this.dbversionsList.size(); ++i) {
            final MenuItem setupWithMenuItem = new MenuItem(this.setupWithSubMenu, 0);
            setupWithMenuItem.setText(this.dbversionsList.get(i).getTitle());
            setupWithMenuItem.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int index = MainWindow.this.profile_table.getSelectionIndex();
                    if (index != -1) {
                        Profile prof = (Profile)MainWindow.this.profilesList.get(index);
                        DosboxVersion dbversion = (DosboxVersion)MainWindow.this.dbversionsList.get(MainWindow.this.setupWithSubMenu.indexOf(setupWithMenuItem));
                        try {
                            FileUtils.doRunProfile(prof, dbversion, (Map<String, String>)MainWindow.getEnv(MainWindow.this.settings), true);
                        }
                        catch (IOException exc) {
                            GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, exc.getMessage());
                        }
                    }
                }
            });
        }
    }

    private void updateViewLinkSubmenu(final Profile prof) {
        MenuItem parent = this.viewLinkSubMenu.getParentItem();
        this.viewLinkSubMenu.dispose();
        this.viewLinkSubMenu = new Menu(parent);
        parent.setMenu(this.viewLinkSubMenu);
        if (prof != null) {
            for (int i = 0; i < prof.getLinks().length; ++i) {
                String title;
                String link = prof.getLink(i);
                if (link.length() <= 0) continue;
                final MenuItem linkMenuItem = new MenuItem(this.viewLinkSubMenu, 0);
                String url = link;
                String tag = link;
                if (url.indexOf("://") == -1) {
                    url = "file://" + FileUtils.canonicalToData(url).getPath();
                    tag = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToData(tag)).getPath();
                }
                if ((title = prof.getLinkTitle(i)) != null && !"".equals(title)) {
                    tag = title;
                }
                linkMenuItem.setData(url);
                linkMenuItem.setText(StringUtils.shorten(tag, 80));
                linkMenuItem.addSelectionListener(new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        PlatformUtils.openForBrowsing((String)linkMenuItem.getData());
                    }
                });
            }
            MenuItem linkMenuItem = new MenuItem(this.viewLinkSubMenu, 0);
            linkMenuItem.setText(this.settings.msg("dialog.main.profile.view.conf"));
            linkMenuItem.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PlatformUtils.openForEditing(prof.getCanonicalConfFile());
                }
            });
        }
    }

    private void doExportProfilesList() {
        new ExportListDialog(this.shell, this.dbversionsList, this.profilesList).open();
    }

    private void createProfilesTab(TabFolder tabFolder) {
        TabItem profilesTabItem = new TabItem(tabFolder, 0);
        profilesTabItem.setText(this.settings.msg("dialog.main.profiles"));
        Composite composite = new Composite(tabFolder, 0);
        composite.setLayout(new BorderLayout(0, 0));
        profilesTabItem.setControl(composite);
        ToolBar toolBar = new ToolBar(composite, 256);
        toolBar.setLayoutData("North");
        SelectionAdapter addProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddProfile();
            }
        };
        SelectionAdapter editProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditProfile();
            }
        };
        SelectionAdapter removeProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveProfile();
            }
        };
        SelectionAdapter setupProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunProfile(true);
            }
        };
        SelectionAdapter runProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunProfile(false);
            }
        };
        SelectionAdapter selectProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.displayProfileInformation();
            }
        };
        SelectionAdapter duplicateProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doDuplicateProfile();
            }
        };
        SelectionAdapter toggleProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleFavoriteProfile();
            }
        };
        SelectionAdapter shortcutProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doCreateShortcut();
            }
        };
        SelectionAdapter openProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = MainWindow.this.profile_table.getSelectionIndex();
                if (index != -1) {
                    Profile prof = (Profile)MainWindow.this.profilesList.get(index);
                    int dbversionIndex = DosboxVersion.findById(MainWindow.this.dbversionsList, prof.getDbversionId());
                    DosboxVersion dbversion = (DosboxVersion)MainWindow.this.dbversionsList.get(dbversionIndex);
                    CompositeConfiguration compConf = new CompositeConfiguration(dbversion, prof, true, MainWindow.this.shell, System.out);
                    PlatformUtils.openDirForViewing(compConf.getCompositeConf().getCanonicalMainDir());
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doRunProfile(false);
            }
        };
        MouseAdapter filterMouseAdapter = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doEditFilter();
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    MainWindow.this.doRemoveProfile();
                } else if (event.keyCode == 0x1000009) {
                    MainWindow.this.doAddProfile();
                } else if (event.keyCode == 0x100000B) {
                    MainWindow.this.doEditProfile(true);
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleFavoriteProfile();
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 100) {
                    MainWindow.this.doDuplicateProfile();
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 97) {
                    MainWindow.this.profile_table.selectAll();
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 102) {
                    MainWindow.this.doAddFilter();
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 99) {
                    MainWindow.this.doViewProfileConf();
                }
            }
        };
        TraverseListener travListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == 262144 && event.detail == 4) {
                    MainWindow.this.doEditProfile();
                } else if (event.stateMask == 131072 && event.detail == 4) {
                    MainWindow.this.doRunProfile(true);
                } else if (event.detail == 4) {
                    MainWindow.this.doRunProfile(false);
                }
            }
        };
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.addprofile"), "tb_new.png", addProfAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.editprofile"), "tb_edit.png", editProfAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.removeprofile"), "tb_delete.png", removeProfAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.runprofile"), "tb_run.png", runProfAdapter);
        this.setupToolItem = GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.runprofilesetup"), "tb_setup.png", setupProfAdapter);
        final SashForm sashForm = new SashForm(composite, 0);
        ControlAdapter sashResizeAdapter = new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings.setIntValues("gui", "sashweights", sashForm.getWeights());
            }
        };
        SelectionAdapter linkAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PlatformUtils.openForBrowsing(event.text);
            }
        };
        this.filterFolder = new CTabFolder(sashForm, 2048);
        this.filterFolder.setLayoutData("West");
        this.filterFolder.setUnselectedCloseVisible(true);
        this.filterFolder.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.updateProfilesAfterTabAction();
            }
        });
        this.filterFolder.addCTabFolder2Listener(new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                if (GeneralPurposeDialogs.confirmMessage(MainWindow.this.shell, MainWindow.this.settings.msg("dialog.main.confirm.removefilter", new Object[]{((CTabItem)event.item).getText().trim()}))) {
                    boolean currentTabToBeClosed = event.item == MainWindow.this.filterFolder.getSelection();
                    try {
                        int filterId = (Integer)event.item.getData();
                        MainWindow.this.dbase.removeFilter(filterId);
                        MainWindow.this.filtersList.remove(Filter.findById(MainWindow.this.filtersList, filterId));
                    }
                    catch (SQLException e) {
                        GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, e.getMessage());
                    }
                    if (currentTabToBeClosed) {
                        MainWindow.this.filterFolder.setSelection(0);
                        MainWindow.this.updateProfilesAfterTabAction();
                    }
                } else {
                    event.doit = false;
                }
            }
        });
        this.filterFolder.addMouseListener(filterMouseAdapter);
        this.profile_table = new Table(this.filterFolder, 67586);
        this.profile_table.setLinesVisible(true);
        this.profile_table.setHeaderVisible(true);
        for (int i = 0; i < this.columnIds.length; ++i) {
            this.addProfileColumn(columnNames[this.columnIds[i]], i);
        }
        this.profile_table.addMouseListener(mouseAdapter);
        this.profile_table.addKeyListener(keyAdapter);
        this.profile_table.addTraverseListener(travListener);
        this.profile_table.addSelectionListener(selectProfAdapter);
        for (Filter filter : this.filtersList) {
            this.addFilterTab(filter);
        }
        this.filterFolder.setSelection(this.settings.getIntValue("gui", "filtertab"));
        Menu menu = new Menu(this.profile_table);
        this.profile_table.setMenu(menu);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.run"), "run.png", runProfAdapter);
        MenuItem runWithMenuItem = GeneralPurposeGUI.createIconMenuItem(menu, 64, this.settings, this.settings.msg("dialog.main.profile.runwith"), null, null);
        this.runWithSubMenu = new Menu(runWithMenuItem);
        runWithMenuItem.setMenu(this.runWithSubMenu);
        this.updateProfileDbversionsSubmenu();
        final MenuItem setupMenuItem = GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.setup"), "setup.png", setupProfAdapter);
        final MenuItem setupWithMenuItem = GeneralPurposeGUI.createIconMenuItem(menu, 64, this.settings, this.settings.msg("dialog.main.profile.setupwith"), null, null);
        this.setupWithSubMenu = new Menu(setupWithMenuItem);
        setupWithMenuItem.setMenu(this.setupWithSubMenu);
        this.updateSetupDbversionsSubmenu();
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.openfolder"), "folder.png", openProfAdapter);
        MenuItem viewLinkMenuItem = GeneralPurposeGUI.createIconMenuItem(menu, 64, this.settings, this.settings.msg("dialog.main.profile.view"), "zoom.png", null);
        this.viewLinkSubMenu = new Menu(viewLinkMenuItem);
        viewLinkMenuItem.setMenu(this.viewLinkSubMenu);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.add"), "new.png", addProfAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.edit"), "edit.png", editProfAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.duplicate"), "duplicate.png", duplicateProfAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.remove"), "delete.png", removeProfAdapter);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.togglefavorite"), "favorite.png", toggleProfAdapter);
        if (PlatformUtils.IS_WINDOWS) {
            new MenuItem(menu, 2);
            GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.createshortcut"), "shortcut.png", shortcutProfAdapter);
        }
        menu.addMenuListener(new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                if (MainWindow.this.profile_table.getSelectionIndex() != -1) {
                    boolean hasSetup = ((Profile)MainWindow.this.profilesList.get(MainWindow.this.profile_table.getSelectionIndex())).hasSetup();
                    MainWindow.this.setupToolItem.setEnabled(hasSetup);
                    setupMenuItem.setEnabled(hasSetup);
                    setupWithMenuItem.setEnabled(hasSetup);
                }
            }
        });
        Composite informationGroup = new Composite(sashForm, 0);
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        informationGroup.setLayout(gl);
        informationGroup.addControlListener(sashResizeAdapter);
        this.notesField = new Text(informationGroup, 2634);
        this.notesField.setLayoutData(new GridData(4, 4, true, true));
        sashForm.setWeights(this.settings.getIntValues("gui", "sashweights"));
        Composite linksComposite = new Composite(informationGroup, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 1;
        gridLayout.verticalSpacing = 2;
        linksComposite.setLayout(gridLayout);
        linksComposite.setLayoutData(new GridData(4, 1, true, false));
        this.link = new Link[4];
        for (int i = 0; i < this.link.length; ++i) {
            this.link[i] = new Link(linksComposite, 0);
            this.link[i].setLayoutData(new GridData(4, 0x1000000, true, false));
            this.link[i].addSelectionListener(linkAdapter);
        }
        this.thumbHeight = this.settings.getIntValue("gui", "screenshotsheight");
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2304);
        scrolledComposite.setMinHeight(this.thumbHeight + 20);
        scrolledComposite.setLayoutData("South");
        this.thumbsToolBar = new Composite(scrolledComposite, 0);
        this.thumbsToolBar.setLayout(new RowLayout(256));
        scrolledComposite.setContent(this.thumbsToolBar);
        scrolledComposite.getHorizontalBar().setPageIncrement(300);
        scrolledComposite.getHorizontalBar().setIncrement(50);
        this.menu_thumb = new Menu(this.thumbsToolBar);
        SelectionAdapter removeThumbAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveThumb();
            }
        };
        SelectionAdapter openThumbsAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PlatformUtils.openDirForViewing(MainWindow.this.currentThumbFile.getParentFile());
            }
        };
        SelectionAdapter refreshThumbsAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SWTImageManager.dispose();
                MainWindow.this.displayProfileInformation();
            }
        };
        GeneralPurposeGUI.createIconMenuItem(this.menu_thumb, 0, this.settings, this.settings.msg("dialog.main.thumb.remove"), "delete.png", removeThumbAdapter);
        new MenuItem(this.menu_thumb, 2);
        GeneralPurposeGUI.createIconMenuItem(this.menu_thumb, 0, this.settings, this.settings.msg("dialog.main.thumb.openfolder"), "folder.png", openThumbsAdapter);
        GeneralPurposeGUI.createIconMenuItem(this.menu_thumb, 0, this.settings, this.settings.msg("dialog.main.thumb.refresh"), "refresh.png", refreshThumbsAdapter);
    }

    private void addFilterTab(Filter filter) {
        CTabItem item = new CTabItem(this.filterFolder, filter.getFilter() == null ? 0 : 64);
        item.setText("    " + filter.getTitle() + "    ");
        item.setData(filter.getId());
        item.setControl(this.profile_table);
    }

    private void createDosboxVersionsTab(TabFolder tabFolder) {
        TabItem dosboxTabItem = new TabItem(tabFolder, 0);
        dosboxTabItem.setText(this.settings.msg("dialog.main.dosboxversions"));
        Composite composite = new Composite(tabFolder, 0);
        composite.setLayout(new BorderLayout(0, 0));
        dosboxTabItem.setControl(composite);
        ToolBar toolBar = new ToolBar(composite, 0);
        toolBar.setLayoutData("North");
        SelectionAdapter addDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddDosboxVersion();
            }
        };
        SelectionAdapter editDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditDosboxVersion();
            }
        };
        SelectionAdapter removeDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveDosboxVersion();
            }
        };
        SelectionAdapter runDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunDosbox();
            }
        };
        SelectionAdapter toggleDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleDefaultVersion();
            }
        };
        SelectionAdapter openDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = MainWindow.this.dbversion_table.getSelectionIndex();
                if (index != -1) {
                    PlatformUtils.openDirForViewing(((DosboxVersion)MainWindow.this.dbversionsList.get(index)).getCanonicalConfFile().getParentFile());
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doRunDosbox();
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    MainWindow.this.doRemoveDosboxVersion();
                } else if (event.keyCode == 0x1000009) {
                    MainWindow.this.doAddDosboxVersion();
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultVersion();
                }
            }
        };
        TraverseListener travListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == 262144 && event.detail == 4) {
                    MainWindow.this.doEditDosboxVersion();
                } else if (event.detail == 4) {
                    MainWindow.this.doRunDosbox();
                }
            }
        };
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.addversion"), "tb_new.png", addDosboxAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.editversion"), "tb_edit.png", editDosboxAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.removeversion"), "tb_delete.png", removeDosboxAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.runversion"), "tb_run.png", runDosboxAdapter);
        this.dbversion_table = new Table(composite, 67584);
        this.dbversion_table.setLinesVisible(true);
        this.dbversion_table.setHeaderVisible(true);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.title"), 0);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.version"), 1);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.path"), 2);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.default"), 3);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.id"), 4);
        Menu menu = new Menu(this.dbversion_table);
        this.dbversion_table.setMenu(menu);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.run"), "run.png", runDosboxAdapter);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.add"), "new.png", addDosboxAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.edit"), "edit.png", editDosboxAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.remove"), "delete.png", removeDosboxAdapter);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.toggledefault"), "home.png", toggleDosboxAdapter);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.openfolder"), "folder.png", openDosboxAdapter);
        this.dbversion_table.addKeyListener(keyAdapter);
        this.dbversion_table.addTraverseListener(travListener);
        this.dbversion_table.addMouseListener(mouseAdapter);
    }

    private void createTemplatesTab(TabFolder tabFolder) {
        TabItem templatesTabItem = new TabItem(tabFolder, 0);
        templatesTabItem.setText(this.settings.msg("dialog.main.templates"));
        Composite composite = new Composite(tabFolder, 0);
        composite.setLayout(new BorderLayout(0, 0));
        templatesTabItem.setControl(composite);
        ToolBar toolBar = new ToolBar(composite, 0);
        toolBar.setLayoutData("North");
        SelectionAdapter addTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddTemplate();
            }
        };
        SelectionAdapter editTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditTemplate();
            }
        };
        SelectionAdapter removeTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveTemplate();
            }
        };
        SelectionAdapter runTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunTemplate();
            }
        };
        SelectionAdapter toggleTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleDefaultTemplate();
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doRunTemplate();
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    MainWindow.this.doRemoveTemplate();
                } else if (event.keyCode == 0x1000009) {
                    MainWindow.this.doAddTemplate();
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultTemplate();
                }
            }
        };
        TraverseListener travListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == 262144 && event.detail == 4) {
                    MainWindow.this.doEditTemplate();
                } else if (event.detail == 4) {
                    MainWindow.this.doRunTemplate();
                }
            }
        };
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.addtemplate"), "tb_new.png", addTemplAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.edittemplate"), "tb_edit.png", editTemplAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.removetemplate"), "tb_delete.png", removeTemplAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.runtemplate"), "tb_run.png", runTemplAdapter);
        this.template_table = new Table(composite, 67584);
        this.template_table.setLinesVisible(true);
        this.template_table.setHeaderVisible(true);
        this.addTemplateColumn(this.settings.msg("dialog.main.templates.column.title"), 0);
        this.addTemplateColumn(this.settings.msg("dialog.main.templates.column.default"), 1);
        Menu menu = new Menu(this.template_table);
        this.template_table.setMenu(menu);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.run"), "run.png", runTemplAdapter);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.add"), "new.png", addTemplAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.edit"), "edit.png", editTemplAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.remove"), "delete.png", removeTemplAdapter);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.toggledefault"), "home.png", toggleTemplAdapter);
        this.template_table.addKeyListener(keyAdapter);
        this.template_table.addTraverseListener(travListener);
        this.template_table.addMouseListener(mouseAdapter);
    }

    private void createFileMenu() {
        Menu menu = new Menu(this.shell, 2);
        this.shell.setMenuBar(menu);
        MenuItem fileMenuItem = new MenuItem(menu, 64);
        fileMenuItem.setText(this.settings.msg("dialog.main.menu.file"));
        Menu fileMenu = new Menu(fileMenuItem);
        fileMenuItem.setMenu(fileMenu);
        SelectionAdapter dfendAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doDFendImport();
            }
        };
        SelectionAdapter migrateAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doMigrate();
            }
        };
        SelectionAdapter exportListAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doExportProfilesList();
            }
        };
        SelectionAdapter importConfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doImportConfigfile();
            }
        };
        SelectionAdapter exportAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doExportProfiles();
            }
        };
        SelectionAdapter importAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doImportProfiles();
            }
        };
        SelectionAdapter cleanupAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (GeneralPurposeDialogs.confirmMessage(MainWindow.this.shell, MainWindow.this.settings.msg("dialog.main.confirm.databasecleanup"))) {
                        int itemsRemoved = MainWindow.this.dbase.cleanup();
                        GeneralPurposeDialogs.infoMessage(MainWindow.this.shell, MainWindow.this.settings.msg("dialog.main.notice.databasecleanupok", new Object[]{itemsRemoved}));
                    }
                }
                catch (SQLException ex) {
                    GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, ex.getMessage());
                }
            }
        };
        SelectionAdapter settingsAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doOpenSettingsDialog();
            }
        };
        SelectionAdapter exitAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.shell.close();
            }
        };
        if (PlatformUtils.IS_WINDOWS) {
            GeneralPurposeGUI.createIconMenuItem(fileMenu, 0, this.settings, this.settings.msg("dialog.main.menu.importdfendprofiles"), "dfend.png", dfendAdapter);
            new MenuItem(fileMenu, 2);
        }
        GeneralPurposeGUI.createIconMenuItem(fileMenu, 0, this.settings, this.settings.msg("dialog.main.menu.migrateprofiles"), "case.png", migrateAdapter);
        GeneralPurposeGUI.createIconMenuItem(fileMenu, 0, this.settings, this.settings.msg("dialog.main.menu.exportprofileslist"), "checkout.png", exportListAdapter);
        GeneralPurposeGUI.createIconMenuItem(fileMenu, 0, this.settings, this.settings.msg("dialog.main.menu.importprofile"), "import.png", importConfAdapter);
        new MenuItem(fileMenu, 2);
        GeneralPurposeGUI.createIconMenuItem(fileMenu, 0, this.settings, this.settings.msg("dialog.main.menu.export"), "checkout.png", exportAdapter);
        GeneralPurposeGUI.createIconMenuItem(fileMenu, 0, this.settings, this.settings.msg("dialog.main.menu.import"), "import.png", importAdapter);
        new MenuItem(fileMenu, 2);
        GeneralPurposeGUI.createIconMenuItem(fileMenu, 0, this.settings, this.settings.msg("dialog.main.menu.databasecleanup"), "clean.png", cleanupAdapter);
        new MenuItem(fileMenu, 2);
        GeneralPurposeGUI.createIconMenuItem(fileMenu, 0, this.settings, this.settings.msg("dialog.main.menu.adjustsettings"), "settings.png", settingsAdapter);
        GeneralPurposeGUI.createIconMenuItem(fileMenu, 0, this.settings, this.settings.msg("dialog.main.menu.exit"), "stop.png", exitAdapter);
    }

    private void doExportProfiles() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            int[] indices = this.profile_table.getSelectionIndices();
            Profile[] profs = new Profile[indices.length];
            for (int i = 0; i < profs.length; ++i) {
                profs[i] = this.profilesList.get(indices[i]);
            }
            new ExportDialog(this.shell, this.dbversionsList, profs).open();
        }
    }

    private void doImportProfiles() {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterNames(new String[]{"GamePack Archives", "DOSBox configuration files", "Executables, Booter Disk Images", "*"});
        dialog.setFilterExtensions(new String[]{"*.zip;*.ZIP;*.7z;*.7Z", "*.conf;*.CONF", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"});
        String result = dialog.open();
        if (result != null) {
            this.doAddProfile(result);
        }
    }

    private static Map<String, String> getEnv(Settings settings) {
        if (settings.getBooleanValue("environment", "use")) {
            return StringUtils.stringArrayToMap(settings.getValues("environment", "value"));
        }
        return null;
    }

    private void updateProfilesAfterTabAction() {
        int tabIndex = this.filterFolder.getSelectionIndex();
        this.settings.setValue("gui", "filtertab", String.valueOf(tabIndex));
        this.filterClause = this.filtersList.get(tabIndex).getFilter();
        this.updateProfilesList(this.getSelectedProfiles());
        this.displayProfileInformation();
    }

    private void doViewProfileConf() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            PlatformUtils.openForEditing(this.profilesList.get(index).getCanonicalConfFile());
        }
    }

    private Set<Integer> getSelectedProfiles() {
        int[] selection = this.profile_table.getSelectionIndices();
        HashSet<Integer> profileIds = new HashSet<Integer>();
        for (int i : selection) {
            profileIds.add(this.profilesList.get(i).getId());
        }
        return profileIds;
    }

    private int[] getIndicesByIds(Set<Integer> profileIds) {
        ArrayList<Integer> tableIdxsList = new ArrayList<Integer>();
        for (int i = 0; i < this.profilesList.size(); ++i) {
            if (!profileIds.contains(this.profilesList.get(i).getId())) continue;
            tableIdxsList.add(i);
        }
        int[] tableIdxsArray = new int[tableIdxsList.size()];
        for (int i = 0; i < tableIdxsList.size(); ++i) {
            tableIdxsArray[i] = (Integer)tableIdxsList.get(i);
        }
        return tableIdxsArray;
    }
}

