/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.loopy.iso9660;

import org.dbgl.loopy.iso9660.ISO9660FileSystem;
import org.dbgl.loopy.util.Util;

public final class ISO9660FileEntry {
    private static final char ID_SEPARATOR = ';';
    private ISO9660FileSystem fileSystem;
    private String parentPath;
    private final int entryLength;
    private final long startSector;
    private final int dataLength;
    private final int flags;
    private final String identifier;

    public ISO9660FileEntry(ISO9660FileSystem fileSystem, byte[] block, int pos) {
        this(fileSystem, null, block, pos);
    }

    public ISO9660FileEntry(ISO9660FileSystem fileSystem, String parentPath, byte[] block, int startPos) {
        this.fileSystem = fileSystem;
        this.parentPath = parentPath;
        int offset = startPos - 1;
        this.entryLength = Util.getUInt8(block, offset + 1);
        this.startSector = Util.getUInt32LE(block, offset + 3);
        this.dataLength = (int)Util.getUInt32LE(block, offset + 11);
        this.flags = Util.getUInt8(block, offset + 26);
        this.identifier = this.getFileIdentifier(block, offset, this.isDirectory());
    }

    private String getFileIdentifier(byte[] block, int offset, boolean isDir) {
        String id;
        int sepIdx;
        int fidLength = Util.getUInt8(block, offset + 33);
        if (isDir) {
            int buff34 = Util.getUInt8(block, offset + 34);
            if (fidLength == 1 && buff34 == 0) {
                return ".";
            }
            if (fidLength == 1 && buff34 == 1) {
                return "..";
            }
        }
        if ((sepIdx = (id = Util.getDChars(block, offset + 34, fidLength, this.fileSystem.getEncoding())).indexOf(59)) >= 0) {
            return id.substring(0, sepIdx);
        }
        return id;
    }

    public String getPath() {
        if (".".equals(this.getName())) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (this.parentPath != null) {
            buf.append(this.parentPath);
        }
        buf.append(this.getName());
        if (this.isDirectory()) {
            buf.append("/");
        }
        return buf.toString();
    }

    public boolean isDirectory() {
        return (this.flags & 2) != 0;
    }

    String getName() {
        return this.identifier;
    }

    int getSize() {
        return this.dataLength;
    }

    long getStartBlock() {
        return this.startSector;
    }

    int getEntryLength() {
        return this.entryLength;
    }
}

