/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Filter;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.Profile;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private static Connection con = null;
    private static final String GET_IDENTITY_QRY = "CALL IDENTITY()";
    private static final String GAME_LIST_QRY = "SELECT GAM.ID, GAM.TITLE, DEV.NAME, PUBL.NAME, GEN.NAME, YR.YEAR, GAM.DBVERSION_ID, GAM.SETUP, GAM.SETUP_PARAMS, GAM.NOTES, GAM.LINK1, GAM.LINK2, GAM.FAVORITE, STAT.STAT, GAM.CONFFILE, GAM.CAPTURES, GAM.LINK3, GAM.LINK4, CUST1.VALUE, CUST2.VALUE, CUST3.VALUE, CUST4.VALUE, GAM.CUSTOM5, GAM.CUSTOM6, GAM.CUSTOM7, GAM.CUSTOM8, GAM.CUSTOM9, GAM.CUSTOM10, GAM.LINK1_TITLE, GAM.LINK2_TITLE, GAM.LINK3_TITLE, GAM.LINK4_TITLE FROM GAMES GAM, DEVELOPERS DEV, PUBLISHERS PUBL, GENRES GEN, PUBLYEARS YR, STATUS STAT, CUSTOM1 CUST1, CUSTOM2 CUST2, CUSTOM3 CUST3, CUSTOM4 CUST4 WHERE GAM.DEV_ID=DEV.ID AND GAM.PUBL_ID=PUBL.ID AND GAM.GENRE_ID=GEN.ID AND GAM.YEAR_ID=YR.ID AND GAM.STAT_ID=STAT.ID AND   GAM.CUST1_ID=CUST1.ID AND GAM.CUST2_ID=CUST2.ID AND GAM.CUST3_ID=CUST3.ID AND GAM.CUST4_ID=CUST4.ID";
    private static final String DUPL_GAME_QRY = "INSERT INTO GAMES(TITLE, DEV_ID, PUBL_ID, GENRE_ID, YEAR_ID, DBVERSION_ID, STAT_ID, SETUP, SETUP_PARAMS, NOTES,LINK1, LINK2, FAVORITE, CONFFILE, CAPTURES, LINK3, LINK4, CUST1_ID, CUST2_ID, CUST3_ID, CUST4_ID,CUSTOM5, CUSTOM6, CUSTOM7, CUSTOM8, CUSTOM9, CUSTOM10, LINK1_TITLE, LINK2_TITLE, LINK3_TITLE, LINK4_TITLE) (SELECT TITLE, DEV_ID, PUBL_ID, GENRE_ID, YEAR_ID, DBVERSION_ID, STAT_ID, SETUP, SETUP_PARAMS, NOTES,LINK1, LINK2, FAVORITE, NULL, NULL, LINK3, LINK4, CUST1_ID, CUST2_ID, CUST3_ID, CUST4_ID,CUSTOM5, CUSTOM6, CUSTOM7, CUSTOM8, CUSTOM9, CUSTOM10, LINK1_TITLE, LINK2_TITLE, LINK3_TITLE, LINK4_TITLE FROM GAMES WHERE ID = ?)";
    private static final String DEV_LIST_QRY = "SELECT ID, NAME FROM DEVELOPERS ORDER BY NAME";
    private static final String PUBL_LIST_QRY = "SELECT ID, NAME FROM PUBLISHERS ORDER BY NAME";
    private static final String GENRE_LIST_QRY = "SELECT ID, NAME FROM GENRES ORDER BY NAME";
    private static final String PUBLYEAR_LIST_QRY = "SELECT ID, YEAR FROM PUBLYEARS ORDER BY YEAR";
    private static final String DBVERS_LIST_QRY = "SELECT ID, TITLE, PATH, MULTICONF, USINGCURSES, DEFAULT, PARAMETERS, VERSION FROM DOSBOXVERSIONS ORDER BY TITLE";
    private static final String FLTRS_LIST_QRY = "SELECT ID, TITLE, FILTER FROM FILTERS";
    private static final String TEMPL_LIST_QRY = "SELECT ID, TITLE, DBVERSION_ID, DEFAULT FROM TEMPLATES ORDER BY ID";
    private static final String STATUS_LIST_QRY = "SELECT ID, STAT FROM STATUS ORDER BY STAT";
    private static final String[] CUSTOM_LIST_QRY = new String[]{"SELECT ID, VALUE FROM CUSTOM1 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM2 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM3 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM4 ORDER BY VALUE"};
    private static final String DBV_USE_QRY = "SELECT TITLE FROM GAMES WHERE DBVERSION_ID = ? UNION ALL SELECT TITLE FROM TEMPLATES WHERE DBVERSION_ID = ?";
    private static final String ADD_GAME_QRY = "INSERT INTO GAMES(TITLE, DEV_ID, PUBL_ID, GENRE_ID, YEAR_ID, DBVERSION_ID, STAT_ID, SETUP, SETUP_PARAMS, NOTES, LINK1, LINK2, FAVORITE, CONFFILE, CAPTURES, LINK3, LINK4, CUST1_ID, CUST2_ID, CUST3_ID, CUST4_ID,CUSTOM5, CUSTOM6, CUSTOM7, CUSTOM8, CUSTOM9, CUSTOM10, LINK1_TITLE, LINK2_TITLE, LINK3_TITLE, LINK4_TITLE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NULL, NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String ADD_DEVELOPER_QRY = "INSERT INTO DEVELOPERS(NAME) VALUES (?)";
    private static final String ADD_PUBLISHER_QRY = "INSERT INTO PUBLISHERS(NAME) VALUES (?)";
    private static final String ADD_GENRE_QRY = "INSERT INTO GENRES(NAME) VALUES (?)";
    private static final String ADD_YEAR_QRY = "INSERT INTO PUBLYEARS(YEAR) VALUES (?)";
    private static final String ADD_DBVERSION_QRY = "INSERT INTO DOSBOXVERSIONS(TITLE, PATH, MULTICONF, USINGCURSES, DEFAULT, PARAMETERS, VERSION) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String ADD_TEMPLATE_QRY = "INSERT INTO TEMPLATES(TITLE, DBVERSION_ID, DEFAULT) VALUES (?, ?, ?)";
    private static final String ADD_FILTER_QRY = "INSERT INTO FILTERS(TITLE, FILTER, CONF_FILTER) VALUES (?, ?, '')";
    private static final String ADD_STATUS_QRY = "INSERT INTO STATUS(STAT) VALUES (?)";
    private static final String[] ADD_CUSTOM_QRY = new String[]{"INSERT INTO CUSTOM1(VALUE) VALUES (?)", "INSERT INTO CUSTOM2(VALUE) VALUES (?)", "INSERT INTO CUSTOM3(VALUE) VALUES (?)", "INSERT INTO CUSTOM4(VALUE) VALUES (?)"};
    private static final String UPD_GAME_QRY = "UPDATE GAMES SET TITLE = ?, DEV_ID = ?, PUBL_ID = ?, GENRE_ID = ?, YEAR_ID = ?, DBVERSION_ID = ?, STAT_ID = ?, SETUP = ?, SETUP_PARAMS = ?, NOTES = ?, LINK1 = ?, LINK2 = ?, FAVORITE = ?, LINK3 = ?, LINK4 = ?, CUST1_ID = ?, CUST2_ID = ?, CUST3_ID = ?, CUST4_ID = ?, CUSTOM5 = ?, CUSTOM6 = ?, CUSTOM7 = ?, CUSTOM8 = ?, CUSTOM9 = ?, CUSTOM10 = ?, LINK1_TITLE = ?, LINK2_TITLE = ?, LINK3_TITLE = ?, LINK4_TITLE = ? WHERE ID = ?";
    private static final String UPD_GAME_CONF_QRY = "UPDATE GAMES SET CONFFILE = ?, CAPTURES = ? WHERE ID = ?";
    private static final String UPD_STPLNKS_QRY = "UPDATE GAMES SET SETUP = ?, LINK1 = ?, LINK2 = ?, LINK3 = ?, LINK4 = ? WHERE ID = ?";
    private static final String UPD_GAME_DBV_QRY = "UPDATE GAMES SET DBVERSION_ID = ? WHERE ID = ?";
    private static final String UPD_DBV_NODEFAULT = "UPDATE DOSBOXVERSIONS SET DEFAULT = FALSE";
    private static final String UPD_DBVERSION_QRY = "UPDATE DOSBOXVERSIONS SET TITLE = ?, PATH = ?, MULTICONF = ?, USINGCURSES = ?, DEFAULT = ?, PARAMETERS = ?, VERSION = ? WHERE ID = ?";
    private static final String UPD_TEMPLATE_QRY = "UPDATE TEMPLATES SET TITLE = ?, DBVERSION_ID = ?, DEFAULT = ? WHERE ID = ?";
    private static final String UPD_FILTER_QRY = "UPDATE FILTERS SET TITLE = ?, FILTER = ? WHERE ID = ?";
    private static final String UPD_TEMPL_NODFLT = "UPDATE TEMPLATES SET DEFAULT = FALSE";
    private static final String REMOVE_GAME_QRY = "DELETE FROM GAMES WHERE ID = ?";
    private static final String REMOVE_DBV_QRY = "DELETE FROM DOSBOXVERSIONS WHERE ID = ?";
    private static final String REMOVE_TEMPL_QRY = "DELETE FROM TEMPLATES WHERE ID = ?";
    private static final String REMOVE_FLTR_QRY = "DELETE FROM FILTERS WHERE ID = ?";
    private static final String TOGGLE_FAV_QRY = "UPDATE GAMES SET FAVORITE = NOT FAVORITE WHERE ID = ?";
    private static final String GET_VERSION = "SELECT MAJORVERSION, MINORVERSION FROM VERSION";
    private static final String UP_TO_V050_QRY = "ALTER TABLE GAMES ADD COLUMN CONFFILE VARCHAR(256);ALTER TABLE GAMES ADD COLUMN CAPTURES VARCHAR(256);CREATE TABLE VERSION(MAJORVERSION INTEGER NOT NULL, MINORVERSION INTEGER NOT NULL);INSERT INTO VERSION VALUES(0, 50);UPDATE GAMES SET CAPTURES = '" + FileUtils.CAPTURES_DIR + "' || GAMES.ID," + " CONFFILE = '" + FileUtils.PROFILES_DIR + "' || GAMES.ID || '" + ".conf" + "';";
    private static final String UP_TO_V051_QRY = "ALTER TABLE DOSBOXVERSIONS ADD COLUMN PARAMETERS VARCHAR(256) DEFAULT '';UPDATE VERSION SET MINORVERSION = 51;";
    private static final String UP_TO_V056_QRY = "ALTER TABLE GAMES ADD COLUMN LINK3 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK4 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUST1_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUST2_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUST3_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUST4_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUSTOM5 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM6 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM7 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM8 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM9  INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUSTOM10 INTEGER DEFAULT 0;CREATE TABLE CUSTOM1(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);CREATE TABLE CUSTOM2(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);CREATE TABLE CUSTOM3(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);CREATE TABLE CUSTOM4(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);INSERT INTO CUSTOM1(VALUE) VALUES('');INSERT INTO CUSTOM2(VALUE) VALUES('');INSERT INTO CUSTOM3(VALUE) VALUES('');INSERT INTO CUSTOM4(VALUE) VALUES('');UPDATE VERSION SET MINORVERSION = 56;";
    private static final String UP_TO_V062_QRY = "ALTER TABLE DOSBOXVERSIONS ADD COLUMN VERSION VARCHAR(256) DEFAULT '0.72' NOT NULL;UPDATE VERSION SET MINORVERSION = 62;";
    private static final String UP_TO_V065_QRY = "ALTER TABLE GAMES ADD COLUMN LINK1_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK2_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK3_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK4_TITLE VARCHAR(256) DEFAULT '';UPDATE VERSION SET MINORVERSION = 65;";
    private static final String UP_TO_V067_QRY = "ALTER TABLE DOSBOXVERSIONS ADD COLUMN USINGCURSES BOOLEAN;UPDATE VERSION SET MINORVERSION = 67;";
    private static final String UP_TO_V068_QRY = "CREATE MEMORY TABLE FILTERS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,FILTER VARCHAR(256) NOT NULL,CONF_FILTER VARCHAR(256) NOT NULL);UPDATE VERSION SET MINORVERSION = 68;";
    private static final String CREATE_INITIAL_DB = "SET WRITE_DELAY 1;CREATE MEMORY TABLE VERSION(MAJORVERSION INTEGER NOT NULL,MINORVERSION INTEGER NOT NULL);CREATE MEMORY TABLE DEVELOPERS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,NAME VARCHAR(256) NOT NULL);CREATE MEMORY TABLE PUBLISHERS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,NAME VARCHAR(256) NOT NULL);CREATE MEMORY TABLE GENRES(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,NAME VARCHAR(256) NOT NULL);CREATE MEMORY TABLE PUBLYEARS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,YEAR CHAR(4) NOT NULL);CREATE MEMORY TABLE STATUS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,STAT VARCHAR(256) NOT NULL);CREATE MEMORY TABLE CUSTOM1(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,VALUE VARCHAR(256) NOT NULL);CREATE MEMORY TABLE CUSTOM2(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,VALUE VARCHAR(256) NOT NULL);CREATE MEMORY TABLE CUSTOM3(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,VALUE VARCHAR(256) NOT NULL);CREATE MEMORY TABLE CUSTOM4(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,VALUE VARCHAR(256) NOT NULL);CREATE MEMORY TABLE DOSBOXVERSIONS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,PATH VARCHAR(256) NOT NULL,MULTICONF BOOLEAN,DEFAULT BOOLEAN,PARAMETERS VARCHAR(256) DEFAULT '',VERSION VARCHAR(256) NOT NULL,USINGCURSES BOOLEAN);CREATE MEMORY TABLE TEMPLATES(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,DBVERSION_ID INTEGER,DEFAULT BOOLEAN,CONSTRAINT SYS_FK_185 FOREIGN KEY(DBVERSION_ID) REFERENCES DOSBOXVERSIONS(ID));CREATE MEMORY TABLE GAMES(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,DEV_ID INTEGER,PUBL_ID INTEGER,GENRE_ID INTEGER,YEAR_ID INTEGER,DBVERSION_ID INTEGER,STAT_ID INTEGER,SETUP VARCHAR(256),SETUP_PARAMS VARCHAR(256),NOTES LONGVARCHAR,LINK1 VARCHAR(256),LINK2 VARCHAR(256),FAVORITE BOOLEAN,CONFFILE VARCHAR(256),CAPTURES VARCHAR(256),LINK3 VARCHAR(256) DEFAULT '',LINK4 VARCHAR(256) DEFAULT '',CUST1_ID INTEGER DEFAULT 0,CUST2_ID INTEGER DEFAULT 0,CUST3_ID INTEGER DEFAULT 0,CUST4_ID INTEGER DEFAULT 0,CUSTOM5 VARCHAR(256) DEFAULT '',CUSTOM6 VARCHAR(256) DEFAULT '',CUSTOM7 VARCHAR(256) DEFAULT '',CUSTOM8 VARCHAR(256) DEFAULT '',CUSTOM9 INTEGER DEFAULT 0,CUSTOM10 INTEGER DEFAULT 0,LINK1_TITLE VARCHAR(256) DEFAULT '',LINK2_TITLE VARCHAR(256) DEFAULT '',LINK3_TITLE VARCHAR(256) DEFAULT '',LINK4_TITLE VARCHAR(256) DEFAULT '',CONSTRAINT SYS_FK_165 FOREIGN KEY(DEV_ID) REFERENCES DEVELOPERS(ID),CONSTRAINT SYS_FK_166 FOREIGN KEY(PUBL_ID) REFERENCES PUBLISHERS(ID),CONSTRAINT SYS_FK_167 FOREIGN KEY(GENRE_ID) REFERENCES GENRES(ID),CONSTRAINT SYS_FK_168 FOREIGN KEY(YEAR_ID) REFERENCES PUBLYEARS(ID),CONSTRAINT SYS_FK_169 FOREIGN KEY(DBVERSION_ID) REFERENCES DOSBOXVERSIONS(ID),CONSTRAINT SYS_FK_170 FOREIGN KEY(STAT_ID) REFERENCES STATUS(ID));CREATE MEMORY TABLE FILTERS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,FILTER VARCHAR(256) NOT NULL,CONF_FILTER VARCHAR(256) NOT NULL);INSERT INTO DOSBOXVERSIONS VALUES(0,'DOSBox 0.74','DOSBox-0.74',TRUE,TRUE,'','0.74',FALSE);INSERT INTO TEMPLATES VALUES(0,'Booter',0,FALSE);INSERT INTO TEMPLATES VALUES(1,'Early 80''s (CGA, 640KB conv. memory, speaker, 8086 ~4.77Mhz)',0,FALSE);INSERT INTO TEMPLATES VALUES(2,'Late  80''s (VGA, 640KB conv. memory, speaker, 80286 ~12Mhz)',0,FALSE);INSERT INTO TEMPLATES VALUES(3,'Early 90''s (VGA, 4MB ram, full audio support, 80386 ~25Mhz)',0,FALSE);INSERT INTO TEMPLATES VALUES(4,'Late  90''s (VGA, 16MB ram, full audio support, 80486 ~66Mhz)',0,FALSE);INSERT INTO CUSTOM1(VALUE) VALUES(''); INSERT INTO CUSTOM2(VALUE) VALUES('');INSERT INTO CUSTOM3(VALUE) VALUES(''); INSERT INTO CUSTOM4(VALUE) VALUES('');INSERT INTO VERSION VALUES(0,68);";
    private static final String TEST_QRY = "SELECT TOP 1 ID FROM GAMES";
    private static final String CLEANUP_QRY = "DELETE FROM DEVELOPERS WHERE ID NOT IN (SELECT DISTINCT DEV_ID FROM GAMES);DELETE FROM PUBLISHERS WHERE ID NOT IN (SELECT DISTINCT PUBL_ID FROM GAMES);DELETE FROM GENRES WHERE ID NOT IN (SELECT DISTINCT GENRE_ID FROM GAMES);DELETE FROM PUBLYEARS WHERE ID NOT IN (SELECT DISTINCT YEAR_ID FROM GAMES);DELETE FROM STATUS WHERE ID NOT IN (SELECT DISTINCT STAT_ID FROM GAMES);DELETE FROM CUSTOM1 WHERE ID NOT IN (SELECT DISTINCT CUST1_ID FROM GAMES);DELETE FROM CUSTOM2 WHERE ID NOT IN (SELECT DISTINCT CUST2_ID FROM GAMES);DELETE FROM CUSTOM3 WHERE ID NOT IN (SELECT DISTINCT CUST3_ID FROM GAMES);DELETE FROM CUSTOM4 WHERE ID NOT IN (SELECT DISTINCT CUST4_ID FROM GAMES)";
    private static final int COMPLEX_STRINGS = CUSTOM_LIST_QRY.length;
    private static final int SIMPLE_STRINGS = 4;
    private static final int SIMPLE_INTS = 2;

    private Database() {
        this.init();
    }

    public static Database getInstance() {
        return DatabaseHolder.instance;
    }

    private void closeAll(Statement statement, ResultSet resultset) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                System.err.println(Settings.getInstance().msg("database.error.statementclose"));
            }
        }
        if (resultset != null) {
            try {
                resultset.close();
            }
            catch (SQLException e) {
                System.err.println(Settings.getInstance().msg("database.error.resultsetclose"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getVersion() {
        int[] result = new int[2];
        Statement stmt = null;
        ResultSet resultset = null;
        try {
            stmt = con.createStatement();
            resultset = stmt.executeQuery(GET_VERSION);
            if (resultset != null && resultset.next()) {
                result[0] = resultset.getInt(1);
                result[1] = resultset.getInt(2);
            }
            this.closeAll(stmt, resultset);
        }
        catch (SQLException e) {
            try {
                result[0] = 0;
                result[1] = 0;
                this.closeAll(stmt, resultset);
            }
            catch (Throwable throwable) {
                this.closeAll(stmt, resultset);
                throw throwable;
            }
        }
        return result;
    }

    private void upgradeToVersion(String query, int minorVersion) throws SQLException {
        System.out.println(Settings.getInstance().msg("database.notice.upgrade", new Object[]{0, minorVersion}));
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.executeQuery(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.upgrade", new Object[]{0, minorVersion}));
        }
        finally {
            this.closeAll(stmt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNecessary() throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.executeQuery(TEST_QRY);
        }
        catch (SQLException emptydatabase) {
            Statement stmt2 = null;
            try {
                stmt2 = con.createStatement();
                stmt2.executeQuery(CREATE_INITIAL_DB);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"create initial tables"}));
            }
            finally {
                this.closeAll(stmt2, null);
            }
        }
        finally {
            this.closeAll(stmt, null);
        }
    }

    private void upgradeIfNecessary() throws SQLException {
        int[] version = this.getVersion();
        if (version[0] <= 0 && version[1] < 50) {
            this.upgradeToVersion(UP_TO_V050_QRY, 50);
        }
        if (version[0] <= 0 && version[1] < 51) {
            this.upgradeToVersion(UP_TO_V051_QRY, 51);
        }
        if (version[0] <= 0 && version[1] < 56) {
            this.upgradeToVersion(UP_TO_V056_QRY, 56);
        }
        if (version[0] <= 0 && version[1] < 62) {
            this.upgradeToVersion(UP_TO_V062_QRY, 62);
        }
        if (version[0] <= 0 && version[1] < 65) {
            this.upgradeToVersion(UP_TO_V065_QRY, 65);
        }
        if (version[0] <= 0 && version[1] < 67) {
            this.upgradeToVersion(UP_TO_V067_QRY, 67);
        }
        if (version[0] <= 0 && version[1] < 68) {
            this.upgradeToVersion(UP_TO_V068_QRY, 68);
        }
    }

    private void init() {
        Settings settings = Settings.getInstance();
        System.out.println(settings.msg("database.notice.startup"));
        String connString = settings.getSettings().getValue("database", "connectionstring");
        if (connString.contains("file:")) {
            int start = connString.indexOf("file:") + 5;
            int end = connString.indexOf(59, start);
            if (end == -1) {
                end = connString.length();
            }
            String databasefile = FileUtils.getCanonicalPath(connString.substring(start, end));
            connString = connString.substring(0, start) + databasefile + connString.substring(end);
        }
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            con = DriverManager.getConnection(connString, settings.getSettings().getValue("database", "username"), settings.getSettings().getValue("database", "password"));
            this.initializeIfNecessary();
            this.upgradeIfNecessary();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException exc) {
                System.err.println(settings.msg("database.error.connectionclose"));
                exc.printStackTrace();
            }
            Shell shell = new Shell();
            GeneralPurposeDialogs.fatalMessage(shell, settings.msg("database.error.initconnection", new Object[]{e.toString()}));
            System.exit(1);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Shell shell = new Shell();
            GeneralPurposeDialogs.fatalMessage(shell, settings.msg("database.error.registerdriver", new Object[]{e.toString()}));
            System.exit(1);
        }
    }

    private int identity() throws SQLException {
        int result = -1;
        Statement stmt = null;
        ResultSet resultset = null;
        try {
            stmt = con.createStatement();
            resultset = stmt.executeQuery(GET_IDENTITY_QRY);
            if (resultset != null && resultset.next()) {
                result = resultset.getInt(1);
            }
            this.closeAll(stmt, resultset);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"get identity"}));
            }
            catch (Throwable throwable) {
                this.closeAll(stmt, resultset);
                throw throwable;
            }
        }
        return result;
    }

    private int addSomething(String query, String objectToAdd) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(query);
            stmt.setString(1, objectToAdd);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add " + objectToAdd}));
        }
        finally {
            this.closeAll(stmt, null);
        }
        return this.identity();
    }

    private void removeSomething(String query, String objectToRemove, int objectId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(query);
            stmt.setInt(1, objectId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"remove " + objectToRemove}));
        }
        finally {
            this.closeAll(stmt, null);
        }
    }

    private List<KeyValuePair> readKeyValuePairList(String query) throws SQLException {
        ArrayList<KeyValuePair> customList = new ArrayList<KeyValuePair>();
        Statement stmt = null;
        ResultSet resultset = null;
        try {
            stmt = con.createStatement();
            resultset = stmt.executeQuery(query);
            if (resultset != null) {
                while (resultset.next()) {
                    customList.add(new KeyValuePair(resultset.getInt(1), resultset.getString(2)));
                }
            }
            this.closeAll(stmt, resultset);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"read KeyValuePairs"}));
            }
            catch (Throwable throwable) {
                this.closeAll(stmt, resultset);
                throw throwable;
            }
        }
        return customList;
    }

    public void shutdown() throws SQLException {
        System.out.println(Settings.getInstance().msg("database.notice.shutdown"));
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute("SHUTDOWN");
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.shutdown"));
        }
        finally {
            this.closeAll(stmt, null);
            con.close();
        }
    }

    public List<Profile> readProfilesList(String orderingClause, String filterClause) throws SQLException {
        ArrayList<Profile> profilesList = new ArrayList<Profile>();
        Statement stmt = null;
        ResultSet rset = null;
        try {
            stmt = con.createStatement();
            StringBuffer qry = new StringBuffer(GAME_LIST_QRY);
            if (filterClause != null && filterClause.length() > 0) {
                qry.append(" AND (").append(filterClause).append(")");
            }
            qry.append(orderingClause);
            rset = stmt.executeQuery(qry.toString());
            if (rset != null) {
                while (rset.next()) {
                    profilesList.add(new Profile(rset.getInt(1), rset.getString(2), rset.getString(3), rset.getString(4), rset.getString(5), rset.getString(6), rset.getInt(7), rset.getString(8), rset.getString(9), rset.getString(10), rset.getString(11), rset.getString(12), rset.getBoolean(13), rset.getString(14), rset.getString(15), rset.getString(16), rset.getString(17), rset.getString(18), rset.getString(19), rset.getString(20), rset.getString(21), rset.getString(22), rset.getString(23), rset.getString(24), rset.getString(25), rset.getString(26), rset.getInt(27), rset.getInt(28), rset.getString(29), rset.getString(30), rset.getString(31), rset.getString(32)));
                }
            }
            this.closeAll(stmt, rset);
        }
        catch (SQLException e) {
            try {
                if (orderingClause.length() > 0) {
                    e.printStackTrace();
                }
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"read profiles"}));
            }
            catch (Throwable throwable) {
                this.closeAll(stmt, rset);
                throw throwable;
            }
        }
        return profilesList;
    }

    public List<KeyValuePair> readDevelopersList() throws SQLException {
        return this.readKeyValuePairList(DEV_LIST_QRY);
    }

    public List<KeyValuePair> readPublishersList() throws SQLException {
        return this.readKeyValuePairList(PUBL_LIST_QRY);
    }

    public List<KeyValuePair> readGenresList() throws SQLException {
        return this.readKeyValuePairList(GENRE_LIST_QRY);
    }

    public List<KeyValuePair> readYearsList() throws SQLException {
        return this.readKeyValuePairList(PUBLYEAR_LIST_QRY);
    }

    public List<KeyValuePair> readStatusList() throws SQLException {
        return this.readKeyValuePairList(STATUS_LIST_QRY);
    }

    public List<KeyValuePair> readCustomList(int index) throws SQLException {
        return this.readKeyValuePairList(CUSTOM_LIST_QRY[index]);
    }

    public List<DosboxVersion> readDosboxVersionsList() throws SQLException {
        ArrayList<DosboxVersion> dbversionsList = new ArrayList<DosboxVersion>();
        Statement stmt = null;
        ResultSet resultset = null;
        try {
            stmt = con.createStatement();
            resultset = stmt.executeQuery(DBVERS_LIST_QRY);
            if (resultset != null) {
                while (resultset.next()) {
                    dbversionsList.add(new DosboxVersion(resultset.getInt(1), resultset.getString(2), resultset.getString(3), resultset.getBoolean(4), resultset.getBoolean(5), resultset.getBoolean(6), resultset.getString(7), resultset.getString(8)));
                }
            }
            this.closeAll(stmt, resultset);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"read dosboxversions"}));
            }
            catch (Throwable throwable) {
                this.closeAll(stmt, resultset);
                throw throwable;
            }
        }
        return dbversionsList;
    }

    public List<Template> readTemplatesList() throws SQLException {
        ArrayList<Template> templatesList = new ArrayList<Template>();
        Statement stmt = null;
        ResultSet resultset = null;
        try {
            stmt = con.createStatement();
            resultset = stmt.executeQuery(TEMPL_LIST_QRY);
            if (resultset != null) {
                while (resultset.next()) {
                    templatesList.add(new Template(resultset.getInt(1), resultset.getString(2), resultset.getInt(3), resultset.getBoolean(4)));
                }
            }
            this.closeAll(stmt, resultset);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"read templates"}));
            }
            catch (Throwable throwable) {
                this.closeAll(stmt, resultset);
                throw throwable;
            }
        }
        return templatesList;
    }

    public List<Filter> readFiltersList() throws SQLException {
        ArrayList<Filter> filtersList = new ArrayList<Filter>();
        Statement stmt = null;
        ResultSet resultset = null;
        try {
            stmt = con.createStatement();
            resultset = stmt.executeQuery(FLTRS_LIST_QRY);
            if (resultset != null) {
                while (resultset.next()) {
                    filtersList.add(new Filter(resultset.getInt(1), resultset.getString(2), resultset.getString(3)));
                }
            }
            this.closeAll(stmt, resultset);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"read filters"}));
            }
            catch (Throwable throwable) {
                this.closeAll(stmt, resultset);
                throw throwable;
            }
        }
        return filtersList;
    }

    public void removeProfile(int gameId) throws SQLException {
        this.removeSomething(REMOVE_GAME_QRY, "profile", gameId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDosboxVersion(int dbversionId) throws SQLException {
        try {
            this.removeSomething(REMOVE_DBV_QRY, "dosboxversion", dbversionId);
        }
        catch (SQLException e) {
            StringBuffer usageList = new StringBuffer();
            PreparedStatement stmt = null;
            ResultSet resultset = null;
            int amount = 0;
            try {
                stmt = con.prepareStatement(DBV_USE_QRY);
                stmt.setInt(1, dbversionId);
                stmt.setInt(2, dbversionId);
                resultset = stmt.executeQuery();
                if (resultset != null) {
                    while (resultset.next()) {
                        if (amount++ >= 10) continue;
                        if (amount > 1) {
                            usageList.append(", ");
                        }
                        usageList.append(resultset.getString(1));
                    }
                }
                this.closeAll(stmt, resultset);
            }
            catch (Throwable throwable) {
                this.closeAll(stmt, resultset);
                throw throwable;
            }
            throw new SQLException(Settings.getInstance().msg("general.error.profilesandtemplatesusingdbversion", new Object[]{e.getMessage(), amount, usageList}));
        }
    }

    public void removeTemplate(int templateId) throws SQLException {
        this.removeSomething(REMOVE_TEMPL_QRY, "template", templateId);
    }

    public void removeFilter(int filterId) throws SQLException {
        this.removeSomething(REMOVE_FLTR_QRY, "filter", filterId);
    }

    public int addOrEditProfile(String title, String developer, String publisher, String genre, String year, String status, String setup, String setupParams, String notes, boolean favorite, int devId, int publId, int genId, int yrId, int statId, int dbversionId, String[] link, String[] sCust, int[] iCust, int[] custId, String[] linkTitle, int profileId) throws SQLException {
        int result = -1;
        PreparedStatement pstmt = null;
        try {
            int i;
            pstmt = con.prepareStatement(profileId == -1 ? ADD_GAME_QRY : UPD_GAME_QRY);
            pstmt.setString(1, title);
            pstmt.setInt(2, devId == -1 ? this.addSomething(ADD_DEVELOPER_QRY, developer) : devId);
            pstmt.setInt(3, publId == -1 ? this.addSomething(ADD_PUBLISHER_QRY, publisher) : publId);
            pstmt.setInt(4, genId == -1 ? this.addSomething(ADD_GENRE_QRY, genre) : genId);
            pstmt.setInt(5, yrId == -1 ? this.addSomething(ADD_YEAR_QRY, year) : yrId);
            pstmt.setInt(6, dbversionId);
            pstmt.setInt(7, statId == -1 ? this.addSomething(ADD_STATUS_QRY, status) : statId);
            pstmt.setString(8, setup);
            pstmt.setString(9, setupParams);
            pstmt.setString(10, notes);
            pstmt.setString(11, link[0]);
            pstmt.setString(12, link[1]);
            pstmt.setBoolean(13, favorite);
            pstmt.setString(14, link[2]);
            pstmt.setString(15, link[3]);
            for (i = 0; i < COMPLEX_STRINGS; ++i) {
                pstmt.setInt(i + 16, custId[i] == -1 ? this.addSomething(ADD_CUSTOM_QRY[i], sCust[i]) : custId[i]);
            }
            for (i = 0; i < 4; ++i) {
                pstmt.setString(i + COMPLEX_STRINGS + 16, sCust[i + COMPLEX_STRINGS]);
            }
            for (i = 0; i < 2; ++i) {
                pstmt.setInt(i + COMPLEX_STRINGS + 4 + 16, iCust[i]);
            }
            pstmt.setString(26, linkTitle[0]);
            pstmt.setString(27, linkTitle[1]);
            pstmt.setString(28, linkTitle[2]);
            pstmt.setString(29, linkTitle[3]);
            if (profileId == -1) {
                pstmt.executeUpdate();
                result = this.identity();
            } else {
                pstmt.setInt(COMPLEX_STRINGS + 4 + 2 + 20, profileId);
                pstmt.executeUpdate();
                result = profileId;
            }
            this.closeAll(pstmt, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add/edit profile"}));
            }
            catch (Throwable throwable) {
                this.closeAll(pstmt, null);
                throw throwable;
            }
        }
        return result;
    }

    public synchronized int addOrEditProfile(String title, String developer, String publisher, String genre, String year, String status, String setup, String setupParams, String notes, boolean favorite, int dbversionId, String[] link, String[] sCust, int[] iCust, String[] linkTitle, int profileId) throws SQLException {
        int devId = KeyValuePair.findIdByValue(this.readDevelopersList(), developer);
        int publId = KeyValuePair.findIdByValue(this.readPublishersList(), publisher);
        int genId = KeyValuePair.findIdByValue(this.readGenresList(), genre);
        int yrId = KeyValuePair.findIdByValue(this.readYearsList(), year);
        int statId = KeyValuePair.findIdByValue(this.readStatusList(), status);
        int[] customIds = new int[COMPLEX_STRINGS];
        for (int i = 0; i < COMPLEX_STRINGS; ++i) {
            customIds[i] = KeyValuePair.findIdByValue(this.readCustomList(i), sCust[i]);
        }
        return this.addOrEditProfile(title, developer, publisher, genre, year, status, setup, setupParams, notes, favorite, devId, publId, genId, yrId, statId, dbversionId, link, sCust, iCust, customIds, linkTitle, profileId);
    }

    public void updateProfileConf(String confFile, String captures, int profileId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(UPD_GAME_CONF_QRY);
            stmt.setString(1, confFile);
            stmt.setString(2, captures);
            stmt.setInt(3, profileId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"update profile conf"}));
        }
        finally {
            this.closeAll(stmt, null);
        }
    }

    public void updateProfileSetupAndLinks(String setup, String[] links, int profileId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(UPD_STPLNKS_QRY);
            stmt.setString(1, setup);
            stmt.setString(2, links[0]);
            stmt.setString(3, links[1]);
            stmt.setString(4, links[2]);
            stmt.setString(5, links[3]);
            stmt.setInt(6, profileId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"update profile setup and links"}));
        }
        finally {
            this.closeAll(stmt, null);
        }
    }

    public void updateProfileDosboxversion(DosboxVersion dbversion, int profileId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(UPD_GAME_DBV_QRY);
            stmt.setInt(1, dbversion.getId());
            stmt.setInt(2, profileId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"update profile dosbox version"}));
        }
        finally {
            this.closeAll(stmt, null);
        }
    }

    public void toggleFavorite(int profileId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(TOGGLE_FAV_QRY);
            stmt.setInt(1, profileId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"toggle favorite"}));
        }
        finally {
            this.closeAll(stmt, null);
        }
    }

    public int duplicateProfile(int profileId) throws SQLException {
        int result = -1;
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(DUPL_GAME_QRY);
            pstmt.setInt(1, profileId);
            pstmt.executeUpdate();
            result = this.identity();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"duplicate profile"}));
        }
        finally {
            this.closeAll(pstmt, null);
        }
        return result;
    }

    public int addOrEditDosboxVersion(String title, String path, boolean multiConfig, boolean usingCurses, boolean defaultVersion, String parameters, String version, int dbversionId) throws SQLException {
        int result = -1;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        try {
            if (defaultVersion) {
                stmt = con.createStatement();
                stmt.executeQuery(UPD_DBV_NODEFAULT);
            }
            if (dbversionId == -1) {
                pstmt = con.prepareStatement(ADD_DBVERSION_QRY);
                pstmt.setString(1, title);
                pstmt.setString(2, path);
                pstmt.setBoolean(3, multiConfig);
                pstmt.setBoolean(4, usingCurses);
                pstmt.setBoolean(5, defaultVersion);
                pstmt.setString(6, parameters);
                pstmt.setString(7, version);
                pstmt.executeUpdate();
                result = this.identity();
            } else {
                pstmt = con.prepareStatement(UPD_DBVERSION_QRY);
                pstmt.setString(1, title);
                pstmt.setString(2, path);
                pstmt.setBoolean(3, multiConfig);
                pstmt.setBoolean(4, usingCurses);
                pstmt.setBoolean(5, defaultVersion);
                pstmt.setString(6, parameters);
                pstmt.setString(7, version);
                pstmt.setInt(8, dbversionId);
                pstmt.executeUpdate();
                result = dbversionId;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add/edit dosboxversion"}));
        }
        finally {
            this.closeAll(stmt, null);
            this.closeAll(pstmt, null);
        }
        return result;
    }

    public int addOrEditTemplate(String title, int dbversionId, boolean defaultVersion, int templateId) throws SQLException {
        int result = -1;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        try {
            if (defaultVersion) {
                stmt = con.createStatement();
                stmt.executeQuery(UPD_TEMPL_NODFLT);
            }
            if (templateId == -1) {
                pstmt = con.prepareStatement(ADD_TEMPLATE_QRY);
                pstmt.setString(1, title);
                pstmt.setInt(2, dbversionId);
                pstmt.setBoolean(3, defaultVersion);
                pstmt.executeUpdate();
                result = this.identity();
            } else {
                pstmt = con.prepareStatement(UPD_TEMPLATE_QRY);
                pstmt.setString(1, title);
                pstmt.setInt(2, dbversionId);
                pstmt.setBoolean(3, defaultVersion);
                pstmt.setInt(4, templateId);
                pstmt.executeUpdate();
                result = templateId;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add/edit template"}));
        }
        finally {
            this.closeAll(stmt, null);
            this.closeAll(pstmt, null);
        }
        return result;
    }

    public int addOrEditFilter(String title, String filter, int filterId) throws SQLException {
        int result = -1;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        try {
            if (filterId == -1) {
                pstmt = con.prepareStatement(ADD_FILTER_QRY);
                pstmt.setString(1, title);
                pstmt.setString(2, filter);
                pstmt.executeUpdate();
                result = this.identity();
            } else {
                pstmt = con.prepareStatement(UPD_FILTER_QRY);
                pstmt.setString(1, title);
                pstmt.setString(2, filter);
                pstmt.setInt(3, filterId);
                pstmt.executeUpdate();
                result = filterId;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add/edit filter"}));
        }
        finally {
            this.closeAll(stmt, null);
            this.closeAll(pstmt, null);
        }
        return result;
    }

    public int cleanup() throws SQLException {
        int result = -1;
        Statement stmt = null;
        ResultSet resultset = null;
        try {
            stmt = con.createStatement();
            for (String s : CLEANUP_QRY.split(";")) {
                stmt.addBatch(s);
            }
            int[] results = stmt.executeBatch();
            result = 0;
            for (int uc : results) {
                result += uc;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"cleanup"}));
        }
        finally {
            this.closeAll(stmt, resultset);
        }
        return result;
    }

    private static class DatabaseHolder {
        private static Database instance = new Database();

        private DatabaseHolder() {
        }
    }
}

