/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.IOException;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.DFendImportThread;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class DFendImportDialog
extends Dialog {
    private Text location;
    private Text logText;
    private DosboxVersion defaultDbversion;
    private DFendImportThread importThread;
    private Button cancelButton;
    private Label profileLabel;
    private Shell shell;
    private Settings settings;

    public DFendImportDialog(Shell parent, int style) {
        super(parent, style);
    }

    public DFendImportDialog(Shell parent) {
        this(parent, 0);
    }

    public void setDefaultDosboxVersion(DosboxVersion dbversion) {
        this.defaultDbversion = dbversion;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (this.importThread != null && !this.importThread.isAlive() && !this.cancelButton.getText().equals(this.settings.msg("button.close"))) {
                GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.dfendimport.notice.importok"));
                this.profileLabel.setText(this.settings.msg("dialog.dfendimport.reviewlog"));
                this.profileLabel.pack();
                this.cancelButton.setText(this.settings.msg("button.close"));
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.importThread;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout(new GridLayout());
        this.shell.addControlListener(new SizeControlAdapter(this.shell, "dfendimportdialog"));
        this.shell.setText(this.settings.msg("dialog.dfendimport.title"));
        Group optionsGroup = new Group(this.shell, 0);
        optionsGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        optionsGroup.setText(this.settings.msg("dialog.dfendimport.options"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        optionsGroup.setLayout(gridLayout);
        Label dfendLocLabel = new Label(optionsGroup, 0);
        dfendLocLabel.setText(this.settings.msg("dialog.dfendimport.dfendpath"));
        this.location = new Text(optionsGroup, 2048);
        this.location.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.location.setText("C:\\Program Files\\D-Fend\\Profiles.dat");
        final BrowseButton browseButton = new BrowseButton(optionsGroup, 0);
        browseButton.connect(this.shell, this.location, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DFEND, false, null);
        Label cleanUpLabel = new Label(optionsGroup, 0);
        cleanUpLabel.setText(this.settings.msg("dialog.dfendimport.cleanup"));
        final Button cleanup = new Button(optionsGroup, 32);
        cleanup.setText(this.settings.msg("dialog.dfendimport.removesections"));
        cleanup.setSelection(true);
        new Label(optionsGroup, 0);
        final Button startImportButton = new Button(optionsGroup, 0);
        this.shell.setDefaultButton(startImportButton);
        startImportButton.setLayoutData(new GridData(120, -1));
        startImportButton.setText(this.settings.msg("dialog.dfendimport.startimport"));
        this.cancelButton = new Button(optionsGroup, 0);
        this.cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DFendImportDialog.this.shell.close();
            }
        });
        this.cancelButton.setLayoutData(new GridData(80, -1));
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        new Label(optionsGroup, 0);
        Group progressGroup = new Group(this.shell, 0);
        progressGroup.setLayoutData(new GridData(4, 4, true, true));
        progressGroup.setText(this.settings.msg("dialog.dfendimport.progress"));
        progressGroup.setLayout(new GridLayout());
        final ProgressBar progressBar = new ProgressBar(progressGroup, 0);
        progressBar.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.profileLabel = new Label(progressGroup, 0);
        this.logText = new Text(progressGroup, 2826);
        this.logText.setLayoutData(new GridData(4, 4, true, true));
        startImportButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    DFendImportDialog.this.importThread = new DFendImportThread(new File(DFendImportDialog.this.location.getText()), cleanup.getSelection(), DFendImportDialog.this.defaultDbversion, DFendImportDialog.this.logText, progressBar, DFendImportDialog.this.profileLabel);
                    DFendImportDialog.this.location.setEnabled(false);
                    browseButton.setEnabled(false);
                    cleanup.setEnabled(false);
                    startImportButton.setEnabled(false);
                    DFendImportDialog.this.importThread.start();
                }
                catch (IOException ex) {
                    GeneralPurposeDialogs.warningMessage(DFendImportDialog.this.shell, ex.getMessage());
                    DFendImportDialog.this.importThread = null;
                }
            }
        });
    }
}

