/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.dbgl.db.Database;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public final class EditDosboxVersionDialog
extends Dialog {
    private Text parameters;
    private Text path;
    private Text title;
    private Button usingCurses;
    private Database dbase;
    private Object result;
    private Shell shell;
    private Settings settings;

    public EditDosboxVersionDialog(Shell parent) {
        super(parent, 0);
    }

    public void setDosboxVersion(DosboxVersion dbversion) {
        this.result = dbversion;
    }

    public Object open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout(new BorderLayout(0, 0));
        this.shell.addControlListener(new SizeControlAdapter(this.shell, "dosboxdialog"));
        if (this.result == null) {
            this.shell.setText(this.settings.msg("dialog.dosboxversion.title.add"));
        } else {
            this.shell.setText(this.settings.msg("dialog.dosboxversion.title.edit", new Object[]{((DosboxVersion)this.result).getTitle(), ((DosboxVersion)this.result).getId()}));
        }
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        TabItem infoTabItem = new TabItem(tabFolder, 0);
        infoTabItem.setText(this.settings.msg("dialog.dosboxversion.tab.info"));
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout(gridLayout);
        infoTabItem.setControl(composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(this.settings.msg("dialog.dosboxversion.title"));
        this.title = new Text(composite, 2048);
        this.title.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(this.settings.msg("dialog.dosboxversion.path"));
        this.path = new Text(composite, 2048);
        this.path.setLayoutData(new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton = new BrowseButton(composite, 0);
        browseButton.connect(this.shell, this.path, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.DOSBOX, false, null);
        Label parametersLabel = new Label(composite, 0);
        parametersLabel.setText(this.settings.msg("dialog.dosboxversion.parameters"));
        this.parameters = new Text(composite, 2048);
        this.parameters.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText(this.settings.msg("dialog.dosboxversion.version"));
        final Combo version = new Combo(composite, 2056);
        version.setLayoutData(new GridData(16384, 0x1000000, true, false));
        version.setItems(DosboxVersion.SUPP_RELEASES);
        version.setVisibleItemCount(15);
        version.select(version.getItemCount() - 1);
        new Label(composite, 0);
        Label multiconfLabel = new Label(composite, 0);
        multiconfLabel.setText(this.settings.msg("dialog.dosboxversion.multiconfsupport"));
        final Button multiconf = new Button(composite, 32);
        multiconf.setSelection(true);
        new Label(composite, 0);
        Label cursesLabel = new Label(composite, 0);
        cursesLabel.setText(this.settings.msg("dialog.dosboxversion.altstartup"));
        this.usingCurses = new Button(composite, 32);
        this.usingCurses.setText(this.settings.msg("dialog.dosboxversion.altstartupexplanation"));
        this.usingCurses.setSelection(false);
        this.usingCurses.setEnabled(PlatformUtils.IS_WINDOWS);
        this.usingCurses.setLayoutData(new GridData(4, 1, false, false, 2, 1));
        Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText(this.settings.msg("dialog.dosboxversion.default"));
        final Button defaultButton = new Button(composite, 32);
        new Label(composite, 0);
        Composite composite_7 = new Composite(this.shell, 0);
        composite_7.setLayout(new GridLayout(2, true));
        composite_7.setLayoutData("South");
        Button okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        okButton.setLayoutData(gridData);
        okButton.setText(this.settings.msg("button.ok"));
        okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditDosboxVersionDialog.this.isValid()) {
                    return;
                }
                try {
                    int dbversionId = EditDosboxVersionDialog.this.dbase.addOrEditDosboxVersion(EditDosboxVersionDialog.this.title.getText(), EditDosboxVersionDialog.this.path.getText(), multiconf.getSelection(), EditDosboxVersionDialog.this.usingCurses.getSelection(), defaultButton.getSelection(), EditDosboxVersionDialog.this.parameters.getText(), version.getText(), EditDosboxVersionDialog.this.result == null ? -1 : ((DosboxVersion)EditDosboxVersionDialog.this.result).getId());
                    EditDosboxVersionDialog.this.result = new DosboxVersion(dbversionId, EditDosboxVersionDialog.this.title.getText(), EditDosboxVersionDialog.this.path.getText(), multiconf.getSelection(), EditDosboxVersionDialog.this.usingCurses.getSelection(), defaultButton.getSelection(), EditDosboxVersionDialog.this.parameters.getText(), version.getText());
                }
                catch (SQLException e1) {
                    GeneralPurposeDialogs.warningMessage(EditDosboxVersionDialog.this.shell, e1.getMessage());
                }
                EditDosboxVersionDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button(composite_7, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = 4;
        cancelButton.setLayoutData(gridData_1);
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditDosboxVersionDialog.this.result = null;
                EditDosboxVersionDialog.this.shell.close();
            }
        });
        Label label = new Label(composite, 258);
        label.setLayoutData(new GridData(4, 0x1000000, false, false, 3, 1));
        Button editButton = new Button(composite, 0);
        editButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditDosboxVersionDialog.this.isValid()) {
                    return;
                }
                PlatformUtils.openForEditing(FileUtils.constructCanonicalDBConfLocation(EditDosboxVersionDialog.this.path.getText()));
            }
        });
        editButton.setLayoutData(new GridData(4, 0x1000000, false, false, 3, 1));
        editButton.setText(this.settings.msg("dialog.dosboxversion.editconfwitheditor"));
        if (this.result != null) {
            this.title.setText(((DosboxVersion)this.result).getTitle());
            this.path.setText(((DosboxVersion)this.result).getPath());
            this.parameters.setText(((DosboxVersion)this.result).getParameters());
            version.setText(((DosboxVersion)this.result).getVersion());
            defaultButton.setSelection(((DosboxVersion)this.result).isDefault());
            multiconf.setSelection(((DosboxVersion)this.result).isMultiConfig());
            this.usingCurses.setSelection(((DosboxVersion)this.result).isUsingCurses());
        }
        this.title.setFocus();
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.dosboxversion.required.title"), this.title);
        }
        if (this.path.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.dosboxversion.required.path"), this.path);
        }
        DosboxVersion dbversion = new DosboxVersion(-1, "", this.path.getText(), false, this.usingCurses.getSelection(), false, this.parameters.getText(), "");
        File executable = dbversion.getCanonicalExecutable();
        File configFile = dbversion.getCanonicalConfFile();
        boolean exeAvailable = FileUtils.isReadableFile(executable);
        if (!exeAvailable) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.dosboxversion.error.dosboxexemissing", new Object[]{executable}), this.path);
        }
        if (!FileUtils.isReadableFile(configFile) && exeAvailable && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.dosboxversion.confirm.createmissingdosboxconf", new Object[]{configFile}))) {
            try {
                FileUtils.doCreateDosboxConf(dbversion);
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
        if (!this.usingCurses.getSelection() && !FileUtils.isReadableFile(configFile)) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.dosboxversion.error.dosboxconfmissing", new Object[]{configFile}), this.path);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

