/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.MixerCommand;
import org.dbgl.model.conf.Settings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class EditMixerDialog
extends Dialog {
    private MixerCommand mixerCommand;
    private Object result;
    private Shell shell;
    private Settings settings = Settings.getInstance();

    public EditMixerDialog(Shell parent, int style) {
        super(parent, style);
    }

    public EditMixerDialog(Shell parent) {
        this(parent, 0);
    }

    public void setMixerCommand(String command) {
        this.mixerCommand = new MixerCommand(command);
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = MixerCommand.CHANNELS.length;
        this.shell.setLayout(gridLayout);
        this.shell.addControlListener(new SizeControlAdapter(this.shell, "mixerdialog"));
        this.shell.setText(this.settings.msg("dialog.mixer.title"));
        for (final String channelName : MixerCommand.CHANNELS) {
            Group channelGroup = new Group(this.shell, 0);
            channelGroup.setLayoutData(new GridData(4, 4, true, true));
            channelGroup.setText(this.settings.msg("dialog.mixer." + channelName));
            channelGroup.setLayout(new GridLayout(2, true));
            final Text left = new Text(channelGroup, 0);
            left.setEditable(false);
            left.setLayoutData(new GridData(1, 128, true, false));
            final Text right = new Text(channelGroup, 0);
            right.setEditable(false);
            right.setLayoutData(new GridData(1, 128, true, false));
            final Scale scaleLeft = new Scale(channelGroup, 512);
            scaleLeft.setLayoutData(new GridData(0x1000000, 4, true, true));
            scaleLeft.setMaximum(MixerCommand.MAX_VOLUME_LEVEL);
            scaleLeft.setPageIncrement(10);
            scaleLeft.setSelection(MixerCommand.MAX_VOLUME_LEVEL - this.mixerCommand.getVolumeFor(channelName).getLeft());
            final Scale scaleRight = new Scale(channelGroup, 512);
            scaleRight.setLayoutData(new GridData(0x1000000, 4, true, true));
            scaleRight.setMaximum(MixerCommand.MAX_VOLUME_LEVEL);
            scaleRight.setPageIncrement(10);
            scaleRight.setSelection(MixerCommand.MAX_VOLUME_LEVEL - this.mixerCommand.getVolumeFor(channelName).getRight());
            final Button lock = new Button(channelGroup, 32);
            GridData lockData = new GridData(0x1000000, 4, true, false);
            lockData.horizontalSpan = 2;
            lock.setLayoutData(lockData);
            lock.setText(this.settings.msg("dialog.mixer.lockbalance"));
            lock.setSelection(scaleLeft.getSelection() == scaleRight.getSelection());
            this.setVolumeBar(left, right, scaleLeft, scaleRight);
            scaleLeft.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    super.widgetSelected(arg0);
                    if (lock.getSelection()) {
                        scaleRight.setSelection(scaleLeft.getSelection());
                    }
                    EditMixerDialog.this.mixerCommand.setVolumeFor(channelName, MixerCommand.MAX_VOLUME_LEVEL - scaleLeft.getSelection(), MixerCommand.MAX_VOLUME_LEVEL - scaleRight.getSelection());
                    EditMixerDialog.this.setVolumeBar(left, right, scaleLeft, scaleRight);
                }
            });
            scaleRight.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    super.widgetSelected(arg0);
                    if (lock.getSelection()) {
                        scaleLeft.setSelection(scaleRight.getSelection());
                    }
                    EditMixerDialog.this.mixerCommand.setVolumeFor(channelName, MixerCommand.MAX_VOLUME_LEVEL - scaleLeft.getSelection(), MixerCommand.MAX_VOLUME_LEVEL - scaleRight.getSelection());
                    EditMixerDialog.this.setVolumeBar(left, right, scaleLeft, scaleRight);
                }
            });
        }
        Composite bc = new Composite(this.shell, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = gridLayout.numColumns;
        bc.setLayoutData(gd);
        bc.setLayout(new GridLayout(2, true));
        Button okButton = new Button(bc, 0);
        okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditMixerDialog.this.result = EditMixerDialog.this.mixerCommand.toString();
                EditMixerDialog.this.shell.close();
            }
        });
        okButton.setLayoutData(new GridData(80, -1));
        this.shell.setDefaultButton(okButton);
        okButton.setText(this.settings.msg("button.ok"));
        Button cancelButton = new Button(bc, 0);
        cancelButton.setLayoutData(new GridData(80, -1));
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditMixerDialog.this.result = null;
                EditMixerDialog.this.shell.close();
            }
        });
    }

    private void setVolumeBar(Text left, Text right, Scale scaleLeft, Scale scaleRight) {
        left.setText(this.settings.msg("dialog.mixer.leftchannelvolume", new Integer[]{MixerCommand.MAX_VOLUME_LEVEL - scaleLeft.getSelection()}));
        left.pack();
        right.setText(this.settings.msg("dialog.mixer.rightchannelvolume", new Integer[]{MixerCommand.MAX_VOLUME_LEVEL - scaleRight.getSelection()}));
        right.pack();
    }
}

