/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.AutoSelectCombo;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.BrowseMobyGamesDialog;
import org.dbgl.gui.EditMultiProfileDialog;
import org.dbgl.gui.EditTemplateDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.GrabButton;
import org.dbgl.gui.SettingsDialog;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.MobyProfile;
import org.dbgl.model.Profile;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.MobyGamesUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditProfileDialog
extends EditTemplateDialog {
    private static int AMOUNT_OF_LINKS = 4;
    private static int AMOUNT_OF_CUSTOM_STRINGS = 4;
    private boolean focusOnTitle = false;
    private List<KeyValuePair> developersList;
    private List<KeyValuePair> publishersList;
    private List<KeyValuePair> genresList;
    private List<KeyValuePair> yearsList;
    private List<Template> templatesList;
    private List<KeyValuePair> statusList;
    private List<List<KeyValuePair>> customList = new ArrayList<List<KeyValuePair>>();
    private AutoSelectCombo developer;
    private AutoSelectCombo publisher;
    private AutoSelectCombo genre;
    private AutoSelectCombo year;
    private AutoSelectCombo status;
    private Button mobyGames;
    private Button templateReload;
    private Text[] link = new Text[AMOUNT_OF_LINKS];
    private Text[] linkTitle = new Text[AMOUNT_OF_LINKS];
    private BrowseButton[] linkBrowseButton = new BrowseButton[AMOUNT_OF_LINKS];
    private Button favorite;
    private Text notes;
    private AutoSelectCombo[] customCombo = new AutoSelectCombo[AMOUNT_OF_CUSTOM_STRINGS];
    private Text[] customText = new Text[AMOUNT_OF_CUSTOM_STRINGS];
    private Scale custom9;
    private Spinner custom10;
    private Combo template;
    private Button loadfix;
    private Combo loadfix_value;
    private Text main;
    private Text main_params;
    private Text setup;
    private Text setup_params;
    private Text img1;
    private Text img2;
    private Text img3;
    protected ExpProfile multiProfileCombined;
    private int templateIndex = -1;

    public EditProfileDialog(Shell parent) {
        super(parent);
    }

    public void setProfile(Profile prof) {
        this.result = prof;
    }

    public void setConfigurables(List<Configurable> configurables) {
        this.multiProfileList = configurables;
        if (this.multiProfileList.size() == 1) {
            this.setProfile((ExpProfile)this.multiProfileList.get(0));
            this.multiProfileList.remove(0);
        }
    }

    public void setMultiProfileCombined(ExpProfile multiProfileCombined) {
        this.multiProfileCombined = multiProfileCombined;
    }

    public void sendToProfile(String file) {
        this.result = FileUtils.makeRelativeToDosroot(new File(file)).getPath();
    }

    public void focusTitle() {
        this.focusOnTitle = true;
    }

    @Override
    protected boolean init() {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            this.developersList = this.dbase.readDevelopersList();
            this.publishersList = this.dbase.readPublishersList();
            this.genresList = this.dbase.readGenresList();
            this.yearsList = this.dbase.readYearsList();
            this.templatesList = this.dbase.readTemplatesList();
            this.statusList = this.dbase.readStatusList();
            for (int i = 0; i < AMOUNT_OF_CUSTOM_STRINGS; ++i) {
                this.customList.add(this.dbase.readCustomList(i));
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            if (this.result instanceof Profile) {
                Profile profile = (Profile)this.result;
                this.dbversionIndex = DosboxVersion.findById(this.dbversionsList, profile.getDbversionId());
                DosboxVersion dbversion = (DosboxVersion)this.dbversionsList.get(this.dbversionIndex);
                Conf cc = new Conf(profile, dbversion, ps);
                if (cc.getAutoexec().isIncomplete() && !GeneralPurposeDialogs.confirmMessage(this.getParent(), this.settings.msg("dialog.profile.confirm.profileincomplete", new Object[]{"dosbox.conf", dbversion.getCanonicalConfFile()}))) {
                    return false;
                }
                this.multiProfileList.add(new ExpProfile(profile.getId(), cc, FileUtils.makeRelativeToDosroot(cc.getAutoexec().getCanonicalMainDir()), profile));
            } else if (this.isMultiEdit()) {
                this.dbversionIndex = DosboxVersion.findById(this.dbversionsList, this.multiProfileCombined.getDbversionId());
            } else {
                this.dbversionIndex = DosboxVersion.findDefault(this.dbversionsList);
                DosboxVersion dbversion = (DosboxVersion)this.dbversionsList.get(this.dbversionIndex);
                this.templateIndex = Template.findDefault(this.templatesList);
                Conf cc = null;
                cc = this.result instanceof String && FileUtils.isConfFile((String)this.result) ? new Conf(FileUtils.canonicalToDosroot((String)this.result), (Template)null, dbversion, ps) : (this.templateIndex != -1 ? new Conf((File)null, this.templatesList.get(this.templateIndex), dbversion, ps) : new Conf((File)null, (Template)null, dbversion, ps));
                this.multiProfileList.add(new ExpProfile(cc));
            }
            if (bos.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), bos.toString());
                bos.reset();
            }
            return true;
        }
        catch (Exception e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e.getMessage());
            return false;
        }
    }

    @Override
    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout(new BorderLayout(0, 0));
        this.shell.addControlListener(new SizeControlAdapter(this.shell, "profiledialog"));
        if (this.result instanceof Profile) {
            this.shell.setText(this.settings.msg("dialog.profile.title.edit", new Object[]{((Profile)this.result).getTitle(), ((Profile)this.result).getId()}));
        } else if (this.isMultiEdit()) {
            this.shell.setText(this.settings.msg("dialog.multiprofile.title.edit", new Object[]{this.multiProfileList.size()}));
        } else if (this.result instanceof String) {
            this.shell.setText(this.settings.msg("dialog.profile.title.send", new Object[]{(String)this.result}));
        } else {
            this.shell.setText(this.settings.msg("dialog.profile.title.add"));
        }
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        this.createInfoTab(tabFolder);
        this.createCustomTab(tabFolder);
        this.createGeneralTab(tabFolder);
        this.createDisplayTab(tabFolder);
        this.createMachineTab(tabFolder);
        this.createAudioTab(tabFolder);
        this.createIOTab(tabFolder);
        this.createMountingTab(tabFolder);
        this.createOkCancelButtons();
        this.okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditProfileDialog.this.isValid()) {
                    return;
                }
                if (EditProfileDialog.this.isMultiEdit()) {
                    EditProfileDialog.this.updateAllConfigurationsBySettings();
                    EditMultiProfileDialog empDialog = new EditMultiProfileDialog(EditProfileDialog.this.shell);
                    DosboxVersion newDbversion = null;
                    if (EditProfileDialog.this.dbversion.getSelectionIndex() != -1) {
                        newDbversion = (DosboxVersion)EditProfileDialog.this.dbversionsList.get(EditProfileDialog.this.dbversion.getSelectionIndex());
                    }
                    Profile newProfile = new Profile(-1, EditProfileDialog.this.fetch(EditProfileDialog.this.title), EditProfileDialog.this.fetch(EditProfileDialog.this.developer), EditProfileDialog.this.fetch(EditProfileDialog.this.publisher), EditProfileDialog.this.fetch(EditProfileDialog.this.genre), EditProfileDialog.this.fetch(EditProfileDialog.this.year), newDbversion != null ? newDbversion.getId() : -1, EditProfileDialog.this.fetch(EditProfileDialog.this.setup), EditProfileDialog.this.fetch(EditProfileDialog.this.setup_params), EditProfileDialog.this.fetch(EditProfileDialog.this.notes), EditProfileDialog.this.fetch(EditProfileDialog.this.link[0]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[1]), EditProfileDialog.this.fetch(EditProfileDialog.this.favorite), EditProfileDialog.this.fetch(EditProfileDialog.this.status), null, null, EditProfileDialog.this.fetch(EditProfileDialog.this.link[2]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[3]), EditProfileDialog.this.fetch(EditProfileDialog.this.customCombo[0]), EditProfileDialog.this.fetch(EditProfileDialog.this.customCombo[1]), EditProfileDialog.this.fetch(EditProfileDialog.this.customCombo[2]), EditProfileDialog.this.fetch(EditProfileDialog.this.customCombo[3]), EditProfileDialog.this.fetch(EditProfileDialog.this.customText[0]), EditProfileDialog.this.fetch(EditProfileDialog.this.customText[1]), EditProfileDialog.this.fetch(EditProfileDialog.this.customText[2]), EditProfileDialog.this.fetch(EditProfileDialog.this.customText[3]), EditProfileDialog.this.fetch(EditProfileDialog.this.custom9), EditProfileDialog.this.fetch(EditProfileDialog.this.custom10), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[0]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[1]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[2]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[3]));
                    for (int i = 0; i < EditProfileDialog.this.multiProfileList.size(); ++i) {
                        ExpProfile ep = (ExpProfile)EditProfileDialog.this.multiProfileList.get(i);
                        ep = new ExpProfile(ep, newProfile);
                        EditProfileDialog.this.multiProfileList.set(i, ep);
                    }
                    empDialog.setData(EditProfileDialog.this.multiProfileList, EditProfileDialog.this.mobyGames.getSelection());
                    if (empDialog.open() != null) {
                        EditProfileDialog.this.result = EditProfileDialog.this.multiProfileList;
                        EditProfileDialog.this.shell.close();
                    }
                } else {
                    try {
                        String capturesString;
                        Conf compConf = ((Configurable)EditProfileDialog.this.multiProfileList.get(0)).getConf();
                        int profileId = EditProfileDialog.this.dbase.addOrEditProfile(EditProfileDialog.this.title.getText(), EditProfileDialog.this.developer.getText(), EditProfileDialog.this.publisher.getText(), EditProfileDialog.this.genre.getText(), EditProfileDialog.this.year.getText(), EditProfileDialog.this.status.getText(), EditProfileDialog.this.setup.getText(), EditProfileDialog.this.setup_params.getText(), EditProfileDialog.this.notes.getText(), EditProfileDialog.this.favorite.getSelection(), compConf.getDbversion().getId(), new String[]{EditProfileDialog.this.link[0].getText(), EditProfileDialog.this.link[1].getText(), EditProfileDialog.this.link[2].getText(), EditProfileDialog.this.link[3].getText()}, new String[]{EditProfileDialog.this.customCombo[0].getText(), EditProfileDialog.this.customCombo[1].getText(), EditProfileDialog.this.customCombo[2].getText(), EditProfileDialog.this.customCombo[3].getText(), EditProfileDialog.this.customText[0].getText(), EditProfileDialog.this.customText[1].getText(), EditProfileDialog.this.customText[2].getText(), EditProfileDialog.this.customText[3].getText()}, new int[]{EditProfileDialog.this.custom9.getSelection(), EditProfileDialog.this.custom10.getSelection()}, new String[]{EditProfileDialog.this.linkTitle[0].getText(), EditProfileDialog.this.linkTitle[1].getText(), EditProfileDialog.this.linkTitle[2].getText(), EditProfileDialog.this.linkTitle[3].getText()}, EditProfileDialog.this.result instanceof Profile ? ((Profile)EditProfileDialog.this.result).getId() : -1);
                        EditProfileDialog.this.updateAllConfigurationsBySettings();
                        String confString = EditProfileDialog.this.result instanceof Profile ? ((Profile)EditProfileDialog.this.result).getConfPathAndFile() : FileUtils.constructUniqueConfigFileString(profileId, EditProfileDialog.this.title.getText(), compConf.getAutoexec().getCanonicalMainDir());
                        if (EditProfileDialog.this.result instanceof Profile) {
                            capturesString = ((Profile)EditProfileDialog.this.result).getCaptures();
                        } else {
                            capturesString = FileUtils.constructCapturesDir(profileId);
                            FileUtils.createDir(FileUtils.canonicalToData(capturesString));
                        }
                        if (!(EditProfileDialog.this.result instanceof Profile)) {
                            EditProfileDialog.this.dbase.updateProfileConf(confString, capturesString, profileId);
                        }
                        EditProfileDialog.this.result = new Profile(profileId, EditProfileDialog.this.title.getText(), EditProfileDialog.this.developer.getText(), EditProfileDialog.this.publisher.getText(), EditProfileDialog.this.genre.getText(), EditProfileDialog.this.year.getText(), compConf.getDbversion().getId(), EditProfileDialog.this.setup.getText(), EditProfileDialog.this.setup_params.getText(), EditProfileDialog.this.notes.getText(), EditProfileDialog.this.link[0].getText(), EditProfileDialog.this.link[1].getText(), EditProfileDialog.this.favorite.getSelection(), EditProfileDialog.this.status.getText(), confString, capturesString, EditProfileDialog.this.link[2].getText(), EditProfileDialog.this.link[3].getText(), EditProfileDialog.this.customCombo[0].getText(), EditProfileDialog.this.customCombo[1].getText(), EditProfileDialog.this.customCombo[2].getText(), EditProfileDialog.this.customCombo[3].getText(), EditProfileDialog.this.customText[0].getText(), EditProfileDialog.this.customText[1].getText(), EditProfileDialog.this.customText[2].getText(), EditProfileDialog.this.customText[3].getText(), EditProfileDialog.this.custom9.getSelection(), EditProfileDialog.this.custom10.getSelection(), EditProfileDialog.this.linkTitle[0].getText(), EditProfileDialog.this.linkTitle[1].getText(), EditProfileDialog.this.linkTitle[2].getText(), EditProfileDialog.this.linkTitle[3].getText());
                        compConf.injectOrUpdateProfile((Profile)EditProfileDialog.this.result);
                        compConf.save();
                    }
                    catch (Exception e1) {
                        GeneralPurposeDialogs.warningMessage(EditProfileDialog.this.shell, e1.getMessage());
                    }
                    EditProfileDialog.this.shell.close();
                }
            }
        });
        for (DosboxVersion dbv : this.dbversionsList) {
            this.dbversion.add(dbv.getTitle());
        }
        for (Template templ : this.templatesList) {
            this.template.add(templ.getTitle());
        }
        this.dbversion.select(this.dbversionIndex);
        this.templateReload.setEnabled(this.dbversionIndex != -1);
        if (this.result instanceof Profile) {
            this.setProfileMetaData((Profile)this.result);
            if (this.focusOnTitle) {
                this.title.selectAll();
                this.title.setFocus();
            }
        } else if (this.isMultiEdit()) {
            this.setProfileMetaData(this.multiProfileCombined);
        } else {
            this.title.setFocus();
            if (this.templateIndex != -1) {
                this.template.select(this.templateIndex);
            }
        }
        if (this.isMultiEdit()) {
            this.enableSettingsByConfiguration(this.multiProfileCombined.getConf().getDosboxSettings());
            this.selectSettingsByConfiguration(this.multiProfileCombined.getConf());
        } else {
            this.enableSettingsByConfiguration(((Configurable)this.multiProfileList.get(0)).getConf().getDosboxSettings());
            this.selectSettingsByConfiguration(((Configurable)this.multiProfileList.get(0)).getConf());
        }
        this.startListeners();
        if (this.result instanceof String) {
            if (FileUtils.isExecutable((String)this.result)) {
                this.main.setText((String)this.result);
            } else if (FileUtils.isBooterImage((String)this.result)) {
                this.img1.setText((String)this.result);
            }
        }
    }

    @Override
    protected void createMachineTab(TabFolder tabFolder) {
        super.createMachineTab(tabFolder);
        Label loadfixLabel = new Label(this.memoryGroup, 0);
        loadfixLabel.setText(this.settings.msg("dialog.profile.loadfix"));
        this.loadfix = new Button(this.memoryGroup, 32);
        this.loadfix.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditProfileDialog.this.loadfix_value.setEnabled(EditProfileDialog.this.loadfix.getSelection());
            }
        });
        this.loadfix_value = new Combo(this.memoryGroup, 0);
        this.loadfix_value.setItems(this.settings.getSettings().getValues("profile", "loadfix_value"));
        this.loadfix_value.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label kbLabel = new Label(this.memoryGroup, 0);
        kbLabel.setText(this.settings.msg("dialog.profile.kb"));
    }

    @Override
    protected void createInfoTab(TabFolder tabFolder) {
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText(this.settings.msg("dialog.profile.tab.info"));
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        composite.setLayout(gridLayout);
        this.infoTabItem.setControl(composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(this.settings.msg("dialog.profile.title"));
        this.title = new Text(composite, 2048);
        this.title.setLayoutData(new GridData(4, 0x1000000, true, false, 5, 1));
        this.mobyGames = GeneralPurposeGUI.createIconButton(composite, this.isMultiEdit() ? 2 : 8, this.settings, this.settings.msg("dialog.profile.consultmobygames"), "moby.png");
        if (!this.isMultiEdit()) {
            this.mobyGames.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MobyProfile orgProf = (MobyProfile)EditProfileDialog.this.mobyGames.getData();
                    if (orgProf == null) {
                        String currTitle = EditProfileDialog.this.title.getText();
                        if (currTitle.length() >= 1) {
                            try {
                                MobyProfile thisGame = null;
                                List<MobyProfile> mobyGamesList = MobyGamesUtils.getEntries(currTitle, EditProfileDialog.this.settings.getSettings().getValues("mobygames", "platform_filter"));
                                if (mobyGamesList.size() == 0) {
                                    GeneralPurposeDialogs.infoMessage(EditProfileDialog.this.shell, EditProfileDialog.this.settings.msg("general.notice.mobygamesnoresults", new String[]{currTitle}));
                                } else if (mobyGamesList.size() == 1) {
                                    thisGame = mobyGamesList.get(0);
                                } else {
                                    BrowseMobyGamesDialog mobyDialog = new BrowseMobyGamesDialog(EditProfileDialog.this.shell);
                                    mobyDialog.setProfilesToBrowse(currTitle, mobyGamesList);
                                    Integer idx = (Integer)mobyDialog.open();
                                    if (idx != null) {
                                        thisGame = mobyGamesList.get(idx);
                                    }
                                }
                                if (thisGame != null) {
                                    String p;
                                    String n;
                                    MobyProfile profExt = MobyGamesUtils.getEntry(thisGame);
                                    MobyProfile currentProf = new MobyProfile();
                                    currentProf.setTitle(EditProfileDialog.this.title.getText());
                                    currentProf.setDeveloperName(EditProfileDialog.this.developer.getText());
                                    currentProf.setPublisherName(EditProfileDialog.this.publisher.getText());
                                    currentProf.setYear(EditProfileDialog.this.year.getText());
                                    currentProf.setGenre(EditProfileDialog.this.genre.getText());
                                    currentProf.setUrl(EditProfileDialog.this.link[0].getText());
                                    currentProf.setPlatform(EditProfileDialog.this.linkTitle[0].getText());
                                    currentProf.setNotes(EditProfileDialog.this.notes.getText());
                                    currentProf.setRank(EditProfileDialog.this.custom9.getSelection());
                                    EditProfileDialog.this.mobyGames.setData(currentProf);
                                    EditProfileDialog.this.mobyGames.setText(EditProfileDialog.this.settings.msg("dialog.profile.undomobygames"));
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue("mobygames", "set_title")) {
                                        EditProfileDialog.this.title.setText(profExt.getTitle());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue("mobygames", "set_developer")) {
                                        EditProfileDialog.this.developer.setText(profExt.getDeveloperName());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue("mobygames", "set_publisher")) {
                                        EditProfileDialog.this.publisher.setText(profExt.getPublisherName());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue("mobygames", "set_year")) {
                                        EditProfileDialog.this.year.setText(profExt.getYear());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue("mobygames", "set_genre")) {
                                        EditProfileDialog.this.genre.setText(profExt.getGenre());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue("mobygames", "set_link")) {
                                        EditProfileDialog.this.link[0].setText(profExt.getUrl());
                                        EditProfileDialog.this.linkTitle[0].setText(EditProfileDialog.this.settings.msg("dialog.profile.mobygames.link.maininfo"));
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue("mobygames", "set_description") && !(n = EditProfileDialog.this.notes.getText()).endsWith(p = profExt.getNotes().replaceAll("\n", EditProfileDialog.this.notes.getLineDelimiter()))) {
                                        if (n.length() > 0) {
                                            EditProfileDialog.this.notes.append(EditProfileDialog.this.notes.getLineDelimiter() + EditProfileDialog.this.notes.getLineDelimiter());
                                        }
                                        EditProfileDialog.this.notes.append(p);
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue("mobygames", "set_rank")) {
                                        EditProfileDialog.this.custom9.setSelection(profExt.getRank());
                                    }
                                }
                            }
                            catch (Exception e1) {
                                GeneralPurposeDialogs.warningMessage(EditProfileDialog.this.shell, EditProfileDialog.this.settings.msg("general.error.retrieveinfomobygames", new String[]{currTitle, e1.toString()}));
                            }
                        }
                    } else {
                        EditProfileDialog.this.title.setText(orgProf.getTitle());
                        EditProfileDialog.this.developer.setText(orgProf.getDeveloperName());
                        EditProfileDialog.this.publisher.setText(orgProf.getPublisherName());
                        EditProfileDialog.this.year.setText(orgProf.getYear());
                        EditProfileDialog.this.genre.setText(orgProf.getGenre());
                        EditProfileDialog.this.link[0].setText(orgProf.getUrl());
                        EditProfileDialog.this.linkTitle[0].setText(orgProf.getPlatform());
                        EditProfileDialog.this.notes.setText(orgProf.getNotes());
                        EditProfileDialog.this.custom9.setSelection(orgProf.getRank());
                        EditProfileDialog.this.mobyGames.setData(null);
                        EditProfileDialog.this.mobyGames.setText(EditProfileDialog.this.settings.msg("dialog.profile.consultmobygames"));
                    }
                }
            });
        }
        int minimumComboWidth = this.settings.getSettings().getIntValue("gui", "profiledialog_width") / 3;
        Label developerLabel = new Label(composite, 0);
        developerLabel.setText(this.settings.msg("dialog.profile.developer"));
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.minimumWidth = minimumComboWidth;
        this.developer = new AutoSelectCombo(composite, 0, this.developersList, gd);
        Label publisherLabel = new Label(composite, 0);
        publisherLabel.setLayoutData(new GridData());
        publisherLabel.setText(this.settings.msg("dialog.profile.publisher"));
        GridData gd2 = new GridData(4, 0x1000000, true, false, 3, 1);
        gd2.minimumWidth = minimumComboWidth;
        this.publisher = new AutoSelectCombo(composite, 0, this.publishersList, gd2);
        Label genreLabel = new Label(composite, 0);
        genreLabel.setText(this.settings.msg("dialog.profile.genre"));
        this.genre = new AutoSelectCombo(composite, 0, this.genresList, new GridData(4, 0x1000000, true, false, 2, 1));
        Label yearLabel = new Label(composite, 0);
        yearLabel.setLayoutData(new GridData());
        yearLabel.setText(this.settings.msg("dialog.profile.year"));
        this.year = new AutoSelectCombo(composite, 0, this.yearsList, new GridData(4, 0x1000000, true, false, 3, 1));
        for (int i = 0; i < AMOUNT_OF_LINKS; ++i) {
            Label linkLabel = new Label(composite, 0);
            linkLabel.setText(this.settings.msg("dialog.profile.link" + (i + 1)));
            this.link[i] = new Text(composite, 2048);
            this.link[i].setLayoutData(new GridData(4, 0x1000000, true, false));
            this.linkBrowseButton[i] = new BrowseButton(composite, 0);
            Label linkTitleLabel = new Label(composite, 0);
            linkTitleLabel.setText(this.settings.msg("dialog.profile.linktitle"));
            this.linkTitle[i] = new Text(composite, 2048);
            this.linkTitle[i].setLayoutData(new GridData(4, 0x1000000, true, false, 3, 1));
        }
        Label statusLabel = new Label(composite, 0);
        statusLabel.setText(this.settings.msg("dialog.profile.status"));
        this.status = new AutoSelectCombo(composite, 0, this.statusList, new GridData(4, 0x1000000, true, false, 2, 1));
        Label favoriteLabel = new Label(composite, 0);
        favoriteLabel.setText(this.settings.msg("dialog.profile.favorite"));
        this.favorite = new Button(composite, 32);
        Label label = new Label(composite, 0);
        label.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        Label notesLabel = new Label(composite, 0);
        notesLabel.setText(this.settings.msg("dialog.profile.notes"));
        this.notes = new Text(composite, 2626);
        this.notes.setLayoutData(new GridData(4, 4, true, true, 6, 1));
    }

    protected void createCustomTab(TabFolder tabFolder) {
        Label customLabel;
        int i;
        TabItem customTabItem = new TabItem(tabFolder, 0);
        customTabItem.setText(this.settings.msg("dialog.profile.tab.custominfo"));
        Composite composite_8 = new Composite(tabFolder, 0);
        GridLayout gridLayout_21 = new GridLayout();
        gridLayout_21.numColumns = 2;
        composite_8.setLayout(gridLayout_21);
        customTabItem.setControl(composite_8);
        for (i = 0; i < AMOUNT_OF_CUSTOM_STRINGS; ++i) {
            customLabel = new Label(composite_8, 0);
            customLabel.setText(this.settings.getSettings().getValue("gui", "custom" + (i + 1)));
            this.customCombo[i] = new AutoSelectCombo(composite_8, 0, this.customList.get(i), new GridData(4, 0x1000000, true, false));
        }
        for (i = 0; i < AMOUNT_OF_CUSTOM_STRINGS; ++i) {
            customLabel = new Label(composite_8, 0);
            customLabel.setText(this.settings.getSettings().getValue("gui", "custom" + (i + 1 + AMOUNT_OF_CUSTOM_STRINGS)));
            this.customText[i] = new Text(composite_8, 2048);
            this.customText[i].setLayoutData(new GridData(4, 0x1000000, true, false));
        }
        Label custom9Label = new Label(composite_8, 0);
        custom9Label.setText(this.settings.getSettings().getValue("gui", "custom9"));
        this.custom9 = new Scale(composite_8, 0);
        this.custom9.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label custom10Label = new Label(composite_8, 0);
        custom10Label.setText(this.settings.getSettings().getValue("gui", "custom10"));
        this.custom10 = new Spinner(composite_8, 2048);
        this.custom10.setLayoutData(new GridData(100, -1));
        this.custom10.setMinimum(Integer.MIN_VALUE);
        this.custom10.setMaximum(Integer.MAX_VALUE);
    }

    @Override
    protected void createGeneralTab(TabFolder tabFolder) {
        super.createGeneralTab(tabFolder);
        Label templateLabel = new Label(this.associationGroup, 0);
        templateLabel.setText(this.settings.msg("dialog.profile.template"));
        this.template = new Combo(this.associationGroup, 8);
        this.template.setLayoutData(new GridData(4, 0x1000000, true, false, 3, 1));
        this.template.setVisibleItemCount(10);
        this.templateReload = new Button(this.associationGroup, 0);
        this.templateReload.setText(this.settings.msg("dialog.profile.reloadsettings"));
        this.templateReload.setToolTipText(this.settings.msg("dialog.profile.reloadsettings.tooltip"));
        this.templateReload.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (EditProfileDialog.this.template.getSelectionIndex() != -1) {
                    if (EditProfileDialog.this.setButton.isEnabled()) {
                        GeneralPurposeDialogs.initErrorDialog();
                        GeneralPurposeDialogs.addError(EditProfileDialog.this.settings.msg("dialog.template.required.dosboxassociation"), EditProfileDialog.this.setButton, EditProfileDialog.this.generalTabItem);
                        GeneralPurposeDialogs.displayErrorDialog(EditProfileDialog.this.shell);
                        return;
                    }
                    EditProfileDialog.this.doPerformDosboxConfAction(EditTemplateDialog.DosboxConfAction.RELOAD_TEMPLATE);
                }
            }
        });
        this.config_file.setText(this.result instanceof Profile ? ((Profile)this.result).getConfPathAndFile() : SettingsDialog.confLocations[this.settings.getSettings().getIntValue("profiledefaults", "confpath")] + ", " + SettingsDialog.confFilenames[this.settings.getSettings().getIntValue("profiledefaults", "conffile")]);
    }

    @Override
    protected void createExecuteGroup(Composite composite) {
        Group executeGroup = new Group(composite, 0);
        executeGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        executeGroup.setText(this.settings.msg("dialog.profile.execute"));
        GridLayout gridLayout_18 = new GridLayout();
        gridLayout_18.numColumns = 6;
        executeGroup.setLayout(gridLayout_18);
        this.dosButton = new Button(executeGroup, 16);
        this.dosButton.setText(this.settings.msg("dialog.template.dos"));
        Label mainExeLabel = new Label(executeGroup, 0);
        mainExeLabel.setText(this.settings.msg("dialog.profile.mainexe"));
        this.main = new Text(executeGroup, 2048);
        this.main.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        for (int i = 0; i < AMOUNT_OF_LINKS; ++i) {
            this.linkBrowseButton[i].connect(this.shell, this.link[i], this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DOC, false, null);
        }
        BrowseButton mainBrowseButton = new BrowseButton(executeGroup, 0);
        mainBrowseButton.connect(this.shell, this.main, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, this.pixelshader);
        GrabButton grab1 = new GrabButton(executeGroup, 0);
        grab1.connect(this.main, this.mountingpoints);
        new Label(executeGroup, 0);
        new Label(executeGroup, 0);
        Label parametersLabel = new Label(executeGroup, 0);
        parametersLabel.setLayoutData(new GridData());
        parametersLabel.setText(this.settings.msg("dialog.profile.mainparameters"));
        this.main_params = new Text(executeGroup, 2048);
        this.main_params.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(executeGroup, 0);
        new Label(executeGroup, 0);
        new Label(executeGroup, 0);
        Label setupLabel = new Label(executeGroup, 0);
        setupLabel.setLayoutData(new GridData());
        setupLabel.setText(this.settings.msg("dialog.profile.setupexe"));
        this.setup = new Text(executeGroup, 2048);
        this.setup.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        BrowseButton setupBrowseButton = new BrowseButton(executeGroup, 0);
        setupBrowseButton.connect(this.shell, this.setup, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, this.pixelshader);
        GrabButton grab2 = new GrabButton(executeGroup, 0);
        grab2.connect(this.setup, this.mountingpoints);
        new Label(executeGroup, 0);
        new Label(executeGroup, 0);
        Label parametersLabel_1 = new Label(executeGroup, 0);
        parametersLabel_1.setLayoutData(new GridData());
        parametersLabel_1.setText(this.settings.msg("dialog.profile.setupparameters"));
        this.setup_params = new Text(executeGroup, 2048);
        this.setup_params.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(executeGroup, 0);
        new Label(executeGroup, 0);
        Label label_1 = new Label(executeGroup, 258);
        label_1.setLayoutData(new GridData(4, 0x1000000, false, false, 6, 1));
        this.booterButton = new Button(executeGroup, 16);
        this.booterButton.setText(this.settings.msg("dialog.template.booter"));
        Label image1Label = new Label(executeGroup, 0);
        image1Label.setText(this.settings.msg("dialog.profile.booterimage1"));
        this.img1 = new Text(executeGroup, 2048);
        this.img1.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        BrowseButton img1BrowseButton = new BrowseButton(executeGroup, 0);
        img1BrowseButton.connect(this.shell, this.img1, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, false, null);
        GrabButton grab3 = new GrabButton(executeGroup, 0);
        grab3.connect(this.img1, this.mountingpoints);
        new Label(executeGroup, 0);
        Label image2Label = new Label(executeGroup, 0);
        image2Label.setText(this.settings.msg("dialog.profile.booterimage2"));
        this.img2 = new Text(executeGroup, 2048);
        this.img2.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        BrowseButton img2BrowseButton = new BrowseButton(executeGroup, 0);
        img2BrowseButton.connect(this.shell, this.img2, this.img1, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, false, null);
        GrabButton grab4 = new GrabButton(executeGroup, 0);
        grab4.connect(this.img2, this.mountingpoints);
        new Label(executeGroup, 0);
        Label image3Label = new Label(executeGroup, 0);
        image3Label.setText(this.settings.msg("dialog.profile.booterimage3"));
        this.img3 = new Text(executeGroup, 2048);
        this.img3.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        BrowseButton img3BrowseButton = new BrowseButton(executeGroup, 0);
        img3BrowseButton.connect(this.shell, this.img3, this.img1, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, false, null);
        GrabButton grab5 = new GrabButton(executeGroup, 0);
        grab5.connect(this.img3, this.mountingpoints);
        if (this.isMultiEdit()) {
            this.dosButton.setEnabled(false);
            this.booterButton.setEnabled(false);
            this.main.setEnabled(false);
            this.main_params.setEnabled(false);
            mainBrowseButton.setEnabled(false);
            this.setup.setEnabled(false);
            this.setup_params.setEnabled(false);
            setupBrowseButton.setEnabled(false);
            this.img1.setEnabled(false);
            img1BrowseButton.setEnabled(false);
            this.img2.setEnabled(false);
            img2BrowseButton.setEnabled(false);
            this.img3.setEnabled(false);
            img3BrowseButton.setEnabled(false);
            grab1.setEnabled(false);
            grab2.setEnabled(false);
            grab3.setEnabled(false);
            grab4.setEnabled(false);
            grab5.setEnabled(false);
        }
    }

    private void startListeners() {
        VerifyListener addMountListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (event.text.length() > 1) {
                    boolean booter = event.widget == EditProfileDialog.this.img1 || event.widget == EditProfileDialog.this.img2 || event.widget == EditProfileDialog.this.img3;
                    EditProfileDialog.this.addMountIfNoMounts(event.text, booter);
                }
            }
        };
        ModifyListener exeListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                boolean booter = event.widget == EditProfileDialog.this.img1 || event.widget == EditProfileDialog.this.img2 || event.widget == EditProfileDialog.this.img3;
                EditProfileDialog.this.dosButton.setSelection(!booter);
                EditProfileDialog.this.booterButton.setSelection(booter);
            }
        };
        this.main.addVerifyListener(addMountListener);
        this.setup.addVerifyListener(addMountListener);
        this.img1.addVerifyListener(addMountListener);
        this.img2.addVerifyListener(addMountListener);
        this.img3.addVerifyListener(addMountListener);
        this.main.addModifyListener(exeListener);
        this.main_params.addModifyListener(exeListener);
        this.setup.addModifyListener(exeListener);
        this.setup_params.addModifyListener(exeListener);
        this.img1.addModifyListener(exeListener);
        this.img2.addModifyListener(exeListener);
        this.img3.addModifyListener(exeListener);
        if (this.isMultiEdit()) {
            ModifyListener changeMarker = new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    Control cntrl = (Control)arg0.widget;
                    cntrl.setData(new Boolean(true));
                    EditTemplateDialog.highlight(cntrl, 3);
                }
            };
            SelectionListener selectionMarker = new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    Control cntrl = (Control)arg0.widget;
                    cntrl.setData(new Boolean(true));
                    EditTemplateDialog.highlight(cntrl, 3);
                    if (cntrl instanceof Button) {
                        ((Button)cntrl).setGrayed(false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.widgetSelected(arg0);
                }
            };
            for (Control child : this.shell.getChildren()) {
                if (!(child instanceof TabFolder)) continue;
                TabFolder tabs = (TabFolder)child;
                for (TabItem tab : tabs.getItems()) {
                    Composite composite = (Composite)tab.getControl();
                    for (Control c : EditProfileDialog.getChangeables(composite)) {
                        Control cntrl;
                        if (c instanceof Combo) {
                            cntrl = (Combo)c;
                            cntrl.setData(new Boolean(false));
                            ((Combo)cntrl).addModifyListener(changeMarker);
                            continue;
                        }
                        if (c instanceof Text) {
                            cntrl = (Text)c;
                            cntrl.setData(new Boolean(false));
                            ((Text)cntrl).addModifyListener(changeMarker);
                            continue;
                        }
                        if (c instanceof Button) {
                            cntrl = (Button)c;
                            cntrl.setData(new Boolean(false));
                            ((Button)cntrl).addSelectionListener(selectionMarker);
                            continue;
                        }
                        if (c instanceof Spinner) {
                            cntrl = (Spinner)c;
                            cntrl.setData(new Boolean(false));
                            ((Spinner)cntrl).addModifyListener(changeMarker);
                            continue;
                        }
                        if (c instanceof Scale) {
                            cntrl = (Scale)c;
                            cntrl.setData(new Boolean(false));
                            ((Scale)cntrl).addSelectionListener(selectionMarker);
                            continue;
                        }
                        if (!(c instanceof org.eclipse.swt.widgets.List)) continue;
                        cntrl = (org.eclipse.swt.widgets.List)c;
                        cntrl.setData(new Boolean(false));
                        ((org.eclipse.swt.widgets.List)cntrl).addSelectionListener(selectionMarker);
                    }
                }
            }
        }
    }

    private void addMountIfNoMounts(String hostFileLocation, boolean booter) {
        if (this.mountingpoints.getItemCount() == 0) {
            try {
                this.mountingpoints.setItems(((Configurable)this.multiProfileList.get(0)).getConf().addRequiredMount(booter, hostFileLocation));
                this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Profile duplicateProfile(Profile prof, List<DosboxVersion> dbversionsList, Database dbase, Shell shell) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        try {
            DosboxVersion dbversion = dbversionsList.get(DosboxVersion.findById(dbversionsList, prof.getDbversionId()));
            Conf newCompositeConf = new Conf(prof, dbversion, ps);
            int newProfileId = dbase.duplicateProfile(prof.getId());
            String newCapturesString = FileUtils.constructCapturesDir(newProfileId);
            File newCaptures = FileUtils.canonicalToData(newCapturesString);
            FileUtils.createDir(newCaptures);
            String newConfFile = FileUtils.constructUniqueConfigFileString(newProfileId, prof.getTitle(), newCompositeConf.getAutoexec().getCanonicalMainDir());
            Profile newProfile = new Profile(newProfileId, newConfFile, newCapturesString, prof);
            newCompositeConf.injectOrUpdateProfile(newProfile);
            newCompositeConf.save();
            dbase.updateProfileConf(newConfFile, newCapturesString, newProfileId);
            if (GeneralPurposeDialogs.confirmMessage(shell, Settings.getInstance().msg("dialog.profile.confirm.capturesduplication"))) {
                FileUtils.copyFiles(prof.getCanonicalCaptures(), newCaptures);
            }
            if (bos.size() > 0) {
                GeneralPurposeDialogs.warningMessage(shell, bos.toString());
                bos.reset();
            }
            return newProfile;
        }
        catch (Exception e) {
            GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
            return null;
        }
    }

    @Override
    protected void doPerformDosboxConfAction(EditTemplateDialog.DosboxConfAction action) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            this.updateAllConfigurationsBySettings();
            Conf newDosboxVersion = null;
            newDosboxVersion = action == EditTemplateDialog.DosboxConfAction.RELOAD_TEMPLATE ? new Conf(this.templatesList.get(this.template.getSelectionIndex()), (DosboxVersion)this.dbversionsList.get(this.dbversion.getSelectionIndex()), ps) : new Conf((DosboxVersion)this.dbversionsList.get(this.dbversion.getSelectionIndex()), ps);
            for (Configurable c : this.multiProfileList) {
                this.doPerformdosboxConfAction(action, newDosboxVersion, c);
            }
            if (this.isMultiEdit()) {
                this.doPerformdosboxConfAction(action, newDosboxVersion, this.multiProfileCombined);
                this.enableSettingsByConfiguration(this.multiProfileCombined.getConf().getDosboxSettings());
                this.selectSettingsByConfiguration(this.multiProfileCombined.getConf());
            } else {
                this.enableSettingsByConfiguration(((Configurable)this.multiProfileList.get(0)).getConf().getDosboxSettings());
                this.selectSettingsByConfiguration(((Configurable)this.multiProfileList.get(0)).getConf());
            }
            if (bos.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), bos.toString());
                bos.reset();
            }
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e.getMessage());
        }
    }

    private void doPerformdosboxConfAction(EditTemplateDialog.DosboxConfAction action, Conf newDosboxVersion, Configurable c) {
        if (action == EditTemplateDialog.DosboxConfAction.SET) {
            c.getConf().setToDosboxVersion(newDosboxVersion);
        } else if (action == EditTemplateDialog.DosboxConfAction.SWITCH) {
            c.getConf().switchToDosboxVersion(newDosboxVersion);
        } else if (action == EditTemplateDialog.DosboxConfAction.RELOAD) {
            c.getConf().reloadDosboxVersion(newDosboxVersion);
        } else if (action == EditTemplateDialog.DosboxConfAction.RELOAD_TEMPLATE) {
            c.getConf().reloadTemplate(newDosboxVersion);
        }
    }

    @Override
    protected void selectSettingsByConfiguration(Conf conf) {
        super.selectSettingsByConfiguration(conf);
        EditProfileDialog.setFieldIfEnabled(this.result instanceof Profile ? ((Profile)this.result).getCaptures() : this.settings.msg("dialog.profile.automatic"), false, this.captures);
        EditProfileDialog.setFieldIfEnabled(String.valueOf(conf.getAutoexec().isLoadfix()), Conf.isConflictingValue(conf.getAutoexec().isLoadfix()), this.loadfix);
        this.loadfix_value.setEnabled(this.loadfix.getSelection());
        EditProfileDialog.setFieldIfEnabled(String.valueOf(conf.getAutoexec().getLoadfixValue()), Conf.isConflictingValue(conf.getAutoexec().getLoadfixValue()), this.loadfix_value);
        if (!this.isMultiEdit()) {
            if (conf.getAutoexec().isBooter()) {
                this.img1.setText(conf.getAutoexec().getImg1());
                this.img2.setText(conf.getAutoexec().getImg2());
                this.img3.setText(conf.getAutoexec().getImg3());
            } else {
                this.main.setText(conf.getAutoexec().getMain());
                this.main_params.setText(conf.getAutoexec().getMainParameters());
            }
        }
    }

    protected void updateAllConfigurationsBySettings() {
        if (this.isMultiEdit()) {
            for (Configurable c : this.multiProfileList) {
                super.updateConfigurationBySettings(c.getConf());
                c.getConf().setAutoexecSettingsForProfileMultiEdit(this.fetch(this.loadfix), this.fetch(this.loadfix_value), this.fetch(this.exit), this.fetch(this.mixer_config), this.fetch(this.keyb), this.fetch(this.ipxnet));
            }
            super.updateConfigurationBySettings(this.multiProfileCombined.getConf());
            this.multiProfileCombined.getConf().setAutoexecSettingsForProfileMultiEdit(this.fetch(this.loadfix), this.fetch(this.loadfix_value), this.fetch(this.exit), this.fetch(this.mixer_config), this.fetch(this.keyb), this.fetch(this.ipxnet));
        } else {
            super.updateConfigurationBySettings(((Configurable)this.multiProfileList.get(0)).getConf());
            ((Configurable)this.multiProfileList.get(0)).getConf().setAutoexecSettingsForProfile(this.loadfix.getSelection(), this.loadfix_value.getText(), this.main.getText(), this.main_params.getText(), this.img1.getText(), this.img2.getText(), this.img3.getText());
        }
    }

    protected boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (!this.isMultiEdit()) {
            String requiredMount = null;
            if (this.title.getText().length() == 0) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.title"), this.title, this.infoTabItem);
            }
            if (this.dosButton.getSelection()) {
                if (FileUtils.isExecutable(this.main.getText())) {
                    requiredMount = this.dealWithField(false, this.main.getText());
                } else {
                    GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.mainexe"), this.main, this.mountingTabItem);
                }
                if (FileUtils.isExecutable(this.setup.getText())) {
                    requiredMount = this.dealWithField(false, this.setup.getText());
                }
            } else if (this.booterButton.getSelection()) {
                if (this.img1.getText().length() == 0) {
                    GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.booterimage"), this.img1, this.mountingTabItem);
                } else {
                    requiredMount = this.dealWithField(true, this.img1.getText());
                }
                if (this.img2.getText().length() > 0) {
                    requiredMount = this.dealWithField(true, this.img2.getText());
                }
                if (this.img3.getText().length() > 0) {
                    requiredMount = this.dealWithField(true, this.img3.getText());
                }
            }
            if (requiredMount != null) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.mountlocation"), this.mountingpoints, this.mountingTabItem);
            }
        }
        if (this.setButton.isEnabled()) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.template.required.dosboxassociation"), this.setButton, this.generalTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private String dealWithField(boolean booter, String loc) {
        String requiredMount = ((Configurable)this.multiProfileList.get(0)).getConf().getRequiredMount(booter, loc);
        if (requiredMount != null && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.profile.confirm.addmountlocation", new Object[]{requiredMount}))) {
            this.mountingpoints.setItems(((Configurable)this.multiProfileList.get(0)).getConf().addRequiredMount(booter, loc));
        }
        return ((Configurable)this.multiProfileList.get(0)).getConf().getRequiredMount(booter, loc);
    }

    private void setProfileMetaData(Profile prof) {
        int i;
        EditProfileDialog.setFieldIfEnabled(prof.getTitle(), Conf.isConflictingValue(prof.getTitle()), this.title);
        EditProfileDialog.setFieldIfEnabled(prof.getDeveloperName(), Conf.isConflictingValue(prof.getDeveloperName()), this.developer);
        EditProfileDialog.setFieldIfEnabled(prof.getPublisherName(), Conf.isConflictingValue(prof.getPublisherName()), this.publisher);
        EditProfileDialog.setFieldIfEnabled(prof.getGenre(), Conf.isConflictingValue(prof.getGenre()), this.genre);
        EditProfileDialog.setFieldIfEnabled(prof.getYear(), Conf.isConflictingValue(prof.getYear()), this.year);
        for (i = 0; i < AMOUNT_OF_LINKS; ++i) {
            EditProfileDialog.setFieldIfEnabled(prof.getLink(i), Conf.isConflictingValue(prof.getLink(i)), this.link[i]);
            EditProfileDialog.setFieldIfEnabled(prof.getLinkTitle(i), Conf.isConflictingValue(prof.getLinkTitle(i)), this.linkTitle[i]);
        }
        EditProfileDialog.setFieldIfEnabled(prof.getStatus(), Conf.isConflictingValue(prof.getStatus()), this.status);
        EditProfileDialog.setFieldIfEnabled(String.valueOf(prof.isDefault()), Conf.isConflictingValue(prof.isDefault()), this.favorite);
        EditProfileDialog.setFieldIfEnabled(prof.getNotes(), Conf.isConflictingValue(prof.getNotes()), this.notes);
        EditProfileDialog.setFieldIfEnabled(prof.getSetup(), Conf.isConflictingValue(prof.getSetup()), this.setup);
        EditProfileDialog.setFieldIfEnabled(prof.getSetupParameters(), Conf.isConflictingValue(prof.getSetupParameters()), this.setup_params);
        for (i = 0; i < AMOUNT_OF_CUSTOM_STRINGS; ++i) {
            EditProfileDialog.setFieldIfEnabled(prof.getCustomString(i), Conf.isConflictingValue(prof.getCustomString(i)), this.customCombo[i]);
            EditProfileDialog.setFieldIfEnabled(prof.getCustomString(AMOUNT_OF_CUSTOM_STRINGS + i), Conf.isConflictingValue(prof.getCustomString(AMOUNT_OF_CUSTOM_STRINGS + i)), this.customText[i]);
        }
        EditProfileDialog.setFieldIfEnabled(String.valueOf(prof.getCustomInt(0)), Conf.isConflictingValue(prof.getCustomInt(0)), this.custom9);
        EditProfileDialog.setFieldIfEnabled(String.valueOf(prof.getCustomInt(1)), Conf.isConflictingValue(prof.getCustomInt(1)), this.custom10);
    }

    private static List<Control> getChangeables(Composite composite) {
        Control[] children = composite.getChildren();
        ArrayList<Control> result = new ArrayList<Control>();
        for (Control c : children) {
            if (c instanceof Button && (c.getStyle() & 0x20) != 0 || c instanceof Combo || c instanceof Text || c instanceof Spinner || c instanceof Scale || c instanceof org.eclipse.swt.widgets.List) {
                result.add(c);
                continue;
            }
            if (!(c instanceof Group) && !(c instanceof Composite)) continue;
            result.addAll(EditProfileDialog.getChangeables((Composite)c));
        }
        return result;
    }
}

