/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.Wizard;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.ImportThread;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportDialog
extends Wizard {
    private Text confLogText;
    private Text logText;
    private Text title;
    private Text author;
    private Text notes;
    private Button settingsOnly;
    private Button fullGames;
    private Button fullSettingsButton;
    private Button incrementalSettingsButton;
    private Button importCapturesButton;
    private Button useOrgConf;
    private Button createNewConf;
    private Button customValues;
    private Button customFields;
    private Table profilesTable;
    private Table impDbVersionsList;
    private org.eclipse.swt.widgets.List myDbVersionsList;
    private Button start;
    private Label profileLabel;
    private File archive;
    private List<DosboxVersion> dbversionsList;
    private ImportThread importThread;
    private String packageTitle;
    private String packageAuthor;
    private String packageNotes;
    private String[] customFieldTitles;
    private String creationApp;
    private String creationAppVersion;
    private Date creationDate;
    private boolean capturesAvailable = false;
    private boolean gamedataAvailable = false;
    private List<ExpProfile> profs;
    private SortedSet<DosboxVersion> dbSet;
    private List<Integer> dbmapping;

    public ImportDialog(Shell parent, int style) {
        super(parent, style);
    }

    public ImportDialog(Shell parent, List<DosboxVersion> dbList, File archive) {
        this(parent, 0);
        this.dbversionsList = dbList;
        this.archive = archive;
    }

    public Object open() {
        this.createContents(this.settings.msg("dialog.import.title"), "import");
        this.readConfigurationFiles();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (this.importThread != null && !this.importThread.isAlive() && !this.finish.getEnabled()) {
                GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.import.notice.importok"));
                this.profileLabel.setText(this.settings.msg("dialog.export.reviewlog"));
                this.profileLabel.pack();
                this.cancel.setEnabled(false);
                this.finish.setEnabled(true);
                this.shell.setDefaultButton(this.finish);
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return new Boolean(this.importThread != null && this.importThread.getCustomFields() != null);
    }

    private void readConfigurationFiles() {
        Settings settings = Settings.getInstance();
        StringBuffer messageLog = new StringBuffer();
        try {
            TableItem item;
            InputStream xml = null;
            ZipFile zf = new ZipFile(this.archive);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().equalsIgnoreCase("profiles.xml")) continue;
                xml = zf.getInputStream(entry);
            }
            if (xml == null) {
                throw new ZipException(settings.msg("dialog.import.error.gamepackarchivemissingprofilesxml"));
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xml);
            zf.close();
            XPathFactory xfactory = XPathFactory.newInstance();
            XPath xPath = xfactory.newXPath();
            this.packageTitle = xPath.evaluate("/document/export/title", doc);
            this.packageAuthor = xPath.evaluate("/document/export/author", doc);
            this.packageNotes = xPath.evaluate("/document/export/notes", doc);
            this.customFieldTitles = new String[10];
            for (int i = 0; i < 10; ++i) {
                this.customFieldTitles[i] = xPath.evaluate("/document/export/custom" + (i + 1), doc);
            }
            this.creationApp = xPath.evaluate("/document/export/generator-title", doc);
            this.creationAppVersion = xPath.evaluate("/document/export/generator-version", doc);
            this.creationDate = XmlUtils.datetimeFormatter.parse(xPath.evaluate("/document/export/creationdatetime", doc));
            this.capturesAvailable = Boolean.valueOf(xPath.evaluate("/document/export/captures-available", doc));
            this.gamedataAvailable = Boolean.valueOf(xPath.evaluate("/document/export/gamedata-available", doc));
            NodeList profNodes = (NodeList)xPath.evaluate("/document/profile", doc, XPathConstants.NODESET);
            this.profs = new ArrayList<ExpProfile>();
            this.dbSet = new TreeSet<DosboxVersion>();
            for (int i = 0; i < profNodes.getLength(); ++i) {
                Element profileNode = (Element)profNodes.item(i);
                Element dosbox = XmlUtils.getNode(profileNode, "dosbox");
                DosboxVersion d = new DosboxVersion(i, XmlUtils.getTextValue(dosbox, "title"), "", true, false, false, "", XmlUtils.getTextValue(dosbox, "version"));
                this.dbSet.add(d);
                this.profs.add(new ExpProfile(profileNode, ImportDialog.getDosboxVersionId(d, this.dbSet)));
            }
            if (this.packageTitle != null) {
                this.title.setText(this.packageTitle);
            }
            if (this.packageAuthor != null) {
                this.author.setText(this.packageAuthor);
            }
            if (this.packageNotes != null) {
                this.notes.setText(this.packageNotes);
            }
            if (this.gamedataAvailable) {
                this.fullGames.setSelection(true);
            } else {
                this.fullGames.setEnabled(false);
                this.settingsOnly.setSelection(true);
            }
            if (settings.getSettings().getIntValue("profiledefaults", "confpath") == 1) {
                this.useOrgConf.setSelection(true);
            } else {
                this.useOrgConf.setEnabled(false);
                this.createNewConf.setEnabled(false);
            }
            if (this.capturesAvailable) {
                this.importCapturesButton.setSelection(true);
            } else {
                this.importCapturesButton.setEnabled(false);
            }
            for (ExpProfile prof : this.profs) {
                item = new TableItem(this.profilesTable, 0);
                item.setText(prof.getTitle());
                item.setText(1, prof.getBaseDir().getPath());
                item.setText(2, prof.getGameDir().getPath());
                item.setChecked(true);
            }
            for (DosboxVersion ver : this.dbversionsList) {
                this.myDbVersionsList.add(ver.getTitle() + " (" + ver.getVersion() + ")");
            }
            this.dbmapping = new ArrayList<Integer>();
            for (DosboxVersion dbversion : this.dbSet) {
                item = new TableItem(this.impDbVersionsList, 0);
                item.setText(dbversion.getTitle() + " (" + dbversion.getVersion() + ")");
                this.dbmapping.add(dbversion.findBestMatchId(this.dbversionsList));
            }
        }
        catch (ZipException e) {
            messageLog.append(e.toString()).append('\n');
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            messageLog.append(settings.msg("dialog.import.error.profilesxmlinvalidformat", new Object[]{e.toString()})).append('\n');
            e.printStackTrace();
        }
        catch (SAXException e) {
            messageLog.append(settings.msg("dialog.import.error.profilesxmlinvalidformat", new Object[]{e.toString()})).append('\n');
            e.printStackTrace();
        }
        catch (IOException e) {
            messageLog.append(settings.msg("general.error.openfile", new Object[]{this.archive})).append('\n').append(e.toString()).append('\n');
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            messageLog.append(e.toString()).append('\n');
            e.printStackTrace();
        }
        catch (ParseException e) {
            messageLog.append(e.toString()).append('\n');
            e.printStackTrace();
        }
        if (messageLog.length() == 0) {
            messageLog.append(settings.msg("dialog.import.notice.importinformation", new Object[]{this.creationDate, this.creationApp, this.creationAppVersion})).append('\n');
        }
        this.confLogText.setText(messageLog.toString());
    }

    private Control page1() {
        Group group1 = new Group(this.shell, 0);
        group1.setLayoutData(new GridData(4, 0x1000000, true, false));
        group1.setText(this.settings.msg("dialog.import.step1"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group1.setLayout(gridLayout);
        Label titleLabel = new Label(group1, 0);
        titleLabel.setText(this.settings.msg("dialog.export.exporttitle"));
        this.title = new Text(group1, 2048);
        this.title.setLayoutData(new GridData(4, 4, true, false));
        this.title.setEditable(false);
        Label authorLabel = new Label(group1, 0);
        authorLabel.setText(this.settings.msg("dialog.export.author"));
        this.author = new Text(group1, 2048);
        this.author.setLayoutData(new GridData(4, 4, true, false));
        this.author.setEditable(false);
        Label notesLabel = new Label(group1, 0);
        notesLabel.setText(this.settings.msg("dialog.export.notes"));
        this.notes = new Text(group1, 2890);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 40;
        this.notes.setLayoutData(gridData);
        Label logLabel = new Label(group1, 0);
        logLabel.setText(this.settings.msg("dialog.export.log"));
        this.confLogText = new Text(group1, 2890);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.minimumHeight = 40;
        this.confLogText.setLayoutData(gridData2);
        return group1;
    }

    private Control page2() {
        Group page2 = new Group(this.shell, 0);
        page2.setLayoutData(new GridData(4, 0x1000000, true, false));
        page2.setText(this.settings.msg("dialog.import.step2"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        page2.setLayout(gridLayout);
        Label importLabel = new Label(page2, 0);
        importLabel.setText(this.settings.msg("dialog.import.import"));
        Group group1 = new Group(page2, 0);
        group1.setLayoutData(new GridData(4, 0x1000000, true, false));
        group1.setLayout(new GridLayout());
        this.settingsOnly = new Button(group1, 16);
        this.settingsOnly.setText(this.settings.msg("dialog.export.export.profiles"));
        this.fullGames = new Button(group1, 16);
        this.fullGames.setText(this.settings.msg("dialog.export.export.games"));
        new Label(page2, 0);
        Group group2 = new Group(page2, 0);
        group2.setLayoutData(new GridData(4, 0x1000000, true, false));
        group2.setLayout(new GridLayout());
        this.incrementalSettingsButton = new Button(group2, 16);
        this.incrementalSettingsButton.setText(this.settings.msg("dialog.import.import.incrconf"));
        this.fullSettingsButton = new Button(group2, 16);
        this.fullSettingsButton.setText(this.settings.msg("dialog.import.import.fullconf"));
        this.incrementalSettingsButton.setSelection(true);
        new Label(page2, 0);
        Group group3 = new Group(page2, 0);
        group3.setLayoutData(new GridData(4, 0x1000000, true, false));
        group3.setLayout(new GridLayout());
        this.importCapturesButton = new Button(group3, 32);
        this.importCapturesButton.setText(this.settings.msg("dialog.template.captures"));
        new Label(page2, 0);
        Group group5 = new Group(page2, 0);
        group5.setLayoutData(new GridData(4, 0x1000000, true, false));
        group5.setLayout(new GridLayout());
        this.customValues = new Button(group5, 32);
        this.customValues.setText(this.settings.msg("dialog.import.import.customvalues"));
        this.customValues.setSelection(true);
        this.customFields = new Button(group5, 32);
        this.customFields.setText(this.settings.msg("dialog.import.import.customfields"));
        Label confFileLabel = new Label(page2, 0);
        confFileLabel.setText(this.settings.msg("dialog.main.profile.view.conf"));
        Group group4 = new Group(page2, 0);
        group4.setLayoutData(new GridData(4, 0x1000000, true, false));
        group4.setLayout(new GridLayout());
        this.useOrgConf = new Button(group4, 16);
        this.useOrgConf.setText(this.settings.msg("dialog.import.useorgconf"));
        this.createNewConf = new Button(group4, 16);
        this.createNewConf.setText(this.settings.msg("dialog.import.createnewconf"));
        return page2;
    }

    private Control page3() {
        Group profilesGroup = new Group(this.shell, 0);
        profilesGroup.setText(this.settings.msg("dialog.import.step3"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        profilesGroup.setLayout(gridLayout);
        this.profilesTable = new Table(profilesGroup, 67616);
        this.profilesTable.setHeaderVisible(true);
        GridData gridData_1 = new GridData(4, 4, true, true, 1, 2);
        gridData_1.heightHint = 80;
        this.profilesTable.setLayoutData(gridData_1);
        this.profilesTable.setLinesVisible(true);
        TableColumn title = new TableColumn(this.profilesTable, 0);
        title.setWidth(260);
        title.setText(this.settings.msg("dialog.main.profiles.column.title"));
        TableColumn basedir = new TableColumn(this.profilesTable, 0);
        basedir.setWidth(100);
        basedir.setText(this.settings.msg("dialog.import.column.basedir"));
        TableColumn subdir = new TableColumn(this.profilesTable, 0);
        subdir.setWidth(120);
        subdir.setText(this.settings.msg("dialog.export.column.gamedir"));
        Button allButton = new Button(profilesGroup, 0);
        allButton.setLayoutData(new GridData(50, -1));
        allButton.setText(this.settings.msg("button.all"));
        allButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TableItem item : ImportDialog.this.profilesTable.getItems()) {
                    item.setChecked(true);
                }
            }
        });
        Button noneButton = new Button(profilesGroup, 0);
        GridData gridData = new GridData(16384, 1024, false, false);
        gridData.widthHint = 50;
        noneButton.setLayoutData(gridData);
        noneButton.setText(this.settings.msg("button.none"));
        noneButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TableItem item : ImportDialog.this.profilesTable.getItems()) {
                    item.setChecked(false);
                }
            }
        });
        Composite buttonsGroup = new Composite(profilesGroup, 0);
        buttonsGroup.setLayout(new RowLayout());
        Button setBaseDirButton = new Button(buttonsGroup, 0);
        setBaseDirButton.setText(this.settings.msg("button.setbasedir"));
        setBaseDirButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ImportDialog.this.shell);
                dialog.setFilterPath(FileUtils.canonicalToDosroot(".").getPath());
                String result = dialog.open();
                if (result != null) {
                    File newBaseDir = FileUtils.makeRelativeToDosroot(new File(result));
                    for (int i = 0; i < ImportDialog.this.profilesTable.getItems().length; ++i) {
                        TableItem item = ImportDialog.this.profilesTable.getItem(i);
                        if (!item.getChecked()) continue;
                        ((ExpProfile)ImportDialog.this.profs.get(i)).setBaseDir(newBaseDir);
                        item.setText(1, newBaseDir.getPath());
                    }
                }
            }
        });
        Button addGameTitleToBaseDirButton = new Button(buttonsGroup, 0);
        addGameTitleToBaseDirButton.setText(this.settings.msg("button.addgametitletobasedir"));
        addGameTitleToBaseDirButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (int i = 0; i < ImportDialog.this.profilesTable.getItems().length; ++i) {
                    TableItem item = ImportDialog.this.profilesTable.getItem(i);
                    if (!item.getChecked()) continue;
                    String gameTitle = item.getText(0).replaceAll("[^a-zA-Z_0-9()]", "");
                    if (item.getText(1).endsWith(gameTitle)) continue;
                    File newFile = new File(item.getText(1), gameTitle);
                    ((ExpProfile)ImportDialog.this.profs.get(i)).setBaseDir(newFile);
                    item.setText(1, newFile.getPath());
                }
            }
        });
        Button removeGameTitleFromBaseDirButton = new Button(buttonsGroup, 0);
        removeGameTitleFromBaseDirButton.setText(this.settings.msg("button.removegametitlefrombasedir"));
        removeGameTitleFromBaseDirButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (int i = 0; i < ImportDialog.this.profilesTable.getItems().length; ++i) {
                    TableItem item = ImportDialog.this.profilesTable.getItem(i);
                    if (!item.getChecked()) continue;
                    String gameTitle = item.getText(0).replaceAll("[^a-zA-Z_0-9()]", "");
                    if (!item.getText(1).endsWith(gameTitle)) continue;
                    File newFile = new File(item.getText(1)).getParentFile();
                    ((ExpProfile)ImportDialog.this.profs.get(i)).setBaseDir(newFile);
                    item.setText(1, newFile.getPath());
                }
            }
        });
        this.profilesTable.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                int idx = ImportDialog.this.profilesTable.getSelectionIndex();
                ExpProfile prof = (ExpProfile)ImportDialog.this.profs.get(idx);
                DirectoryDialog dialog = new DirectoryDialog(ImportDialog.this.shell);
                dialog.setFilterPath(FileUtils.canonicalToDosroot(prof.getBaseDir().getPath()).getPath());
                String result = dialog.open();
                if (result != null) {
                    File newBaseDir = FileUtils.makeRelativeToDosroot(new File(result));
                    prof.setBaseDir(newBaseDir);
                    ImportDialog.this.profilesTable.getSelection()[0].setText(1, newBaseDir.getPath());
                }
            }
        });
        return profilesGroup;
    }

    private Control page4() {
        Group dosboxVersionsGroup = new Group(this.shell, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        dosboxVersionsGroup.setLayout(gridLayout2);
        dosboxVersionsGroup.setText(this.settings.msg("dialog.import.step4"));
        dosboxVersionsGroup.setLayoutData("North");
        Label importedVersionsLabel = new Label(dosboxVersionsGroup, 0);
        importedVersionsLabel.setText(this.settings.msg("dialog.import.dosboxversioninimport"));
        Label label_2 = new Label(dosboxVersionsGroup, 2);
        label_2.setLayoutData(new GridData(16384, 4, false, true, 1, 2));
        Label configuredVersionsLabel = new Label(dosboxVersionsGroup, 0);
        configuredVersionsLabel.setText(this.settings.msg("dialog.import.dosboxversioninstalled"));
        this.impDbVersionsList = new Table(dosboxVersionsGroup, 67584);
        this.impDbVersionsList.setLayoutData(new GridData(4, 4, true, true));
        this.impDbVersionsList.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int impIdx = ImportDialog.this.impDbVersionsList.getSelectionIndex();
                int mappedId = (Integer)ImportDialog.this.dbmapping.get(impIdx);
                int myIdx = DosboxVersion.findById(ImportDialog.this.dbversionsList, mappedId);
                ImportDialog.this.myDbVersionsList.select(myIdx);
            }
        });
        this.myDbVersionsList = new org.eclipse.swt.widgets.List(dosboxVersionsGroup, 2816);
        this.myDbVersionsList.setLayoutData(new GridData(4, 4, true, true));
        this.myDbVersionsList.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = ImportDialog.this.impDbVersionsList.getSelectionIndex();
                if (idx != -1) {
                    int myIdx = ImportDialog.this.myDbVersionsList.getSelectionIndex();
                    ImportDialog.this.dbmapping.set(idx, ((DosboxVersion)ImportDialog.this.dbversionsList.get(myIdx)).getId());
                }
            }
        });
        return dosboxVersionsGroup;
    }

    private Control page5() {
        Group progressGroup = new Group(this.shell, 0);
        progressGroup.setText(this.settings.msg("dialog.import.step5"));
        progressGroup.setLayout(new GridLayout());
        this.start = new Button(progressGroup, 0);
        this.shell.setDefaultButton(this.start);
        this.start.setLayoutData(new GridData(4, 0x1000000, false, false));
        this.start.setText(this.settings.msg("dialog.import.start"));
        final ProgressBar progressBar = new ProgressBar(progressGroup, 0);
        progressBar.setLayoutData(new GridData(4, 0x1000000, false, false));
        this.profileLabel = new Label(progressGroup, 0);
        this.logText = new Text(progressGroup, 2826);
        this.logText.setLayoutData(new GridData(4, 4, true, true));
        this.start.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    int i;
                    ImportDialog.this.back.setEnabled(false);
                    ImportDialog.this.start.setEnabled(false);
                    for (i = 0; i < ImportDialog.this.profs.size(); ++i) {
                        for (int j = 0; j < i; ++j) {
                            ExpProfile pI = (ExpProfile)ImportDialog.this.profs.get(i);
                            ExpProfile pJ = (ExpProfile)ImportDialog.this.profs.get(j);
                            if (!pI.getGameDir().equals(pJ.getGameDir())) continue;
                            pI.setImportedId(pJ.getImportedId());
                        }
                    }
                    for (i = ImportDialog.this.profs.size() - 1; i >= 0; --i) {
                        TableItem it = ImportDialog.this.profilesTable.getItem(i);
                        if (it.getChecked()) {
                            ExpProfile p = (ExpProfile)ImportDialog.this.profs.get(i);
                            p.setDbversionId(ImportDialog.this.getMappedDosboxVersionId(p.getDbversionId()));
                            continue;
                        }
                        ImportDialog.this.profs.remove(i);
                    }
                    ImportDialog.this.importThread = new ImportThread(ImportDialog.this.profs, ImportDialog.this.dbversionsList, ImportDialog.this.archive, ImportDialog.this.importCapturesButton.getSelection(), ImportDialog.this.useOrgConf.getSelection(), ImportDialog.this.fullGames.getSelection(), ImportDialog.this.fullSettingsButton.getSelection(), ImportDialog.this.customValues.getSelection(), ImportDialog.this.customFields.getSelection() ? ImportDialog.this.customFieldTitles : null, ImportDialog.this.logText, progressBar, ImportDialog.this.profileLabel);
                    ImportDialog.this.importThread.start();
                }
                catch (IOException ex) {
                    GeneralPurposeDialogs.warningMessage(ImportDialog.this.shell, ex.getMessage());
                    ImportDialog.this.importThread = null;
                }
            }
        });
        return progressGroup;
    }

    @Override
    protected void fillPages() {
        this.addStep(this.page1());
        this.addStep(this.page2());
        this.addStep(this.page3());
        this.addStep(this.page4());
        this.addStep(this.page5());
    }

    @Override
    protected int stepSize(boolean up) {
        return 1;
    }

    @Override
    protected boolean isValid() {
        if (this.stepNr == 2) {
            if (!this.conditionsForStep3Ok()) {
                return false;
            }
            this.refillImportedDBVersionsList();
        }
        return true;
    }

    private boolean conditionsForStep3Ok() {
        GeneralPurposeDialogs.initErrorDialog();
        this.atLeastOneProfileSelected();
        if (this.fullGames.getSelection()) {
            this.gameDirExists();
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private void atLeastOneProfileSelected() {
        for (TableItem item : this.profilesTable.getItems()) {
            if (!item.getChecked()) continue;
            return;
        }
        GeneralPurposeDialogs.addError(this.settings.msg("dialog.import.required.oneprofiletoimport"), this.profilesTable);
    }

    private void gameDirExists() {
        for (TableItem item : this.profilesTable.getItems()) {
            File f;
            if (!item.getChecked() || !(f = FileUtils.canonicalToDosroot(new File(item.getText(1), item.getText(2)).getPath())).exists()) continue;
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.import.error.gamedatadirexists", new Object[]{f}), this.profilesTable);
        }
    }

    private void refillImportedDBVersionsList() {
        int idx = 0;
        for (DosboxVersion dbversion : this.dbSet) {
            int dbid = dbversion.getId();
            TableItem ti = this.impDbVersionsList.getItem(idx);
            Display d = this.shell.getDisplay();
            Color c = this.isUsed(dbid) ? null : d.getSystemColor(15);
            ti.setForeground(c);
            ++idx;
        }
    }

    private boolean isUsed(int dbVersionId) {
        for (int i = 0; i < this.profs.size(); ++i) {
            TableItem item = this.profilesTable.getItem(i);
            int dbid = this.profs.get(i).getDbversionId();
            if (!item.getChecked() || dbVersionId != dbid) continue;
            return true;
        }
        return false;
    }

    private int getMappedDosboxVersionId(int id) {
        int index = 0;
        for (DosboxVersion ver : this.dbSet) {
            if (ver.getId() == id) {
                return this.dbmapping.get(index);
            }
            ++index;
        }
        return -1;
    }

    private static int getDosboxVersionId(DosboxVersion dbversion, SortedSet<DosboxVersion> set) {
        for (DosboxVersion d : set) {
            if (d.compareTo(dbversion) != 0) continue;
            return d.getId();
        }
        return -1;
    }
}

