/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProfileLoader
extends Dialog {
    private Shell shell;
    private ProgressBar progressBar;
    private List<Profile> profs;
    private List<DosboxVersion> dbversionsList;
    private List<ExpProfile> jobResult = new ArrayList<ExpProfile>();
    private List<ExpProfile> result = null;
    private boolean combine;
    private ExpProfile multiProfileCombined = null;
    private Settings settings;
    private Label profileLabel;
    private Text logText;
    private Button okButton;
    private Button cancelButton;

    public ProfileLoader(Shell parent, int style) {
        super(parent, style);
    }

    public ProfileLoader(Shell parent, List<DosboxVersion> dbList, List<Profile> profs, boolean combine) {
        this(parent, 0);
        this.dbversionsList = dbList;
        this.profs = profs;
        this.combine = combine;
        this.settings = Settings.getInstance();
    }

    public ProfileLoader(Shell parent) {
        this(parent, 0);
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        final StringBuffer messageLog = new StringBuffer();
        final Display display = this.getParent().getDisplay();
        Thread job = new Thread(){

            public void run() {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bos);
                Conf targetDBConf = null;
                for (int i = 0; i < ProfileLoader.this.profs.size(); ++i) {
                    final Profile profile = (Profile)ProfileLoader.this.profs.get(i);
                    int dbversionIndex = DosboxVersion.findById(ProfileLoader.this.dbversionsList, profile.getDbversionId());
                    DosboxVersion dbversion = (DosboxVersion)ProfileLoader.this.dbversionsList.get(dbversionIndex);
                    try {
                        ExpProfile expProfile;
                        Conf conf = new Conf(profile, dbversion, ps);
                        if (bos.size() > 0) {
                            messageLog.append(profile.getTitle()).append(": ").append(bos.toString()).append('\n');
                            bos.reset();
                        }
                        if (conf.getAutoexec().isIncomplete()) {
                            messageLog.append(profile.getTitle()).append(": ").append(Settings.getInstance().msg("dialog.multiprofile.error.profileincomplete")).append('\n');
                        } else if (ProfileLoader.this.combine) {
                            expProfile = new ExpProfile(profile.getId(), conf, FileUtils.makeRelativeToDosroot(conf.getAutoexec().getCanonicalMainDir()), profile);
                            if (ProfileLoader.this.jobResult.isEmpty()) {
                                ProfileLoader.this.multiProfileCombined = expProfile;
                                targetDBConf = Conf.extractDBVersionConf(ProfileLoader.this.multiProfileCombined.getConf());
                                ProfileLoader.this.jobResult.add(expProfile);
                            } else {
                                Conf c = expProfile.getConf();
                                boolean same = true;
                                if (ProfileLoader.this.multiProfileCombined.getDbversionId() != expProfile.getDbversionId()) {
                                    c.alterToDosboxVersionGeneration(targetDBConf);
                                    same = false;
                                }
                                c = new Conf(ProfileLoader.this.multiProfileCombined.getConf(), c, same);
                                ProfileLoader.this.multiProfileCombined = new ExpProfile(ProfileLoader.this.multiProfileCombined, expProfile, c);
                                if (bos.size() > 0) {
                                    messageLog.append(profile.getTitle()).append(": ").append(bos.toString()).append('\n');
                                    bos.reset();
                                } else {
                                    ProfileLoader.this.jobResult.add(expProfile);
                                }
                            }
                        } else {
                            expProfile = new ExpProfile(i, conf, FileUtils.makeRelativeToDosroot(conf.getAutoexec().getCanonicalMainDir()), profile);
                            ProfileLoader.this.jobResult.add(expProfile);
                        }
                    }
                    catch (IOException e) {
                        messageLog.append(profile.getTitle()).append(": ").append(e.getMessage()).append('\n');
                    }
                    final int progress = i + 1;
                    if (display.isDisposed()) {
                        return;
                    }
                    display.syncExec(new Runnable(){

                        public void run() {
                            if (!ProfileLoader.this.progressBar.isDisposed()) {
                                ProfileLoader.this.progressBar.setSelection(progress);
                                ProfileLoader.this.profileLabel.setText(ProfileLoader.this.settings.msg("dialog.profileloader.reading", new Object[]{profile.getTitle()}));
                            }
                        }
                    });
                }
            }
        };
        job.start();
        while (!this.shell.isDisposed()) {
            if (job != null && !job.isAlive()) {
                if (messageLog.length() > 0) {
                    String msg = this.settings.msg("dialog.profileloader.error.reading");
                    this.logText.setText(messageLog.toString());
                    this.profileLabel.setText(this.settings.msg("dialog.migration.reviewlog"));
                    this.profileLabel.pack();
                    if (!this.jobResult.isEmpty()) {
                        this.okButton.setEnabled(true);
                        msg = msg + "\n\n" + this.settings.msg("dialog.profileloader.confirm.continue", new Object[]{this.jobResult.size()});
                    }
                    GeneralPurposeDialogs.warningMessage(this.shell, msg);
                } else {
                    this.result = this.jobResult;
                    this.shell.close();
                }
                job = null;
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout(new GridLayout());
        this.shell.addControlListener(new SizeControlAdapter(this.shell, "profileloaderdialog"));
        this.shell.setText(this.settings.msg("dialog.profileloader.title", new Object[]{this.profs.size()}));
        Group progressGroup = new Group(this.shell, 0);
        progressGroup.setLayoutData(new GridData(4, 4, true, true));
        progressGroup.setText(this.settings.msg("dialog.migration.progress"));
        progressGroup.setLayout(new GridLayout());
        this.progressBar = new ProgressBar(progressGroup, 0);
        this.progressBar.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.progressBar.setMaximum(this.profs.size());
        this.profileLabel = new Label(progressGroup, 0);
        this.profileLabel.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.logText = new Text(progressGroup, 2826);
        this.logText.setLayoutData(new GridData(4, 4, true, true));
        Composite buttonComposite = new Composite(this.shell, 0);
        buttonComposite.setLayout(new GridLayout(2, true));
        this.okButton = new Button(buttonComposite, 0);
        this.shell.setDefaultButton(this.okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        this.okButton.setLayoutData(gridData);
        this.okButton.setText(this.settings.msg("button.ok"));
        this.okButton.setEnabled(false);
        this.okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProfileLoader.this.result = ProfileLoader.this.jobResult;
                ProfileLoader.this.shell.close();
            }
        });
        this.cancelButton = new Button(buttonComposite, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = 4;
        this.cancelButton.setLayoutData(gridData_1);
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        this.cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProfileLoader.this.shell.close();
            }
        });
    }

    public List<ExpProfile> getResult() {
        return this.result;
    }

    public List<Configurable> getResultAsConfigurables() {
        return new ArrayList<Configurable>(this.result);
    }

    public ExpProfile getMultiProfileCombined() {
        return this.multiProfileCombined;
    }
}

