/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.Vector;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.conf.Settings;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public abstract class Wizard
extends Dialog {
    protected int stepNr = 0;
    protected Vector<Control> steps;
    protected Composite wizardPanel;
    protected StackLayout wizardLayout;
    protected Button back;
    protected Button next;
    protected Button finish;
    protected Button cancel;
    protected Shell shell;
    protected Settings settings = Settings.getInstance();

    public Wizard(Shell arg0, int arg1) {
        super(arg0, arg1);
        this.steps = new Vector();
    }

    protected void createContents(String title, String dialog) {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setText(title);
        this.shell.setLayout(new GridLayout(4, false));
        this.shell.addControlListener(new SizeControlAdapter(this.shell, dialog));
        SelectionAdapter closeAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Wizard.this.shell.close();
            }
        };
        this.wizardPanel = new Composite(this.shell, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 4;
        this.wizardPanel.setLayoutData(gd);
        this.wizardLayout = new StackLayout();
        this.wizardPanel.setLayout(this.wizardLayout);
        this.back = new Button(this.shell, 8);
        this.back.setText(this.settings.msg("button.back"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        this.back.setLayoutData(gridData);
        this.back.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Wizard.this.previousStep();
            }
        });
        this.next = new Button(this.shell, 8);
        this.next.setText(this.settings.msg("button.next"));
        this.next.setLayoutData(gridData);
        this.next.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Wizard.this.nextStep();
            }
        });
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.widthHint = 80;
        gridData2.horizontalIndent = 10;
        this.finish = new Button(this.shell, 8);
        this.finish.setText(this.settings.msg("button.finish"));
        this.finish.setLayoutData(gridData2);
        this.finish.addSelectionListener(closeAdapter);
        this.finish.setEnabled(false);
        this.cancel = new Button(this.shell, 8);
        this.cancel.setText(this.settings.msg("button.cancel"));
        this.cancel.setLayoutData(new GridData());
        this.cancel.addSelectionListener(closeAdapter);
        this.fillPages();
        this.showCurrentStep();
        this.shell.setDefaultButton(this.next);
    }

    protected abstract void fillPages();

    protected int stepSize(boolean up) {
        return 1;
    }

    protected boolean isValid() {
        return true;
    }

    protected void nextStep() {
        if (this.isValid()) {
            this.stepNr += this.stepSize(true);
            this.showCurrentStep();
        }
    }

    protected void previousStep() {
        this.stepNr -= this.stepSize(false);
        this.showCurrentStep();
    }

    protected void showCurrentStep() {
        this.wizardLayout.topControl = this.steps.get(this.stepNr);
        this.wizardPanel.layout();
        this.back.setEnabled(this.stepNr > 0);
        this.next.setEnabled(this.stepNr < this.steps.size() - 1);
    }

    public void addStep(Control c) {
        c.setParent(this.wizardPanel);
        this.steps.addElement(c);
    }
}

