/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;
import org.dbgl.db.Database;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public final class DFendImportThread
extends Thread {
    public static final String[] CUST_STRINGS = new String[]{"", "", "", "", "", "", "", ""};
    public static final int[] CUST_INTS = new int[]{0, 0};
    public static final int[] CUST_IDS = new int[]{0, 0, 0, 0};
    private static final String[] LINKS = new String[]{"", "", "", ""};
    private final DosboxVersion defaultDBVersion;
    private final Text log;
    private final ProgressBar progressBar;
    private final Label profileLabel;
    private final boolean performCleanup;
    private final Display display;
    private String title;
    private int profileNumber;
    private File dfendProfilesFile;

    public DFendImportThread(File dfendProfilesFile, boolean performCleanup, DosboxVersion defaultDBVersion, Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
        this.performCleanup = performCleanup;
        this.defaultDBVersion = defaultDBVersion;
        this.log = log;
        this.progressBar = progressBar;
        this.profileLabel = profileLabel;
        this.display = log.getShell().getDisplay();
        this.dfendProfilesFile = dfendProfilesFile;
        this.profileNumber = 0;
    }

    public void run() {
        Database dbase = Database.getInstance();
        final StringBuffer displayedLog = new StringBuffer();
        final StringBuffer messageLog = new StringBuffer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        try {
            Conf profiles = new Conf(this.dfendProfilesFile, ps);
            final Set<String> sectionNames = profiles.getSettings().getAllSectionNames();
            this.display.asyncExec(new Runnable(){

                public void run() {
                    DFendImportThread.this.progressBar.setMaximum(sectionNames.size());
                }
            });
            Iterator<String> i$ = sectionNames.iterator();
            while (i$.hasNext()) {
                String titleLoop;
                this.title = titleLoop = i$.next();
                String profFile = profiles.getSettings().getValue(this.title, "prof");
                String confFile = profiles.getSettings().getValue(this.title, "conf");
                boolean favorite = profiles.getSettings().getValue(this.title, "fav").equals("1");
                try {
                    Conf dfendExtra = new Conf(new File(profFile), ps);
                    String setup = dfendExtra.getSettings().getValue("Extra", "Setup");
                    String setupParams = dfendExtra.getSettings().getValue("Extra", "SetupParameters");
                    String notes = dfendExtra.getSettings().getValue("ExtraInfo", "Notes");
                    String dev = dfendExtra.getSettings().getValue("ExtraInfo", "Developer");
                    String pub = dfendExtra.getSettings().getValue("ExtraInfo", "Publisher");
                    String gen = dfendExtra.getSettings().getValue("ExtraInfo", "Genre");
                    String year = dfendExtra.getSettings().getValue("ExtraInfo", "Year");
                    String status = Settings.getInstance().msg("dialog.dfendimport.defaultprofilestatus");
                    String cap = dfendExtra.getSettings().getValue("dosbox", "captures");
                    int devId = KeyValuePair.findIdByValue(dbase.readDevelopersList(), dev);
                    int publId = KeyValuePair.findIdByValue(dbase.readPublishersList(), pub);
                    int genId = KeyValuePair.findIdByValue(dbase.readGenresList(), gen);
                    int yrId = KeyValuePair.findIdByValue(dbase.readYearsList(), year);
                    int statId = KeyValuePair.findIdByValue(dbase.readStatusList(), status);
                    int[] custIDs = CUST_IDS;
                    for (int i = 0; i < 4; ++i) {
                        custIDs[i] = KeyValuePair.findIdByValue(dbase.readCustomList(i), "");
                    }
                    try {
                        int profileId = dbase.addOrEditProfile(this.title, dev, pub, gen, year, status, setup, setupParams, notes, favorite, devId, publId, genId, yrId, statId, this.defaultDBVersion.getId(), LINKS, CUST_STRINGS, CUST_INTS, custIDs, LINKS, -1);
                        Conf dfendProfile = new Conf(new File(confFile), this.title, profileId, this.defaultDBVersion, ps);
                        String dstCap = FileUtils.constructCapturesDir(profileId);
                        String dstCapRelative = FileUtils.constructRelativeCapturesDir(profileId);
                        File dstCapAbsolute = FileUtils.canonicalToData(dstCap);
                        FileUtils.createDir(dstCapAbsolute);
                        FileUtils.copyFiles(new File(cap), dstCapAbsolute);
                        dfendProfile.getSettings().setValue("dosbox", "captures", dstCapRelative);
                        if (this.performCleanup) {
                            dfendProfile.getSettings().removeSection("directserial");
                            dfendProfile.getSettings().removeSection("modem");
                            dfendProfile.getSettings().removeSection("ipx");
                            dfendProfile.getSettings().removeSection("sdl");
                        }
                        dfendProfile.alterToDosboxVersionGeneration(dfendProfile);
                        dfendProfile.save();
                        dbase.updateProfileConf(FileUtils.makeRelativeToData(dfendProfile.getConfFile()).getPath(), dstCap, profileId);
                        if (dfendProfile.getAutoexec().isIncomplete()) {
                            messageLog.append(this.title).append(": ").append(Settings.getInstance().msg("dialog.multiprofile.error.profileincomplete")).append('\n');
                        }
                        if (bos.size() > 0) {
                            messageLog.append(bos.toString());
                            bos.reset();
                        }
                    }
                    catch (SQLException se) {
                        messageLog.append(se.getMessage()).append('\n');
                    }
                }
                catch (IOException e) {
                    messageLog.append(e.getMessage()).append('\n');
                }
                if (!(this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed())) {
                    this.display.asyncExec(new Runnable(){

                        public void run() {
                            DFendImportThread.this.profileLabel.setText(Settings.getInstance().msg("dialog.dfendimport.importing", new Object[]{DFendImportThread.this.title}));
                            DFendImportThread.this.profileLabel.pack();
                            if (messageLog.length() > displayedLog.length()) {
                                String newOutput = messageLog.substring(displayedLog.length());
                                DFendImportThread.this.log.append(newOutput);
                                displayedLog.append(newOutput);
                            }
                            DFendImportThread.this.progressBar.setSelection(DFendImportThread.this.profileNumber++);
                        }
                    });
                    continue;
                }
                break;
            }
        }
        catch (Exception se) {
            messageLog.append(se.getMessage());
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (messageLog.length() > displayedLog.length()) {
                        String newOutput = messageLog.substring(displayedLog.length());
                        DFendImportThread.this.log.append(newOutput);
                        displayedLog.append(newOutput);
                    }
                }
            });
        }
        this.display.asyncExec(new Runnable(){

            public void run() {
                DFendImportThread.this.progressBar.setSelection(DFendImportThread.this.progressBar.getMaximum());
            }
        });
    }
}

