/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.DFendImportThread;
import org.dbgl.util.FileUtils;
import org.dbgl.util.ProgressNotifyable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportThread
extends Thread
implements ProgressNotifyable {
    private static final String PREFIX_OK = "  + ";
    private static final String PREFIX_ERR = "  - ";
    private List<ExpProfile> profs;
    private List<DosboxVersion> dbversionsList;
    private boolean importCaptures;
    private boolean importGameData;
    private boolean importFullSettings;
    private boolean customValues;
    private String[] customFields;
    private boolean useExistingConf;
    private File zipfile;
    private Text log;
    private ProgressBar progressBar;
    private Label status;
    private Display display;

    public ImportThread(List<ExpProfile> p, List<DosboxVersion> dbList, File zipfile, boolean captures, boolean useExistingConf, boolean gamedata, boolean fullSettings, boolean customValues, String[] customFields, Text log, ProgressBar progressBar, Label status) throws IOException {
        this.profs = p;
        this.dbversionsList = dbList;
        this.zipfile = zipfile;
        this.importCaptures = captures;
        this.useExistingConf = useExistingConf;
        this.importGameData = gamedata;
        this.importFullSettings = fullSettings;
        this.customValues = customValues;
        this.customFields = customFields;
        this.log = log;
        this.progressBar = progressBar;
        long bytes = 0L;
        for (ExpProfile ep : this.profs) {
            if (this.importCaptures) {
                bytes += FileUtils.extractZipSizeInBytes(zipfile, new File(ep.getCaptures()));
            }
            if (!this.importGameData) continue;
            bytes += FileUtils.extractZipSizeInBytes(zipfile, new File(FileUtils.DOSROOT_DIR, new File(String.valueOf(ep.getImportedId()), ep.getGameDir().getPath()).getPath()));
        }
        this.progressBar.setMaximum((int)(bytes / 1024L) + this.profs.size());
        this.status = status;
        this.display = log.getShell().getDisplay();
    }

    @Override
    public void run() {
        final Settings settings = Settings.getInstance();
        Database db = Database.getInstance();
        final StringBuffer messageLog = new StringBuffer();
        final StringBuffer displayedLog = new StringBuffer();
        for (final ExpProfile p : this.profs) {
            if (this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed()) break;
            this.display.syncExec(new Runnable(){

                public void run() {
                    ImportThread.this.status.setText(settings.msg("dialog.import.importing", new Object[]{p.getTitle()}));
                    ImportThread.this.status.pack();
                }
            });
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            try {
                messageLog.append(p.getTitle()).append(":\n");
                int devId = KeyValuePair.findIdByValue(db.readDevelopersList(), p.getDeveloperName());
                int publId = KeyValuePair.findIdByValue(db.readPublishersList(), p.getPublisherName());
                int genId = KeyValuePair.findIdByValue(db.readGenresList(), p.getGenre());
                int yrId = KeyValuePair.findIdByValue(db.readYearsList(), p.getYear());
                int statId = KeyValuePair.findIdByValue(db.readStatusList(), p.getStatus());
                String[] customStrings = DFendImportThread.CUST_STRINGS;
                int[] customInts = DFendImportThread.CUST_INTS;
                int[] custIDs = DFendImportThread.CUST_IDS;
                if (this.customValues) {
                    customStrings = p.getCustomStrings();
                    customInts = p.getCustomInts();
                    for (int i = 0; i < 4; ++i) {
                        custIDs[i] = KeyValuePair.findIdByValue(db.readCustomList(i), p.getCustomString(i));
                    }
                }
                int profileId = db.addOrEditProfile(p.getTitle(), p.getDeveloperName(), p.getPublisherName(), p.getGenre(), p.getYear(), p.getStatus(), p.getSetup(), p.getSetupParameters(), p.getNotes(), p.isDefault(), devId, publId, genId, yrId, statId, p.getDbversionId(), p.getLinks(), customStrings, customInts, custIDs, p.getLinkTitles(), -1);
                String newCapturesString = FileUtils.constructCapturesDir(profileId);
                File relativeCapturesDirInZip = new File(p.getCaptures());
                File canonicalCapturesDir = FileUtils.canonicalToData(newCapturesString);
                if (!canonicalCapturesDir.exists()) {
                    FileUtils.createDir(canonicalCapturesDir);
                    messageLog.append(PREFIX_OK).append(settings.msg("dialog.import.notice.createddir", new Object[]{canonicalCapturesDir})).append('\n');
                    if (this.importCaptures) {
                        try {
                            FileUtils.extractZip(this.zipfile, relativeCapturesDirInZip, canonicalCapturesDir, this);
                            messageLog.append(PREFIX_OK).append(settings.msg("dialog.import.notice.extractedcaptures", new Object[]{canonicalCapturesDir})).append('\n');
                        }
                        catch (IOException e) {
                            messageLog.append(PREFIX_ERR).append(settings.msg("dialog.import.error.capturesextraction", new Object[]{e.getMessage()})).append('\n');
                        }
                    }
                } else {
                    messageLog.append(PREFIX_ERR).append(settings.msg("dialog.import.error.capturesdirexists", new Object[]{canonicalCapturesDir})).append('\n');
                }
                File relativeGameDir = p.getGameDir();
                File relativeGameDirInZip = new File(FileUtils.DOSROOT_DIR, new File(String.valueOf(p.getImportedId()), relativeGameDir.getPath()).getPath());
                File canonicalGameDir = FileUtils.canonicalToDosroot(new File(p.getBaseDir(), p.getGameDir().getPath()).getPath());
                if (this.importGameData && !canonicalGameDir.exists()) {
                    FileUtils.createDir(canonicalGameDir);
                    messageLog.append(PREFIX_OK).append(settings.msg("dialog.import.notice.createddir", new Object[]{canonicalGameDir})).append('\n');
                    try {
                        FileUtils.extractZip(this.zipfile, relativeGameDirInZip, canonicalGameDir, this);
                        messageLog.append(PREFIX_OK).append(settings.msg("dialog.import.notice.extractedgamedata", new Object[]{canonicalGameDir})).append('\n');
                    }
                    catch (IOException e) {
                        messageLog.append(PREFIX_ERR).append(settings.msg("dialog.import.error.gamedataextraction", new Object[]{e.getMessage()})).append('\n');
                    }
                }
                DosboxVersion assocDBVersion = this.dbversionsList.get(DosboxVersion.findById(this.dbversionsList, p.getDbversionId()));
                String newConfString = null;
                if (this.useExistingConf && FileUtils.areRelated(new File(FileUtils.getDosRoot()), p.getCanonicalConfFile()) && FileUtils.isExistingFile(p.getCanonicalConfFile())) {
                    newConfString = p.getCanonicalConfFile().getPath();
                    messageLog.append(PREFIX_OK).append(settings.msg("dialog.import.notice.usingexistingconf", new Object[]{p.getCanonicalConfFile()})).append('\n');
                } else {
                    try {
                        Conf gameConf = new Conf(p.getImportedFullConfig(), p.getImportedIncrConfig(), this.importFullSettings, this.zipfile.getPath(), p, profileId, assocDBVersion, ps);
                        newConfString = gameConf.getConfFile().getPath();
                        Profile newProfile = new Profile(profileId, newConfString, newCapturesString, p);
                        if (!canonicalGameDir.exists()) {
                            FileUtils.createDir(canonicalGameDir);
                            messageLog.append(PREFIX_OK).append(settings.msg("dialog.import.notice.createddir", new Object[]{canonicalGameDir})).append('\n');
                        }
                        String dstCapRelative = FileUtils.constructRelativeCapturesDir(profileId);
                        gameConf.getSettings().setValue("dosbox", "captures", dstCapRelative);
                        gameConf.save();
                        messageLog.append(PREFIX_OK).append(settings.msg("dialog.import.notice.createdconf", new Object[]{newProfile.getCanonicalConfFile()})).append('\n');
                    }
                    catch (IOException e) {
                        ps.println(e);
                    }
                    if (bos.size() > 0) {
                        messageLog.append(PREFIX_ERR).append(bos.toString());
                        bos.reset();
                    }
                }
                if (newConfString != null) {
                    db.updateProfileConf(newConfString, newCapturesString, profileId);
                    String setup = p.getSetup();
                    if (setup.length() > 0) {
                        setup = FileUtils.prefixAndSanitizeToDosroot(p.getBaseDir(), new File(setup)).getPath();
                    }
                    String[] links = p.getLinks();
                    for (int i = 0; i < links.length; ++i) {
                        if (links[i].equals("") || links[i].contains("://")) continue;
                        links[i] = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToData(links[i])).getPath();
                        links[i] = FileUtils.prefixAndSanitizeToDosroot(p.getBaseDir(), new File(links[i])).getPath();
                        if (p.getBaseDir().isAbsolute()) continue;
                        links[i] = FileUtils.DOSROOT_DIR + links[i];
                    }
                    db.updateProfileSetupAndLinks(setup, links, profileId);
                    messageLog.append(PREFIX_OK).append(settings.msg("dialog.import.notice.createddbentry", new Object[]{profileId, newConfString, newCapturesString, assocDBVersion.getTitle()})).append('\n');
                }
            }
            catch (SQLException e) {
                messageLog.append(e.getMessage()).append('\n');
            }
            if (this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed()) break;
            this.display.syncExec(new Runnable(){

                public void run() {
                    if (messageLog.length() > displayedLog.length()) {
                        String newOutput = messageLog.substring(displayedLog.length());
                        ImportThread.this.log.append(newOutput);
                        displayedLog.append(newOutput);
                    }
                    ImportThread.this.progressBar.setSelection(ImportThread.this.progressBar.getSelection() + 1);
                }
            });
        }
        if (this.customFields != null) {
            for (int i = 0; i < 10; ++i) {
                if (this.customFields[i].equalsIgnoreCase("Custom" + (i + 1))) continue;
                settings.getSettings().setValue("gui", "custom" + (i + 1), this.customFields[i]);
            }
        }
        if (!this.display.isDisposed() && !this.progressBar.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    ImportThread.this.progressBar.setSelection(ImportThread.this.progressBar.getMaximum());
                }
            });
        }
    }

    public String[] getCustomFields() {
        return this.customFields;
    }

    @Override
    public void notifyOfProgress(final long progress) {
        if (!this.display.isDisposed() && !this.progressBar.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    ImportThread.this.progressBar.setSelection(ImportThread.this.progressBar.getSelection() + (int)(progress / 1024L));
                }
            });
        }
    }
}

