/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public final class MigrateThread
extends Thread {
    private final File from;
    private final Display display;
    private final Text log;
    private final ProgressBar progressBar;
    private final Label profileLabel;
    private String title;
    private int profileNumber;
    private List<Profile> profilesList;
    private List<DosboxVersion> dbversionsList;

    public MigrateThread(File from, Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
        this.from = from;
        this.log = log;
        this.progressBar = progressBar;
        this.profileLabel = profileLabel;
        this.display = log.getShell().getDisplay();
        this.profileNumber = 0;
        try {
            Database dbase = Database.getInstance();
            this.profilesList = dbase.readProfilesList(" ORDER BY LOWER(GAM.TITLE)", null);
            this.dbversionsList = dbase.readDosboxVersionsList();
            this.progressBar.setMaximum(this.profilesList.size());
        }
        catch (SQLException e) {
            this.profilesList = new ArrayList<Profile>();
            GeneralPurposeDialogs.warningMessage(log.getShell(), e.getMessage());
        }
    }

    public void run() {
        Database dbase = Database.getInstance();
        final StringBuffer displayedLog = new StringBuffer();
        final StringBuffer messageLog = new StringBuffer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        try {
            for (Profile prof : this.profilesList) {
                this.title = prof.getTitle();
                try {
                    File newFile;
                    File file = prof.getCanonicalConfFile();
                    DosboxVersion assocDBVersion = this.dbversionsList.get(DosboxVersion.findById(this.dbversionsList, prof.getDbversionId()));
                    Conf profileConf = new Conf(prof, assocDBVersion, ps);
                    profileConf.getAutoexec().migrateToDosroot(this.from);
                    if (bos.size() > 0) {
                        messageLog.append(bos.toString());
                        bos.reset();
                    }
                    profileConf.save();
                    String newConfigPath = prof.getConfPathAndFile();
                    if (new File(prof.getConfPathAndFile()).isAbsolute() && !(newFile = FileUtils.makeRelativeTo(file, this.from)).isAbsolute()) {
                        newConfigPath = FileUtils.DOSROOT_DIR + newFile.getPath();
                    }
                    dbase.updateProfileConf(newConfigPath, prof.getCaptures(), prof.getId());
                    String setup = prof.getSetup();
                    if (setup.length() > 0) {
                        setup = FileUtils.makeRelativeTo(new File(setup), this.from).getPath();
                    }
                    String[] links = prof.getLinks();
                    for (int i = 0; i < links.length; ++i) {
                        File newFile2;
                        if (links[i].toLowerCase().startsWith("file://")) {
                            links[i] = links[i].substring(7);
                        }
                        if (links[i].equals("") || links[i].contains("://") || (newFile2 = FileUtils.makeRelativeTo(new File(links[i]), this.from)).isAbsolute() || newFile2.getPath().startsWith(FileUtils.DOSROOT_DIR)) continue;
                        links[i] = FileUtils.DOSROOT_DIR + newFile2.getPath();
                    }
                    dbase.updateProfileSetupAndLinks(setup, links, prof.getId());
                }
                catch (IOException e) {
                    messageLog.append(e.getMessage()).append('\n');
                }
                if (!(this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed())) {
                    this.display.asyncExec(new Runnable(){

                        public void run() {
                            MigrateThread.this.profileLabel.setText(Settings.getInstance().msg("dialog.migration.migrating", new Object[]{MigrateThread.this.title}));
                            MigrateThread.this.profileLabel.pack();
                            if (messageLog.length() > displayedLog.length()) {
                                String newOutput = messageLog.substring(displayedLog.length());
                                MigrateThread.this.log.append(newOutput);
                                displayedLog.append(newOutput);
                            }
                            MigrateThread.this.progressBar.setSelection(MigrateThread.this.profileNumber++);
                        }
                    });
                    continue;
                }
                break;
            }
        }
        catch (SQLException se) {
            messageLog.append(se.getMessage());
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (messageLog.length() > displayedLog.length()) {
                        String newOutput = messageLog.substring(displayedLog.length());
                        MigrateThread.this.log.append(newOutput);
                        displayedLog.append(newOutput);
                    }
                }
            });
        }
        this.display.asyncExec(new Runnable(){

            public void run() {
                MigrateThread.this.progressBar.setSelection(MigrateThread.this.progressBar.getMaximum());
            }
        });
    }
}

