/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMUPDOWN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.UDACCEL;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    long hwndText;
    long hwndUpDown;
    boolean ignoreModify;
    boolean ignoreCharacter;
    int pageIncrement;
    int digits;
    static final long EditProc;
    static final TCHAR EditClass;
    static final long UpDownProc;
    static final TCHAR UpDownClass;
    public static final int LIMIT;

    static {
        EditClass = new TCHAR(0, "EDIT", true);
        UpDownClass = new TCHAR(0, "msctls_updown32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0L, EditClass, wNDCLASS);
        EditProc = wNDCLASS.lpfnWndProc;
        OS.GetClassInfo(0L, UpDownClass, wNDCLASS);
        UpDownProc = wNDCLASS.lpfnWndProc;
        LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    }

    public Spinner(Composite composite, int n) {
        super(composite, Spinner.checkStyle(n));
    }

    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        if (l == this.hwndText) {
            return OS.CallWindowProc(EditProc, l, n, l2, l3);
        }
        if (l == this.hwndUpDown) {
            return OS.CallWindowProc(UpDownProc, l, n, l2, l3);
        }
        return OS.DefWindowProc(this.handle, n, l2, l3);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    boolean checkHandle(long l) {
        return l == this.handle || l == this.hwndText || l == this.hwndUpDown;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        long l = OS.GetModuleHandle(null);
        int n = (this.style & 0x800) != 0 ? 512 : 0;
        int n2 = 1409286272;
        if ((this.style & 8) != 0) {
            n2 |= 0x800;
        }
        if (OS.WIN32_VERSION >= OS.VERSION(4, 10) && (this.style & 0x4000000) != 0) {
            n |= 0x400000;
        }
        this.hwndText = OS.CreateWindowEx(n, EditClass, null, n2, 0, 0, 0, 0, this.handle, 0L, l, null);
        if (this.hwndText == 0L) {
            this.error(2);
        }
        OS.SetWindowLongPtr(this.hwndText, -12, this.hwndText);
        int n3 = 0x50000010;
        if ((this.style & 0x40) != 0) {
            n3 |= 1;
        }
        if ((this.style & 0x800) != 0) {
            n3 = (this.style & 0x4000000) != 0 ? (n3 |= 8) : (n3 |= 4);
        }
        this.hwndUpDown = OS.CreateWindowEx(0, UpDownClass, null, n3, 0, 0, 0, 0, this.handle, 0L, l, null);
        if (this.hwndUpDown == 0L) {
            this.error(2);
        }
        int n4 = 19;
        this.SetWindowPos(this.hwndText, this.hwndUpDown, 0, 0, 0, 0, n4);
        OS.SetWindowLongPtr(this.hwndUpDown, -12, this.hwndUpDown);
        if (OS.IsDBLocale) {
            long l2 = OS.ImmGetContext(this.handle);
            OS.ImmAssociateContext(this.hwndText, l2);
            OS.ImmAssociateContext(this.hwndUpDown, l2);
            OS.ImmReleaseContext(this.handle, l2);
        }
        OS.SendMessage(this.hwndUpDown, 1135, 0L, 100L);
        OS.SendMessage(this.hwndUpDown, OS.IsWinCE ? 1127 : 1137, 0L, 0L);
        this.pageIncrement = 10;
        this.digits = 0;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), "0", true);
        OS.SetWindowText(this.hwndText, tCHAR);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    long borderHandle() {
        return this.hwndText;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (n == -1 || n2 == -1) {
            int n5;
            Object object;
            long l = 0L;
            long l2 = OS.GetDC(this.hwndText);
            long l3 = OS.SendMessage(this.hwndText, 49, 0L, 0L);
            if (l3 != 0L) {
                l = OS.SelectObject(l2, l3);
            }
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(l2, tEXTMETRIC);
            n4 = tEXTMETRIC.tmHeight;
            RECT rECT = new RECT();
            int[] nArray = new int[1];
            OS.SendMessage(this.hwndUpDown, 1136, null, nArray);
            String string = String.valueOf(nArray[0]);
            if (this.digits > 0) {
                object = new StringBuffer();
                ((StringBuffer)object).append(string);
                ((StringBuffer)object).append(this.getDecimalSeparator());
                n5 = this.digits - string.length();
                while (n5 >= 0) {
                    ((StringBuffer)object).append("0");
                    --n5;
                }
                string = ((StringBuffer)object).toString();
            }
            object = new TCHAR(this.getCodePage(), string, false);
            n5 = 11264;
            OS.DrawText(l2, (TCHAR)object, ((TCHAR)object).length(), rECT, n5);
            n3 = rECT.right - rECT.left;
            if (l3 != 0L) {
                OS.SelectObject(l2, l);
            }
            OS.ReleaseDC(this.hwndText, l2);
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
        if (n2 == -1) {
            int n6 = OS.GetSystemMetrics(20) + 2 * this.getBorderWidth();
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                n6 += (this.style & 0x800) != 0 ? 1 : 3;
            }
            rectangle.height = Math.max(rectangle.height, n6);
        }
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        int n5 = OS.GetWindowLong(this.hwndText, -16);
        int n6 = OS.GetWindowLong(this.hwndText, -20);
        OS.AdjustWindowRectEx(rECT, n5, false, n6);
        n3 = rECT.right - rECT.left;
        n4 = rECT.bottom - rECT.top;
        long l = OS.SendMessage(this.hwndText, 212, 0L, 0L);
        n -= OS.LOWORD(l);
        n3 += OS.LOWORD(l) + OS.HIWORD(l);
        if ((this.style & 0x800) != 0) {
            --n;
            --n2;
            n3 += 2;
            n4 += 2;
        }
        return new Rectangle(n, n2, n3 += OS.GetSystemMetrics(2), n4);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.hwndText, 769, 0L, 0L);
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.hwndText, 768, 0L, 0L);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        OS.EnableWindow(this.hwndText, bl);
        OS.EnableWindow(this.hwndUpDown, bl);
    }

    void deregister() {
        super.deregister();
        this.display.removeControl(this.hwndText);
        this.display.removeControl(this.hwndUpDown);
    }

    boolean hasFocus() {
        long l = OS.GetFocus();
        if (l == this.handle) {
            return true;
        }
        if (l == this.hwndText) {
            return true;
        }
        return l == this.hwndUpDown;
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    String getDecimalSeparator() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 4);
        int n = OS.GetLocaleInfo(1024, 14, tCHAR, 4);
        return n != 0 ? tCHAR.toString(0, n - 1) : ".";
    }

    public int getIncrement() {
        this.checkWidget();
        UDACCEL uDACCEL = new UDACCEL();
        OS.SendMessage(this.hwndUpDown, 1132, 1L, uDACCEL);
        return uDACCEL.nInc;
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, null, nArray);
        return nArray[0];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, nArray, null);
        return nArray[0];
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0L, 0L));
        }
        return (int)OS.SendMessage(this.hwndUpDown, 1138, 0L, 0L);
    }

    int getSelectionText(boolean[] blArray) {
        int n = OS.GetWindowTextLength(this.hwndText);
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.hwndText, tCHAR, n + 1);
        String string = tCHAR.toString(0, n);
        try {
            int n2;
            Object object;
            if (this.digits > 0) {
                object = this.getDecimalSeparator();
                int n3 = string.indexOf((String)object);
                if (n3 != -1) {
                    int n4;
                    int n5;
                    int n6 = string.startsWith("+") || string.startsWith("-") ? 1 : 0;
                    String string2 = n6 != n3 ? string.substring(n6, n3) : "0";
                    String string3 = string.substring(n3 + 1);
                    if (string3.length() > this.digits) {
                        string3 = string3.substring(0, this.digits);
                    } else {
                        n5 = this.digits - string3.length();
                        n4 = 0;
                        while (n4 < n5) {
                            string3 = String.valueOf(string3) + "0";
                            ++n4;
                        }
                    }
                    n5 = Integer.parseInt(string2);
                    n4 = Integer.parseInt(string3);
                    int n7 = 0;
                    while (n7 < this.digits) {
                        n5 *= 10;
                        ++n7;
                    }
                    n2 = n5 + n4;
                    if (string.startsWith("-")) {
                        n2 = -n2;
                    }
                } else {
                    n2 = Integer.parseInt(string);
                    int n8 = 0;
                    while (n8 < this.digits) {
                        n2 *= 10;
                        ++n8;
                    }
                }
            } else {
                n2 = Integer.parseInt(string);
            }
            object = new int[1];
            int[] nArray = new int[1];
            OS.SendMessage(this.hwndUpDown, 1136, nArray, (int[])object);
            if (nArray[0] <= n2 && n2 <= object[0]) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        blArray[0] = true;
        return -1;
    }

    public String getText() {
        this.checkWidget();
        int n = OS.GetWindowTextLength(this.hwndText);
        if (n == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.hwndText, tCHAR, n + 1);
        return tCHAR.toString(0, n);
    }

    public int getTextLimit() {
        this.checkWidget();
        return (int)OS.SendMessage(this.hwndText, 213, 0L, 0L) & Integer.MAX_VALUE;
    }

    int mbcsToWcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        int n2 = OS.GetWindowTextLengthA(this.hwndText);
        if (n2 == 0) {
            return 0;
        }
        if (n >= n2) {
            return n2;
        }
        byte[] byArray = new byte[n2 + 1];
        OS.GetWindowTextA(this.hwndText, byArray, n2 + 1);
        return OS.MultiByteToWideChar(this.getCodePage(), 1, byArray, n, null, 0);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.hwndText, 770, 0L, 0L);
    }

    void register() {
        super.register();
        this.display.addControl(this.hwndText, this);
        this.display.addControl(this.hwndUpDown, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.hwndUpDown = 0L;
        this.hwndText = 0L;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    boolean sendKeyEvent(int n, int n2, long l, long l2, Event event) {
        Object object;
        Object object2;
        if (!super.sendKeyEvent(n, n2, l, l2, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (n != 1) {
            return true;
        }
        if (n2 != 258 && n2 != 256 && n2 != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        char c = event.character;
        int n3 = event.stateMask;
        switch (n2) {
            case 258: {
                if (c != '\b' && c != '\u007f' && c != '\r' && c != '\t' && c != '\n') break;
            }
            case 256: {
                if ((n3 & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0) {
            return true;
        }
        String string = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.hwndText, 176, nArray, nArray2);
        switch (c) {
            case '\b': {
                if (nArray[0] != nArray2[0]) break;
                if (nArray[0] == 0) {
                    return true;
                }
                nArray[0] = nArray[0] - 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object2 = new int[1];
                    object = new int[1];
                    OS.SendMessage(this.hwndText, 177, (long)nArray[0], (long)nArray2[0]);
                    OS.SendMessage(this.hwndText, 176, (int[])object2, object);
                    if (nArray[0] != object2[0]) {
                        nArray[0] = nArray[0] - 1;
                    }
                }
                nArray[0] = Math.max(nArray[0], 0);
                break;
            }
            case '\u007f': {
                if (nArray[0] != nArray2[0]) break;
                int n4 = OS.GetWindowTextLength(this.hwndText);
                if (nArray[0] == n4) {
                    return true;
                }
                nArray2[0] = nArray2[0] + 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object = new int[1];
                    int[] nArray3 = new int[1];
                    OS.SendMessage(this.hwndText, 177, (long)nArray[0], (long)nArray2[0]);
                    OS.SendMessage(this.hwndText, 176, object, nArray3);
                    if (nArray2[0] != nArray3[0]) {
                        nArray2[0] = nArray2[0] + 1;
                    }
                }
                nArray2[0] = Math.min(nArray2[0], n4);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (c != '\t' && c < ' ') {
                    return true;
                }
                string = new String(new char[]{c});
            }
        }
        if ((object2 = this.verifyText(string, nArray[0], nArray2[0], event)) == null) {
            return false;
        }
        if (object2 == string) {
            return true;
        }
        object = new TCHAR(this.getCodePage(), (String)object2, true);
        OS.SendMessage(this.hwndText, 177, (long)nArray[0], (long)nArray2[0]);
        OS.SendMessage(this.hwndText, 194, 0L, (TCHAR)object);
        return false;
    }

    void setBackgroundImage(long l) {
        super.setBackgroundImage(l);
        OS.InvalidateRect(this.hwndText, null, true);
    }

    void setBackgroundPixel(int n) {
        super.setBackgroundPixel(n);
        OS.InvalidateRect(this.hwndText, null, true);
    }

    public void setDigits(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        if (n == this.digits) {
            return;
        }
        this.digits = n;
        int n2 = OS.IsWinCE ? OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0L, 0L)) : (int)OS.SendMessage(this.hwndUpDown, 1138, 0L, 0L);
        this.setSelection(n2, false, true, false);
    }

    void setForegroundPixel(int n) {
        super.setForegroundPixel(n);
        OS.InvalidateRect(this.hwndText, null, true);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        long l = OS.GetProcessHeap();
        int n2 = (int)OS.SendMessage(this.hwndUpDown, 1132, 0L, null);
        long l2 = OS.HeapAlloc(l, 8, UDACCEL.sizeof * n2);
        OS.SendMessage(this.hwndUpDown, 1132, (long)n2, l2);
        int n3 = -1;
        UDACCEL uDACCEL = new UDACCEL();
        int n4 = 0;
        while (n4 < n2) {
            long l3 = l2 + (long)(n4 * UDACCEL.sizeof);
            OS.MoveMemory(uDACCEL, l3, UDACCEL.sizeof);
            if (n3 == -1) {
                n3 = uDACCEL.nInc;
            }
            uDACCEL.nInc = uDACCEL.nInc / n3 * n;
            OS.MoveMemory(l3, uDACCEL, UDACCEL.sizeof);
            ++n4;
        }
        OS.SendMessage(this.hwndUpDown, 1131, (long)n2, l2);
        OS.HeapFree(l, 0, l2);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, nArray, null);
        if (n < nArray[0]) {
            return;
        }
        int n2 = OS.IsWinCE ? OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0L, 0L)) : (int)OS.SendMessage(this.hwndUpDown, 1138, 0L, 0L);
        OS.SendMessage(this.hwndUpDown, 1135, (long)nArray[0], (long)n);
        if (n2 > n) {
            this.setSelection(n, true, true, false);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, null, nArray);
        if (n > nArray[0]) {
            return;
        }
        int n2 = OS.IsWinCE ? OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0L, 0L)) : (int)OS.SendMessage(this.hwndUpDown, 1138, 0L, 0L);
        OS.SendMessage(this.hwndUpDown, 1135, (long)n, (long)nArray[0]);
        if (n2 < n) {
            this.setSelection(n, true, true, false);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.pageIncrement = n;
    }

    public void setSelection(int n) {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, nArray2, nArray);
        n = Math.min(Math.max(nArray2[0], n), nArray[0]);
        this.setSelection(n, true, true, false);
    }

    void setSelection(int n, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            OS.SendMessage(this.hwndUpDown, OS.IsWinCE ? 1127 : 1137, 0L, (long)n);
        }
        if (bl2) {
            int n2;
            Object object;
            String string;
            if (this.digits == 0) {
                string = String.valueOf(n);
            } else {
                string = String.valueOf(Math.abs(n));
                object = this.getDecimalSeparator();
                int n3 = string.length() - this.digits;
                StringBuffer stringBuffer = new StringBuffer();
                if (n < 0) {
                    stringBuffer.append("-");
                }
                if (n3 > 0) {
                    stringBuffer.append(string.substring(0, n3));
                    stringBuffer.append((String)object);
                    stringBuffer.append(string.substring(n3));
                } else {
                    stringBuffer.append("0");
                    stringBuffer.append((String)object);
                    while (n3++ < 0) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string);
                }
                string = stringBuffer.toString();
            }
            if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, n2 = OS.GetWindowTextLength(this.hwndText), null)) == null) {
                return;
            }
            object = new TCHAR(this.getCodePage(), string, true);
            OS.SetWindowText(this.hwndText, (TCHAR)object);
            OS.SendMessage(this.hwndText, 177, 0L, -1L);
            if (!OS.IsWinCE) {
                OS.NotifyWinEvent(32773, this.hwndText, -4, 0);
            }
        }
        if (bl3) {
            this.sendSelectionEvent(13);
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        OS.SendMessage(this.hwndText, 197, (long)n, 0L);
    }

    void setToolTipText(Shell shell, String string) {
        shell.setToolTipText(this.hwndText, string);
        shell.setToolTipText(this.hwndUpDown, string);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n3 < n2) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n = Math.min(Math.max(n2, n), n3);
        this.setIncrement(n5);
        this.pageIncrement = n6;
        this.digits = n4;
        OS.SendMessage(this.hwndUpDown, 1135, (long)n2, (long)n3);
        this.setSelection(n, true, true, false);
    }

    void subclass() {
        super.subclass();
        long l = this.display.windowProc;
        OS.SetWindowLongPtr(this.hwndText, -4, l);
        OS.SetWindowLongPtr(this.hwndUpDown, -4, l);
    }

    void unsubclass() {
        super.unsubclass();
        OS.SetWindowLongPtr(this.hwndText, -4, EditProc);
        OS.SetWindowLongPtr(this.hwndUpDown, -4, UpDownProc);
    }

    String verifyText(String string, int n, int n2, Event event) {
        Object object;
        Event event2 = new Event();
        event2.text = string;
        event2.start = n;
        event2.end = n2;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        int n3 = 0;
        if (this.digits > 0) {
            object = this.getDecimalSeparator();
            n3 = string.indexOf((String)object);
            if (n3 != -1) {
                string = String.valueOf(string.substring(0, n3)) + string.substring(n3 + 1);
            }
            n3 = 0;
        }
        if (string.length() > 0) {
            object = new int[1];
            OS.SendMessage(this.hwndUpDown, 1136, (int[])object, null);
            if (object[0] < 0 && string.charAt(0) == '-') {
                ++n3;
            }
        }
        while (n3 < string.length()) {
            if (!Character.isDigit(string.charAt(n3))) break;
            ++n3;
        }
        boolean bl = event2.doit = n3 == string.length();
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event2.start = this.mbcsToWcsPos(n);
            event2.end = this.mbcsToWcsPos(n2);
        }
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFFFFDFF;
    }

    long windowProc(long l, int n, long l2, long l3) {
        if (l == this.hwndText || l == this.hwndUpDown) {
            LRESULT lRESULT = null;
            switch (n) {
                case 258: {
                    lRESULT = this.wmChar(l, l2, l3);
                    break;
                }
                case 646: {
                    lRESULT = this.wmIMEChar(l, l2, l3);
                    break;
                }
                case 256: {
                    lRESULT = this.wmKeyDown(l, l2, l3);
                    break;
                }
                case 257: {
                    lRESULT = this.wmKeyUp(l, l2, l3);
                    break;
                }
                case 262: {
                    lRESULT = this.wmSysChar(l, l2, l3);
                    break;
                }
                case 260: {
                    lRESULT = this.wmSysKeyDown(l, l2, l3);
                    break;
                }
                case 261: {
                    lRESULT = this.wmSysKeyUp(l, l2, l3);
                    break;
                }
                case 533: {
                    lRESULT = this.wmCaptureChanged(l, l2, l3);
                    break;
                }
                case 515: {
                    lRESULT = this.wmLButtonDblClk(l, l2, l3);
                    break;
                }
                case 513: {
                    lRESULT = this.wmLButtonDown(l, l2, l3);
                    break;
                }
                case 514: {
                    lRESULT = this.wmLButtonUp(l, l2, l3);
                    break;
                }
                case 521: {
                    lRESULT = this.wmMButtonDblClk(l, l2, l3);
                    break;
                }
                case 519: {
                    lRESULT = this.wmMButtonDown(l, l2, l3);
                    break;
                }
                case 520: {
                    lRESULT = this.wmMButtonUp(l, l2, l3);
                    break;
                }
                case 673: {
                    lRESULT = this.wmMouseHover(l, l2, l3);
                    break;
                }
                case 675: {
                    lRESULT = this.wmMouseLeave(l, l2, l3);
                    break;
                }
                case 512: {
                    lRESULT = this.wmMouseMove(l, l2, l3);
                    break;
                }
                case 518: {
                    lRESULT = this.wmRButtonDblClk(l, l2, l3);
                    break;
                }
                case 516: {
                    lRESULT = this.wmRButtonDown(l, l2, l3);
                    break;
                }
                case 517: {
                    lRESULT = this.wmRButtonUp(l, l2, l3);
                    break;
                }
                case 525: {
                    lRESULT = this.wmXButtonDblClk(l, l2, l3);
                    break;
                }
                case 523: {
                    lRESULT = this.wmXButtonDown(l, l2, l3);
                    break;
                }
                case 524: {
                    lRESULT = this.wmXButtonUp(l, l2, l3);
                    break;
                }
                case 7: {
                    lRESULT = this.wmSetFocus(l, l2, l3);
                    break;
                }
                case 8: {
                    lRESULT = this.wmKillFocus(l, l2, l3);
                    break;
                }
                case 15: {
                    lRESULT = this.wmPaint(l, l2, l3);
                    break;
                }
                case 791: {
                    lRESULT = this.wmPrint(l, l2, l3);
                    break;
                }
                case 123: {
                    lRESULT = this.wmContextMenu(l, l2, l3);
                    break;
                }
                case 199: 
                case 768: 
                case 770: 
                case 771: 
                case 772: {
                    if (l != this.hwndText) break;
                    lRESULT = this.wmClipboard(l, n, l2, l3);
                }
            }
            if (lRESULT != null) {
                return lRESULT.value;
            }
            return this.callWindowProc(l, n, l2, l3);
        }
        return super.windowProc(l, n, l2, l3);
    }

    LRESULT WM_ERASEBKGND(long l, long l2) {
        super.WM_ERASEBKGND(l, l2);
        this.drawBackground(l);
        return LRESULT.ONE;
    }

    LRESULT WM_KILLFOCUS(long l, long l2) {
        return null;
    }

    LRESULT WM_SETFOCUS(long l, long l2) {
        OS.SetFocus(this.hwndText);
        OS.SendMessage(this.hwndText, 177, 0L, -1L);
        return null;
    }

    LRESULT WM_SETFONT(long l, long l2) {
        LRESULT lRESULT = super.WM_SETFONT(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        OS.SendMessage(this.hwndText, 48, l, l2);
        return lRESULT;
    }

    LRESULT WM_SIZE(long l, long l2) {
        LRESULT lRESULT = super.WM_SIZE(l, l2);
        if (this.isDisposed()) {
            return lRESULT;
        }
        int n = OS.LOWORD(l2);
        int n2 = OS.HIWORD(l2);
        int n3 = OS.GetSystemMetrics(2);
        int n4 = n - n3;
        int n5 = OS.GetSystemMetrics(45);
        int n6 = 52;
        this.SetWindowPos(this.hwndText, 0L, 0, 0, n4 + n5, n2, n6);
        this.SetWindowPos(this.hwndUpDown, 0L, n4, 0, n3, n2, n6);
        return lRESULT;
    }

    LRESULT wmIMEChar(long l, long l2, long l3) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = (int)l2;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, l2, l3)) {
            return LRESULT.ZERO;
        }
        this.ignoreCharacter = true;
        long l4 = this.callWindowProc(l, 646, l2, l3);
        MSG mSG = new MSG();
        int n = 10420227;
        while (OS.PeekMessage(mSG, l, 258, 258, n)) {
            OS.TranslateMessage(mSG);
            OS.DispatchMessage(mSG);
        }
        this.ignoreCharacter = false;
        this.sendKeyEvent(2, 646, l2, l3);
        display.lastAscii = 0;
        display.lastKey = 0;
        return new LRESULT(l4);
    }

    LRESULT wmChar(long l, long l2, long l3) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmChar(l, l2, l3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch ((int)l2) {
            case 13: {
                this.sendSelectionEvent(14);
            }
            case 9: 
            case 27: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmClipboard(long l, int n, long l2, long l3) {
        Object object;
        if ((this.style & 8) != 0) {
            return null;
        }
        boolean bl = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (n) {
            case 768: 
            case 771: {
                OS.SendMessage(l, 176, nArray, nArray2);
                if (nArray[0] == nArray2[0]) break;
                string = "";
                bl = true;
                break;
            }
            case 770: {
                OS.SendMessage(l, 176, nArray, nArray2);
                string = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage(l, 198, 0L, 0L) == 0L) break;
                this.ignoreModify = true;
                OS.CallWindowProc(EditProc, l, n, l2, l3);
                int n2 = OS.GetWindowTextLength(l);
                object = new int[1];
                int[] nArray3 = new int[1];
                OS.SendMessage(l, 176, (int[])object, nArray3);
                if (n2 != 0 && object[0] != nArray3[0]) {
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), n2 + 1);
                    OS.GetWindowText(l, tCHAR, n2 + 1);
                    string = tCHAR.toString((int)object[0], nArray3[0] - object[0]);
                } else {
                    string = "";
                }
                OS.CallWindowProc(EditProc, l, n, l2, l3);
                OS.SendMessage(l, 176, nArray, nArray2);
                this.ignoreModify = false;
            }
        }
        if (string != null) {
            String string2 = string;
            if ((string = this.verifyText(string, nArray[0], nArray2[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!string.equals(string2)) {
                if (bl) {
                    OS.CallWindowProc(EditProc, l, n, l2, l3);
                }
                object = new TCHAR(this.getCodePage(), string, true);
                if (n == 12) {
                    long l4 = OS.GetProcessHeap();
                    int n3 = ((TCHAR)object).length() * TCHAR.sizeof;
                    long l5 = OS.HeapAlloc(l4, 8, n3);
                    OS.MoveMemory(l5, (TCHAR)object, n3);
                    long l6 = OS.CallWindowProc(EditProc, l, n, l2, l5);
                    OS.HeapFree(l4, 0, l5);
                    return new LRESULT(l6);
                }
                OS.SendMessage(l, 194, 0L, (TCHAR)object);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    LRESULT wmCommandChild(long l, long l2) {
        int n = OS.HIWORD(l);
        switch (n) {
            case 768: {
                int n2;
                if (this.ignoreModify) break;
                boolean[] blArray = new boolean[1];
                int n3 = this.getSelectionText(blArray);
                if (!blArray[0] && (n2 = OS.IsWinCE ? OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0L, 0L)) : (int)OS.SendMessage(this.hwndUpDown, 1138, 0L, 0L)) != n3) {
                    this.setSelection(n3, true, false, true);
                }
                this.sendEvent(24);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
        }
        return super.wmCommandChild(l, l2);
    }

    LRESULT wmKeyDown(long l, long l2, long l3) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmKeyDown(l, l2, l3);
        if (lRESULT != null) {
            return lRESULT;
        }
        UDACCEL uDACCEL = new UDACCEL();
        OS.SendMessage(this.hwndUpDown, 1132, 1L, uDACCEL);
        int n = 0;
        switch ((int)l2) {
            case 38: {
                n = uDACCEL.nInc;
                break;
            }
            case 40: {
                n = -uDACCEL.nInc;
                break;
            }
            case 33: {
                n = this.pageIncrement;
                break;
            }
            case 34: {
                n = -this.pageIncrement;
            }
        }
        if (n != 0) {
            boolean[] blArray = new boolean[1];
            int n2 = this.getSelectionText(blArray);
            if (blArray[0]) {
                n2 = OS.IsWinCE ? OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0L, 0L)) : (int)OS.SendMessage(this.hwndUpDown, 1138, 0L, 0L);
            }
            int n3 = n2 + n;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage(this.hwndUpDown, 1136, nArray2, nArray);
            if ((this.style & 0x40) != 0) {
                if (n3 < nArray2[0]) {
                    n3 = nArray[0];
                }
                if (n3 > nArray[0]) {
                    n3 = nArray2[0];
                }
            }
            if (n2 != (n3 = Math.min(Math.max(nArray2[0], n3), nArray[0]))) {
                this.setSelection(n3, true, true, true);
            }
        }
        switch ((int)l2) {
            case 38: 
            case 40: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmKillFocus(long l, long l2, long l3) {
        boolean[] blArray = new boolean[1];
        int n = this.getSelectionText(blArray);
        if (blArray[0]) {
            n = OS.IsWinCE ? OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0L, 0L)) : (int)OS.SendMessage(this.hwndUpDown, 1138, 0L, 0L);
            this.setSelection(n, false, true, false);
        }
        return super.wmKillFocus(l, l2, l3);
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, long l, long l2) {
        switch (nMHDR.code) {
            case -722: {
                NMUPDOWN nMUPDOWN = new NMUPDOWN();
                OS.MoveMemory(nMUPDOWN, l2, NMUPDOWN.sizeof);
                int n = nMUPDOWN.iPos + nMUPDOWN.iDelta;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.SendMessage(this.hwndUpDown, 1136, nArray2, nArray);
                if ((this.style & 0x40) != 0) {
                    if (n < nArray2[0]) {
                        n = nArray[0];
                    }
                    if (n > nArray[0]) {
                        n = nArray2[0];
                    }
                }
                if ((n = Math.min(Math.max(nArray2[0], n), nArray[0])) != nMUPDOWN.iPos) {
                    this.setSelection(n, true, true, true);
                }
                return LRESULT.ONE;
            }
        }
        return super.wmNotifyChild(nMHDR, l, l2);
    }

    LRESULT wmScrollChild(long l, long l2) {
        int n = OS.LOWORD(l);
        switch (n) {
            case 4: {
                this.sendSelectionEvent(13);
            }
        }
        return super.wmScrollChild(l, l2);
    }
}

