/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.LoaderThread;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProfileLoader
extends Dialog {
    private Shell shell;
    private ProgressBar progressBar;
    private List<Profile> profs;
    private LoaderThread job = null;
    private List<ExpProfile> result = null;
    private boolean combine;
    private Settings settings;
    private Label status;
    private Text log;
    private Button okButton;
    private Button cancelButton;

    public ProfileLoader(Shell parent, int style) {
        super(parent, style);
    }

    public ProfileLoader(Shell parent, List<Profile> profs, boolean combine) {
        this(parent, 0);
        this.profs = profs;
        this.combine = combine;
        this.settings = Settings.getInstance();
    }

    public ProfileLoader(Shell parent) {
        this(parent, 0);
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        try {
            this.job = new LoaderThread(this.log, this.progressBar, this.status, this.profs, this.combine);
            this.job.start();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
            this.shell.close();
        }
        boolean finishedOnce = false;
        while (!this.shell.isDisposed()) {
            if (this.job != null && !this.job.isAlive() && !finishedOnce) {
                if (!this.job.isEverythingOk()) {
                    String msg = this.settings.msg("dialog.profileloader.error.reading");
                    if (!this.job.getResult().isEmpty()) {
                        this.okButton.setEnabled(true);
                        msg = msg + "\n\n" + this.settings.msg("dialog.profileloader.confirm.continue", new Object[]{this.job.getResult().size()});
                    }
                    GeneralPurposeDialogs.warningMessage(this.shell, msg);
                    this.status.setText(this.settings.msg("dialog.migration.reviewlog"));
                    this.status.pack();
                } else {
                    this.result = this.job.getResult();
                    this.shell.close();
                }
                finishedOnce = true;
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout(new GridLayout());
        this.shell.addControlListener(new SizeControlAdapter(this.shell, "profileloaderdialog"));
        this.shell.setText(this.settings.msg("dialog.profileloader.title", new Object[]{this.profs.size()}));
        Group progressGroup = new Group(this.shell, 0);
        progressGroup.setLayoutData(new GridData(4, 4, true, true));
        progressGroup.setText(this.settings.msg("dialog.migration.progress"));
        progressGroup.setLayout(new GridLayout());
        this.progressBar = new ProgressBar(progressGroup, 0);
        this.progressBar.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.progressBar.setMaximum(this.profs.size());
        this.status = new Label(progressGroup, 0);
        this.status.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.log = new Text(progressGroup, 2826);
        this.log.setLayoutData(new GridData(4, 4, true, true));
        Composite buttonComposite = new Composite(this.shell, 0);
        buttonComposite.setLayout(new GridLayout(2, true));
        this.okButton = new Button(buttonComposite, 0);
        this.shell.setDefaultButton(this.okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        this.okButton.setLayoutData(gridData);
        this.okButton.setText(this.settings.msg("button.ok"));
        this.okButton.setEnabled(false);
        this.okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProfileLoader.this.result = ProfileLoader.this.job.getResult();
                ProfileLoader.this.shell.close();
            }
        });
        this.cancelButton = new Button(buttonComposite, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = 4;
        this.cancelButton.setLayoutData(gridData_1);
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        this.cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProfileLoader.this.shell.close();
            }
        });
    }

    public List<ExpProfile> getResult() {
        return this.result;
    }

    public List<Configurable> getResultAsConfigurables() {
        return new ArrayList<Configurable>(this.result);
    }

    public ExpProfile getMultiProfileCombined() {
        return this.job.getMultiProfileCombined();
    }
}

