/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.MainWindow;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.searchengine.MobyGamesSearchEngine;
import org.dbgl.util.searchengine.PouetSearchEngine;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class SettingsDialog
extends Dialog {
    private static final List<String> SUPPORTED_LANGUAGES = Arrays.asList("da", "de", "en", "es", "it", "ko", "nl", "ru", "zh", "zh_TW");
    private static final SortedMap<String, Locale> allLocales = new TreeMap<String, Locale>();
    private static final int EDITABLE_COLUMN = 0;
    public static final String[] confLocations;
    public static final String[] confFilenames;
    public static final String[] buttonDisplayOptions;
    private Table visible_columns;
    private boolean changedVisColumns = false;
    private TableItem[] visibleColumns;
    private TabItem columnsTabItem;
    private Combo confFilename;
    private Combo confLocation;
    private Combo localeCombo;
    private Text port;
    private Label heightValue;
    private Label columnHeightValue;
    private Scale screenshotsHeight;
    private Scale screenshotsColumnHeight;
    private Combo buttonDisplay;
    private int previousSelection = -1;
    private Text values;
    private Text platformFilterValues;
    private Text platformFilterValuesPouet;
    private Text envValues;
    private SectionsWrapper conf;
    private org.eclipse.swt.widgets.List options;
    protected Object result;
    protected Shell shell;
    private Settings settings;

    public SettingsDialog(Shell parent, int style) {
        super(parent, style);
    }

    public SettingsDialog(Shell parent) {
        this(parent, 0);
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.conf = new SectionsWrapper(this.settings.getSettings());
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.result = this.changedVisColumns;
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout(new BorderLayout(0, 0));
        this.shell.addControlListener(new SizeControlAdapter(this.shell, "settingsdialog"));
        this.shell.setText(this.settings.msg("dialog.settings.title"));
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText(this.settings.msg("dialog.settings.tab.general"));
        Composite composite = new Composite(tabFolder, 0);
        composite.setLayout(new GridLayout());
        generalTabItem.setControl(composite);
        Group dosboxGroup = new Group(composite, 0);
        dosboxGroup.setText(this.settings.msg("dialog.settings.dosbox"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        dosboxGroup.setLayout(gridLayout);
        Label showConsoleLabel = new Label(dosboxGroup, 0);
        showConsoleLabel.setText(this.settings.msg("dialog.settings.hidestatuswindow"));
        final Button console = new Button(dosboxGroup, 32);
        console.setSelection(this.conf.getBooleanValue("dosbox", "hideconsole"));
        Group sendToGroup = new Group(composite, 0);
        sendToGroup.setText(this.settings.msg("dialog.settings.sendto"));
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 2;
        sendToGroup.setLayout(gridLayout_2);
        Label enableCommLabel = new Label(sendToGroup, 0);
        enableCommLabel.setText(this.settings.msg("dialog.settings.enableport"));
        final Button portEnabled = new Button(sendToGroup, 32);
        portEnabled.setSelection(this.conf.getBooleanValue("communication", "port_enabled"));
        portEnabled.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.this.port.setEnabled(portEnabled.getSelection());
            }
        });
        Label portnumberLabel = new Label(sendToGroup, 0);
        portnumberLabel.setText(this.settings.msg("dialog.settings.port"));
        this.port = new Text(sendToGroup, 2048);
        this.port.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.port.setText(this.conf.getValue("communication", "port"));
        this.port.setEnabled(portEnabled.getSelection());
        Group profileDefGroup = new Group(composite, 0);
        profileDefGroup.setText(this.settings.msg("dialog.settings.profiledefaults"));
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 3;
        profileDefGroup.setLayout(gridLayout_3);
        Label configFileLabel = new Label(profileDefGroup, 0);
        configFileLabel.setText(this.settings.msg("dialog.settings.configfile"));
        this.confLocation = new Combo(profileDefGroup, 8);
        this.confLocation.setItems(confLocations);
        this.confLocation.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.confLocation.select(this.conf.getIntValue("profiledefaults", "confpath"));
        this.confFilename = new Combo(profileDefGroup, 8);
        this.confFilename.setItems(confFilenames);
        this.confFilename.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.confFilename.select(this.conf.getIntValue("profiledefaults", "conffile"));
        Group i18nGroup = new Group(composite, 0);
        i18nGroup.setText(this.settings.msg("dialog.settings.i18n"));
        GridLayout gridLayout_30 = new GridLayout();
        gridLayout_30.numColumns = 2;
        i18nGroup.setLayout(gridLayout_30);
        Label languageLabel = new Label(i18nGroup, 0);
        languageLabel.setText(this.settings.msg("dialog.settings.languagecountry"));
        this.localeCombo = new Combo(i18nGroup, 8);
        Locale locale = new Locale(this.conf.getValue("locale", "language"), this.conf.getValue("locale", "country"));
        final TreeMap<String, Locale> locales = new TreeMap<String, Locale>();
        String locString = "";
        ArrayList<String> supportedLanguages = new ArrayList<String>(SUPPORTED_LANGUAGES);
        File[] files = new File("./plugins/i18n").listFiles();
        if (files != null) {
            for (File file : files) {
                String code;
                String name = file.getName();
                if (!name.startsWith("MessagesBundle_") || !name.endsWith(".properties") || (code = name.substring("MessagesBundle_".length(), name.indexOf(".properties"))).length() <= 0) continue;
                supportedLanguages.add(code);
            }
        }
        for (String lang : supportedLanguages) {
            Locale loc = (Locale)allLocales.get(lang);
            if (loc == null) continue;
            StringBuffer s = new StringBuffer(loc.getDisplayLanguage(Locale.getDefault()));
            if (loc.getCountry().length() > 0) {
                s.append(" - ").append(loc.getDisplayCountry(Locale.getDefault()));
            }
            locales.put(s.toString(), loc);
            if (!loc.equals(locale)) continue;
            locString = s.toString();
        }
        for (String sloc : locales.keySet()) {
            this.localeCombo.add(sloc);
        }
        this.localeCombo.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.localeCombo.setText(locString);
        this.localeCombo.setVisibleItemCount(20);
        this.columnsTabItem = new TabItem(tabFolder, 0);
        this.columnsTabItem.setText(this.settings.msg("dialog.settings.tab.profiletable"));
        Composite composite2 = new Composite(tabFolder, 0);
        composite2.setLayout(new BorderLayout(0, 0));
        this.columnsTabItem.setControl(composite2);
        Group visColumnsGroup = new Group(composite2, 0);
        visColumnsGroup.setLayout(new FillLayout());
        visColumnsGroup.setText(this.settings.msg("dialog.settings.visiblecolunms"));
        this.visible_columns = new Table(visColumnsGroup, 67616);
        this.visible_columns.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.visible_columns, 0);
        column1.setWidth(350);
        this.visibleColumns = new TableItem[MainWindow.columnNames.length];
        for (int i = 0; i < MainWindow.columnNames.length; ++i) {
            this.visibleColumns[i] = new TableItem(this.visible_columns, 2048);
            this.visibleColumns[i].setText(MainWindow.columnNames[i]);
            this.visibleColumns[i].setChecked(this.conf.getBooleanValue("gui", "column" + (i + 1) + "visible"));
        }
        final TableEditor editor = new TableEditor(this.visible_columns);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        this.visible_columns.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)event.item) == null) {
                    return;
                }
                int idx = item.getParent().getSelectionIndex();
                if (idx < 10 || idx == 20 || idx == 21) {
                    return;
                }
                Text newEditor = new Text(SettingsDialog.this.visible_columns, 0);
                newEditor.setText(item.getText(0));
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent mEvent) {
                        Text text = (Text)editor.getEditor();
                        editor.getItem().setText(0, text.getText());
                    }
                });
                newEditor.selectAll();
                newEditor.setFocus();
                editor.setEditor(newEditor, item, 0);
            }
        });
        Group addProfGroup = new Group(composite2, 0);
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 2;
        addProfGroup.setLayout(gridLayout_4);
        addProfGroup.setText(this.settings.msg("dialog.settings.addeditduplicateprofile"));
        addProfGroup.setLayoutData("South");
        Label autoSortLabel = new Label(addProfGroup, 0);
        autoSortLabel.setText(this.settings.msg("dialog.settings.autosort"));
        final Button autosort = new Button(addProfGroup, 32);
        autosort.setSelection(this.conf.getBooleanValue("gui", "autosortonupdate"));
        TabItem dynTabItem = new TabItem(tabFolder, 0);
        dynTabItem.setText(this.settings.msg("dialog.settings.tab.dynamicoptions"));
        Composite composite_1 = new Composite(tabFolder, 0);
        composite_1.setLayout(new FillLayout());
        dynTabItem.setControl(composite_1);
        Group dynOptionsGroup = new Group(composite_1, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        dynOptionsGroup.setLayout(gridLayout_1);
        dynOptionsGroup.setText(this.settings.msg("dialog.settings.dynamicoptions"));
        Label optionsLabel = new Label(dynOptionsGroup, 0);
        optionsLabel.setText(this.settings.msg("dialog.settings.options"));
        Label valuesLabel = new Label(dynOptionsGroup, 0);
        valuesLabel.setText(this.settings.msg("dialog.settings.values"));
        this.options = new org.eclipse.swt.widgets.List(dynOptionsGroup, 2560);
        this.options.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.this.storeValues();
                SettingsDialog.this.previousSelection = SettingsDialog.this.options.getSelectionIndex();
                if (SettingsDialog.this.previousSelection != -1) {
                    SettingsDialog.this.values.setText(SettingsDialog.this.conf.getMultilineValues("profile", SettingsDialog.this.options.getItem(SettingsDialog.this.previousSelection), SettingsDialog.this.values.getLineDelimiter()));
                }
            }
        });
        this.options.setLayoutData(new GridData(4, 4, true, true));
        for (String s : this.conf.getAllItemNames("profile")) {
            this.options.add(s);
        }
        this.values = new Text(dynOptionsGroup, 2818);
        this.values.setLayoutData(new GridData(4, 4, true, true));
        TabItem guiTabItem = new TabItem(tabFolder, 0);
        guiTabItem.setText(this.settings.msg("dialog.settings.tab.gui"));
        final Composite composite1 = new Composite(tabFolder, 0);
        GridLayout composite1Layout = new GridLayout();
        composite1Layout.numColumns = 2;
        composite1.setLayout(composite1Layout);
        guiTabItem.setControl(composite1);
        Group screenshots = new Group(composite1, 0);
        GridLayout screenshotsLayout = new GridLayout();
        screenshotsLayout.numColumns = 3;
        screenshots.setLayout(screenshotsLayout);
        GridData screenshotsLData = new GridData();
        screenshotsLData.grabExcessHorizontalSpace = true;
        screenshotsLData.horizontalAlignment = 4;
        screenshotsLData.horizontalSpan = 2;
        screenshots.setLayoutData(screenshotsLData);
        screenshots.setText(this.settings.msg("dialog.settings.screenshots"));
        Label heightLabel = new Label(screenshots, 0);
        heightLabel.setText(this.settings.msg("dialog.settings.height"));
        GridData sshotsHeightData = new GridData();
        sshotsHeightData.grabExcessHorizontalSpace = true;
        sshotsHeightData.horizontalAlignment = 4;
        this.screenshotsHeight = new Scale(screenshots, 0);
        this.screenshotsHeight.setMaximum(750);
        this.screenshotsHeight.setMinimum(50);
        this.screenshotsHeight.setLayoutData(sshotsHeightData);
        this.screenshotsHeight.setIncrement(25);
        this.screenshotsHeight.setPageIncrement(100);
        this.screenshotsHeight.setSelection(this.conf.getIntValue("gui", "screenshotsheight"));
        this.screenshotsHeight.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SettingsDialog.this.heightValue.setText(SettingsDialog.this.screenshotsHeight.getSelection() + SettingsDialog.this.settings.msg("dialog.settings.px"));
                SettingsDialog.this.heightValue.pack();
            }
        });
        this.heightValue = new Label(screenshots, 0);
        this.heightValue.setText(this.screenshotsHeight.getSelection() + this.settings.msg("dialog.settings.px"));
        Label displayFilenameLabel = new Label(screenshots, 0);
        displayFilenameLabel.setText(this.settings.msg("dialog.settings.screenshotsfilename"));
        final Button displayFilename = new Button(screenshots, 32);
        displayFilename.setSelection(this.conf.getBooleanValue("gui", "screenshotsfilename"));
        Group screenshotsColumn = new Group(composite1, 0);
        screenshotsColumn.setLayout(new GridLayout(3, false));
        GridData screenshotsCData = new GridData();
        screenshotsCData.grabExcessHorizontalSpace = true;
        screenshotsCData.horizontalAlignment = 4;
        screenshotsCData.horizontalSpan = 2;
        screenshotsColumn.setLayoutData(screenshotsCData);
        screenshotsColumn.setText(this.settings.msg("dialog.settings.screenshotscolumn"));
        Label columnHeightLabel = new Label(screenshotsColumn, 0);
        columnHeightLabel.setText(this.settings.msg("dialog.settings.height"));
        this.screenshotsColumnHeight = new Scale(screenshotsColumn, 0);
        this.screenshotsColumnHeight.setMaximum(200);
        this.screenshotsColumnHeight.setMinimum(16);
        GridData sshotsColumnHeightData = new GridData();
        sshotsColumnHeightData.grabExcessHorizontalSpace = true;
        sshotsColumnHeightData.horizontalAlignment = 4;
        this.screenshotsColumnHeight.setLayoutData(sshotsColumnHeightData);
        this.screenshotsColumnHeight.setIncrement(4);
        this.screenshotsColumnHeight.setPageIncrement(16);
        this.screenshotsColumnHeight.setSelection(this.conf.getIntValue("gui", "screenshotscolumnheight"));
        this.screenshotsColumnHeight.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SettingsDialog.this.columnHeightValue.setText(SettingsDialog.this.screenshotsColumnHeight.getSelection() + SettingsDialog.this.settings.msg("dialog.settings.px"));
                SettingsDialog.this.columnHeightValue.pack();
            }
        });
        this.columnHeightValue = new Label(screenshotsColumn, 0);
        this.columnHeightValue.setText(this.screenshotsColumnHeight.getSelection() + this.settings.msg("dialog.settings.px"));
        Group buttonsGroup = new Group(composite1, 0);
        buttonsGroup.setLayoutData(new GridData(16384, 0x1000000, true, false));
        buttonsGroup.setLayout(new GridLayout(2, false));
        buttonsGroup.setText(this.settings.msg("dialog.settings.buttons"));
        Label buttonLabel = new Label(buttonsGroup, 0);
        buttonLabel.setLayoutData(new GridData(4, 0x1000000, true, false));
        buttonLabel.setText(this.settings.msg("dialog.settings.display"));
        this.buttonDisplay = new Combo(buttonsGroup, 8);
        this.buttonDisplay.setItems(buttonDisplayOptions);
        this.buttonDisplay.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.buttonDisplay.select(this.conf.getIntValue("gui", "buttondisplay"));
        final Group notesGroup = new Group(composite1, 0);
        notesGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        notesGroup.setLayout(new GridLayout(2, false));
        notesGroup.setText(this.settings.msg("dialog.profile.notes"));
        Label fontLabel = new Label(notesGroup, 0);
        fontLabel.setLayoutData(new GridData(4, 0x1000000, true, false));
        fontLabel.setText(this.settings.msg("dialog.settings.font"));
        final Button fontButton = new Button(notesGroup, 8);
        fontButton.setLayoutData(new GridData(4, 0x1000000, true, false));
        Font f = GeneralPurposeGUI.stringToFont(this.shell.getDisplay(), this.port.getFont(), this.conf.getValues("gui", "notesfont"));
        fontButton.setText(f.getFontData()[0].getName());
        fontButton.setFont(f);
        fontButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog fd = new FontDialog(SettingsDialog.this.shell, 0);
                fd.setFontList(fontButton.getFont().getFontData());
                FontData newFont = fd.open();
                if (newFont != null) {
                    fontButton.setText(newFont.getName());
                    fontButton.setFont(new Font((Device)SettingsDialog.this.shell.getDisplay(), newFont));
                    notesGroup.setSize(notesGroup.computeSize(-1, -1));
                    composite1.layout();
                }
            }
        });
        WebSearchEngine engine = MobyGamesSearchEngine.getInstance();
        TabItem mobygamesTabItem = new TabItem(tabFolder, 0);
        mobygamesTabItem.setText(this.settings.msg("dialog.settings.tab.mobygames"));
        Composite composite3 = new Composite(tabFolder, 0);
        GridLayout composite3Layout = new GridLayout();
        composite3Layout.makeColumnsEqualWidth = true;
        composite3.setLayout(composite3Layout);
        mobygamesTabItem.setControl(composite3);
        Group consult = new Group(composite3, 0);
        GridLayout consultLayout = new GridLayout();
        consultLayout.numColumns = 2;
        consult.setLayout(consultLayout);
        GridData consultLData = new GridData();
        consultLData.grabExcessHorizontalSpace = true;
        consultLData.horizontalAlignment = 4;
        consultLData.grabExcessVerticalSpace = true;
        consultLData.verticalAlignment = 4;
        consult.setLayoutData(consultLData);
        consult.setText(this.settings.msg("dialog.settings.consult", new String[]{engine.getName()}));
        Label titleLabel = new Label(consult, 0);
        titleLabel.setText(this.settings.msg("dialog.settings.settitle"));
        final Button setTitle = new Button(consult, 32);
        setTitle.setSelection(this.conf.getBooleanValue("mobygames", "set_title"));
        Label devLabel = new Label(consult, 0);
        devLabel.setText(this.settings.msg("dialog.settings.setdeveloper"));
        final Button setDev = new Button(consult, 32);
        setDev.setSelection(this.conf.getBooleanValue("mobygames", "set_developer"));
        Label pubLabel = new Label(consult, 0);
        pubLabel.setText(this.settings.msg("dialog.settings.setpublisher"));
        final Button setPub = new Button(consult, 32);
        setPub.setSelection(this.conf.getBooleanValue("mobygames", "set_publisher"));
        Label yearLabel = new Label(consult, 0);
        yearLabel.setText(this.settings.msg("dialog.settings.setyear"));
        final Button setYear = new Button(consult, 32);
        setYear.setSelection(this.conf.getBooleanValue("mobygames", "set_year"));
        Label genreLabel = new Label(consult, 0);
        genreLabel.setText(this.settings.msg("dialog.settings.setgenre"));
        final Button setGenre = new Button(consult, 32);
        setGenre.setSelection(this.conf.getBooleanValue("mobygames", "set_genre"));
        Label linkLabel = new Label(consult, 0);
        linkLabel.setText(this.settings.msg("dialog.settings.setlink", new String[]{engine.getName()}));
        final Button setLink = new Button(consult, 32);
        setLink.setSelection(this.conf.getBooleanValue("mobygames", "set_link"));
        Label rankLabel = new Label(consult, 0);
        rankLabel.setText(this.settings.msg("dialog.settings.setrank", new Object[]{MainWindow.columnNames[18]}));
        final Button setRank = new Button(consult, 32);
        setRank.setSelection(this.conf.getBooleanValue("mobygames", "set_rank"));
        Label descrLabel = new Label(consult, 0);
        descrLabel.setText(this.settings.msg("dialog.settings.setdescription"));
        final Button setDescr = new Button(consult, 32);
        setDescr.setSelection(this.conf.getBooleanValue("mobygames", "set_description"));
        Label chooseCoverArtLabel = new Label(consult, 0);
        chooseCoverArtLabel.setText(this.settings.msg("dialog.settings.choosecoverart"));
        final Button chooseCoverArt = new Button(consult, 32);
        chooseCoverArt.setSelection(this.conf.getBooleanValue("mobygames", "choose_coverart"));
        Label chooseScreenshotLabel = new Label(consult, 0);
        chooseScreenshotLabel.setText(this.settings.msg("dialog.settings.choosescreenshot"));
        final Button chooseScreenshot = new Button(consult, 32);
        chooseScreenshot.setSelection(this.conf.getBooleanValue("mobygames", "choose_screenshot"));
        Label maxCoverArtLabel = new Label(consult, 0);
        maxCoverArtLabel.setText(this.settings.msg("dialog.settings.multieditmaxcoverart"));
        final Spinner maxCoverArt = new Spinner(consult, 2048);
        maxCoverArt.setLayoutData(new GridData(100, -1));
        maxCoverArt.setMinimum(0);
        maxCoverArt.setMaximum(Integer.MAX_VALUE);
        maxCoverArt.setSelection(this.conf.getIntValue("mobygames", "multi_max_coverart"));
        Label maxScreenshotsLabel = new Label(consult, 0);
        maxScreenshotsLabel.setText(this.settings.msg("dialog.settings.multieditmaxscreenshot"));
        final Spinner maxScreenshots = new Spinner(consult, 2048);
        maxScreenshots.setLayoutData(new GridData(100, -1));
        maxScreenshots.setMinimum(0);
        maxScreenshots.setMaximum(Integer.MAX_VALUE);
        maxScreenshots.setSelection(this.conf.getIntValue("mobygames", "multi_max_screenshot"));
        Label filterLabel = new Label(consult, 0);
        filterLabel.setText(this.settings.msg("dialog.settings.platformfilter"));
        this.platformFilterValues = new Text(consult, 2818);
        this.platformFilterValues.setLayoutData(new GridData(4, 4, true, true));
        this.platformFilterValues.setText(this.conf.getMultilineValues("mobygames", "platform_filter", this.platformFilterValues.getLineDelimiter()));
        engine = PouetSearchEngine.getInstance();
        TabItem pouetTabItem = new TabItem(tabFolder, 0);
        pouetTabItem.setText(this.settings.msg("dialog.settings.tab.pouet"));
        Composite composite3p = new Composite(tabFolder, 0);
        GridLayout composite3pLayout = new GridLayout();
        composite3pLayout.makeColumnsEqualWidth = true;
        composite3p.setLayout(composite3pLayout);
        pouetTabItem.setControl(composite3p);
        Group consultp = new Group(composite3p, 0);
        GridLayout consultpLayout = new GridLayout();
        consultpLayout.numColumns = 2;
        consultp.setLayout(consultpLayout);
        GridData consultpLData = new GridData();
        consultpLData.grabExcessHorizontalSpace = true;
        consultpLData.horizontalAlignment = 4;
        consultpLData.grabExcessVerticalSpace = true;
        consultpLData.verticalAlignment = 4;
        consultp.setLayoutData(consultpLData);
        consultp.setText(this.settings.msg("dialog.settings.consult", new String[]{engine.getName()}));
        Label titlepLabel = new Label(consultp, 0);
        titlepLabel.setText(this.settings.msg("dialog.settings.settitle"));
        final Button setTitlePouet = new Button(consultp, 32);
        setTitlePouet.setSelection(this.conf.getBooleanValue("pouet", "set_title"));
        Label devpLabel = new Label(consultp, 0);
        devpLabel.setText(this.settings.msg("dialog.settings.setdeveloper"));
        final Button setDevPouet = new Button(consultp, 32);
        setDevPouet.setSelection(this.conf.getBooleanValue("pouet", "set_developer"));
        Label yearpLabel = new Label(consultp, 0);
        yearpLabel.setText(this.settings.msg("dialog.settings.setyear"));
        final Button setYearPouet = new Button(consultp, 32);
        setYearPouet.setSelection(this.conf.getBooleanValue("pouet", "set_year"));
        Label genrepLabel = new Label(consultp, 0);
        genrepLabel.setText(this.settings.msg("dialog.settings.setgenre"));
        final Button setGenrePouet = new Button(consultp, 32);
        setGenrePouet.setSelection(this.conf.getBooleanValue("pouet", "set_genre"));
        Label linkpLabel = new Label(consultp, 0);
        linkpLabel.setText(this.settings.msg("dialog.settings.setlink", new String[]{engine.getName()}));
        final Button setLinkPouet = new Button(consultp, 32);
        setLinkPouet.setSelection(this.conf.getBooleanValue("pouet", "set_link"));
        Label rankpLabel = new Label(consultp, 0);
        rankpLabel.setText(this.settings.msg("dialog.settings.setrank", new Object[]{MainWindow.columnNames[18]}));
        final Button setRankPouet = new Button(consultp, 32);
        setRankPouet.setSelection(this.conf.getBooleanValue("pouet", "set_rank"));
        Label chooseScreenshotLabelp = new Label(consultp, 0);
        chooseScreenshotLabelp.setText(this.settings.msg("dialog.settings.choosescreenshot"));
        final Button chooseScreenshotp = new Button(consultp, 32);
        chooseScreenshotp.setSelection(this.conf.getBooleanValue("pouet", "choose_screenshot"));
        Label maxScreenshotsLabelp = new Label(consultp, 0);
        maxScreenshotsLabelp.setText(this.settings.msg("dialog.settings.multieditmaxscreenshot"));
        final Spinner maxScreenshotsp = new Spinner(consultp, 2048);
        maxScreenshotsp.setLayoutData(new GridData(100, -1));
        maxScreenshotsp.setMinimum(0);
        maxScreenshotsp.setMaximum(Integer.MAX_VALUE);
        maxScreenshotsp.setSelection(this.conf.getIntValue("pouet", "multi_max_screenshot"));
        Label filterpLabel = new Label(consultp, 0);
        filterpLabel.setText(this.settings.msg("dialog.settings.platformfilter"));
        this.platformFilterValuesPouet = new Text(consultp, 2818);
        this.platformFilterValuesPouet.setLayoutData(new GridData(4, 4, true, true));
        this.platformFilterValuesPouet.setText(this.conf.getMultilineValues("pouet", "platform_filter", this.platformFilterValuesPouet.getLineDelimiter()));
        TabItem envTabItem = new TabItem(tabFolder, 0);
        envTabItem.setText(this.settings.msg("dialog.settings.tab.environment"));
        Composite composite4 = new Composite(tabFolder, 0);
        GridLayout composite4Layout = new GridLayout();
        composite4Layout.makeColumnsEqualWidth = true;
        composite4.setLayout(composite4Layout);
        envTabItem.setControl(composite4);
        Group envGroup = new Group(composite4, 0);
        GridLayout envLayout = new GridLayout();
        envLayout.numColumns = 2;
        envGroup.setLayout(envLayout);
        GridData envLData = new GridData();
        envLData.grabExcessHorizontalSpace = true;
        envLData.horizontalAlignment = 4;
        envLData.grabExcessVerticalSpace = true;
        envLData.verticalAlignment = 4;
        envGroup.setLayoutData(envLData);
        envGroup.setText(this.settings.msg("dialog.settings.environment"));
        Label enableEnvLabel = new Label(envGroup, 0);
        enableEnvLabel.setText(this.settings.msg("dialog.settings.enableenvironment"));
        final Button enableEnv = new Button(envGroup, 32);
        enableEnv.setSelection(this.conf.getBooleanValue("environment", "use"));
        enableEnv.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.this.envValues.setEnabled(enableEnv.getSelection());
            }
        });
        Label envLabel = new Label(envGroup, 0);
        envLabel.setText(this.settings.msg("dialog.settings.environmentvariables"));
        this.envValues = new Text(envGroup, 2818);
        this.envValues.setLayoutData(new GridData(4, 4, true, true));
        this.envValues.setText(this.conf.getMultilineValues("environment", "value", this.envValues.getLineDelimiter()));
        this.envValues.setEnabled(enableEnv.getSelection());
        Composite composite_7 = new Composite(this.shell, 0);
        composite_7.setLayout(new GridLayout(2, true));
        composite_7.setLayoutData("South");
        Button okButton = new Button(composite_7, 0);
        okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i;
                if (!SettingsDialog.this.isValid()) {
                    return;
                }
                for (i = 0; i < MainWindow.columnNames.length; ++i) {
                    if (SettingsDialog.this.conf.getBooleanValue("gui", "column" + (i + 1) + "visible") == SettingsDialog.this.visibleColumns[i].getChecked()) continue;
                    SettingsDialog.this.changedVisColumns = true;
                }
                for (i = 0; i < 10; ++i) {
                    if (MainWindow.columnNames[i + 10].equals(SettingsDialog.this.visibleColumns[i + 10].getText())) continue;
                    SettingsDialog.this.changedVisColumns = true;
                }
                if (SettingsDialog.this.changedVisColumns) {
                    SettingsDialog.this.resetColumnSettings();
                }
                SettingsDialog.this.conf.setBooleanValue("dosbox", "hideconsole", console.getSelection());
                SettingsDialog.this.conf.setBooleanValue("communication", "port_enabled", portEnabled.getSelection());
                SettingsDialog.this.conf.setValue("communication", "port", SettingsDialog.this.port.getText());
                SettingsDialog.this.conf.setIntValue("profiledefaults", "confpath", SettingsDialog.this.confLocation.getSelectionIndex());
                SettingsDialog.this.conf.setIntValue("profiledefaults", "conffile", SettingsDialog.this.confFilename.getSelectionIndex());
                SettingsDialog.this.conf.setValue("locale", "language", ((Locale)locales.get(SettingsDialog.this.localeCombo.getText())).getLanguage());
                SettingsDialog.this.conf.setValue("locale", "country", ((Locale)locales.get(SettingsDialog.this.localeCombo.getText())).getCountry());
                for (i = 0; i < MainWindow.columnNames.length; ++i) {
                    SettingsDialog.this.conf.setBooleanValue("gui", "column" + (i + 1) + "visible", SettingsDialog.this.visibleColumns[i].getChecked());
                }
                SettingsDialog.this.conf.setBooleanValue("gui", "autosortonupdate", autosort.getSelection());
                for (i = 0; i < 10; ++i) {
                    SettingsDialog.this.conf.setValue("gui", "custom" + (i + 1), SettingsDialog.this.visibleColumns[i + 10].getText());
                }
                SettingsDialog.this.conf.setIntValue("gui", "screenshotsheight", SettingsDialog.this.screenshotsHeight.getSelection());
                SettingsDialog.this.conf.setBooleanValue("gui", "screenshotsfilename", displayFilename.getSelection());
                SettingsDialog.this.conf.setIntValue("gui", "screenshotscolumnheight", SettingsDialog.this.screenshotsColumnHeight.getSelection());
                Rectangle rec = SettingsDialog.this.shell.getBounds();
                SettingsDialog.this.conf.setIntValue("gui", "settingsdialog_width", rec.width);
                SettingsDialog.this.conf.setIntValue("gui", "settingsdialog_height", rec.height);
                SettingsDialog.this.conf.setIntValue("gui", "buttondisplay", SettingsDialog.this.buttonDisplay.getSelectionIndex());
                SettingsDialog.this.conf.setMultilineValues("gui", "notesfont", GeneralPurposeGUI.fontToString(SettingsDialog.this.shell.getDisplay(), fontButton.getFont()), "|");
                SettingsDialog.this.conf.setBooleanValue("mobygames", "set_title", setTitle.getSelection());
                SettingsDialog.this.conf.setBooleanValue("mobygames", "set_developer", setDev.getSelection());
                SettingsDialog.this.conf.setBooleanValue("mobygames", "set_publisher", setPub.getSelection());
                SettingsDialog.this.conf.setBooleanValue("mobygames", "set_year", setYear.getSelection());
                SettingsDialog.this.conf.setBooleanValue("mobygames", "set_genre", setGenre.getSelection());
                SettingsDialog.this.conf.setBooleanValue("mobygames", "set_link", setLink.getSelection());
                SettingsDialog.this.conf.setBooleanValue("mobygames", "set_description", setDescr.getSelection());
                SettingsDialog.this.conf.setBooleanValue("mobygames", "set_rank", setRank.getSelection());
                SettingsDialog.this.conf.setMultilineValues("mobygames", "platform_filter", SettingsDialog.this.platformFilterValues.getText(), SettingsDialog.this.platformFilterValues.getLineDelimiter());
                SettingsDialog.this.conf.setBooleanValue("mobygames", "choose_coverart", chooseCoverArt.getSelection());
                SettingsDialog.this.conf.setBooleanValue("mobygames", "choose_screenshot", chooseScreenshot.getSelection());
                SettingsDialog.this.conf.setIntValue("mobygames", "multi_max_coverart", maxCoverArt.getSelection());
                SettingsDialog.this.conf.setIntValue("mobygames", "multi_max_screenshot", maxScreenshots.getSelection());
                SettingsDialog.this.conf.setBooleanValue("pouet", "set_title", setTitlePouet.getSelection());
                SettingsDialog.this.conf.setBooleanValue("pouet", "set_developer", setDevPouet.getSelection());
                SettingsDialog.this.conf.setBooleanValue("pouet", "set_year", setYearPouet.getSelection());
                SettingsDialog.this.conf.setBooleanValue("pouet", "set_genre", setGenrePouet.getSelection());
                SettingsDialog.this.conf.setBooleanValue("pouet", "set_link", setLinkPouet.getSelection());
                SettingsDialog.this.conf.setBooleanValue("pouet", "set_rank", setRankPouet.getSelection());
                SettingsDialog.this.conf.setMultilineValues("pouet", "platform_filter", SettingsDialog.this.platformFilterValuesPouet.getText(), SettingsDialog.this.platformFilterValuesPouet.getLineDelimiter());
                SettingsDialog.this.conf.setBooleanValue("pouet", "choose_screenshot", chooseScreenshotp.getSelection());
                SettingsDialog.this.conf.setIntValue("pouet", "multi_max_screenshot", maxScreenshotsp.getSelection());
                SettingsDialog.this.conf.setBooleanValue("environment", "use", enableEnv.getSelection());
                SettingsDialog.this.conf.setMultilineValues("environment", "value", SettingsDialog.this.envValues.getText(), SettingsDialog.this.envValues.getLineDelimiter());
                SettingsDialog.this.storeValues();
                SettingsDialog.this.settings.getSettings().injectValuesFrom(SettingsDialog.this.conf);
                SettingsDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        okButton.setLayoutData(gridData);
        okButton.setText(this.settings.msg("button.ok"));
        Button cancelButton = new Button(composite_7, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = 4;
        cancelButton.setLayoutData(gridData_1);
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.this.shell.close();
            }
        });
    }

    private void storeValues() {
        if (this.previousSelection != -1) {
            this.conf.setMultilineValues("profile", this.options.getItem(this.previousSelection), this.values.getText(), this.values.getLineDelimiter());
        }
    }

    private int countVisibleColumns() {
        int result = 0;
        for (int i = 0; i < MainWindow.columnNames.length; ++i) {
            if (!this.visibleColumns[i].getChecked()) continue;
            ++result;
        }
        return result;
    }

    private int getFirstVisibleColumn() {
        for (int i = 0; i < MainWindow.columnNames.length; ++i) {
            if (!this.visibleColumns[i].getChecked()) continue;
            return i;
        }
        return -1;
    }

    private void resetColumnSettings() {
        this.conf.setIntValue("gui", "sortcolumn", this.getFirstVisibleColumn());
        this.conf.setBooleanValue("gui", "sortascending", true);
        StringBuffer colOrder = new StringBuffer();
        for (int i = 0; i < this.countVisibleColumns(); ++i) {
            colOrder.append(i).append(' ');
        }
        this.conf.setValue("gui", "columnorder", colOrder.toString().trim());
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.countVisibleColumns() == 0) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.settings.required.onevisiblecolumn"), this.visible_columns, this.columnsTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    static {
        for (Locale loc : Locale.getAvailableLocales()) {
            allLocales.put(loc.toString(), loc);
        }
        confLocations = new String[]{Settings.getInstance().msg("dialog.settings.confindbgldir"), Settings.getInstance().msg("dialog.settings.confingamedir")};
        confFilenames = new String[]{Settings.getInstance().msg("dialog.settings.conffilebyid"), Settings.getInstance().msg("dialog.settings.conffilebytitle")};
        buttonDisplayOptions = new String[]{Settings.getInstance().msg("dialog.settings.displaybuttonimageandtext"), Settings.getInstance().msg("dialog.settings.displaybuttontextonly"), Settings.getInstance().msg("dialog.settings.displaybuttonimageonly")};
    }
}

