/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.net.MalformedURLException;
import org.dbgl.model.KeyTitleDefault;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;

public class Profile
extends KeyTitleDefault {
    protected String developerName;
    protected String publisherName;
    protected String genre;
    protected String year;
    protected int dbversionId;
    protected String setup;
    protected String setupParams;
    protected String notes;
    protected String[] link;
    protected String[] linkTitle;
    protected String status;
    protected String confPathAndFile;
    protected String captures;
    protected String[] customString;
    protected int[] customInt;

    protected Profile(String title, boolean favorite) {
        super(-1, title, favorite);
    }

    public Profile(int id, String title, String devName, String publName, String genre, String year, int dbversionId, String setup, String setupParams, String notes, String link1, String link2, Boolean favorite, String status, String confPathAndFile, String captures, String link3, String link4, String cust1, String cust2, String cust3, String cust4, String cust5, String cust6, String cust7, String cust8, int cust9, int cust10, String link1Title, String link2Title, String link3Title, String link4Title) {
        super(id, title, favorite);
        this.developerName = devName;
        this.publisherName = publName;
        this.genre = genre;
        this.year = year;
        this.dbversionId = dbversionId;
        this.setup = PlatformUtils.pathToNativePath(setup);
        this.setupParams = setupParams;
        this.notes = notes;
        this.status = status;
        this.confPathAndFile = PlatformUtils.pathToNativePath(confPathAndFile);
        this.captures = PlatformUtils.pathToNativePath(captures);
        this.link = new String[]{PlatformUtils.pathToNativePath(link1), PlatformUtils.pathToNativePath(link2), PlatformUtils.pathToNativePath(link3), PlatformUtils.pathToNativePath(link4)};
        this.linkTitle = new String[]{link1Title, link2Title, link3Title, link4Title};
        this.customString = new String[]{cust1, cust2, cust3, cust4, cust5, cust6, cust7, cust8};
        this.customInt = new int[]{cust9, cust10};
    }

    public Profile(int id, String confFile, String captures, Profile prof) {
        this(id, prof.getTitle(), prof.getDeveloperName(), prof.getPublisherName(), prof.getGenre(), prof.getYear(), prof.getDbversionId(), prof.getSetup(), prof.getSetupParameters(), prof.getNotes(), prof.getLink(0), prof.getLink(1), prof.isDefault(), prof.getStatus(), confFile, captures, prof.getLink(2), prof.getLink(3), prof.getCustomString(0), prof.getCustomString(1), prof.getCustomString(2), prof.getCustomString(3), prof.getCustomString(4), prof.getCustomString(5), prof.getCustomString(6), prof.getCustomString(7), prof.getCustomInt(0), prof.getCustomInt(1), prof.getLinkTitle(0), prof.getLinkTitle(1), prof.getLinkTitle(2), prof.getLinkTitle(3));
    }

    public Profile(Profile prof1, Profile prof2) {
        this(-1, prof1.getTitle().equals(prof2.getTitle()) ? prof1.getTitle() : "CONFLICTING_SETTING", prof1.getDeveloperName().equals(prof2.getDeveloperName()) ? prof1.getDeveloperName() : "CONFLICTING_SETTING", prof1.getPublisherName().equals(prof2.getPublisherName()) ? prof1.getPublisherName() : "CONFLICTING_SETTING", prof1.getGenre().equals(prof2.getGenre()) ? prof1.getGenre() : "CONFLICTING_SETTING", prof1.getYear().equals(prof2.getYear()) ? prof1.getYear() : "CONFLICTING_SETTING", prof1.getDbversionId() == prof2.getDbversionId() ? prof1.getDbversionId() : Integer.MIN_VALUE, prof1.getSetup().equals(prof2.getSetup()) ? prof1.getSetup() : "CONFLICTING_SETTING", prof1.getSetupParameters().equals(prof2.getSetupParameters()) ? prof1.getSetupParameters() : "CONFLICTING_SETTING", prof1.getNotes().equals(prof2.getNotes()) ? prof1.getNotes() : "CONFLICTING_SETTING", prof1.getLink(0).equals(prof2.getLink(0)) ? prof1.getLink(0) : "CONFLICTING_SETTING", prof1.getLink(1).equals(prof2.getLink(1)) ? prof1.getLink(1) : "CONFLICTING_SETTING", prof1.isDefault() == prof2.isDefault() ? prof1.isDefault() : Conf.CONFLICTING_BOOL_SETTING, prof1.getStatus().equals(prof2.getStatus()) ? prof1.getStatus() : "CONFLICTING_SETTING", prof1.getConfPathAndFile().equals(prof2.getConfPathAndFile()) ? prof1.getConfPathAndFile() : "CONFLICTING_SETTING", prof1.getCaptures().equals(prof2.getCaptures()) ? prof1.getCaptures() : "CONFLICTING_SETTING", prof1.getLink(2).equals(prof2.getLink(2)) ? prof1.getLink(2) : "CONFLICTING_SETTING", prof1.getLink(3).equals(prof2.getLink(3)) ? prof1.getLink(3) : "CONFLICTING_SETTING", prof1.getCustomString(0).equals(prof2.getCustomString(0)) ? prof1.getCustomString(0) : "CONFLICTING_SETTING", prof1.getCustomString(1).equals(prof2.getCustomString(1)) ? prof1.getCustomString(1) : "CONFLICTING_SETTING", prof1.getCustomString(2).equals(prof2.getCustomString(2)) ? prof1.getCustomString(2) : "CONFLICTING_SETTING", prof1.getCustomString(3).equals(prof2.getCustomString(3)) ? prof1.getCustomString(3) : "CONFLICTING_SETTING", prof1.getCustomString(4).equals(prof2.getCustomString(4)) ? prof1.getCustomString(4) : "CONFLICTING_SETTING", prof1.getCustomString(5).equals(prof2.getCustomString(5)) ? prof1.getCustomString(5) : "CONFLICTING_SETTING", prof1.getCustomString(6).equals(prof2.getCustomString(6)) ? prof1.getCustomString(6) : "CONFLICTING_SETTING", prof1.getCustomString(7).equals(prof2.getCustomString(7)) ? prof1.getCustomString(7) : "CONFLICTING_SETTING", prof1.getCustomInt(0) == prof2.getCustomInt(0) ? prof1.getCustomInt(0) : Integer.MIN_VALUE, prof1.getCustomInt(1) == prof2.getCustomInt(1) ? prof1.getCustomInt(1) : Integer.MIN_VALUE, prof1.getLinkTitle(0).equals(prof2.getLinkTitle(0)) ? prof1.getLinkTitle(0) : "CONFLICTING_SETTING", prof1.getLinkTitle(1).equals(prof2.getLinkTitle(1)) ? prof1.getLinkTitle(1) : "CONFLICTING_SETTING", prof1.getLinkTitle(2).equals(prof2.getLinkTitle(2)) ? prof1.getLinkTitle(2) : "CONFLICTING_SETTING", prof1.getLinkTitle(3).equals(prof2.getLinkTitle(3)) ? prof1.getLinkTitle(3) : "CONFLICTING_SETTING");
    }

    public Profile(Profile prof1, Profile prof2, boolean bogus) {
        this(prof1.getId(), prof2.getTitle() == null ? prof1.getTitle() : prof2.getTitle(), prof2.getDeveloperName() == null ? prof1.getDeveloperName() : prof2.getDeveloperName(), prof2.getPublisherName() == null ? prof1.getPublisherName() : prof2.getPublisherName(), prof2.getGenre() == null ? prof1.getGenre() : prof2.getGenre(), prof2.getYear() == null ? prof1.getYear() : prof2.getYear(), prof2.getDbversionId() == -1 ? prof1.getDbversionId() : prof2.getDbversionId(), prof2.getSetup() == null ? prof1.getSetup() : prof2.getSetup(), prof2.getSetupParameters() == null ? prof1.getSetupParameters() : prof2.getSetupParameters(), prof2.getNotes() == null ? prof1.getNotes() : prof2.getNotes(), prof2.getLink(0) == null ? prof1.getLink(0) : prof2.getLink(0), prof2.getLink(1) == null ? prof1.getLink(1) : prof2.getLink(1), prof2.isDefault() == null ? prof1.isDefault() : prof2.isDefault(), prof2.getStatus() == null ? prof1.getStatus() : prof2.getStatus(), prof2.getConfPathAndFile() == null ? prof1.getConfPathAndFile() : prof2.getConfPathAndFile(), prof2.getCaptures() == null ? prof1.getCaptures() : prof2.getCaptures(), prof2.getLink(2) == null ? prof1.getLink(2) : prof2.getLink(2), prof2.getLink(3) == null ? prof1.getLink(3) : prof2.getLink(3), prof2.getCustomString(0) == null ? prof1.getCustomString(0) : prof2.getCustomString(0), prof2.getCustomString(1) == null ? prof1.getCustomString(1) : prof2.getCustomString(1), prof2.getCustomString(2) == null ? prof1.getCustomString(2) : prof2.getCustomString(2), prof2.getCustomString(3) == null ? prof1.getCustomString(3) : prof2.getCustomString(3), prof2.getCustomString(4) == null ? prof1.getCustomString(4) : prof2.getCustomString(4), prof2.getCustomString(5) == null ? prof1.getCustomString(5) : prof2.getCustomString(5), prof2.getCustomString(6) == null ? prof1.getCustomString(6) : prof2.getCustomString(6), prof2.getCustomString(7) == null ? prof1.getCustomString(7) : prof2.getCustomString(7), prof2.getCustomInt(0) == -1 ? prof1.getCustomInt(0) : prof2.getCustomInt(0), prof2.getCustomInt(1) == -1 ? prof1.getCustomInt(1) : prof2.getCustomInt(1), prof2.getLinkTitle(0) == null ? prof1.getLinkTitle(0) : prof2.getLinkTitle(0), prof2.getLinkTitle(1) == null ? prof1.getLinkTitle(1) : prof2.getLinkTitle(1), prof2.getLinkTitle(2) == null ? prof1.getLinkTitle(2) : prof2.getLinkTitle(2), prof2.getLinkTitle(3) == null ? prof1.getLinkTitle(3) : prof2.getLinkTitle(3));
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public String getYear() {
        return this.year;
    }

    public int getDbversionId() {
        return this.dbversionId;
    }

    public boolean hasSetup() {
        return !"".equals(this.setup);
    }

    public String hasSetupString() {
        return this.hasSetup() ? Settings.getInstance().msg("general.yes") : Settings.getInstance().msg("general.no");
    }

    public String[] getLinks() {
        return (String[])this.link.clone();
    }

    public String getLink(int index) {
        return this.link[index];
    }

    public String getLinkTitle(int index) {
        return this.linkTitle[index];
    }

    public String[] getLinkTitles() {
        return (String[])this.linkTitle.clone();
    }

    public String getLinkAsUrl(int index) {
        String res = this.link[index];
        if (res != null && res.length() > 0 && res.indexOf("://") == -1) {
            try {
                res = FileUtils.getUrlFromFile(FileUtils.canonicalToData(res));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return res;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getSetup() {
        return this.setup;
    }

    public String getSetupParameters() {
        return this.setupParams;
    }

    public String getStatus() {
        return this.status;
    }

    public String getConfPathAndFile() {
        return this.confPathAndFile;
    }

    public File getCanonicalConfFile() {
        return FileUtils.canonicalToData(this.confPathAndFile);
    }

    public String getConfFileAsUrl() {
        try {
            return FileUtils.getUrlFromFile(this.getCanonicalConfFile());
        }
        catch (MalformedURLException e1) {
            return this.getCanonicalConfFile().getPath();
        }
    }

    public String getCaptures() {
        return this.captures;
    }

    public File getCanonicalCaptures() {
        return FileUtils.canonicalToData(this.captures);
    }

    public String getCapturesAsUrl() {
        try {
            return FileUtils.getUrlFromFile(this.getCanonicalCaptures());
        }
        catch (MalformedURLException e1) {
            return this.getCanonicalCaptures().getPath();
        }
    }

    public String getCustomString(int index) {
        return this.customString[index];
    }

    public String[] getCustomStrings() {
        return (String[])this.customString.clone();
    }

    public int getCustomInt(int index) {
        return this.customInt[index];
    }

    public int[] getCustomInts() {
        return (int[])this.customInt.clone();
    }
}

