/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeleteProfilesDialog
extends Dialog {
    private List<Profile> profs;
    private List<DosboxVersion> dbversions;
    private Database dbase;
    private Object result;
    private Shell shell;
    private Settings settings;

    public DeleteProfilesDialog(Shell parent) {
        super(parent, 0);
    }

    public void setProfilesToBeDeleted(List<Profile> profs, List<DosboxVersion> dbversions) {
        this.profs = profs;
        this.dbversions = dbversions;
    }

    public Object open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout(new BorderLayout(0, 0));
        this.shell.addControlListener(new SizeControlAdapter(this.shell, "profiledeletedialog"));
        this.shell.setText(this.settings.msg("dialog.deleteprofiles.title", new Object[]{this.profs.size()}));
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        TabItem infoTabItem = new TabItem(tabFolder, 0);
        infoTabItem.setText(this.settings.msg("dialog.deleteprofiles.options"));
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout(gridLayout);
        infoTabItem.setControl(composite);
        Label deleteRecordLabel = new Label(composite, 0);
        deleteRecordLabel.setText(this.settings.msg("dialog.deleteprofiles.confirm.removedatabaseentry"));
        Button deleteRecord = new Button(composite, 32);
        deleteRecord.setSelection(true);
        deleteRecord.setEnabled(false);
        Label deleteConfsLabel = new Label(composite, 0);
        deleteConfsLabel.setText(this.settings.msg("dialog.deleteprofiles.confirm.removeprofileconf"));
        final Button deleteConfs = new Button(composite, 32);
        deleteConfs.setSelection(true);
        Label deleteMapperfilesLabel = new Label(composite, 0);
        deleteMapperfilesLabel.setText(this.settings.msg("dialog.deleteprofiles.confirm.removemapperfile"));
        final Button deleteMapperfiles = new Button(composite, 32);
        deleteMapperfiles.setSelection(true);
        Label deleteCapturesLabel = new Label(composite, 0);
        deleteCapturesLabel.setText(this.settings.msg("dialog.deleteprofiles.confirm.removeprofilecaptures"));
        final Button deleteCaptures = new Button(composite, 32);
        deleteCaptures.setSelection(true);
        Composite composite_7 = new Composite(this.shell, 0);
        composite_7.setLayout(new GridLayout(2, true));
        composite_7.setLayoutData("South");
        Button okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        okButton.setLayoutData(gridData);
        okButton.setText(this.settings.msg("button.ok"));
        okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (GeneralPurposeDialogs.confirmMessage(DeleteProfilesDialog.this.shell, DeleteProfilesDialog.this.settings.msg("dialog.deleteprofiles.confirm.removal", new Object[]{DeleteProfilesDialog.this.profs.size()}))) {
                    for (Profile prof : DeleteProfilesDialog.this.profs) {
                        try {
                            Conf conf;
                            File customMapperfile;
                            DeleteProfilesDialog.this.dbase.removeProfile(prof.getId());
                            if (deleteMapperfiles.getSelection() && (customMapperfile = (conf = new Conf(prof, (DosboxVersion)DeleteProfilesDialog.this.dbversions.get(DosboxVersion.findById(DeleteProfilesDialog.this.dbversions, prof.getDbversionId())), System.err)).getCustomMapperFile()) != null) {
                                FileUtils.removeFile(customMapperfile);
                            }
                            if (deleteConfs.getSelection()) {
                                FileUtils.removeFile(prof.getCanonicalConfFile());
                            }
                            if (!deleteCaptures.getSelection()) continue;
                            FileUtils.removeFilesInDirAndDir(prof.getCanonicalCaptures());
                        }
                        catch (IOException e) {
                            GeneralPurposeDialogs.warningMessage(DeleteProfilesDialog.this.shell, e);
                        }
                        catch (SQLException e) {
                            GeneralPurposeDialogs.warningMessage(DeleteProfilesDialog.this.shell, e);
                        }
                    }
                    DeleteProfilesDialog.this.result = DeleteProfilesDialog.this.profs;
                }
                DeleteProfilesDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button(composite_7, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = 4;
        cancelButton.setLayoutData(gridData_1);
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DeleteProfilesDialog.this.result = null;
                DeleteProfilesDialog.this.shell.close();
            }
        });
    }
}

