/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.AutoSelectCombo;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.BrowseSearchEngineDialog;
import org.dbgl.gui.EditMultiProfileDialog;
import org.dbgl.gui.EditTemplateDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.GrabButton;
import org.dbgl.gui.SettingsDialog;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.Profile;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.Template;
import org.dbgl.model.WebProfile;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.FileUtils;
import org.dbgl.util.StringUtils;
import org.dbgl.util.searchengine.MobyGamesSearchEngine;
import org.dbgl.util.searchengine.PouetSearchEngine;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditProfileDialog
extends EditTemplateDialog {
    static final List<WebSearchEngine> webSearchEngines = Arrays.asList(MobyGamesSearchEngine.getInstance(), PouetSearchEngine.getInstance());
    public static int AMOUNT_OF_LINKS = 8;
    private static int AMOUNT_OF_CUSTOM_STRINGS = 4;
    private boolean focusOnTitle = false;
    private List<KeyValuePair> developersList;
    private List<KeyValuePair> publishersList;
    private List<KeyValuePair> genresList;
    private List<KeyValuePair> yearsList;
    private List<KeyValuePair> statusList;
    private List<Template> templatesList;
    private List<List<KeyValuePair>> customList = new ArrayList<List<KeyValuePair>>();
    private SizeControlAdapter sizeControlAdapter;
    private SearchEngineImageInformation[] imageInformation = null;
    private Button[] imgButtons;
    private AutoSelectCombo developer;
    private AutoSelectCombo publisher;
    private AutoSelectCombo genre;
    private AutoSelectCombo year;
    private AutoSelectCombo status;
    private Button favorite;
    private Button doSearch;
    private Button templateReload;
    private Button loadfix;
    private ToolItem engineSelector;
    private Composite webImagesSpaceHolder;
    private ScrolledComposite webImagesSpace;
    private Text[] link = new Text[AMOUNT_OF_LINKS];
    private Text[] linkTitle = new Text[AMOUNT_OF_LINKS];
    private BrowseButton[] linkBrowseButton = new BrowseButton[AMOUNT_OF_LINKS];
    private AutoSelectCombo[] customCombo = new AutoSelectCombo[AMOUNT_OF_CUSTOM_STRINGS];
    private Text[] customText = new Text[AMOUNT_OF_CUSTOM_STRINGS];
    private Scale custom9;
    private Spinner custom10;
    private Combo template;
    private Combo loadfix_value;
    private Text notes;
    private Text main;
    private Text main_params;
    private Text setup;
    private Text setup_params;
    private Text alt1;
    private Text alt1_params;
    private Text alt2;
    private Text alt2_params;
    private Text img1;
    private Text img2;
    private Text img3;
    protected ExpProfile multiProfileCombined;
    private int templateIndex = -1;

    public EditProfileDialog(Shell parent) {
        super(parent);
    }

    public void setProfile(Profile prof) {
        this.result = prof;
    }

    public void setConfigurables(List<Configurable> configurables) {
        this.multiProfileList = configurables;
        if (this.multiProfileList.size() == 1) {
            this.setProfile((ExpProfile)this.multiProfileList.get(0));
            this.multiProfileList.remove(0);
        }
    }

    public void setMultiProfileCombined(ExpProfile multiProfileCombined) {
        this.multiProfileCombined = multiProfileCombined;
    }

    public void sendToProfile(String file) {
        this.result = FileUtils.makeRelativeToDosroot(new File(file)).getPath();
    }

    public void focusTitle() {
        this.focusOnTitle = true;
    }

    @Override
    protected boolean init() {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            this.developersList = this.dbase.readDevelopersList();
            this.publishersList = this.dbase.readPublishersList();
            this.genresList = this.dbase.readGenresList();
            this.yearsList = this.dbase.readYearsList();
            this.templatesList = this.dbase.readTemplatesList();
            this.statusList = this.dbase.readStatusList();
            for (int i = 0; i < AMOUNT_OF_CUSTOM_STRINGS; ++i) {
                this.customList.add(this.dbase.readCustomList(i));
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            if (this.result instanceof Profile) {
                Profile profile = (Profile)this.result;
                this.dbversionIndex = DosboxVersion.findById(this.dbversionsList, profile.getDbversionId());
                DosboxVersion dbversion = (DosboxVersion)this.dbversionsList.get(this.dbversionIndex);
                Conf cc = new Conf(profile, dbversion, ps);
                if (cc.getAutoexec().isIncomplete() && !GeneralPurposeDialogs.confirmMessage(this.getParent(), this.settings.msg("dialog.profile.confirm.profileincomplete", new Object[]{"dosbox.conf", dbversion.getCanonicalConfFile()}))) {
                    return false;
                }
                this.multiProfileList.add(new ExpProfile(profile.getId(), cc, FileUtils.makeRelativeToDosroot(cc.getAutoexec().getCanonicalMainDir()), profile));
            } else if (this.isMultiEdit()) {
                this.dbversionIndex = DosboxVersion.findById(this.dbversionsList, this.multiProfileCombined.getDbversionId());
            } else {
                this.dbversionIndex = DosboxVersion.findDefault(this.dbversionsList);
                DosboxVersion dbversion = (DosboxVersion)this.dbversionsList.get(this.dbversionIndex);
                this.templateIndex = Template.findDefault(this.templatesList);
                Conf cc = null;
                cc = this.result instanceof String && FileUtils.isConfFile((String)this.result) ? new Conf(FileUtils.canonicalToDosroot((String)this.result), (Template)null, dbversion, ps) : (this.templateIndex != -1 ? new Conf((File)null, this.templatesList.get(this.templateIndex), dbversion, ps) : new Conf((File)null, (Template)null, dbversion, ps));
                this.multiProfileList.add(new ExpProfile(cc));
            }
            if (bos.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), bos.toString());
                bos.reset();
            }
            return true;
        }
        catch (Exception e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
            return false;
        }
    }

    @Override
    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout(new BorderLayout(0, 0));
        this.sizeControlAdapter = new SizeControlAdapter(this.shell, "profiledialog");
        this.shell.addControlListener(this.sizeControlAdapter);
        if (this.result instanceof Profile) {
            this.shell.setText(this.settings.msg("dialog.profile.title.edit", new Object[]{((Profile)this.result).getTitle(), ((Profile)this.result).getId()}));
        } else if (this.isMultiEdit()) {
            this.shell.setText(this.settings.msg("dialog.multiprofile.title.edit", new Object[]{this.multiProfileList.size()}));
        } else if (this.result instanceof String) {
            this.shell.setText(this.settings.msg("dialog.profile.title.send", new Object[]{(String)this.result}));
        } else {
            this.shell.setText(this.settings.msg("dialog.profile.title.add"));
        }
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        this.createInfoTab(tabFolder);
        this.createCustomTab(tabFolder);
        this.createGeneralTab(tabFolder);
        this.createDisplayTab(tabFolder);
        this.createMachineTab(tabFolder);
        this.createAudioTab(tabFolder);
        this.createIOTab(tabFolder);
        this.createMountingTab(tabFolder);
        this.createOkCancelButtons();
        this.okButton.addSelectionListener(new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent event) {
                if (!EditProfileDialog.this.isValid()) {
                    return;
                }
                if (EditProfileDialog.this.isMultiEdit()) {
                    EditProfileDialog.this.updateAllConfigurationsBySettings();
                    EditMultiProfileDialog empDialog = new EditMultiProfileDialog(EditProfileDialog.this.shell);
                    DosboxVersion newDbversion = null;
                    if (EditProfileDialog.this.dbversion.getSelectionIndex() != -1) {
                        newDbversion = (DosboxVersion)EditProfileDialog.this.dbversionsList.get(EditProfileDialog.this.dbversion.getSelectionIndex());
                    }
                    Profile newProfile = new Profile(-1, EditProfileDialog.this.fetch(EditProfileDialog.this.title), EditProfileDialog.this.fetch(EditProfileDialog.this.developer), EditProfileDialog.this.fetch(EditProfileDialog.this.publisher), EditProfileDialog.this.fetch(EditProfileDialog.this.genre), EditProfileDialog.this.fetch(EditProfileDialog.this.year), EditProfileDialog.this.fetch(EditProfileDialog.this.status), EditProfileDialog.this.fetch(EditProfileDialog.this.notes), EditProfileDialog.this.fetch(EditProfileDialog.this.favorite), new String[]{EditProfileDialog.this.fetch(EditProfileDialog.this.setup), EditProfileDialog.this.fetch(EditProfileDialog.this.alt1), EditProfileDialog.this.fetch(EditProfileDialog.this.alt2)}, new String[]{EditProfileDialog.this.fetch(EditProfileDialog.this.setup_params), EditProfileDialog.this.fetch(EditProfileDialog.this.alt1_params), EditProfileDialog.this.fetch(EditProfileDialog.this.alt2_params)}, null, null, newDbversion != null ? newDbversion.getId() : -1, new String[]{EditProfileDialog.this.fetch(EditProfileDialog.this.link[0]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[1]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[2]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[3]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[4]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[5]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[6]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[7])}, new String[]{EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[0]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[1]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[2]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[3]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[4]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[5]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[6]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[7])}, new String[]{EditProfileDialog.this.fetch(EditProfileDialog.this.customCombo[0]), EditProfileDialog.this.fetch(EditProfileDialog.this.customCombo[1]), EditProfileDialog.this.fetch(EditProfileDialog.this.customCombo[2]), EditProfileDialog.this.fetch(EditProfileDialog.this.customCombo[3]), EditProfileDialog.this.fetch(EditProfileDialog.this.customText[0]), EditProfileDialog.this.fetch(EditProfileDialog.this.customText[1]), EditProfileDialog.this.fetch(EditProfileDialog.this.customText[2]), EditProfileDialog.this.fetch(EditProfileDialog.this.customText[3])}, new int[]{EditProfileDialog.this.fetch(EditProfileDialog.this.custom9), EditProfileDialog.this.fetch(EditProfileDialog.this.custom10)});
                    for (int i = 0; i < EditProfileDialog.this.multiProfileList.size(); ++i) {
                        ExpProfile ep = (ExpProfile)EditProfileDialog.this.multiProfileList.get(i);
                        ep = new ExpProfile(ep, newProfile);
                        EditProfileDialog.this.multiProfileList.set(i, ep);
                    }
                    empDialog.setData(EditProfileDialog.this.multiProfileList, EditProfileDialog.this.doSearch.getSelection() ? EditProfileDialog.this.getSelectedSearchEngine() : null);
                    if (empDialog.open() != null) {
                        EditProfileDialog.this.result = EditProfileDialog.this.multiProfileList;
                        EditProfileDialog.this.shell.close();
                    }
                } else {
                    try {
                        String capturesString;
                        EditProfileDialog.this.dbase.startTransaction();
                        Conf compConf = ((Configurable)EditProfileDialog.this.multiProfileList.get(0)).getConf();
                        int profileId = EditProfileDialog.this.dbase.addOrEditProfile(EditProfileDialog.this.title.getText(), EditProfileDialog.this.developer.getText(), EditProfileDialog.this.publisher.getText(), EditProfileDialog.this.genre.getText(), EditProfileDialog.this.year.getText(), EditProfileDialog.this.status.getText(), EditProfileDialog.this.notes.getText(), EditProfileDialog.this.favorite.getSelection(), new String[]{EditProfileDialog.this.setup.getText(), EditProfileDialog.this.alt1.getText(), EditProfileDialog.this.alt2.getText()}, new String[]{EditProfileDialog.this.setup_params.getText(), EditProfileDialog.this.alt1_params.getText(), EditProfileDialog.this.alt2_params.getText()}, compConf.getDbversion().getId(), new String[]{EditProfileDialog.this.link[0].getText(), EditProfileDialog.this.link[1].getText(), EditProfileDialog.this.link[2].getText(), EditProfileDialog.this.link[3].getText(), EditProfileDialog.this.link[4].getText(), EditProfileDialog.this.link[5].getText(), EditProfileDialog.this.link[6].getText(), EditProfileDialog.this.link[7].getText()}, new String[]{EditProfileDialog.this.linkTitle[0].getText(), EditProfileDialog.this.linkTitle[1].getText(), EditProfileDialog.this.linkTitle[2].getText(), EditProfileDialog.this.linkTitle[3].getText(), EditProfileDialog.this.linkTitle[4].getText(), EditProfileDialog.this.linkTitle[5].getText(), EditProfileDialog.this.linkTitle[6].getText(), EditProfileDialog.this.linkTitle[7].getText()}, new String[]{EditProfileDialog.this.customCombo[0].getText(), EditProfileDialog.this.customCombo[1].getText(), EditProfileDialog.this.customCombo[2].getText(), EditProfileDialog.this.customCombo[3].getText(), EditProfileDialog.this.customText[0].getText(), EditProfileDialog.this.customText[1].getText(), EditProfileDialog.this.customText[2].getText(), EditProfileDialog.this.customText[3].getText()}, new int[]{EditProfileDialog.this.custom9.getSelection(), EditProfileDialog.this.custom10.getSelection()}, EditProfileDialog.this.result instanceof Profile ? ((Profile)EditProfileDialog.this.result).getId() : -1);
                        EditProfileDialog.this.updateAllConfigurationsBySettings();
                        String confString = EditProfileDialog.this.result instanceof Profile ? ((Profile)EditProfileDialog.this.result).getConfPathAndFile() : FileUtils.constructUniqueConfigFileString(profileId, EditProfileDialog.this.title.getText(), compConf.getAutoexec().getCanonicalMainDir());
                        if (EditProfileDialog.this.result instanceof Profile) {
                            capturesString = ((Profile)EditProfileDialog.this.result).getCaptures();
                        } else {
                            capturesString = FileUtils.constructCapturesDir(profileId);
                            FileUtils.createDir(FileUtils.canonicalToData(capturesString));
                        }
                        if (!(EditProfileDialog.this.result instanceof Profile)) {
                            EditProfileDialog.this.dbase.updateProfileConf(confString, capturesString, profileId);
                        }
                        EditProfileDialog.this.result = new Profile(profileId, EditProfileDialog.this.title.getText(), EditProfileDialog.this.developer.getText(), EditProfileDialog.this.publisher.getText(), EditProfileDialog.this.genre.getText(), EditProfileDialog.this.year.getText(), EditProfileDialog.this.status.getText(), EditProfileDialog.this.notes.getText(), EditProfileDialog.this.favorite.getSelection(), new String[]{EditProfileDialog.this.setup.getText(), EditProfileDialog.this.alt1.getText(), EditProfileDialog.this.alt2.getText()}, new String[]{EditProfileDialog.this.setup_params.getText(), EditProfileDialog.this.alt1_params.getText(), EditProfileDialog.this.alt2_params.getText()}, confString, capturesString, compConf.getDbversion().getId(), new String[]{EditProfileDialog.this.link[0].getText(), EditProfileDialog.this.link[1].getText(), EditProfileDialog.this.link[2].getText(), EditProfileDialog.this.link[3].getText(), EditProfileDialog.this.link[4].getText(), EditProfileDialog.this.link[5].getText(), EditProfileDialog.this.link[6].getText(), EditProfileDialog.this.link[7].getText()}, new String[]{EditProfileDialog.this.linkTitle[0].getText(), EditProfileDialog.this.linkTitle[1].getText(), EditProfileDialog.this.linkTitle[2].getText(), EditProfileDialog.this.linkTitle[3].getText(), EditProfileDialog.this.linkTitle[4].getText(), EditProfileDialog.this.linkTitle[5].getText(), EditProfileDialog.this.linkTitle[6].getText(), EditProfileDialog.this.linkTitle[7].getText()}, new String[]{EditProfileDialog.this.customCombo[0].getText(), EditProfileDialog.this.customCombo[1].getText(), EditProfileDialog.this.customCombo[2].getText(), EditProfileDialog.this.customCombo[3].getText(), EditProfileDialog.this.customText[0].getText(), EditProfileDialog.this.customText[1].getText(), EditProfileDialog.this.customText[2].getText(), EditProfileDialog.this.customText[3].getText()}, new int[]{EditProfileDialog.this.custom9.getSelection(), EditProfileDialog.this.custom10.getSelection()});
                        compConf.injectOrUpdateProfile((Profile)EditProfileDialog.this.result);
                        compConf.save();
                        if (EditProfileDialog.this.imageInformation != null) {
                            EditProfileDialog.this.saveWebImages(FileUtils.canonicalToData(capturesString));
                        }
                        EditProfileDialog.this.dbase.commitTransaction();
                    }
                    catch (Exception e) {
                        GeneralPurposeDialogs.warningMessage(EditProfileDialog.this.shell, e);
                        try {
                            EditProfileDialog.this.dbase.rollbackTransaction();
                        }
                        catch (SQLException se) {
                            GeneralPurposeDialogs.warningMessage(EditProfileDialog.this.shell, se);
                        }
                    }
                    finally {
                        EditProfileDialog.this.dbase.finishTransaction();
                    }
                    EditProfileDialog.this.shell.close();
                }
            }
        });
        for (DosboxVersion dbv : this.dbversionsList) {
            this.dbversion.add(dbv.getTitle());
        }
        for (Template templ : this.templatesList) {
            this.template.add(templ.getTitle());
        }
        this.dbversion.select(this.dbversionIndex);
        this.templateReload.setEnabled(this.dbversionIndex != -1);
        if (this.result instanceof Profile) {
            this.setProfileMetaData((Profile)this.result);
            if (this.focusOnTitle) {
                this.title.selectAll();
                this.title.setFocus();
            }
        } else if (this.isMultiEdit()) {
            this.setProfileMetaData(this.multiProfileCombined);
        } else {
            this.title.setFocus();
            if (this.templateIndex != -1) {
                this.template.select(this.templateIndex);
            }
        }
        if (this.isMultiEdit()) {
            this.enableSettingsByConfiguration(this.multiProfileCombined.getConf().getDosboxSettings());
            this.selectSettingsByConfiguration(this.multiProfileCombined.getConf());
        } else {
            this.enableSettingsByConfiguration(((Configurable)this.multiProfileList.get(0)).getConf().getDosboxSettings());
            this.selectSettingsByConfiguration(((Configurable)this.multiProfileList.get(0)).getConf());
        }
        this.startListeners();
        if (this.result instanceof String) {
            if (FileUtils.isExecutable((String)this.result)) {
                this.main.setText((String)this.result);
            } else if (FileUtils.isBooterImage((String)this.result)) {
                this.img1.setText((String)this.result);
            }
        }
    }

    @Override
    protected void createMachineTab(TabFolder tabFolder) {
        super.createMachineTab(tabFolder);
        Label loadfixLabel = new Label(this.memoryGroup, 0);
        loadfixLabel.setText(this.settings.msg("dialog.profile.loadfix"));
        this.loadfix = new Button(this.memoryGroup, 32);
        this.loadfix.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditProfileDialog.this.loadfix_value.setEnabled(EditProfileDialog.this.loadfix.getSelection());
            }
        });
        this.loadfix_value = new Combo(this.memoryGroup, 0);
        this.loadfix_value.setItems(this.settings.getSettings().getValues("profile", "loadfix_value"));
        this.loadfix_value.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label kbLabel = new Label(this.memoryGroup, 0);
        kbLabel.setText(this.settings.msg("dialog.profile.kb"));
    }

    @Override
    protected void createInfoTab(TabFolder tabFolder) {
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText(this.settings.msg("dialog.profile.tab.info"));
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        composite.setLayout(gridLayout);
        this.infoTabItem.setControl(composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(this.settings.msg("dialog.profile.title"));
        this.title = new Text(composite, 2048);
        this.title.setLayoutData(new GridData(4, 0x1000000, true, false, 4, 1));
        WebSearchEngine defaultEngine = this.getSearchEngineBySimpleName(this.settings.getSettings().getValue("gui", "searchengine"));
        if (defaultEngine == null) {
            defaultEngine = webSearchEngines.get(0);
        }
        this.doSearch = new Button(composite, this.isMultiEdit() ? 2 : 8);
        this.doSearch.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.doSearch.setText(this.settings.msg("dialog.profile.consultsearchengine", new String[]{defaultEngine.getName()}));
        this.doSearch.setData(defaultEngine.getName());
        final ToolBar toolBar = new ToolBar(composite, 0);
        this.engineSelector = new ToolItem(toolBar, 4);
        this.engineSelector.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), defaultEngine.getIcon()));
        final Menu menu = new Menu(this.shell, 8);
        for (final WebSearchEngine engine : webSearchEngines) {
            MenuItem item = new MenuItem(menu, 8);
            item.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), engine.getIcon()));
            item.setText(engine.getName());
            item.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MenuItem sel = (MenuItem)event.widget;
                    EditProfileDialog.this.engineSelector.setImage(sel.getImage());
                    EditProfileDialog.this.doSearch.setData(sel.getText());
                    EditProfileDialog.this.doSearch.setText(EditProfileDialog.this.settings.msg("dialog.profile.consultsearchengine", new String[]{EditProfileDialog.this.doSearch.getData().toString()}));
                    EditProfileDialog.this.settings.getSettings().setValue("gui", "searchengine", engine.getSimpleName());
                }
            });
        }
        this.engineSelector.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle rect = EditProfileDialog.this.engineSelector.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = toolBar.toDisplay(pt);
                    menu.setLocation(pt.x, pt.y);
                    menu.setVisible(true);
                } else {
                    for (int i = 0; i < webSearchEngines.size(); ++i) {
                        if (!webSearchEngines.get(i).getName().equals(EditProfileDialog.this.doSearch.getData())) continue;
                        int nextIdx = i + 1;
                        if (nextIdx >= webSearchEngines.size()) {
                            nextIdx = 0;
                        }
                        MenuItem sel = menu.getItem(nextIdx);
                        EditProfileDialog.this.engineSelector.setImage(sel.getImage());
                        EditProfileDialog.this.doSearch.setData(sel.getText());
                        EditProfileDialog.this.doSearch.setText(EditProfileDialog.this.settings.msg("dialog.profile.consultsearchengine", new String[]{EditProfileDialog.this.doSearch.getData().toString()}));
                        EditProfileDialog.this.settings.getSettings().setValue("gui", "searchengine", EditProfileDialog.this.getSelectedSearchEngine().getSimpleName());
                        break;
                    }
                }
            }
        });
        if (!this.isMultiEdit()) {
            this.doSearch.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    final int WEB_IMAGE_WIDTH = EditProfileDialog.this.settings.getSettings().getIntValue("mobygames", "image_width");
                    int WEB_IMAGE_HEIGHT = EditProfileDialog.this.settings.getSettings().getIntValue("mobygames", "image_height");
                    int WEB_IMAGE_COLUMNS = EditProfileDialog.this.settings.getSettings().getIntValue("mobygames", "image_columns");
                    int DIALOG_RESIZE_WIDTH = (WEB_IMAGE_WIDTH + 10) * WEB_IMAGE_COLUMNS + 3 * (WEB_IMAGE_COLUMNS - 1) + 19;
                    WebProfile orgProf = (WebProfile)EditProfileDialog.this.engineSelector.getData();
                    if (orgProf == null) {
                        String currTitle = EditProfileDialog.this.title.getText();
                        if (currTitle.length() >= 1) {
                            WebSearchEngine engine = EditProfileDialog.this.getSelectedSearchEngine();
                            try {
                                WebProfile thisGame = null;
                                List<WebProfile> webGamesList = engine.getEntries(currTitle, EditProfileDialog.this.settings.getSettings().getValues(engine.getSimpleName(), "platform_filter"));
                                if (webGamesList.size() == 0) {
                                    GeneralPurposeDialogs.infoMessage(EditProfileDialog.this.shell, EditProfileDialog.this.settings.msg("general.notice.searchenginenoresults", new String[]{engine.getName(), currTitle}));
                                } else if (webGamesList.size() == 1) {
                                    thisGame = webGamesList.get(0);
                                } else {
                                    BrowseSearchEngineDialog mobyDialog = new BrowseSearchEngineDialog(EditProfileDialog.this.shell);
                                    mobyDialog.setProfilesToBrowse(currTitle, webGamesList);
                                    mobyDialog.setEngine(engine);
                                    Integer idx = (Integer)mobyDialog.open();
                                    if (idx != null) {
                                        thisGame = webGamesList.get(idx);
                                    }
                                }
                                if (thisGame != null) {
                                    int ss;
                                    String p;
                                    String n;
                                    final WebProfile profExt = engine.getEntryDetailedInformation(thisGame);
                                    WebProfile currentProf = new WebProfile();
                                    currentProf.setTitle(EditProfileDialog.this.title.getText());
                                    currentProf.setDeveloperName(EditProfileDialog.this.developer.getText());
                                    currentProf.setPublisherName(EditProfileDialog.this.publisher.getText());
                                    currentProf.setYear(EditProfileDialog.this.year.getText());
                                    currentProf.setGenre(EditProfileDialog.this.genre.getText());
                                    currentProf.setUrl(EditProfileDialog.this.link[0].getText());
                                    currentProf.setPlatform(EditProfileDialog.this.linkTitle[0].getText());
                                    currentProf.setNotes(EditProfileDialog.this.notes.getText());
                                    currentProf.setRank(EditProfileDialog.this.custom9.getSelection());
                                    EditProfileDialog.this.engineSelector.setData(currentProf);
                                    EditProfileDialog.this.doSearch.setText(EditProfileDialog.this.settings.msg("dialog.profile.undosearchengine"));
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_title")) {
                                        EditProfileDialog.this.title.setText(profExt.getTitle());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_developer")) {
                                        EditProfileDialog.this.developer.setText(profExt.getDeveloperName());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_publisher")) {
                                        EditProfileDialog.this.publisher.setText(profExt.getPublisherName());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_year")) {
                                        EditProfileDialog.this.year.setText(profExt.getYear());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_genre")) {
                                        EditProfileDialog.this.genre.setText(profExt.getGenre());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_link")) {
                                        EditProfileDialog.this.link[0].setText(profExt.getUrl());
                                        EditProfileDialog.this.linkTitle[0].setText(EditProfileDialog.this.settings.msg("dialog.profile.searchengine.link.maininfo", new String[]{engine.getName()}));
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_description") && !(n = EditProfileDialog.this.notes.getText()).endsWith(p = profExt.getNotes().replaceAll("\n", EditProfileDialog.this.notes.getLineDelimiter()))) {
                                        if (n.length() > 0) {
                                            EditProfileDialog.this.notes.append(EditProfileDialog.this.notes.getLineDelimiter() + EditProfileDialog.this.notes.getLineDelimiter());
                                        }
                                        EditProfileDialog.this.notes.append(p);
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_rank")) {
                                        EditProfileDialog.this.custom9.setSelection(profExt.getRank());
                                    }
                                    int ca = EditProfileDialog.this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "choose_coverart") ? Integer.MAX_VALUE : 0;
                                    int n2 = ss = EditProfileDialog.this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "choose_screenshot") ? Integer.MAX_VALUE : 0;
                                    if (ca > 0 || ss > 0) {
                                        EditProfileDialog.access$2102(EditProfileDialog.this, engine.getEntryImages(profExt, ca, ss));
                                        EditProfileDialog.this.webImagesSpaceHolder = new Composite(EditProfileDialog.this.shell, 0);
                                        EditProfileDialog.this.webImagesSpaceHolder.setLayoutData("East");
                                        GridLayout holderLayout = new GridLayout();
                                        holderLayout.numColumns = 2;
                                        holderLayout.marginHeight = 0;
                                        holderLayout.marginWidth = 0;
                                        holderLayout.horizontalSpacing = 0;
                                        holderLayout.verticalSpacing = 0;
                                        EditProfileDialog.this.webImagesSpaceHolder.setLayout(holderLayout);
                                        if (EditProfileDialog.this.imageInformation.length > 0) {
                                            Button allButton = new Button(EditProfileDialog.this.webImagesSpaceHolder, 0);
                                            allButton.setLayoutData(new GridData(50, -1));
                                            allButton.setText(EditProfileDialog.this.settings.msg("button.all"));
                                            allButton.addSelectionListener(new SelectionAdapter(){

                                                public void widgetSelected(SelectionEvent e) {
                                                    for (Button but : EditProfileDialog.this.imgButtons) {
                                                        but.setSelection(true);
                                                    }
                                                }
                                            });
                                            Button noneButton = new Button(EditProfileDialog.this.webImagesSpaceHolder, 0);
                                            noneButton.setLayoutData(new GridData(50, -1));
                                            noneButton.setText(EditProfileDialog.this.settings.msg("button.none"));
                                            noneButton.addSelectionListener(new SelectionAdapter(){

                                                public void widgetSelected(SelectionEvent e) {
                                                    for (Button but : EditProfileDialog.this.imgButtons) {
                                                        but.setSelection(false);
                                                    }
                                                }
                                            });
                                        }
                                        EditProfileDialog.this.webImagesSpace = new ScrolledComposite(EditProfileDialog.this.webImagesSpaceHolder, 512);
                                        EditProfileDialog.this.webImagesSpace.setLayoutData(new GridData(4, 4, true, true, 2, 1));
                                        EditProfileDialog.this.webImagesSpace.setLayout(new GridLayout());
                                        EditProfileDialog.this.webImagesSpace.getVerticalBar().setIncrement(WEB_IMAGE_HEIGHT / WEB_IMAGE_COLUMNS);
                                        EditProfileDialog.this.webImagesSpace.getVerticalBar().setPageIncrement(WEB_IMAGE_HEIGHT / WEB_IMAGE_COLUMNS * 8);
                                        final Composite webImagesComposite = new Composite(EditProfileDialog.this.webImagesSpace, 0);
                                        GridLayout gridLayoutImagesGroup = new GridLayout();
                                        gridLayoutImagesGroup.numColumns = WEB_IMAGE_COLUMNS;
                                        gridLayoutImagesGroup.marginHeight = 0;
                                        gridLayoutImagesGroup.marginWidth = 0;
                                        gridLayoutImagesGroup.horizontalSpacing = 1;
                                        gridLayoutImagesGroup.verticalSpacing = 1;
                                        gridLayoutImagesGroup.makeColumnsEqualWidth = true;
                                        webImagesComposite.setLayout(gridLayoutImagesGroup);
                                        EditProfileDialog.this.webImagesSpace.setContent(webImagesComposite);
                                        if (EditProfileDialog.this.imageInformation.length > 0) {
                                            EditProfileDialog.access$2702(EditProfileDialog.this, new Button[EditProfileDialog.this.imageInformation.length]);
                                            int i = 0;
                                            while (i < EditProfileDialog.this.imageInformation.length) {
                                                ((EditProfileDialog)EditProfileDialog.this).imgButtons[i] = new Button(webImagesComposite, 0x800002);
                                                EditProfileDialog.this.imgButtons[i].setLayoutData(new GridData(16384, 1024, true, true));
                                                EditProfileDialog.this.imgButtons[i].setToolTipText(((EditProfileDialog)EditProfileDialog.this).imageInformation[i].description);
                                                EditProfileDialog.this.imgButtons[i].setImage(SWTImageManager.getEmptyImage(EditProfileDialog.this.shell.getDisplay(), WEB_IMAGE_WIDTH, WEB_IMAGE_HEIGHT));
                                                EditProfileDialog.this.imgButtons[i].addDisposeListener(new DisposeListener(){

                                                    public void widgetDisposed(DisposeEvent e) {
                                                        ((Button)e.getSource()).getImage().dispose();
                                                    }
                                                });
                                                final int j = i++;
                                                Thread thread = new Thread(){

                                                    public void run() {
                                                        try {
                                                            ImageData imgData = profExt.getWebImage(j);
                                                            if (!EditProfileDialog.this.shell.isDisposed() && !EditProfileDialog.this.imgButtons[j].isDisposed()) {
                                                                final Image img = SWTImageManager.getWidthLimitedImage(EditProfileDialog.this.shell.getDisplay(), WEB_IMAGE_WIDTH, imgData);
                                                                if (!EditProfileDialog.this.shell.isDisposed() && !EditProfileDialog.this.imgButtons[j].isDisposed()) {
                                                                    EditProfileDialog.this.shell.getDisplay().syncExec(new Runnable(){

                                                                        public void run() {
                                                                            EditProfileDialog.this.imgButtons[j].getImage().dispose();
                                                                            EditProfileDialog.this.imgButtons[j].setImage(img);
                                                                            webImagesComposite.setSize(webImagesComposite.computeSize(-1, -1));
                                                                            webImagesComposite.layout();
                                                                        }
                                                                    });
                                                                }
                                                            }
                                                        }
                                                        catch (IOException iOException) {
                                                            // empty catch block
                                                        }
                                                    }
                                                };
                                                thread.start();
                                            }
                                        } else {
                                            Label noneFoundLabel = new Label(webImagesComposite, 0x1000040);
                                            noneFoundLabel.setText(EditProfileDialog.this.settings.msg("dialog.profile.notice.noimagesfound", new String[]{engine.getName()}));
                                            GridData gd = new GridData(0x1000000, 4, true, true, WEB_IMAGE_COLUMNS, 1);
                                            gd.widthHint = (WEB_IMAGE_WIDTH + 10) * WEB_IMAGE_COLUMNS + 3 * (WEB_IMAGE_COLUMNS - 1) + 2;
                                            gd.verticalIndent = WEB_IMAGE_HEIGHT / 2;
                                            noneFoundLabel.setLayoutData(gd);
                                        }
                                        EditProfileDialog.this.sizeControlAdapter.setEnabled(false);
                                        webImagesComposite.pack();
                                        EditProfileDialog.this.shell.setSize(EditProfileDialog.this.shell.getSize().x + DIALOG_RESIZE_WIDTH, EditProfileDialog.this.shell.getSize().y);
                                        EditProfileDialog.this.shell.layout();
                                    }
                                }
                            }
                            catch (Exception e) {
                                GeneralPurposeDialogs.warningMessage(EditProfileDialog.this.shell, EditProfileDialog.this.settings.msg("general.error.retrieveinfosearchengine", new String[]{engine.getName(), currTitle, StringUtils.toString(e)}), e);
                            }
                        }
                    } else {
                        EditProfileDialog.this.title.setText(orgProf.getTitle());
                        EditProfileDialog.this.developer.setText(orgProf.getDeveloperName());
                        EditProfileDialog.this.publisher.setText(orgProf.getPublisherName());
                        EditProfileDialog.this.year.setText(orgProf.getYear());
                        EditProfileDialog.this.genre.setText(orgProf.getGenre());
                        EditProfileDialog.this.link[0].setText(orgProf.getUrl());
                        EditProfileDialog.this.linkTitle[0].setText(orgProf.getPlatform());
                        EditProfileDialog.this.notes.setText(orgProf.getNotes());
                        EditProfileDialog.this.custom9.setSelection(orgProf.getRank());
                        EditProfileDialog.this.engineSelector.setData(null);
                        EditProfileDialog.this.doSearch.setText(EditProfileDialog.this.settings.msg("dialog.profile.consultsearchengine", new String[]{EditProfileDialog.this.doSearch.getData().toString()}));
                        if (EditProfileDialog.this.webImagesSpaceHolder != null) {
                            EditProfileDialog.this.webImagesSpaceHolder.dispose();
                            EditProfileDialog.this.webImagesSpaceHolder = null;
                            EditProfileDialog.this.shell.setSize(EditProfileDialog.this.shell.getSize().x - DIALOG_RESIZE_WIDTH, EditProfileDialog.this.shell.getSize().y);
                            EditProfileDialog.this.shell.layout();
                            EditProfileDialog.this.sizeControlAdapter.setEnabled(true);
                            EditProfileDialog.access$2102(EditProfileDialog.this, null);
                        }
                    }
                }
            });
        }
        int minimumComboWidth = this.settings.getSettings().getIntValue("gui", "profiledialog_width") / 3;
        Label developerLabel = new Label(composite, 0);
        developerLabel.setText(this.settings.msg("dialog.profile.developer"));
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.minimumWidth = minimumComboWidth;
        this.developer = new AutoSelectCombo(composite, 0, this.developersList, gd);
        Label publisherLabel = new Label(composite, 0);
        publisherLabel.setLayoutData(new GridData());
        publisherLabel.setText(this.settings.msg("dialog.profile.publisher"));
        GridData gd2 = new GridData(4, 0x1000000, true, false, 3, 1);
        gd2.minimumWidth = minimumComboWidth;
        this.publisher = new AutoSelectCombo(composite, 0, this.publishersList, gd2);
        Label genreLabel = new Label(composite, 0);
        genreLabel.setText(this.settings.msg("dialog.profile.genre"));
        this.genre = new AutoSelectCombo(composite, 0, this.genresList, new GridData(4, 0x1000000, true, false, 2, 1));
        Label yearLabel = new Label(composite, 0);
        yearLabel.setLayoutData(new GridData());
        yearLabel.setText(this.settings.msg("dialog.profile.year"));
        this.year = new AutoSelectCombo(composite, 0, this.yearsList, new GridData(4, 0x1000000, true, false, 3, 1));
        for (int i = 0; i < AMOUNT_OF_LINKS / 2; ++i) {
            Label linkLabel = new Label(composite, 0);
            linkLabel.setText(this.settings.msg("dialog.profile.link", new Object[]{i + 1}));
            this.link[i] = new Text(composite, 2048);
            this.link[i].setLayoutData(new GridData(4, 0x1000000, true, false));
            this.linkBrowseButton[i] = new BrowseButton(composite, 0);
            Label linkTitleLabel = new Label(composite, 0);
            linkTitleLabel.setText(this.settings.msg("dialog.profile.linktitle"));
            this.linkTitle[i] = new Text(composite, 2048);
            this.linkTitle[i].setLayoutData(new GridData(4, 0x1000000, true, false, 3, 1));
        }
        Label statusLabel = new Label(composite, 0);
        statusLabel.setText(this.settings.msg("dialog.profile.status"));
        this.status = new AutoSelectCombo(composite, 0, this.statusList, new GridData(4, 0x1000000, true, false, 2, 1));
        Label favoriteLabel = new Label(composite, 0);
        favoriteLabel.setText(this.settings.msg("dialog.profile.favorite"));
        this.favorite = new Button(composite, 32);
        Label label = new Label(composite, 0);
        label.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        Label notesLabel = new Label(composite, 0);
        notesLabel.setText(this.settings.msg("dialog.profile.notes"));
        this.notes = new Text(composite, 2626);
        this.notes.setLayoutData(new GridData(4, 4, true, true, 6, 1));
        this.notes.setFont(GeneralPurposeGUI.stringToFont(this.shell.getDisplay(), this.notes.getFont(), this.settings.getSettings().getValues("gui", "notesfont")));
    }

    protected void createCustomTab(TabFolder tabFolder) {
        Label customLabel;
        int i;
        TabItem customTabItem = new TabItem(tabFolder, 0);
        customTabItem.setText(this.settings.msg("dialog.profile.tab.custominfo"));
        Composite composite_8 = new Composite(tabFolder, 0);
        GridLayout gridLayout_21 = new GridLayout();
        gridLayout_21.numColumns = 5;
        composite_8.setLayout(gridLayout_21);
        customTabItem.setControl(composite_8);
        for (i = 0; i < AMOUNT_OF_CUSTOM_STRINGS; ++i) {
            customLabel = new Label(composite_8, 0);
            customLabel.setText(this.settings.getSettings().getValue("gui", "custom" + (i + 1)));
            this.customCombo[i] = new AutoSelectCombo(composite_8, 0, this.customList.get(i), new GridData(4, 0x1000000, true, false, 4, 1));
        }
        for (i = 0; i < AMOUNT_OF_CUSTOM_STRINGS; ++i) {
            customLabel = new Label(composite_8, 0);
            customLabel.setText(this.settings.getSettings().getValue("gui", "custom" + (i + 1 + AMOUNT_OF_CUSTOM_STRINGS)));
            this.customText[i] = new Text(composite_8, 2048);
            this.customText[i].setLayoutData(new GridData(4, 0x1000000, true, false, 4, 1));
        }
        Label custom9Label = new Label(composite_8, 0);
        custom9Label.setText(this.settings.getSettings().getValue("gui", "custom9"));
        this.custom9 = new Scale(composite_8, 0);
        this.custom9.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        Label custom10Label = new Label(composite_8, 0);
        custom10Label.setText(this.settings.getSettings().getValue("gui", "custom10"));
        this.custom10 = new Spinner(composite_8, 2048);
        this.custom10.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.custom10.setMinimum(Integer.MIN_VALUE);
        this.custom10.setMaximum(Integer.MAX_VALUE);
        for (int i2 = AMOUNT_OF_LINKS / 2; i2 < AMOUNT_OF_LINKS; ++i2) {
            Label linkLabel = new Label(composite_8, 0);
            linkLabel.setText(this.settings.msg("dialog.profile.link", new Object[]{i2 + 1}));
            this.link[i2] = new Text(composite_8, 2048);
            this.link[i2].setLayoutData(new GridData(4, 0x1000000, true, false));
            this.linkBrowseButton[i2] = new BrowseButton(composite_8, 0);
            Label linkTitleLabel = new Label(composite_8, 0);
            linkTitleLabel.setText(this.settings.msg("dialog.profile.linktitle"));
            this.linkTitle[i2] = new Text(composite_8, 2048);
            this.linkTitle[i2].setLayoutData(new GridData(4, 0x1000000, true, false));
        }
    }

    @Override
    protected void createGeneralTab(TabFolder tabFolder) {
        super.createGeneralTab(tabFolder);
        Label templateLabel = new Label(this.associationGroup, 0);
        templateLabel.setText(this.settings.msg("dialog.profile.template"));
        this.template = new Combo(this.associationGroup, 8);
        this.template.setLayoutData(new GridData(4, 0x1000000, true, false, 3, 1));
        this.template.setVisibleItemCount(10);
        this.templateReload = new Button(this.associationGroup, 0);
        this.templateReload.setText(this.settings.msg("dialog.profile.reloadsettings"));
        this.templateReload.setToolTipText(this.settings.msg("dialog.profile.reloadsettings.tooltip"));
        this.templateReload.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (EditProfileDialog.this.template.getSelectionIndex() != -1) {
                    if (EditProfileDialog.this.setButton.isEnabled()) {
                        GeneralPurposeDialogs.initErrorDialog();
                        GeneralPurposeDialogs.addError(EditProfileDialog.this.settings.msg("dialog.template.required.dosboxassociation"), EditProfileDialog.this.setButton, EditProfileDialog.this.generalTabItem);
                        GeneralPurposeDialogs.displayErrorDialog(EditProfileDialog.this.shell);
                        return;
                    }
                    EditProfileDialog.this.doPerformDosboxConfAction(EditTemplateDialog.DosboxConfAction.RELOAD_TEMPLATE);
                }
            }
        });
        this.config_file.setText(this.result instanceof Profile ? ((Profile)this.result).getConfPathAndFile() : SettingsDialog.confLocations[this.settings.getSettings().getIntValue("profiledefaults", "confpath")] + ", " + SettingsDialog.confFilenames[this.settings.getSettings().getIntValue("profiledefaults", "conffile")]);
    }

    @Override
    protected void createBooterComposite(Composite booterComposite) {
        booterComposite.setLayout(new GridLayout(4, false));
        Label image1Label = new Label(booterComposite, 0);
        image1Label.setText(this.settings.msg("dialog.profile.booterimage1"));
        this.img1 = new Text(booterComposite, 2048);
        this.img1.setLayoutData(new GridData(4, 0x1000000, true, false));
        BrowseButton img1BrowseButton = new BrowseButton(booterComposite, 0);
        img1BrowseButton.connect(this.shell, this.img1, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, false, null);
        GrabButton grab1 = new GrabButton(booterComposite, 0);
        grab1.connect(this.img1, this.mountingpoints);
        Label image2Label = new Label(booterComposite, 0);
        image2Label.setText(this.settings.msg("dialog.profile.booterimage2"));
        this.img2 = new Text(booterComposite, 2048);
        this.img2.setLayoutData(new GridData(4, 0x1000000, true, false));
        BrowseButton img2BrowseButton = new BrowseButton(booterComposite, 0);
        img2BrowseButton.connect(this.shell, this.img2, this.img1, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, false, null);
        GrabButton grab2 = new GrabButton(booterComposite, 0);
        grab2.connect(this.img2, this.mountingpoints);
        Label image3Label = new Label(booterComposite, 0);
        image3Label.setText(this.settings.msg("dialog.profile.booterimage3"));
        this.img3 = new Text(booterComposite, 2048);
        this.img3.setLayoutData(new GridData(4, 0x1000000, true, false));
        BrowseButton img3BrowseButton = new BrowseButton(booterComposite, 0);
        img3BrowseButton.connect(this.shell, this.img3, this.img1, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, false, null);
        GrabButton grab3 = new GrabButton(booterComposite, 0);
        grab3.connect(this.img3, this.mountingpoints);
    }

    @Override
    protected void createDosComposite(Composite dosComposite) {
        dosComposite.setLayout(new GridLayout(6, false));
        Label mainExeLabel = new Label(dosComposite, 0);
        mainExeLabel.setText(this.settings.msg("dialog.profile.mainexe"));
        this.main = new Text(dosComposite, 2048);
        this.main.setLayoutData(new GridData(4, 0x1000000, true, false, 3, 1));
        for (int i = 0; i < AMOUNT_OF_LINKS; ++i) {
            this.linkBrowseButton[i].connect(this.shell, this.link[i], this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DOC, false, null);
        }
        BrowseButton mainBrowseButton = new BrowseButton(dosComposite, 0);
        mainBrowseButton.connect(this.shell, this.main, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, this.pixelshader);
        GrabButton grab1 = new GrabButton(dosComposite, 0);
        grab1.connect(this.main, this.mountingpoints);
        new Label(dosComposite, 0);
        Label parametersLabel = new Label(dosComposite, 0);
        parametersLabel.setText(this.settings.msg("dialog.profile.mainparameters"));
        this.main_params = new Text(dosComposite, 2048);
        this.main_params.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        new Label(dosComposite, 0);
        new Label(dosComposite, 0);
        Label setupLabel = new Label(dosComposite, 0);
        setupLabel.setText(this.settings.msg("dialog.profile.setupexe"));
        this.setup = new Text(dosComposite, 2048);
        this.setup.setLayoutData(new GridData(4, 0x1000000, true, false, 3, 1));
        BrowseButton setupBrowseButton = new BrowseButton(dosComposite, 0);
        setupBrowseButton.connect(this.shell, this.setup, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, this.pixelshader);
        GrabButton grab2 = new GrabButton(dosComposite, 0);
        grab2.connect(this.setup, this.mountingpoints);
        new Label(dosComposite, 0);
        Label parametersLabel_1 = new Label(dosComposite, 0);
        parametersLabel_1.setText(this.settings.msg("dialog.profile.setupparameters"));
        this.setup_params = new Text(dosComposite, 2048);
        this.setup_params.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        new Label(dosComposite, 0);
        new Label(dosComposite, 0);
        Label alt1Label = new Label(dosComposite, 0);
        alt1Label.setText(this.settings.msg("dialog.profile.altexe", new Object[]{1}));
        this.alt1 = new Text(dosComposite, 2048);
        this.alt1.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.alt1_params = new Text(dosComposite, 2048);
        BrowseButton alt1BrowseButton = new BrowseButton(dosComposite, 0);
        alt1BrowseButton.connect(this.shell, this.alt1, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, this.pixelshader);
        GrabButton grab3 = new GrabButton(dosComposite, 0);
        grab3.connect(this.alt1, this.mountingpoints);
        Label alt2Label = new Label(dosComposite, 0);
        alt2Label.setText(this.settings.msg("dialog.profile.altexe", new Object[]{2}));
        this.alt2 = new Text(dosComposite, 2048);
        this.alt2.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.alt2_params = new Text(dosComposite, 2048);
        BrowseButton alt2BrowseButton = new BrowseButton(dosComposite, 0);
        alt2BrowseButton.connect(this.shell, this.alt2, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, this.pixelshader);
        GrabButton grab4 = new GrabButton(dosComposite, 0);
        grab4.connect(this.alt2, this.mountingpoints);
    }

    private void startListeners() {
        VerifyListener addMountListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (event.text.length() > 1) {
                    boolean booter = event.widget == EditProfileDialog.this.img1 || event.widget == EditProfileDialog.this.img2 || event.widget == EditProfileDialog.this.img3;
                    EditProfileDialog.this.addMountIfNoMounts(event.text, booter);
                }
            }
        };
        this.main.addVerifyListener(addMountListener);
        this.setup.addVerifyListener(addMountListener);
        this.img1.addVerifyListener(addMountListener);
        this.img2.addVerifyListener(addMountListener);
        this.img3.addVerifyListener(addMountListener);
        if (this.isMultiEdit()) {
            ModifyListener changeMarker = new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    Control cntrl = (Control)arg0.widget;
                    cntrl.setData(new Boolean(true));
                    EditTemplateDialog.highlight(cntrl, 3);
                }
            };
            SelectionListener selectionMarker = new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    Control cntrl = (Control)arg0.widget;
                    cntrl.setData(new Boolean(true));
                    EditTemplateDialog.highlight(cntrl, 3);
                    if (cntrl instanceof Button) {
                        ((Button)cntrl).setGrayed(false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.widgetSelected(arg0);
                }
            };
            for (Control child : this.shell.getChildren()) {
                if (!(child instanceof TabFolder)) continue;
                TabFolder tabs = (TabFolder)child;
                for (TabItem tab : tabs.getItems()) {
                    Composite composite = (Composite)tab.getControl();
                    for (Control c : EditProfileDialog.getChangeables(composite)) {
                        Control cntrl;
                        if (c instanceof Combo) {
                            cntrl = (Combo)c;
                            cntrl.setData(new Boolean(false));
                            ((Combo)cntrl).addModifyListener(changeMarker);
                            continue;
                        }
                        if (c instanceof Text) {
                            cntrl = (Text)c;
                            cntrl.setData(new Boolean(false));
                            ((Text)cntrl).addModifyListener(changeMarker);
                            continue;
                        }
                        if (c instanceof Button) {
                            cntrl = (Button)c;
                            cntrl.setData(new Boolean(false));
                            ((Button)cntrl).addSelectionListener(selectionMarker);
                            continue;
                        }
                        if (c instanceof Spinner) {
                            cntrl = (Spinner)c;
                            cntrl.setData(new Boolean(false));
                            ((Spinner)cntrl).addModifyListener(changeMarker);
                            continue;
                        }
                        if (c instanceof Scale) {
                            cntrl = (Scale)c;
                            cntrl.setData(new Boolean(false));
                            ((Scale)cntrl).addSelectionListener(selectionMarker);
                            continue;
                        }
                        if (!(c instanceof org.eclipse.swt.widgets.List)) continue;
                        cntrl = (org.eclipse.swt.widgets.List)c;
                        cntrl.setData(new Boolean(false));
                        ((org.eclipse.swt.widgets.List)cntrl).addSelectionListener(selectionMarker);
                    }
                }
            }
        }
    }

    private void addMountIfNoMounts(String hostFileLocation, boolean booter) {
        if (this.mountingpoints.getItemCount() == 0) {
            try {
                this.mountingpoints.setItems(((Configurable)this.multiProfileList.get(0)).getConf().addRequiredMount(booter, hostFileLocation));
                this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Profile duplicateProfile(Profile prof, List<DosboxVersion> dbversionsList, Database dbase, Shell shell) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        try {
            dbase.startTransaction();
            DosboxVersion dbversion = dbversionsList.get(DosboxVersion.findById(dbversionsList, prof.getDbversionId()));
            Conf newCompositeConf = new Conf(prof, dbversion, ps);
            int newProfileId = dbase.duplicateProfile(prof.getId());
            String newCapturesString = FileUtils.constructCapturesDir(newProfileId);
            File newCaptures = FileUtils.canonicalToData(newCapturesString);
            FileUtils.createDir(newCaptures);
            String newConfFile = FileUtils.constructUniqueConfigFileString(newProfileId, prof.getTitle(), newCompositeConf.getAutoexec().getCanonicalMainDir());
            Profile newProfile = new Profile(newProfileId, newConfFile, newCapturesString, prof);
            newCompositeConf.injectOrUpdateProfile(newProfile);
            newCompositeConf.save();
            dbase.updateProfileConf(newConfFile, newCapturesString, newProfileId);
            dbase.commitTransaction();
            if (GeneralPurposeDialogs.confirmMessage(shell, Settings.getInstance().msg("dialog.profile.confirm.capturesduplication"))) {
                FileUtils.copyFiles(prof.getCanonicalCaptures(), newCaptures);
            }
            if (bos.size() > 0) {
                GeneralPurposeDialogs.warningMessage(shell, bos.toString());
                bos.reset();
            }
            Profile profile = newProfile;
            return profile;
        }
        catch (Exception e) {
            GeneralPurposeDialogs.warningMessage(shell, e);
            try {
                dbase.rollbackTransaction();
            }
            catch (SQLException se) {
                GeneralPurposeDialogs.warningMessage(shell, se);
            }
            Profile profile = null;
            return profile;
        }
        finally {
            dbase.finishTransaction();
        }
    }

    @Override
    protected void doPerformDosboxConfAction(EditTemplateDialog.DosboxConfAction action) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            this.updateAllConfigurationsBySettings();
            Conf newDosboxVersion = null;
            newDosboxVersion = action == EditTemplateDialog.DosboxConfAction.RELOAD_TEMPLATE ? new Conf(this.templatesList.get(this.template.getSelectionIndex()), (DosboxVersion)this.dbversionsList.get(this.dbversion.getSelectionIndex()), ps) : new Conf((DosboxVersion)this.dbversionsList.get(this.dbversion.getSelectionIndex()), ps);
            for (Configurable c : this.multiProfileList) {
                this.doPerformdosboxConfAction(action, newDosboxVersion, c);
            }
            if (this.isMultiEdit()) {
                this.doPerformdosboxConfAction(action, newDosboxVersion, this.multiProfileCombined);
                this.enableSettingsByConfiguration(this.multiProfileCombined.getConf().getDosboxSettings());
                this.selectSettingsByConfiguration(this.multiProfileCombined.getConf());
            } else {
                this.enableSettingsByConfiguration(((Configurable)this.multiProfileList.get(0)).getConf().getDosboxSettings());
                this.selectSettingsByConfiguration(((Configurable)this.multiProfileList.get(0)).getConf());
            }
            if (bos.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), bos.toString());
                bos.reset();
            }
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
        }
    }

    private void doPerformdosboxConfAction(EditTemplateDialog.DosboxConfAction action, Conf newDosboxVersion, Configurable c) {
        if (action == EditTemplateDialog.DosboxConfAction.SET) {
            c.getConf().setToDosboxVersion(newDosboxVersion);
        } else if (action == EditTemplateDialog.DosboxConfAction.SWITCH) {
            c.getConf().switchToDosboxVersion(newDosboxVersion);
        } else if (action == EditTemplateDialog.DosboxConfAction.RELOAD) {
            c.getConf().reloadDosboxVersion(newDosboxVersion);
        } else if (action == EditTemplateDialog.DosboxConfAction.RELOAD_TEMPLATE) {
            c.getConf().reloadTemplate(newDosboxVersion);
        }
    }

    @Override
    protected void selectSettingsByConfiguration(Conf conf) {
        super.selectSettingsByConfiguration(conf);
        EditProfileDialog.setFieldIfEnabled(this.result instanceof Profile ? ((Profile)this.result).getCaptures() : this.settings.msg("dialog.profile.automatic"), false, this.captures);
        EditProfileDialog.setFieldIfEnabled(String.valueOf(conf.getAutoexec().isLoadfix()), Conf.isConflictingValue(conf.getAutoexec().isLoadfix()), this.loadfix);
        this.loadfix_value.setEnabled(this.loadfix.getSelection());
        EditProfileDialog.setFieldIfEnabled(String.valueOf(conf.getAutoexec().getLoadfixValue()), Conf.isConflictingValue(conf.getAutoexec().getLoadfixValue()), this.loadfix_value);
        if (!this.isMultiEdit()) {
            if (conf.getAutoexec().isBooter()) {
                this.img1.setText(conf.getAutoexec().getImg1());
                this.img2.setText(conf.getAutoexec().getImg2());
                this.img3.setText(conf.getAutoexec().getImg3());
            } else {
                this.main.setText(conf.getAutoexec().getMain());
                this.main_params.setText(conf.getAutoexec().getMainParameters());
            }
        }
    }

    protected void updateAllConfigurationsBySettings() {
        if (this.isMultiEdit()) {
            for (Configurable c : this.multiProfileList) {
                super.updateConfigurationBySettings(c.getConf());
                c.getConf().setAutoexecSettingsForProfileMultiEdit(this.fetch(this.loadfix), this.fetch(this.loadfix_value), this.fetch(this.exit), this.fetch(this.mixer_config), this.fetch(this.keyb), this.fetch(this.ipxnet));
            }
            super.updateConfigurationBySettings(this.multiProfileCombined.getConf());
            this.multiProfileCombined.getConf().setAutoexecSettingsForProfileMultiEdit(this.fetch(this.loadfix), this.fetch(this.loadfix_value), this.fetch(this.exit), this.fetch(this.mixer_config), this.fetch(this.keyb), this.fetch(this.ipxnet));
        } else {
            super.updateConfigurationBySettings(((Configurable)this.multiProfileList.get(0)).getConf());
            ((Configurable)this.multiProfileList.get(0)).getConf().setAutoexecSettingsForProfile(this.loadfix.getSelection(), this.loadfix_value.getText(), this.main.getText(), this.main_params.getText(), this.img1.getText(), this.img2.getText(), this.img3.getText());
        }
    }

    protected boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (!this.isMultiEdit()) {
            String requiredMount = null;
            if (this.title.getText().length() == 0) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.title"), this.title, this.infoTabItem);
            }
            if (this.dosExpandItem.getExpanded()) {
                if (FileUtils.isExecutable(this.main.getText())) {
                    requiredMount = this.dealWithField(false, this.main.getText());
                } else {
                    GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.mainexe"), this.main, this.mountingTabItem);
                }
                if (FileUtils.isExecutable(this.setup.getText())) {
                    requiredMount = this.dealWithField(false, this.setup.getText());
                }
            } else {
                if (this.img1.getText().length() == 0) {
                    GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.booterimage"), this.img1, this.mountingTabItem);
                } else {
                    requiredMount = this.dealWithField(true, this.img1.getText());
                }
                if (this.img2.getText().length() > 0) {
                    requiredMount = this.dealWithField(true, this.img2.getText());
                }
                if (this.img3.getText().length() > 0) {
                    requiredMount = this.dealWithField(true, this.img3.getText());
                }
            }
            if (requiredMount != null) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.mountlocation"), this.mountingpoints, this.mountingTabItem);
            }
        }
        if (this.setButton.isEnabled()) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.template.required.dosboxassociation"), this.setButton, this.generalTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private String dealWithField(boolean booter, String loc) {
        String requiredMount = ((Configurable)this.multiProfileList.get(0)).getConf().getRequiredMount(booter, loc);
        if (requiredMount != null && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.profile.confirm.addmountlocation", new Object[]{requiredMount}))) {
            this.mountingpoints.setItems(((Configurable)this.multiProfileList.get(0)).getConf().addRequiredMount(booter, loc));
        }
        return ((Configurable)this.multiProfileList.get(0)).getConf().getRequiredMount(booter, loc);
    }

    private void setProfileMetaData(Profile prof) {
        int i;
        EditProfileDialog.setFieldIfEnabled(prof.getTitle(), Conf.isConflictingValue(prof.getTitle()), this.title);
        EditProfileDialog.setFieldIfEnabled(prof.getDeveloperName(), Conf.isConflictingValue(prof.getDeveloperName()), this.developer);
        EditProfileDialog.setFieldIfEnabled(prof.getPublisherName(), Conf.isConflictingValue(prof.getPublisherName()), this.publisher);
        EditProfileDialog.setFieldIfEnabled(prof.getGenre(), Conf.isConflictingValue(prof.getGenre()), this.genre);
        EditProfileDialog.setFieldIfEnabled(prof.getYear(), Conf.isConflictingValue(prof.getYear()), this.year);
        for (i = 0; i < AMOUNT_OF_LINKS; ++i) {
            EditProfileDialog.setFieldIfEnabled(prof.getLink(i), Conf.isConflictingValue(prof.getLink(i)), this.link[i]);
            EditProfileDialog.setFieldIfEnabled(prof.getLinkTitle(i), Conf.isConflictingValue(prof.getLinkTitle(i)), this.linkTitle[i]);
        }
        EditProfileDialog.setFieldIfEnabled(prof.getStatus(), Conf.isConflictingValue(prof.getStatus()), this.status);
        EditProfileDialog.setFieldIfEnabled(String.valueOf(prof.isDefault()), Conf.isConflictingValue(prof.isDefault()), this.favorite);
        EditProfileDialog.setFieldIfEnabled(prof.getNotes(), Conf.isConflictingValue(prof.getNotes()), this.notes);
        EditProfileDialog.setFieldIfEnabled(prof.getSetup(0), Conf.isConflictingValue(prof.getSetup(0)), this.setup);
        EditProfileDialog.setFieldIfEnabled(prof.getSetupParameters(0), Conf.isConflictingValue(prof.getSetupParameters(0)), this.setup_params);
        EditProfileDialog.setFieldIfEnabled(prof.getSetup(1), Conf.isConflictingValue(prof.getSetup(1)), this.alt1);
        EditProfileDialog.setFieldIfEnabled(prof.getSetupParameters(1), Conf.isConflictingValue(prof.getSetupParameters(1)), this.alt1_params);
        EditProfileDialog.setFieldIfEnabled(prof.getSetup(2), Conf.isConflictingValue(prof.getSetup(2)), this.alt2);
        EditProfileDialog.setFieldIfEnabled(prof.getSetupParameters(2), Conf.isConflictingValue(prof.getSetupParameters(2)), this.alt2_params);
        for (i = 0; i < AMOUNT_OF_CUSTOM_STRINGS; ++i) {
            EditProfileDialog.setFieldIfEnabled(prof.getCustomString(i), Conf.isConflictingValue(prof.getCustomString(i)), this.customCombo[i]);
            EditProfileDialog.setFieldIfEnabled(prof.getCustomString(AMOUNT_OF_CUSTOM_STRINGS + i), Conf.isConflictingValue(prof.getCustomString(AMOUNT_OF_CUSTOM_STRINGS + i)), this.customText[i]);
        }
        EditProfileDialog.setFieldIfEnabled(String.valueOf(prof.getCustomInt(0)), Conf.isConflictingValue(prof.getCustomInt(0)), this.custom9);
        EditProfileDialog.setFieldIfEnabled(String.valueOf(prof.getCustomInt(1)), Conf.isConflictingValue(prof.getCustomInt(1)), this.custom10);
    }

    private static List<Control> getChangeables(Composite composite) {
        Control[] children = composite.getChildren();
        ArrayList<Control> result = new ArrayList<Control>();
        for (Control c : children) {
            if (c instanceof Button && (c.getStyle() & 0x20) != 0 || c instanceof Combo || c instanceof Text || c instanceof Spinner || c instanceof Scale || c instanceof org.eclipse.swt.widgets.List) {
                result.add(c);
                continue;
            }
            if (!(c instanceof Group) && !(c instanceof Composite)) continue;
            result.addAll(EditProfileDialog.getChangeables((Composite)c));
        }
        return result;
    }

    private void saveWebImages(File canonicalCapturesDir) {
        for (int i = 0; i < this.imageInformation.length; ++i) {
            File file;
            String filename;
            if (!this.imgButtons[i].getSelection()) continue;
            String description = FileUtils.fileSystemSafeWebImages(this.imageInformation[i].description);
            if (this.imageInformation[i].type == SearchEngineImageInformation.SearchEngineImageType.CoverArt) {
                filename = this.settings.msg("dialog.profile.mobygames.coverartfilename", new Object[]{i, description});
                file = new File(canonicalCapturesDir, filename + ".jpg");
            } else {
                filename = this.settings.msg("dialog.profile.mobygames.screenshotfilename", new Object[]{i, description});
                file = new File(canonicalCapturesDir, filename + ".png");
            }
            if (!FileUtils.isExistingFile(file)) {
                SWTImageManager.save(this.imageInformation[i].data, file.getPath());
                continue;
            }
            GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("dialog.profile.error.imagealreadyexists", new Object[]{file.getPath(), this.getSelectedSearchEngine().getName()}));
        }
    }

    private WebSearchEngine getSelectedSearchEngine() {
        WebSearchEngine engine = null;
        for (WebSearchEngine engn : webSearchEngines) {
            if (!engn.getName().equals(this.doSearch.getData())) continue;
            engine = engn;
        }
        return engine;
    }

    private WebSearchEngine getSearchEngineBySimpleName(String simpleName) {
        for (WebSearchEngine engn : webSearchEngines) {
            if (!engn.getSimpleName().equalsIgnoreCase(simpleName)) continue;
            return engn;
        }
        return null;
    }

    static /* synthetic */ SearchEngineImageInformation[] access$2102(EditProfileDialog x0, SearchEngineImageInformation[] x1) {
        x0.imageInformation = x1;
        return x1;
    }

    static /* synthetic */ Button[] access$2702(EditProfileDialog x0, Button[] x1) {
        x0.imgButtons = x1;
        return x1;
    }
}

