/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.AutoSelectCombo;
import org.dbgl.gui.EditMixerDialog;
import org.dbgl.gui.EditMountDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SettingsDialog;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpTemplate;
import org.dbgl.model.Mount;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditTemplateDialog
extends Dialog {
    protected Text title;
    protected Button defaultButton;
    protected Combo dbversion;
    protected Button setButton;
    protected Button switchButton;
    protected Button reloadButton;
    protected Combo priority_active;
    protected Combo priority_inactive;
    protected Button waitonerror;
    protected Button exit;
    protected Text language;
    protected Text captures;
    protected Text config_file;
    protected Combo output;
    protected Combo frameskip;
    protected Combo scaler;
    protected Combo pixelshader;
    protected Button fulldouble;
    protected Button fullscreen;
    protected Combo fullresolution;
    protected Combo windowresolution;
    protected Button aspect;
    protected Text overscan;
    protected Combo svgachipset;
    protected Combo videoram;
    protected Combo vsyncmode;
    protected Text vsyncrate;
    protected Button scaler_forced;
    protected Button glide;
    protected Text glideport;
    protected Combo lfbGlide;
    protected Combo machine;
    protected Combo cpu_type;
    protected Combo core;
    protected Combo cycles;
    protected Combo cycles_up;
    protected Combo cycles_down;
    protected Button timesynched;
    protected Combo memsize;
    protected Button xms;
    protected Combo ems;
    protected Combo umb;
    protected Button nosound;
    protected Combo rate;
    protected Combo blocksize;
    protected Combo prebuffer;
    protected Combo mpu401;
    protected Combo midi_device;
    protected Text midi_config;
    protected Text mixer_config;
    protected Combo mt32rate;
    protected Combo sbtype;
    protected Combo oplrate;
    protected Combo oplmode;
    protected Combo oplemu;
    protected Combo sbbase;
    protected Combo irq;
    protected Combo dma;
    protected Combo hdma;
    protected Button sbmixer;
    protected Button gus;
    protected Combo gusrate;
    protected Combo gusbase;
    protected Combo gusdma1;
    protected Combo gusdma2;
    protected Combo gusirq1;
    protected Combo gusirq2;
    protected Text ultradir;
    protected Button pcspeaker;
    protected Combo pcrate;
    protected Combo tandy;
    protected Combo tandyrate;
    protected Button disney;
    protected Button usescancodes;
    protected Text mapperfile;
    protected Combo keyboard_layout;
    protected Text keyb;
    protected Button autolock;
    protected Combo sensitivity;
    protected Combo joysticktype;
    protected Button timed;
    protected Button autofire;
    protected Button swap34;
    protected Button buttonwrap;
    protected Text serial1;
    protected Text serial2;
    protected Text serial3;
    protected Text serial4;
    protected Button ipx;
    protected Text ipxnet;
    protected org.eclipse.swt.widgets.List mountingpoints;
    protected ExpandItem booterExpandItem;
    protected ExpandItem dosExpandItem;
    protected Group memoryGroup;
    protected Group associationGroup;
    protected Group miscGroup;
    protected Group executeGroup;
    protected TabItem infoTabItem;
    protected TabItem generalTabItem;
    protected TabItem mountingTabItem;
    protected Button okButton;
    protected Button cancelButton;
    protected int dbversionIndex = -1;
    protected Shell shell;
    protected List<DosboxVersion> dbversionsList;
    protected Database dbase;
    protected List<Configurable> multiProfileList = new ArrayList<Configurable>();
    protected Settings settings;
    protected Object result;

    public EditTemplateDialog(Shell parent) {
        super(parent, 0);
    }

    public void setTemplate(Template template) {
        this.result = template;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.dbase = Database.getInstance();
        if (this.init()) {
            this.createContents();
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        return this.result;
    }

    protected boolean init() {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            if (this.result == null) {
                this.dbversionIndex = DosboxVersion.findDefault(this.dbversionsList);
                this.multiProfileList.add(new ExpTemplate(new Conf((Template)null, this.dbversionsList.get(this.dbversionIndex), ps)));
            } else {
                this.dbversionIndex = DosboxVersion.findById(this.dbversionsList, ((Template)this.result).getDbversionId());
                this.multiProfileList.add(new ExpTemplate(new Conf((Template)this.result, this.dbversionsList.get(this.dbversionIndex), ps)));
            }
            if (bos.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), bos.toString());
                bos.reset();
            }
            return true;
        }
        catch (Exception e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
            return false;
        }
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout(new BorderLayout(0, 0));
        this.shell.addControlListener(new SizeControlAdapter(this.shell, "templatedialog"));
        if (this.result == null) {
            this.shell.setText(this.settings.msg("dialog.template.title.add"));
        } else {
            this.shell.setText(this.settings.msg("dialog.template.title.edit", new Object[]{((Template)this.result).getTitle(), ((Template)this.result).getId()}));
        }
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        this.createInfoTab(tabFolder);
        this.createGeneralTab(tabFolder);
        this.createDisplayTab(tabFolder);
        this.createMachineTab(tabFolder);
        this.createAudioTab(tabFolder);
        this.createIOTab(tabFolder);
        this.createMountingTab(tabFolder);
        this.createOkCancelButtons();
        this.okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditTemplateDialog.this.isValid()) {
                    return;
                }
                try {
                    Conf conf = EditTemplateDialog.this.multiProfileList.get(0).getConf();
                    int templateId = EditTemplateDialog.this.dbase.addOrEditTemplate(EditTemplateDialog.this.title.getText(), conf.getDbversion().getId(), EditTemplateDialog.this.defaultButton.getSelection(), EditTemplateDialog.this.result == null ? -1 : ((Template)EditTemplateDialog.this.result).getId());
                    EditTemplateDialog.this.updateConfigurationBySettings(conf);
                    EditTemplateDialog.this.result = new Template(templateId, EditTemplateDialog.this.title.getText(), conf.getDbversion().getId(), EditTemplateDialog.this.defaultButton.getSelection());
                    conf.injectOrUpdateTemplate((Template)EditTemplateDialog.this.result);
                    conf.save();
                }
                catch (Exception e) {
                    GeneralPurposeDialogs.warningMessage(EditTemplateDialog.this.shell, e);
                }
                EditTemplateDialog.this.shell.close();
            }
        });
        for (DosboxVersion dbv : this.dbversionsList) {
            this.dbversion.add(dbv.getTitle());
        }
        this.dbversion.select(this.dbversionIndex);
        if (this.result == null) {
            this.title.setFocus();
        } else {
            this.title.setText(((Template)this.result).getTitle());
            this.defaultButton.setSelection(((Template)this.result).isDefault());
        }
        this.enableSettingsByConfiguration(this.multiProfileList.get(0).getConf().getDosboxSettings());
        this.selectSettingsByConfiguration(this.multiProfileList.get(0).getConf());
    }

    protected void createOkCancelButtons() {
        Composite composite_7 = new Composite(this.shell, 0);
        composite_7.setLayout(new GridLayout(2, true));
        composite_7.setLayoutData("South");
        this.okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(this.okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        this.okButton.setLayoutData(gridData);
        this.okButton.setText(this.settings.msg("button.ok"));
        this.cancelButton = new Button(composite_7, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = 4;
        this.cancelButton.setLayoutData(gridData_1);
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        this.cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (EditTemplateDialog.this.cancelButton.getText().equals(EditTemplateDialog.this.settings.msg("button.cancel"))) {
                    EditTemplateDialog.this.result = null;
                }
                EditTemplateDialog.this.shell.close();
            }
        });
    }

    protected void createMountingTab(TabFolder tabFolder) {
        this.mountingTabItem = new TabItem(tabFolder, 0);
        this.mountingTabItem.setText(this.settings.msg("dialog.template.tab.mounting"));
        Composite composite = new Composite(tabFolder, 0);
        composite.setLayout(new GridLayout());
        this.mountingTabItem.setControl(composite);
        this.createMountingGroup(composite);
        this.createExecuteGroup(composite);
    }

    protected void createExecuteGroup(final Composite composite) {
        this.executeGroup = new Group(composite, 0);
        this.executeGroup.setLayoutData(new GridData(4, 4, true, true));
        this.executeGroup.setText(this.settings.msg("dialog.template.execute"));
        this.executeGroup.setLayout(new FillLayout());
        final ExpandBar bar = new ExpandBar(this.executeGroup, 512);
        Composite booterComposite = new Composite(bar, 0);
        Composite dosComposite = new Composite(bar, 0);
        this.createBooterComposite(booterComposite);
        this.createDosComposite(dosComposite);
        this.booterExpandItem = new ExpandItem(bar, 0, 0);
        this.booterExpandItem.setText(this.settings.msg("dialog.template.booter"));
        this.booterExpandItem.setHeight(booterComposite.computeSize((int)-1, (int)-1).y);
        this.booterExpandItem.setControl(booterComposite);
        this.dosExpandItem = new ExpandItem(bar, 0, 1);
        this.dosExpandItem.setText(this.settings.msg("dialog.template.dos"));
        this.dosExpandItem.setHeight(dosComposite.computeSize((int)-1, (int)-1).y);
        this.dosExpandItem.setControl(dosComposite);
        bar.addExpandListener(new ExpandAdapter(){

            public void itemCollapsed(ExpandEvent e) {
                bar.getItem(((ExpandItem)e.item).getText().equals(EditTemplateDialog.this.settings.msg("dialog.template.dos")) ? 0 : 1).setExpanded(true);
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        composite.layout();
                    }
                });
            }

            public void itemExpanded(ExpandEvent e) {
                bar.getItem(((ExpandItem)e.item).getText().equals(EditTemplateDialog.this.settings.msg("dialog.template.dos")) ? 0 : 1).setExpanded(false);
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        composite.layout();
                    }
                });
            }
        });
        if (this.isMultiEdit()) {
            bar.setEnabled(false);
        }
    }

    protected void createBooterComposite(Composite booterComposite) {
        booterComposite.setLayout(new GridLayout());
        Label image1Label = new Label(booterComposite, 0);
        image1Label.setText(this.settings.msg("dialog.profile.booterimage1"));
    }

    protected void createDosComposite(Composite dosComposite) {
        dosComposite.setLayout(new GridLayout());
        Label mainExeLabel = new Label(dosComposite, 0);
        mainExeLabel.setText(this.settings.msg("dialog.profile.mainexe"));
    }

    protected void createMountingGroup(Composite composite) {
        Group mountGroup = new Group(composite, 0);
        mountGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        mountGroup.setText(this.settings.msg("dialog.template.mountingoverview"));
        GridLayout gridLayout_19 = new GridLayout();
        gridLayout_19.numColumns = 2;
        mountGroup.setLayout(gridLayout_19);
        this.mountingpoints = new org.eclipse.swt.widgets.List(mountGroup, 2560);
        this.mountingpoints.setLayoutData(new GridData(4, 4, true, false, 1, 3));
        this.mountingpoints.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (EditTemplateDialog.this.mountingpoints.getSelectionIndex() == -1) {
                    EditTemplateDialog.this.doAddMount();
                } else {
                    EditTemplateDialog.this.doEditMount();
                }
            }
        });
        Button addButton = new Button(mountGroup, 0);
        addButton.setLayoutData(new GridData(4, 0x1000000, false, false));
        addButton.setText(this.settings.msg("dialog.template.mount.add"));
        addButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doAddMount();
            }
        });
        Button editButton = new Button(mountGroup, 0);
        editButton.setLayoutData(new GridData(4, 0x1000000, false, false));
        editButton.setText(this.settings.msg("dialog.template.mount.edit"));
        editButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doEditMount();
            }
        });
        Button removeButton = new Button(mountGroup, 0);
        removeButton.setLayoutData(new GridData(4, 0x1000000, false, false));
        removeButton.setText(this.settings.msg("dialog.template.mount.remove"));
        removeButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doRemoveMount();
            }
        });
        if (this.isMultiEdit()) {
            this.mountingpoints.setEnabled(false);
            addButton.setEnabled(false);
            editButton.setEnabled(false);
            removeButton.setEnabled(false);
        }
    }

    protected void createIOTab(TabFolder tabFolder) {
        TabItem inputTabItem = new TabItem(tabFolder, 0);
        inputTabItem.setText(this.settings.msg("dialog.template.tab.io"));
        Composite composite_5 = new Composite(tabFolder, 0);
        GridLayout gridLayout_17 = new GridLayout();
        gridLayout_17.numColumns = 3;
        composite_5.setLayout(gridLayout_17);
        inputTabItem.setControl(composite_5);
        Group mouseGroup = new Group(composite_5, 0);
        mouseGroup.setLayoutData(new GridData(4, 4, false, false));
        mouseGroup.setText(this.settings.msg("dialog.template.mouse"));
        GridLayout gridLayout_13 = new GridLayout();
        gridLayout_13.numColumns = 2;
        mouseGroup.setLayout(gridLayout_13);
        Label autolockLabel = new Label(mouseGroup, 0);
        autolockLabel.setText(this.settings.msg("dialog.template.autolock"));
        this.autolock = new Button(mouseGroup, 32);
        this.autolock.setToolTipText(this.settings.msg("dialog.template.autolock.tooltip"));
        Label sensitivityLabel = new Label(mouseGroup, 0);
        sensitivityLabel.setText(this.settings.msg("dialog.template.sensitivity"));
        this.sensitivity = new Combo(mouseGroup, 8);
        this.sensitivity.setItems(this.settings.getSettings().getValues("profile", "sensitivity"));
        this.sensitivity.setLayoutData(new GridData(4, 0x1000000, false, false));
        this.sensitivity.setVisibleItemCount(20);
        this.sensitivity.setToolTipText(this.settings.msg("dialog.template.sensitivity.tooltip"));
        Group keyboardGroup = new Group(composite_5, 0);
        keyboardGroup.setLayoutData(new GridData(4, 4, true, false));
        keyboardGroup.setText(this.settings.msg("dialog.template.keyboard"));
        GridLayout gridLayout_14 = new GridLayout();
        gridLayout_14.numColumns = 2;
        keyboardGroup.setLayout(gridLayout_14);
        Label useScancodesLabel = new Label(keyboardGroup, 0);
        useScancodesLabel.setText(this.settings.msg("dialog.template.usescancodes"));
        this.usescancodes = new Button(keyboardGroup, 32);
        this.usescancodes.setToolTipText(this.settings.msg("dialog.template.usescancodes.tooltip"));
        Label mapperFileLabel = new Label(keyboardGroup, 0);
        mapperFileLabel.setText(this.settings.msg("dialog.template.mapperfile"));
        this.mapperfile = new Text(keyboardGroup, 2048);
        this.mapperfile.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.mapperfile.setToolTipText(this.settings.msg("dialog.template.mapperfile.tooltip"));
        Label layoutLabel = new Label(keyboardGroup, 0);
        layoutLabel.setText(this.settings.msg("dialog.template.keyboardlayout"));
        this.keyboard_layout = new Combo(keyboardGroup, 0);
        this.keyboard_layout.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.keyboard_layout.setVisibleItemCount(15);
        this.keyboard_layout.setItems(this.settings.getSettings().getValues("profile", "keyboardlayout"));
        this.keyboard_layout.setToolTipText(this.settings.msg("dialog.template.keyboardlayout.tooltip"));
        Label keybLabel = new Label(keyboardGroup, 0);
        keybLabel.setText(this.settings.msg("dialog.template.keybcommand"));
        this.keyb = new Text(keyboardGroup, 2048);
        this.keyb.setLayoutData(new GridData(4, 0x1000000, true, false));
        Group joystickGroup = new Group(composite_5, 0);
        joystickGroup.setLayoutData(new GridData(4, 4, false, false));
        joystickGroup.setText(this.settings.msg("dialog.template.joystick"));
        GridLayout gridLayout_15 = new GridLayout();
        gridLayout_15.numColumns = 2;
        joystickGroup.setLayout(gridLayout_15);
        Label typeLabel_1 = new Label(joystickGroup, 0);
        typeLabel_1.setText(this.settings.msg("dialog.template.joysticktype"));
        this.joysticktype = new Combo(joystickGroup, 8);
        this.joysticktype.setItems(this.settings.getSettings().getValues("profile", "joysticktype"));
        this.joysticktype.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.joysticktype.setToolTipText(this.settings.msg("dialog.template.joysticktype.tooltip"));
        Label timedLabel = new Label(joystickGroup, 0);
        timedLabel.setText(this.settings.msg("dialog.template.timedemulation"));
        this.timed = new Button(joystickGroup, 32);
        this.timed.setToolTipText(this.settings.msg("dialog.template.timedemulation.tooltip"));
        Label autofireLabel = new Label(joystickGroup, 0);
        autofireLabel.setText(this.settings.msg("dialog.template.autofire"));
        this.autofire = new Button(joystickGroup, 32);
        this.autofire.setToolTipText(this.settings.msg("dialog.template.autofire.tooltip"));
        Label swapAxes3Label = new Label(joystickGroup, 0);
        swapAxes3Label.setText(this.settings.msg("dialog.template.swap34"));
        this.swap34 = new Button(joystickGroup, 32);
        this.swap34.setToolTipText(this.settings.msg("dialog.template.swap34.tooltip"));
        Label buttonWrapLabel = new Label(joystickGroup, 0);
        buttonWrapLabel.setText(this.settings.msg("dialog.template.buttonwrapping"));
        this.buttonwrap = new Button(joystickGroup, 32);
        this.buttonwrap.setToolTipText(this.settings.msg("dialog.template.buttonwrapping.tooltip"));
        Group modemGroup = new Group(composite_5, 0);
        modemGroup.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        modemGroup.setText(this.settings.msg("dialog.template.modem"));
        GridLayout gridLayout_16 = new GridLayout();
        gridLayout_16.numColumns = 2;
        modemGroup.setLayout(gridLayout_16);
        Label serial1Label = new Label(modemGroup, 0);
        serial1Label.setText(this.settings.msg("dialog.template.serial1"));
        this.serial1 = new Text(modemGroup, 2048);
        this.serial1.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.serial1.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Label serial2Label = new Label(modemGroup, 0);
        serial2Label.setText(this.settings.msg("dialog.template.serial2"));
        this.serial2 = new Text(modemGroup, 2048);
        this.serial2.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.serial2.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Label serial3Label = new Label(modemGroup, 0);
        serial3Label.setText(this.settings.msg("dialog.template.serial3"));
        this.serial3 = new Text(modemGroup, 2048);
        this.serial3.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.serial3.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Label serial4Label = new Label(modemGroup, 0);
        serial4Label.setText(this.settings.msg("dialog.template.serial4"));
        this.serial4 = new Text(modemGroup, 2048);
        this.serial4.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.serial4.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Group networkGroup = new Group(composite_5, 0);
        networkGroup.setLayoutData(new GridData(4, 4, false, false));
        networkGroup.setText(this.settings.msg("dialog.template.network"));
        GridLayout gridLayout_20 = new GridLayout();
        gridLayout_20.numColumns = 2;
        networkGroup.setLayout(gridLayout_20);
        Label ipxLabel = new Label(networkGroup, 0);
        ipxLabel.setText(this.settings.msg("dialog.template.enableipx"));
        this.ipx = new Button(networkGroup, 32);
        this.ipx.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.ipxnet.setEnabled(EditTemplateDialog.this.ipx.getSelection());
            }
        });
        this.ipx.setToolTipText(this.settings.msg("dialog.template.enableipx.tooltip"));
        Label ipxnetCommandLabel = new Label(networkGroup, 0);
        ipxnetCommandLabel.setText(this.settings.msg("dialog.template.ipxnetcommand"));
        ipxnetCommandLabel.setLayoutData(new GridData(1, 0x1000000, false, false, 2, 1));
        this.ipxnet = new Text(networkGroup, 2048);
        this.ipxnet.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
    }

    protected void createAudioTab(TabFolder tabFolder) {
        TabItem audioTabItem = new TabItem(tabFolder, 0);
        audioTabItem.setText(this.settings.msg("dialog.template.tab.audio"));
        Composite composite_4 = new Composite(tabFolder, 0);
        GridLayout gridLayout_9 = new GridLayout();
        gridLayout_9.numColumns = 3;
        composite_4.setLayout(gridLayout_9);
        audioTabItem.setControl(composite_4);
        Group generalGroup = new Group(composite_4, 0);
        generalGroup.setLayoutData(new GridData(4, 4, true, false));
        GridLayout gridLayout_6 = new GridLayout();
        gridLayout_6.numColumns = 2;
        generalGroup.setLayout(gridLayout_6);
        generalGroup.setText(this.settings.msg("dialog.template.general"));
        Label silentModeLabel = new Label(generalGroup, 0);
        silentModeLabel.setText(this.settings.msg("dialog.template.silentmode"));
        this.nosound = new Button(generalGroup, 32);
        this.nosound.setToolTipText(this.settings.msg("dialog.template.silentmode.tooltip"));
        Label sampleRateLabel = new Label(generalGroup, 0);
        sampleRateLabel.setText(this.settings.msg("dialog.template.samplerate"));
        this.rate = new Combo(generalGroup, 8);
        this.rate.setVisibleItemCount(10);
        this.rate.setItems(this.settings.getSettings().getValues("profile", "rate"));
        this.rate.setLayoutData(new GridData());
        this.rate.setToolTipText(this.settings.msg("dialog.template.samplerate.tooltip"));
        Label blockSizeLabel = new Label(generalGroup, 0);
        blockSizeLabel.setText(this.settings.msg("dialog.template.blocksize"));
        this.blocksize = new Combo(generalGroup, 8);
        this.blocksize.setItems(this.settings.getSettings().getValues("profile", "blocksize"));
        this.blocksize.setLayoutData(new GridData());
        this.blocksize.setToolTipText(this.settings.msg("dialog.template.blocksize.tooltip"));
        Label prebufferLabel = new Label(generalGroup, 0);
        prebufferLabel.setText(this.settings.msg("dialog.template.prebuffer"));
        this.prebuffer = new Combo(generalGroup, 0);
        this.prebuffer.setItems(this.settings.getSettings().getValues("profile", "prebuffer"));
        this.prebuffer.setLayoutData(new GridData(70, -1));
        this.prebuffer.setToolTipText(this.settings.msg("dialog.template.prebuffer.tooltip"));
        Label mpu401Label = new Label(generalGroup, 0);
        mpu401Label.setText(this.settings.msg("dialog.template.mpu401"));
        this.mpu401 = new Combo(generalGroup, 8);
        this.mpu401.setItems(this.settings.getSettings().getValues("profile", "mpu401"));
        this.mpu401.setLayoutData(new GridData());
        this.mpu401.setToolTipText(this.settings.msg("dialog.template.mpu401.tooltip"));
        Label midiDeviceLabel = new Label(generalGroup, 0);
        midiDeviceLabel.setText(this.settings.msg("dialog.template.mididevice"));
        this.midi_device = new Combo(generalGroup, 8);
        this.midi_device.setVisibleItemCount(10);
        this.midi_device.setItems(this.settings.getSettings().getValues("profile", "device"));
        this.midi_device.setLayoutData(new GridData());
        this.midi_device.setToolTipText(this.settings.msg("dialog.template.mididevice.tooltip"));
        Label configLabel = new Label(generalGroup, 0);
        configLabel.setText(this.settings.msg("dialog.template.midiconfig"));
        this.midi_config = new Text(generalGroup, 2048);
        this.midi_config.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.midi_config.setToolTipText(this.settings.msg("dialog.template.midiconfig.tooltip"));
        Label mixerConfigLabel = new Label(generalGroup, 0);
        mixerConfigLabel.setText(this.settings.msg("dialog.template.mixercommand"));
        Composite mixerSettings = new Composite(generalGroup, 0);
        mixerSettings.setLayoutData(new GridData(4, 4, false, false));
        GridLayout filler = new GridLayout();
        filler.numColumns = 2;
        filler.horizontalSpacing = 2;
        filler.marginWidth = 0;
        mixerSettings.setLayout(filler);
        this.mixer_config = new Text(mixerSettings, 18436);
        GridData mixerConfigGridData = new GridData(4, 0x1000000, true, false);
        mixerConfigGridData.widthHint = 66;
        this.mixer_config.setLayoutData(mixerConfigGridData);
        Button mixerConfig = new Button(mixerSettings, 0);
        mixerConfig.setText("...");
        mixerConfig.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditMixerDialog dialog = new EditMixerDialog(EditTemplateDialog.this.shell);
                dialog.setMixerCommand(EditTemplateDialog.this.mixer_config.getText());
                String command = (String)dialog.open();
                if (command != null) {
                    EditTemplateDialog.this.mixer_config.setText(command);
                }
            }
        });
        Group soundblasterGroup = new Group(composite_4, 0);
        soundblasterGroup.setLayoutData(new GridData(4, 4, false, false));
        soundblasterGroup.setText(this.settings.msg("dialog.template.soundblaster"));
        GridLayout gridLayout_7 = new GridLayout();
        gridLayout_7.numColumns = 2;
        soundblasterGroup.setLayout(gridLayout_7);
        Label typeLabel = new Label(soundblasterGroup, 0);
        typeLabel.setText(this.settings.msg("dialog.template.sbtype"));
        this.sbtype = new Combo(soundblasterGroup, 8);
        this.sbtype.setVisibleItemCount(10);
        this.sbtype.setItems(this.settings.getSettings().getValues("profile", "sbtype"));
        this.sbtype.setLayoutData(new GridData());
        this.sbtype.setToolTipText(this.settings.msg("dialog.template.sbtype.tooltip"));
        Label oplRateLabel = new Label(soundblasterGroup, 0);
        oplRateLabel.setText(this.settings.msg("dialog.template.sboplrate"));
        this.oplrate = new Combo(soundblasterGroup, 8);
        this.oplrate.setVisibleItemCount(10);
        this.oplrate.setItems(this.settings.getSettings().getValues("profile", "oplrate"));
        this.oplrate.setLayoutData(new GridData());
        this.oplrate.setToolTipText(this.settings.msg("dialog.template.sboplrate.tooltip"));
        Label oplModeLabel = new Label(soundblasterGroup, 0);
        oplModeLabel.setLayoutData(new GridData());
        oplModeLabel.setText(this.settings.msg("dialog.template.sboplmode"));
        this.oplmode = new Combo(soundblasterGroup, 8);
        this.oplmode.setItems(this.settings.getSettings().getValues("profile", "oplmode"));
        this.oplmode.setLayoutData(new GridData());
        this.oplmode.setToolTipText(this.settings.msg("dialog.template.sboplmode.tooltip"));
        Label oplEmuLabel = new Label(soundblasterGroup, 0);
        oplEmuLabel.setLayoutData(new GridData());
        oplEmuLabel.setText(this.settings.msg("dialog.template.sboplemu"));
        this.oplemu = new Combo(soundblasterGroup, 8);
        this.oplemu.setItems(this.settings.getSettings().getValues("profile", "oplemu"));
        this.oplemu.setLayoutData(new GridData());
        this.oplemu.setToolTipText(this.settings.msg("dialog.template.sboplemu.tooltip"));
        Label addressLabel = new Label(soundblasterGroup, 0);
        addressLabel.setText(this.settings.msg("dialog.template.sbaddress"));
        this.sbbase = new Combo(soundblasterGroup, 8);
        this.sbbase.setItems(this.settings.getSettings().getValues("profile", "sbbase"));
        this.sbbase.setLayoutData(new GridData());
        this.sbbase.setToolTipText(this.settings.msg("dialog.template.sbaddress.tooltip"));
        Label irqLabel = new Label(soundblasterGroup, 0);
        irqLabel.setText(this.settings.msg("dialog.template.sbirq"));
        this.irq = new Combo(soundblasterGroup, 8);
        this.irq.setItems(this.settings.getSettings().getValues("profile", "irq"));
        this.irq.setLayoutData(new GridData());
        this.irq.setToolTipText(this.settings.msg("dialog.template.sbirq.tooltip"));
        Label dmaLabel = new Label(soundblasterGroup, 0);
        dmaLabel.setText(this.settings.msg("dialog.template.sbdma"));
        this.dma = new Combo(soundblasterGroup, 8);
        this.dma.setItems(this.settings.getSettings().getValues("profile", "dma"));
        this.dma.setLayoutData(new GridData());
        this.dma.setToolTipText(this.settings.msg("dialog.template.sbdma.tooltip"));
        Label hdmaLabel = new Label(soundblasterGroup, 0);
        hdmaLabel.setLayoutData(new GridData());
        hdmaLabel.setText(this.settings.msg("dialog.template.sbhdma"));
        this.hdma = new Combo(soundblasterGroup, 8);
        this.hdma.setItems(this.settings.getSettings().getValues("profile", "hdma"));
        this.hdma.setLayoutData(new GridData());
        this.hdma.setToolTipText(this.settings.msg("dialog.template.sbhdma.tooltip"));
        Label mixerLabel = new Label(soundblasterGroup, 0);
        mixerLabel.setText(this.settings.msg("dialog.template.mixer"));
        this.sbmixer = new Button(soundblasterGroup, 32);
        this.sbmixer.setToolTipText(this.settings.msg("dialog.template.mixer.tooltip"));
        Group gusGroup = new Group(composite_4, 0);
        gusGroup.setLayoutData(new GridData(4, 4, true, false));
        gusGroup.setText(this.settings.msg("dialog.template.gravisultrasound"));
        GridLayout gridLayout_8 = new GridLayout();
        gridLayout_8.numColumns = 2;
        gusGroup.setLayout(gridLayout_8);
        Label enableLabel_1 = new Label(gusGroup, 0);
        enableLabel_1.setLayoutData(new GridData());
        enableLabel_1.setText(this.settings.msg("dialog.template.enablegus"));
        this.gus = new Button(gusGroup, 32);
        this.gus.setLayoutData(new GridData());
        this.gus.setToolTipText(this.settings.msg("dialog.template.enablegus.tooltip"));
        Label sampleRateLabel_2 = new Label(gusGroup, 0);
        sampleRateLabel_2.setText(this.settings.msg("dialog.template.gusrate"));
        this.gusrate = new Combo(gusGroup, 8);
        this.gusrate.setVisibleItemCount(10);
        this.gusrate.setItems(this.settings.getSettings().getValues("profile", "gusrate"));
        this.gusrate.setLayoutData(new GridData());
        this.gusrate.setToolTipText(this.settings.msg("dialog.template.gusrate.tooltip"));
        Label addressLabel_1 = new Label(gusGroup, 0);
        addressLabel_1.setText(this.settings.msg("dialog.template.gusaddress"));
        this.gusbase = new Combo(gusGroup, 8);
        this.gusbase.setItems(this.settings.getSettings().getValues("profile", "gusbase"));
        this.gusbase.setLayoutData(new GridData());
        this.gusbase.setToolTipText(this.settings.msg("dialog.template.gusaddress.tooltip"));
        Label irqLabel_1 = new Label(gusGroup, 0);
        irqLabel_1.setText(this.settings.msg("dialog.template.gusirq1"));
        this.gusirq1 = new Combo(gusGroup, 8);
        this.gusirq1.setItems(this.settings.getSettings().getValues("profile", "irq1"));
        this.gusirq1.setLayoutData(new GridData());
        this.gusirq1.setToolTipText(this.settings.msg("dialog.template.gusirq1.tooltip"));
        Label irq2Label = new Label(gusGroup, 0);
        irq2Label.setText(this.settings.msg("dialog.template.gusirq2"));
        this.gusirq2 = new Combo(gusGroup, 8);
        this.gusirq2.setItems(this.settings.getSettings().getValues("profile", "irq2"));
        this.gusirq2.setLayoutData(new GridData());
        Label dmaLabel_1 = new Label(gusGroup, 0);
        dmaLabel_1.setText(this.settings.msg("dialog.template.gusdma1"));
        this.gusdma1 = new Combo(gusGroup, 8);
        this.gusdma1.setItems(this.settings.getSettings().getValues("profile", "dma1"));
        this.gusdma1.setLayoutData(new GridData());
        this.gusdma1.setToolTipText(this.settings.msg("dialog.template.gusdma1.tooltip"));
        Label hdmaLabel_1 = new Label(gusGroup, 0);
        hdmaLabel_1.setLayoutData(new GridData());
        hdmaLabel_1.setText(this.settings.msg("dialog.template.gusdma2"));
        this.gusdma2 = new Combo(gusGroup, 8);
        this.gusdma2.setItems(this.settings.getSettings().getValues("profile", "dma2"));
        this.gusdma2.setLayoutData(new GridData());
        Label ultradirLabel = new Label(gusGroup, 0);
        ultradirLabel.setText(this.settings.msg("dialog.template.ultradir"));
        this.ultradir = new Text(gusGroup, 2048);
        this.ultradir.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.ultradir.setToolTipText(this.settings.msg("dialog.template.ultradir.tooltip"));
        Group speakerGroup = new Group(composite_4, 0);
        speakerGroup.setLayoutData(new GridData(4, 4, true, false));
        speakerGroup.setText(this.settings.msg("dialog.template.pcspeaker"));
        GridLayout gridLayout_10 = new GridLayout();
        gridLayout_10.numColumns = 2;
        speakerGroup.setLayout(gridLayout_10);
        Label enableLabel = new Label(speakerGroup, 0);
        enableLabel.setText(this.settings.msg("dialog.template.enablepcspeaker"));
        this.pcspeaker = new Button(speakerGroup, 32);
        this.pcspeaker.setToolTipText(this.settings.msg("dialog.template.enablepcspeaker.tooltip"));
        Label sampleRateLabel_1 = new Label(speakerGroup, 0);
        sampleRateLabel_1.setText(this.settings.msg("dialog.template.pcrate"));
        this.pcrate = new Combo(speakerGroup, 8);
        this.pcrate.setVisibleItemCount(10);
        this.pcrate.setItems(this.settings.getSettings().getValues("profile", "pcrate"));
        this.pcrate.setLayoutData(new GridData());
        this.pcrate.setToolTipText(this.settings.msg("dialog.template.pcrate.tooltip"));
        Group tandyGroup = new Group(composite_4, 0);
        tandyGroup.setLayoutData(new GridData(4, 4, false, false));
        tandyGroup.setText(this.settings.msg("dialog.template.tandy"));
        GridLayout gridLayout_11 = new GridLayout();
        gridLayout_11.numColumns = 2;
        tandyGroup.setLayout(gridLayout_11);
        Label enableLabel_2 = new Label(tandyGroup, 0);
        enableLabel_2.setText(this.settings.msg("dialog.template.enabletandy"));
        this.tandy = new Combo(tandyGroup, 8);
        this.tandy.setItems(this.settings.getSettings().getValues("profile", "tandy"));
        this.tandy.setLayoutData(new GridData());
        this.tandy.setToolTipText(this.settings.msg("dialog.template.enabletandy.tooltip"));
        Label sampleLabel2 = new Label(tandyGroup, 0);
        sampleLabel2.setText(this.settings.msg("dialog.template.tandyrate"));
        this.tandyrate = new Combo(tandyGroup, 8);
        this.tandyrate.setVisibleItemCount(10);
        this.tandyrate.setItems(this.settings.getSettings().getValues("profile", "tandyrate"));
        this.tandyrate.setLayoutData(new GridData());
        this.tandyrate.setToolTipText(this.settings.msg("dialog.template.tandyrate.tooltip"));
        Group disneyGroup = new Group(composite_4, 0);
        disneyGroup.setLayoutData(new GridData(4, 4, true, false));
        disneyGroup.setText(this.settings.msg("dialog.template.miscellaneous"));
        GridLayout gridLayout_12 = new GridLayout();
        gridLayout_12.numColumns = 2;
        disneyGroup.setLayout(gridLayout_12);
        Label enableLabel_3 = new Label(disneyGroup, 0);
        enableLabel_3.setText(this.settings.msg("dialog.template.enablesoundsource"));
        this.disney = new Button(disneyGroup, 32);
        this.disney.setToolTipText(this.settings.msg("dialog.template.enablesoundsource.tooltip"));
        Composite composite2 = new Composite(disneyGroup, 0);
        composite2.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.numColumns = 2;
        composite2.setLayout(gridLayout2);
        Label mt32RateLabel = new Label(composite2, 0);
        mt32RateLabel.setText(this.settings.msg("dialog.template.mt32rate"));
        this.mt32rate = new Combo(composite2, 8);
        this.mt32rate.setVisibleItemCount(10);
        this.mt32rate.setItems(this.settings.getSettings().getValues("profile", "mt32rate"));
    }

    protected void createMachineTab(TabFolder tabFolder) {
        TabItem machineTabItem = new TabItem(tabFolder, 0);
        machineTabItem.setText(this.settings.msg("dialog.template.tab.machine"));
        Composite composite_3 = new Composite(tabFolder, 0);
        GridLayout gridLayout_2 = new GridLayout();
        composite_3.setLayout(gridLayout_2);
        machineTabItem.setControl(composite_3);
        Group cpuGroup = new Group(composite_3, 0);
        cpuGroup.setText(this.settings.msg("dialog.template.cpu"));
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 6;
        cpuGroup.setLayout(gridLayout_3);
        Label machineLabel = new Label(cpuGroup, 0);
        machineLabel.setText(this.settings.msg("dialog.template.machine"));
        this.machine = new Combo(cpuGroup, 8);
        this.machine.setLayoutData(new GridData());
        this.machine.setVisibleItemCount(20);
        this.machine.setToolTipText(this.settings.msg("dialog.template.machine.tooltip"));
        Label cputypeLabel = new Label(cpuGroup, 0);
        cputypeLabel.setText(this.settings.msg("dialog.template.cputype"));
        this.cpu_type = new Combo(cpuGroup, 8);
        this.cpu_type.setItems(this.settings.getSettings().getValues("profile", "cputype"));
        this.cpu_type.setLayoutData(new GridData());
        this.cpu_type.setVisibleItemCount(10);
        this.cpu_type.setToolTipText(this.settings.msg("dialog.template.cputype.tooltip"));
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        Label coreLabel = new Label(cpuGroup, 0);
        coreLabel.setText(this.settings.msg("dialog.template.core"));
        this.core = new Combo(cpuGroup, 8);
        this.core.setItems(this.settings.getSettings().getValues("profile", "core"));
        this.core.setLayoutData(new GridData());
        this.core.setToolTipText(this.settings.msg("dialog.template.core.tooltip"));
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        Label cyclesLabel = new Label(cpuGroup, 0);
        cyclesLabel.setText(this.settings.msg("dialog.template.cycles"));
        this.cycles = new Combo(cpuGroup, 0);
        this.cycles.setItems(this.settings.getSettings().getValues("profile", "cycles"));
        this.cycles.setLayoutData(new GridData(100, -1));
        this.cycles.setVisibleItemCount(15);
        this.cycles.setToolTipText(this.settings.msg("dialog.template.cycles.tooltip"));
        Label upLabel = new Label(cpuGroup, 0);
        upLabel.setLayoutData(new GridData());
        upLabel.setText(this.settings.msg("dialog.template.up"));
        this.cycles_up = new Combo(cpuGroup, 0);
        this.cycles_up.setItems(this.settings.getSettings().getValues("profile", "cycles_up"));
        this.cycles_up.setLayoutData(new GridData(75, -1));
        this.cycles_up.setToolTipText(this.settings.msg("dialog.template.up.tooltip"));
        Label downLabel = new Label(cpuGroup, 0);
        downLabel.setLayoutData(new GridData());
        downLabel.setText(this.settings.msg("dialog.template.down"));
        this.cycles_down = new Combo(cpuGroup, 0);
        this.cycles_down.setItems(this.settings.getSettings().getValues("profile", "cycles_down"));
        this.cycles_down.setLayoutData(new GridData(75, -1));
        this.cycles_down.setToolTipText(this.settings.msg("dialog.template.down.tooltip"));
        Label timesynchedLabel = new Label(cpuGroup, 0);
        timesynchedLabel.setText(this.settings.msg("dialog.template.timesynched"));
        this.timesynched = new Button(cpuGroup, 32);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        new Label(cpuGroup, 0);
        this.memoryGroup = new Group(composite_3, 0);
        this.memoryGroup.setText(this.settings.msg("dialog.template.memory"));
        this.memoryGroup.setLayoutData(new GridData());
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        this.memoryGroup.setLayout(gridLayout_4);
        Label sizeLabel = new Label(this.memoryGroup, 0);
        sizeLabel.setText(this.settings.msg("dialog.template.memorysize"));
        this.memsize = new Combo(this.memoryGroup, 8);
        this.memsize.setItems(this.settings.getSettings().getValues("profile", "memsize"));
        this.memsize.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.memsize.setToolTipText(this.settings.msg("dialog.template.memorysize.tooltip"));
        new Label(this.memoryGroup, 0);
        new Label(this.memoryGroup, 0);
        Label xmsLabel = new Label(this.memoryGroup, 0);
        xmsLabel.setText(this.settings.msg("dialog.template.xms"));
        this.xms = new Button(this.memoryGroup, 32);
        this.xms.setToolTipText(this.settings.msg("dialog.template.xms.tooltip"));
        new Label(this.memoryGroup, 0);
        new Label(this.memoryGroup, 0);
        Label emsLabel = new Label(this.memoryGroup, 0);
        emsLabel.setText(this.settings.msg("dialog.template.ems"));
        this.ems = new Combo(this.memoryGroup, 8);
        this.ems.setItems(this.settings.getSettings().getValues("profile", "ems"));
        this.ems.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.ems.setToolTipText(this.settings.msg("dialog.template.ems.tooltip"));
        new Label(this.memoryGroup, 0);
        new Label(this.memoryGroup, 0);
        Label umbLabel = new Label(this.memoryGroup, 0);
        umbLabel.setText(this.settings.msg("dialog.template.umb"));
        this.umb = new Combo(this.memoryGroup, 8);
        this.umb.setItems(this.settings.getSettings().getValues("profile", "umb"));
        this.umb.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.umb.setToolTipText(this.settings.msg("dialog.template.umb.tooltip"));
        new Label(this.memoryGroup, 0);
        new Label(this.memoryGroup, 0);
    }

    protected void createDisplayTab(TabFolder tabFolder) {
        TabItem displayTabItem = new TabItem(tabFolder, 0);
        displayTabItem.setText(this.settings.msg("dialog.template.tab.display"));
        Composite composite_2 = new Composite(tabFolder, 0);
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 4;
        composite_2.setLayout(gridLayout_5);
        displayTabItem.setControl(composite_2);
        Label outputLabel = new Label(composite_2, 0);
        outputLabel.setText(this.settings.msg("dialog.template.output"));
        this.output = new Combo(composite_2, 8);
        this.output.setItems(this.settings.getSettings().getValues("profile", "output"));
        this.output.setVisibleItemCount(10);
        this.output.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.output.setToolTipText(this.settings.msg("dialog.template.output.tooltip"));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label frameskipLabel = new Label(composite_2, 0);
        frameskipLabel.setText(this.settings.msg("dialog.template.frameskip"));
        this.frameskip = new Combo(composite_2, 8);
        this.frameskip.setItems(this.settings.getSettings().getValues("profile", "frameskip"));
        this.frameskip.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.frameskip.setToolTipText(this.settings.msg("dialog.template.frameskip.tooltip"));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label scalerLabel = new Label(composite_2, 0);
        scalerLabel.setText(this.settings.msg("dialog.template.scaler"));
        this.scaler = new Combo(composite_2, 8);
        this.scaler.setItems(this.settings.getSettings().getValues("profile", "scaler"));
        this.scaler.setVisibleItemCount(15);
        this.scaler.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.scaler.setToolTipText(this.settings.msg("dialog.template.scaler.tooltip"));
        Label forcedLabel = new Label(composite_2, 0);
        forcedLabel.setText(this.settings.msg("dialog.template.scalerforced"));
        this.scaler_forced = new Button(composite_2, 32);
        this.scaler_forced.setToolTipText(this.settings.msg("dialog.template.scalerforced.tooltip"));
        Label fullscreenLabel = new Label(composite_2, 0);
        fullscreenLabel.setText(this.settings.msg("dialog.template.fullscreen"));
        this.fullscreen = new Button(composite_2, 32);
        this.fullscreen.setToolTipText(this.settings.msg("dialog.template.fullscreen.tooltip"));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label doubleBuffLabel = new Label(composite_2, 0);
        doubleBuffLabel.setText(this.settings.msg("dialog.template.doublebuffering"));
        this.fulldouble = new Button(composite_2, 32);
        this.fulldouble.setToolTipText(this.settings.msg("dialog.template.doublebuffering.tooltip"));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label resolutionLabel = new Label(composite_2, 0);
        resolutionLabel.setText(this.settings.msg("dialog.template.fullscreenresolution"));
        this.fullresolution = new Combo(composite_2, 8);
        this.fullresolution.setItems(this.settings.getSettings().getValues("profile", "fullresolution"));
        this.fullresolution.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.fullresolution.setVisibleItemCount(10);
        this.fullresolution.setToolTipText(this.settings.msg("dialog.template.fullscreenresolution.tooltip"));
        Label windowResLabel = new Label(composite_2, 0);
        windowResLabel.setText(this.settings.msg("dialog.template.windowresolution"));
        this.windowresolution = new Combo(composite_2, 8);
        this.windowresolution.setItems(this.settings.getSettings().getValues("profile", "windowresolution"));
        this.windowresolution.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.windowresolution.setVisibleItemCount(10);
        this.windowresolution.setToolTipText(this.settings.msg("dialog.template.windowresolution.tooltip"));
        Label aspectLabel = new Label(composite_2, 0);
        aspectLabel.setText(this.settings.msg("dialog.template.aspectcorrection"));
        this.aspect = new Button(composite_2, 32);
        this.aspect.setToolTipText(this.settings.msg("dialog.template.aspectcorrection.tooltip"));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label pixelshaderLabel = new Label(composite_2, 0);
        pixelshaderLabel.setLayoutData(new GridData());
        pixelshaderLabel.setText(this.settings.msg("dialog.template.pixelshader"));
        this.pixelshader = new Combo(composite_2, 8);
        this.pixelshader.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.pixelshader.setVisibleItemCount(15);
        this.pixelshader.setItems(this.settings.getSettings().getValues("profile", "pixelshader"));
        Label overscanLabel = new Label(composite_2, 0);
        overscanLabel.setText(this.settings.msg("dialog.template.overscan"));
        this.overscan = new Text(composite_2, 2048);
        this.overscan.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label svgaChipsetLabel = new Label(composite_2, 0);
        svgaChipsetLabel.setText(this.settings.msg("dialog.template.svgachipset"));
        this.svgachipset = new Combo(composite_2, 8);
        this.svgachipset.setItems(this.settings.getSettings().getValues("profile", "svgachipset"));
        this.svgachipset.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label videoRamLabel = new Label(composite_2, 0);
        videoRamLabel.setText(this.settings.msg("dialog.template.videoram"));
        this.videoram = new Combo(composite_2, 8);
        this.videoram.setItems(this.settings.getSettings().getValues("profile", "videoram"));
        this.videoram.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label vsyncModeLabel = new Label(composite_2, 0);
        vsyncModeLabel.setText(this.settings.msg("dialog.template.vsyncmode"));
        this.vsyncmode = new Combo(composite_2, 8);
        this.vsyncmode.setItems(this.settings.getSettings().getValues("profile", "vsyncmode"));
        this.vsyncmode.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label vsyncRateLabel = new Label(composite_2, 0);
        vsyncRateLabel.setLayoutData(new GridData());
        vsyncRateLabel.setText(this.settings.msg("dialog.template.vsyncrate"));
        this.vsyncrate = new Text(composite_2, 2048);
        this.vsyncrate.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label glideLabel = new Label(composite_2, 0);
        glideLabel.setText(this.settings.msg("dialog.template.glide"));
        this.glide = new Button(composite_2, 32);
        Label glidePortLabel = new Label(composite_2, 0);
        glidePortLabel.setText(this.settings.msg("dialog.template.glideport"));
        this.glideport = new Text(composite_2, 2048);
        this.glideport.setLayoutData(new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label lfbGlideLabel = new Label(composite_2, 0);
        lfbGlideLabel.setText(this.settings.msg("dialog.template.lfbglide"));
        this.lfbGlide = new Combo(composite_2, 8);
        this.lfbGlide.setItems(this.settings.getSettings().getValues("profile", "lfbglide"));
        this.lfbGlide.setLayoutData(new GridData(4, 0x1000000, true, false));
    }

    protected void createGeneralTab(TabFolder tabFolder) {
        this.generalTabItem = new TabItem(tabFolder, 0);
        this.generalTabItem.setText(this.settings.msg("dialog.template.tab.general"));
        Composite composite_1 = new Composite(tabFolder, 0);
        GridLayout gridLayout_1 = new GridLayout();
        composite_1.setLayout(gridLayout_1);
        this.generalTabItem.setControl(composite_1);
        this.associationGroup = new Group(composite_1, 0);
        this.associationGroup.setText(this.settings.msg("dialog.template.association"));
        this.associationGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 5;
        this.associationGroup.setLayout(gridLayout_4);
        Label dbversionLabel = new Label(this.associationGroup, 0);
        dbversionLabel.setText(this.settings.msg("dialog.template.dosboxversion"));
        this.dbversion = new Combo(this.associationGroup, 8);
        this.dbversion.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.dbversion.setVisibleItemCount(20);
        this.setButton = new Button(this.associationGroup, 0);
        this.setButton.setText(this.settings.msg("dialog.template.set"));
        this.setButton.setToolTipText(this.settings.msg("dialog.template.set.tooltip"));
        this.setButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doPerformDosboxConfAction(DosboxConfAction.SET);
            }
        });
        this.switchButton = new Button(this.associationGroup, 0);
        this.switchButton.setText(this.settings.msg("dialog.template.switch"));
        this.switchButton.setToolTipText(this.settings.msg("dialog.template.switch.tooltip"));
        this.switchButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doPerformDosboxConfAction(DosboxConfAction.SWITCH);
            }
        });
        this.dbversion.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.setButton.setEnabled(true);
                EditTemplateDialog.this.switchButton.setEnabled(true);
            }
        });
        this.reloadButton = new Button(this.associationGroup, 0);
        this.reloadButton.setText(this.settings.msg("dialog.template.reloadsettings"));
        this.reloadButton.setToolTipText(this.settings.msg("dialog.template.reloadsettings.tooltip"));
        this.reloadButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doPerformDosboxConfAction(DosboxConfAction.RELOAD);
            }
        });
        this.miscGroup = new Group(composite_1, 0);
        this.miscGroup.setText(this.settings.msg("dialog.template.miscellaneous"));
        this.miscGroup.setLayoutData(new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 3;
        this.miscGroup.setLayout(gridLayout_5);
        new Label(this.miscGroup, 0);
        Label activeLabel = new Label(this.miscGroup, 0);
        activeLabel.setText(this.settings.msg("dialog.template.active"));
        Label inactiveLabel = new Label(this.miscGroup, 0);
        inactiveLabel.setText(this.settings.msg("dialog.template.inactive"));
        Label priorityLabel = new Label(this.miscGroup, 0);
        priorityLabel.setText(this.settings.msg("dialog.template.priority"));
        this.priority_active = new Combo(this.miscGroup, 8);
        this.priority_active.setItems(this.settings.getSettings().getValues("profile", "priority_active"));
        this.priority_active.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.priority_active.setToolTipText(this.settings.msg("dialog.template.priority.tooltip"));
        this.priority_inactive = new Combo(this.miscGroup, 8);
        this.priority_inactive.setItems(this.settings.getSettings().getValues("profile", "priority_inactive"));
        this.priority_inactive.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.priority_inactive.setToolTipText(this.settings.msg("dialog.template.priority.tooltip"));
        Label waitOnErrorLabel = new Label(this.miscGroup, 0);
        waitOnErrorLabel.setText(this.settings.msg("dialog.template.waitonerror"));
        this.waitonerror = new Button(this.miscGroup, 32);
        this.waitonerror.setToolTipText(this.settings.msg("dialog.template.waitonerror.tooltip"));
        new Label(this.miscGroup, 0);
        Label exitLabel = new Label(this.miscGroup, 0);
        exitLabel.setText(this.settings.msg("dialog.template.exitafterwards"));
        this.exit = new Button(this.miscGroup, 32);
        new Label(this.miscGroup, 0);
        Label languageFileLabel = new Label(this.miscGroup, 0);
        languageFileLabel.setLayoutData(new GridData());
        languageFileLabel.setText(this.settings.msg("dialog.template.languagefile"));
        this.language = new Text(this.miscGroup, 2048);
        this.language.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.language.setToolTipText(this.settings.msg("dialog.template.languagefile.tooltip"));
        Label capturesLabel = new Label(this.miscGroup, 0);
        capturesLabel.setLayoutData(new GridData());
        capturesLabel.setText(this.settings.msg("dialog.template.captures"));
        this.captures = new Text(this.miscGroup, 2048);
        this.captures.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.captures.setEditable(false);
        this.captures.setToolTipText(this.settings.msg("dialog.template.captures.tooltip"));
        Label configFileLabel = new Label(this.miscGroup, 0);
        configFileLabel.setText(this.settings.msg("dialog.profile.configfile"));
        this.config_file = new Text(this.miscGroup, 2048);
        this.config_file.setLayoutData(new GridData(4, 0x1000000, false, false, 2, 1));
        this.config_file.setEditable(false);
        this.config_file.setText(this.result instanceof Template ? FileUtils.constructCanonicalTemplateFileLocation(((Template)this.result).getId()).getPath() : SettingsDialog.confFilenames[0]);
    }

    protected void createInfoTab(TabFolder tabFolder) {
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText(this.settings.msg("dialog.template.tab.info"));
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout(gridLayout);
        this.infoTabItem.setControl(composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(this.settings.msg("dialog.template.title"));
        this.title = new Text(composite, 2048);
        this.title.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText(this.settings.msg("dialog.template.default"));
        this.defaultButton = new Button(composite, 32);
    }

    protected void selectSettingsByConfiguration(Conf conf) {
        SectionsWrapper sections = conf.getSettings();
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "priority", this.priority_active, (Control)this.priority_inactive);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "waitonerror", this.waitonerror);
        EditTemplateDialog.setFieldIfEnabled(sections, "dosbox", "language", this.language);
        EditTemplateDialog.setFieldIfEnabled(this.settings.msg("dialog.profile.automatic"), false, this.captures);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "output", this.output);
        EditTemplateDialog.setFieldIfEnabled(sections, "render", "frameskip", this.frameskip);
        if (sections.isConflictingValue("render", "scaler")) {
            EditTemplateDialog.setFieldIfEnabled(sections, "render", "scaler", this.scaler);
            EditTemplateDialog.setFieldIfEnabled(null, true, this.scaler_forced);
        } else {
            String value = sections.getValue("render", "scaler");
            if (value.endsWith(" forced")) {
                EditTemplateDialog.setFieldIfEnabled(value.substring(0, value.length() - 7), false, this.scaler);
                EditTemplateDialog.setFieldIfEnabled(String.valueOf(true), false, this.scaler_forced);
            } else {
                EditTemplateDialog.setFieldIfEnabled(value, false, this.scaler);
                EditTemplateDialog.setFieldIfEnabled(String.valueOf(false), false, this.scaler_forced);
            }
        }
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "pixelshader", this.pixelshader);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "fullscreen", this.fullscreen);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "fulldouble", this.fulldouble);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "fullresolution", this.fullresolution);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "windowresolution", this.windowresolution);
        EditTemplateDialog.setFieldIfEnabled(sections, "render", "aspect", this.aspect);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "overscan", this.overscan);
        EditTemplateDialog.setFieldIfEnabled(sections, "vga", "svgachipset", this.svgachipset);
        EditTemplateDialog.setFieldIfEnabled(sections, "vga", "videoram", this.videoram);
        EditTemplateDialog.setFieldIfEnabled(sections, "vsync", "vsyncmode", this.vsyncmode);
        EditTemplateDialog.setFieldIfEnabled(sections, "vsync", "vsyncrate", this.vsyncrate);
        EditTemplateDialog.setFieldIfEnabled(sections, "glide", "glide", this.glide);
        EditTemplateDialog.setFieldIfEnabled(sections, "glide", "port", "grport", (Control)this.glideport);
        EditTemplateDialog.setFieldIfEnabled(sections, "glide", "lfb", this.lfbGlide);
        EditTemplateDialog.setFieldIfEnabled(sections, "dosbox", "machine", this.machine);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "cputype", this.cpu_type);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "core", this.core);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "cycles", this.cycles);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "cycleup", this.cycles_up);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "cycledown", this.cycles_down);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "timesynched", this.timesynched);
        EditTemplateDialog.setFieldIfEnabled(sections, "dosbox", "memsize", this.memsize);
        EditTemplateDialog.setFieldIfEnabled(sections, "dos", "xms", this.xms);
        EditTemplateDialog.setFieldIfEnabled(sections, "dos", "ems", this.ems);
        EditTemplateDialog.setFieldIfEnabled(sections, "dos", "umb", this.umb);
        EditTemplateDialog.setFieldIfEnabled(sections, "mixer", "nosound", this.nosound);
        EditTemplateDialog.setFieldIfEnabled(sections, "mixer", "rate", this.rate);
        EditTemplateDialog.setFieldIfEnabled(sections, "midi", "mt32rate", this.mt32rate);
        EditTemplateDialog.setFieldIfEnabled(sections, "mixer", "blocksize", this.blocksize);
        EditTemplateDialog.setFieldIfEnabled(sections, "mixer", "prebuffer", this.prebuffer);
        if (sections.hasValue("midi", "intelligent")) {
            if (sections.isConflictingValue("midi", "mpu401") || sections.isConflictingValue("midi", "intelligent")) {
                EditTemplateDialog.setFieldIfEnabled(null, true, this.mpu401);
            } else {
                EditTemplateDialog.setFieldIfEnabled(sections.getBooleanValue("midi", "mpu401") ? (sections.getBooleanValue("midi", "intelligent") ? "intelligent" : "uart") : "none", false, this.mpu401);
            }
        } else {
            EditTemplateDialog.setFieldIfEnabled(sections, "midi", "mpu401", this.mpu401);
        }
        EditTemplateDialog.setFieldIfEnabled(sections, "midi", "device", "mididevice", (Control)this.midi_device);
        EditTemplateDialog.setFieldIfEnabled(sections, "midi", "config", "midiconfig", (Control)this.midi_config);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "type", "sbtype", (Control)this.sbtype);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "oplmode", this.oplmode);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "oplrate", this.oplrate);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "oplemu", this.oplemu);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "base", "sbbase", (Control)this.sbbase);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "irq", this.irq);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "dma", this.dma);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "hdma", this.hdma);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "mixer", "sbmixer", (Control)this.sbmixer);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "gus", this.gus);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "rate", "gusrate", (Control)this.gusrate);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "base", "gusbase", (Control)this.gusbase);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "irq1", "gusirq", (Control)this.gusirq1);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "irq2", "gusirq", (Control)this.gusirq2);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "dma1", "gusdma", (Control)this.gusdma1);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "dma2", "gusdma", (Control)this.gusdma2);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "ultradir", this.ultradir);
        EditTemplateDialog.setFieldIfEnabled(sections, "speaker", "pcspeaker", this.pcspeaker);
        EditTemplateDialog.setFieldIfEnabled(sections, "speaker", "pcrate", this.pcrate);
        EditTemplateDialog.setFieldIfEnabled(sections, "speaker", "tandy", this.tandy);
        EditTemplateDialog.setFieldIfEnabled(sections, "speaker", "tandyrate", this.tandyrate);
        EditTemplateDialog.setFieldIfEnabled(sections, "speaker", "disney", this.disney);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "autolock", this.autolock);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "sensitivity", this.sensitivity);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "usescancodes", this.usescancodes);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "mapperfile", this.mapperfile);
        EditTemplateDialog.setFieldIfEnabled(sections, "dos", "keyboardlayout", this.keyboard_layout);
        if (sections.hasValue("joystick", "joysticktype")) {
            EditTemplateDialog.setFieldIfEnabled(sections, "joystick", "joysticktype", this.joysticktype);
            EditTemplateDialog.setFieldIfEnabled(sections, "joystick", "timed", this.timed);
            EditTemplateDialog.setFieldIfEnabled(sections, "joystick", "autofire", this.autofire);
            EditTemplateDialog.setFieldIfEnabled(sections, "joystick", "swap34", this.swap34);
            EditTemplateDialog.setFieldIfEnabled(sections, "joystick", "buttonwrap", this.buttonwrap);
        } else {
            EditTemplateDialog.setFieldIfEnabled(sections, "bios", "joysticktype", this.joysticktype);
        }
        EditTemplateDialog.setFieldIfEnabled(sections, "serial", "serial1", this.serial1);
        EditTemplateDialog.setFieldIfEnabled(sections, "serial", "serial2", this.serial2);
        EditTemplateDialog.setFieldIfEnabled(sections, "serial", "serial3", this.serial3);
        EditTemplateDialog.setFieldIfEnabled(sections, "serial", "serial4", this.serial4);
        EditTemplateDialog.setFieldIfEnabled(sections, "ipx", "ipx", this.ipx);
        this.ipxnet.setEnabled(this.ipx.getSelection());
        EditTemplateDialog.setFieldIfEnabled(String.valueOf(conf.getAutoexec().isExit()), Conf.isConflictingValue(conf.getAutoexec().isExit()), this.exit);
        EditTemplateDialog.setFieldIfEnabled(conf.getAutoexec().getMixer(), Conf.isConflictingValue(conf.getAutoexec().getMixer()), this.mixer_config);
        EditTemplateDialog.setFieldIfEnabled(conf.getAutoexec().getKeyb(), Conf.isConflictingValue(conf.getAutoexec().getKeyb()), this.keyb);
        EditTemplateDialog.setFieldIfEnabled(conf.getAutoexec().getIpxnet(), Conf.isConflictingValue(conf.getAutoexec().getIpxnet()), this.ipxnet);
        if (!this.isMultiEdit()) {
            this.mountingpoints.setItems(conf.getAutoexec().getMountingpoints());
            this.dosExpandItem.setExpanded(!conf.getAutoexec().isBooter());
            this.booterExpandItem.setExpanded(conf.getAutoexec().isBooter());
        }
    }

    protected void updateConfigurationBySettings(Conf conf) {
        boolean singleEdit = !this.isMultiEdit();
        conf.updateValue("sdl", "priority", this.priority_active.getText() + "," + this.priority_inactive.getText(), singleEdit || (Boolean)this.priority_active.getData() != false || (Boolean)this.priority_inactive.getData() != false);
        conf.updateValue("sdl", "waitonerror", String.valueOf(this.waitonerror.getSelection()), singleEdit || (Boolean)this.waitonerror.getData() != false);
        conf.updateValue("dosbox", "language", this.language.getText(), singleEdit || (Boolean)this.language.getData() != false);
        conf.updateValue("sdl", "output", this.output.getText(), singleEdit || (Boolean)this.output.getData() != false);
        conf.updateValue("render", "frameskip", this.frameskip.getText(), singleEdit || (Boolean)this.frameskip.getData() != false);
        conf.updateScalerValue(this.scaler.getText(), this.scaler_forced.getSelection(), singleEdit || (Boolean)this.scaler.getData() != false || (Boolean)this.scaler_forced.getData() != false);
        conf.updateValue("sdl", "pixelshader", this.pixelshader.getText(), singleEdit || (Boolean)this.pixelshader.getData() != false);
        conf.updateValue("sdl", "fullscreen", String.valueOf(this.fullscreen.getSelection()), singleEdit || (Boolean)this.fullscreen.getData() != false);
        conf.updateValue("sdl", "fulldouble", String.valueOf(this.fulldouble.getSelection()), singleEdit || (Boolean)this.fulldouble.getData() != false);
        conf.updateValue("sdl", "fullresolution", this.fullresolution.getText(), singleEdit || (Boolean)this.fullresolution.getData() != false);
        conf.updateValue("sdl", "windowresolution", this.windowresolution.getText(), singleEdit || (Boolean)this.windowresolution.getData() != false);
        conf.updateValue("render", "aspect", String.valueOf(this.aspect.getSelection()), singleEdit || (Boolean)this.aspect.getData() != false);
        conf.updateValue("sdl", "overscan", this.overscan.getText(), singleEdit || (Boolean)this.overscan.getData() != false);
        conf.updateValue("vga", "svgachipset", this.svgachipset.getText(), singleEdit || (Boolean)this.svgachipset.getData() != false);
        conf.updateValue("vga", "videoram", this.videoram.getText(), singleEdit || (Boolean)this.videoram.getData() != false);
        conf.updateValue("vsync", "vsyncmode", this.vsyncmode.getText(), singleEdit || (Boolean)this.vsyncmode.getData() != false);
        conf.updateValue("vsync", "vsyncrate", this.vsyncrate.getText(), singleEdit || (Boolean)this.vsyncrate.getData() != false);
        conf.updateValue("glide", "glide", String.valueOf(this.glide.getSelection()), singleEdit || (Boolean)this.glide.getData() != false);
        conf.updateValue("glide", "port", "grport", this.glideport.getText(), singleEdit || (Boolean)this.glideport.getData() != false);
        conf.updateValue("glide", "lfb", this.lfbGlide.getText(), singleEdit || (Boolean)this.lfbGlide.getData() != false);
        conf.updateValue("dosbox", "machine", this.machine.getText(), singleEdit || (Boolean)this.machine.getData() != false);
        conf.updateValue("cpu", "cputype", this.cpu_type.getText(), singleEdit || (Boolean)this.cpu_type.getData() != false);
        conf.updateValue("cpu", "core", this.core.getText(), singleEdit || (Boolean)this.core.getData() != false);
        conf.updateValue("cpu", "cycles", this.cycles.getText(), singleEdit || (Boolean)this.cycles.getData() != false);
        conf.updateValue("cpu", "cycleup", this.cycles_up.getText(), singleEdit || (Boolean)this.cycles_up.getData() != false);
        conf.updateValue("cpu", "cycledown", this.cycles_down.getText(), singleEdit || (Boolean)this.cycles_down.getData() != false);
        conf.updateValue("cpu", "timesynched", String.valueOf(this.timesynched.getSelection()), singleEdit || (Boolean)this.timesynched.getData() != false);
        conf.updateValue("dosbox", "memsize", this.memsize.getText(), singleEdit || (Boolean)this.memsize.getData() != false);
        conf.updateValue("dos", "xms", String.valueOf(this.xms.getSelection()), singleEdit || (Boolean)this.xms.getData() != false);
        conf.updateValue("dos", "ems", this.ems.getText(), singleEdit || (Boolean)this.ems.getData() != false);
        conf.updateValue("dos", "umb", this.umb.getText(), singleEdit || (Boolean)this.umb.getData() != false);
        conf.updateValue("mixer", "nosound", String.valueOf(this.nosound.getSelection()), singleEdit || (Boolean)this.nosound.getData() != false);
        conf.updateValue("mixer", "rate", this.rate.getText(), singleEdit || (Boolean)this.rate.getData() != false);
        conf.updateValue("midi", "mt32rate", this.mt32rate.getText(), singleEdit || (Boolean)this.mt32rate.getData() != false);
        conf.updateValue("mixer", "blocksize", this.blocksize.getText(), singleEdit || (Boolean)this.blocksize.getData() != false);
        conf.updateValue("mixer", "prebuffer", this.prebuffer.getText(), singleEdit || (Boolean)this.prebuffer.getData() != false);
        conf.updateMidiValue(this.mpu401.getText(), singleEdit || (Boolean)this.mpu401.getData() != false);
        conf.updateValue("midi", "device", "mididevice", this.midi_device.getText(), singleEdit || (Boolean)this.midi_device.getData() != false);
        conf.updateValue("midi", "config", "midiconfig", this.midi_config.getText(), singleEdit || (Boolean)this.midi_config.getData() != false);
        conf.updateValue("sblaster", "type", "sbtype", this.sbtype.getText(), singleEdit || (Boolean)this.sbtype.getData() != false);
        conf.updateValue("sblaster", "oplmode", this.oplmode.getText(), singleEdit || (Boolean)this.oplmode.getData() != false);
        conf.updateValue("sblaster", "oplrate", this.oplrate.getText(), singleEdit || (Boolean)this.oplrate.getData() != false);
        conf.updateValue("sblaster", "oplemu", this.oplemu.getText(), singleEdit || (Boolean)this.oplemu.getData() != false);
        conf.updateValue("sblaster", "base", "sbbase", this.sbbase.getText(), singleEdit || (Boolean)this.sbbase.getData() != false);
        conf.updateValue("sblaster", "irq", this.irq.getText(), singleEdit || (Boolean)this.irq.getData() != false);
        conf.updateValue("sblaster", "dma", this.dma.getText(), singleEdit || (Boolean)this.dma.getData() != false);
        conf.updateValue("sblaster", "hdma", this.hdma.getText(), singleEdit || (Boolean)this.hdma.getData() != false);
        conf.updateValue("sblaster", "mixer", "sbmixer", String.valueOf(this.sbmixer.getSelection()), singleEdit || (Boolean)this.sbmixer.getData() != false);
        conf.updateValue("gus", "gus", String.valueOf(this.gus.getSelection()), singleEdit || (Boolean)this.gus.getData() != false);
        conf.updateValue("gus", "rate", "gusrate", this.gusrate.getText(), singleEdit || (Boolean)this.gusrate.getData() != false);
        conf.updateValue("gus", "base", "gusbase", this.gusbase.getText(), singleEdit || (Boolean)this.gusbase.getData() != false);
        conf.updateValue("gus", "irq1", "gusirq", this.gusirq1.getText(), singleEdit || (Boolean)this.gusirq1.getData() != false);
        conf.updateValue("gus", "irq2", this.gusirq2.getText(), singleEdit || (Boolean)this.gusirq2.getData() != false);
        conf.updateValue("gus", "dma1", "gusdma", this.gusdma1.getText(), singleEdit || (Boolean)this.gusdma1.getData() != false);
        conf.updateValue("gus", "dma2", this.gusdma2.getText(), singleEdit || (Boolean)this.gusdma2.getData() != false);
        conf.updateValue("gus", "ultradir", this.ultradir.getText(), singleEdit || (Boolean)this.ultradir.getData() != false);
        conf.updateValue("speaker", "pcspeaker", String.valueOf(this.pcspeaker.getSelection()), singleEdit || (Boolean)this.pcspeaker.getData() != false);
        conf.updateValue("speaker", "pcrate", this.pcrate.getText(), singleEdit || (Boolean)this.pcrate.getData() != false);
        conf.updateValue("speaker", "tandy", this.tandy.getText(), singleEdit || (Boolean)this.tandy.getData() != false);
        conf.updateValue("speaker", "tandyrate", this.tandyrate.getText(), singleEdit || (Boolean)this.tandyrate.getData() != false);
        conf.updateValue("speaker", "disney", String.valueOf(this.disney.getSelection()), singleEdit || (Boolean)this.disney.getData() != false);
        conf.updateValue("sdl", "autolock", String.valueOf(this.autolock.getSelection()), singleEdit || (Boolean)this.autolock.getData() != false);
        conf.updateValue("sdl", "sensitivity", this.sensitivity.getText(), singleEdit || (Boolean)this.sensitivity.getData() != false);
        conf.updateValue("sdl", "usescancodes", String.valueOf(this.usescancodes.getSelection()), singleEdit || (Boolean)this.usescancodes.getData() != false);
        conf.updateValue("sdl", "mapperfile", this.mapperfile.getText(), singleEdit || (Boolean)this.mapperfile.getData() != false);
        conf.updateValue("dos", "keyboardlayout", this.keyboard_layout.getText(), singleEdit || (Boolean)this.keyboard_layout.getData() != false);
        conf.updateJoystickValue(this.joysticktype.getText(), this.timed.getSelection(), this.autofire.getSelection(), this.swap34.getSelection(), this.buttonwrap.getSelection(), singleEdit || (Boolean)this.joysticktype.getData() != false, singleEdit || (Boolean)this.timed.getData() != false, singleEdit || (Boolean)this.autofire.getData() != false, singleEdit || (Boolean)this.swap34.getData() != false, singleEdit || (Boolean)this.buttonwrap.getData() != false);
        conf.updateValue("serial", "serial1", this.serial1.getText(), singleEdit || (Boolean)this.serial1.getData() != false);
        conf.updateValue("serial", "serial2", this.serial2.getText(), singleEdit || (Boolean)this.serial2.getData() != false);
        conf.updateValue("serial", "serial3", this.serial3.getText(), singleEdit || (Boolean)this.serial3.getData() != false);
        conf.updateValue("serial", "serial4", this.serial4.getText(), singleEdit || (Boolean)this.serial4.getData() != false);
        conf.updateValue("ipx", "ipx", String.valueOf(this.ipx.getSelection()), singleEdit || (Boolean)this.ipx.getData() != false);
        if (singleEdit) {
            conf.setAutoexecSettingsForTemplate(this.exit.getSelection(), this.mixer_config.getText(), this.keyb.getText(), this.ipx.getSelection() ? this.ipxnet.getText() : "", this.booterExpandItem.getExpanded());
        }
    }

    protected void doAddMount() {
        EditMountDialog addMountDialog = new EditMountDialog(this.shell);
        try {
            addMountDialog.setDefaultDriveletter(Mount.getFreeDriveletter(this.booterExpandItem.getExpanded(), this.mountingpoints.getItems()));
        }
        catch (Exception e) {
            // empty catch block
        }
        String mount = (String)addMountDialog.open();
        if (mount != null) {
            this.mountingpoints.setItems(this.multiProfileList.get(0).getConf().addMount(mount));
            this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
        }
    }

    protected void doEditMount() {
        int mounts = this.mountingpoints.getItemCount();
        int sel = this.mountingpoints.getSelectionIndex();
        if (sel != -1) {
            EditMountDialog editMountDialog = new EditMountDialog(this.shell);
            editMountDialog.setMount(this.mountingpoints.getItem(sel));
            String mount = (String)editMountDialog.open();
            if (mount != null) {
                this.mountingpoints.setItems(this.multiProfileList.get(0).getConf().editMount(sel, mount));
                if (this.mountingpoints.getItemCount() == mounts) {
                    this.mountingpoints.select(sel);
                } else {
                    this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
                }
            }
        }
    }

    protected void doRemoveMount() {
        int mounts = this.mountingpoints.getItemCount();
        int sel = this.mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) {
            sel = 0;
            this.mountingpoints.select(sel);
        }
        if (sel != -1) {
            this.mountingpoints.setItems(this.multiProfileList.get(0).getConf().removeMount(sel));
            if (this.mountingpoints.getItemCount() == mounts) {
                this.mountingpoints.select(sel);
            } else if (this.mountingpoints.getItemCount() > 0) {
                this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
            }
        }
    }

    protected void enableSettingsByConfiguration(SectionsWrapper conf) {
        this.setButton.setEnabled(false);
        this.switchButton.setEnabled(false);
        Object[] otherValues = null;
        otherValues = conf != null ? (conf.hasValue("cpu", "cputype") ? this.settings.getSettings().getValues("profile", "machine073") : this.settings.getSettings().getValues("profile", "machine")) : this.settings.getSettings().getCommonValues("profile", "machine073", "machine");
        if (!Arrays.equals(this.machine.getItems(), otherValues)) {
            Object obj = this.machine.getData();
            this.machine.setItems((String[])otherValues);
            this.machine.setData(obj);
        }
        EditTemplateDialog.enableDisableControl(conf, "cpu", "cputype", this.cpu_type);
        EditTemplateDialog.enableDisableControl(conf, "dos", "umb", this.umb);
        EditTemplateDialog.enableDisableControl(conf, "sdl", "windowresolution", this.windowresolution);
        EditTemplateDialog.enableDisableControl(conf, "sdl", "pixelshader", this.pixelshader);
        EditTemplateDialog.enableDisableControl(conf, "sdl", "overscan", this.overscan);
        EditTemplateDialog.enableDisableControl(conf, "sdl", "usescancodes", this.usescancodes);
        EditTemplateDialog.enableDisableControl(conf, "vga", "svgachipset", this.svgachipset);
        EditTemplateDialog.enableDisableControl(conf, "vga", "videoram", this.videoram);
        EditTemplateDialog.enableDisableControl(conf, "vsync", "vsyncmode", this.vsyncmode);
        EditTemplateDialog.enableDisableControl(conf, "vsync", "vsyncrate", this.vsyncrate);
        EditTemplateDialog.enableDisableControl(conf, "glide", "glide", this.glide);
        EditTemplateDialog.enableDisableControl(conf, "glide", "port", "grport", this.glideport);
        EditTemplateDialog.enableDisableControl(conf, "glide", "lfb", this.lfbGlide);
        EditTemplateDialog.enableDisableControl(conf, "cpu", "timesynched", this.timesynched);
        EditTemplateDialog.enableDisableControl(conf, "sblaster", "oplemu", this.oplemu);
        EditTemplateDialog.enableDisableControl(conf, "gus", "irq2", this.gusirq2);
        EditTemplateDialog.enableDisableControl(conf, "gus", "dma2", this.gusdma2);
        EditTemplateDialog.enableDisableControl(conf, "midi", "mt32rate", this.mt32rate);
        EditTemplateDialog.enableDisableControl(conf, "speaker", "tandy", this.tandy);
        EditTemplateDialog.enableDisableControl(conf, "bios", "joysticktype", "joystick", "joysticktype", this.joysticktype);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "timed", this.timed);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "autofire", this.autofire);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "swap34", this.swap34);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "buttonwrap", this.buttonwrap);
        EditTemplateDialog.enableDisableControl(conf, "dos", "keyboardlayout", this.keyboard_layout);
        EditTemplateDialog.enableDisableControl(conf, "serial", "serial1", this.serial1);
        EditTemplateDialog.enableDisableControl(conf, "serial", "serial2", this.serial2);
        EditTemplateDialog.enableDisableControl(conf, "serial", "serial3", this.serial3);
        EditTemplateDialog.enableDisableControl(conf, "serial", "serial4", this.serial4);
    }

    protected void doPerformDosboxConfAction(DosboxConfAction action) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            this.updateConfigurationBySettings(this.multiProfileList.get(0).getConf());
            Conf newDosboxVersion = new Conf(this.dbversionsList.get(this.dbversion.getSelectionIndex()), ps);
            if (action == DosboxConfAction.SET) {
                this.multiProfileList.get(0).getConf().setToDosboxVersion(newDosboxVersion);
            } else if (action == DosboxConfAction.SWITCH) {
                this.multiProfileList.get(0).getConf().switchToDosboxVersion(newDosboxVersion);
            } else if (action == DosboxConfAction.RELOAD) {
                this.multiProfileList.get(0).getConf().reloadDosboxVersion(newDosboxVersion);
            }
            this.enableSettingsByConfiguration(this.multiProfileList.get(0).getConf().getDosboxSettings());
            this.selectSettingsByConfiguration(this.multiProfileList.get(0).getConf());
            if (bos.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), bos.toString());
                bos.reset();
            }
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
        }
    }

    protected static void enableDisableControl(SectionsWrapper dbConf, String oldSection, String oldItem, String newSection, String newItem, Control control) {
        control.setEnabled(dbConf != null && (dbConf.hasValue(newSection, newItem) || dbConf.hasValue(oldSection, oldItem)));
    }

    protected static void enableDisableControl(SectionsWrapper dbConf, String section, String oldItem, String newItem, Control control) {
        control.setEnabled(dbConf != null && (dbConf.hasValue(section, newItem) || dbConf.hasValue(section, oldItem)));
    }

    protected static void enableDisableControl(SectionsWrapper dbConf, String section, String item, Control control) {
        control.setEnabled(dbConf != null && dbConf.hasValue(section, item));
    }

    protected static void highlight(Control control, int foreGroundColor) {
        Control[] children = control.getParent().getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] != control) continue;
            if (i > 0) {
                Control target = null;
                if (children[i - 1] instanceof Label) {
                    target = children[i - 1];
                } else if (i + 1 == children.length - 1) {
                    target = children[i + 1];
                } else if (i - 1 > 0 && children[i - 2] instanceof Label) {
                    target = children[i - 2];
                }
                if (target == null) continue;
                target.setForeground(control.getDisplay().getSystemColor(foreGroundColor));
                continue;
            }
            EditTemplateDialog.highlight(control.getParent(), foreGroundColor);
        }
    }

    protected static void setFieldIfEnabled(String value, boolean isConflictingValue, AutoSelectCombo combo) {
        if (isConflictingValue) {
            EditTemplateDialog.highlight(combo.getControl(), 4);
        } else if (!combo.getText().equals(value)) {
            combo.setText(value);
        }
    }

    protected static void setFieldIfEnabled(String value, boolean isConflictingValue, Control control) {
        if (control.isEnabled()) {
            if (control instanceof Text) {
                if (isConflictingValue) {
                    EditTemplateDialog.highlight(control, 4);
                } else if (!((Text)control).getText().equals(value)) {
                    ((Text)control).setText(value);
                }
            } else if (control instanceof Combo) {
                if (isConflictingValue) {
                    EditTemplateDialog.highlight(control, 4);
                } else if (!((Combo)control).getText().equals(value)) {
                    ((Combo)control).setText(value);
                }
            } else if (control instanceof Button) {
                if (isConflictingValue) {
                    ((Button)control).setSelection(true);
                    ((Button)control).setGrayed(true);
                    EditTemplateDialog.highlight(control, 4);
                } else {
                    boolean newValue = Boolean.valueOf(value);
                    if (((Button)control).getSelection() != newValue || ((Button)control).getGrayed()) {
                        ((Button)control).setSelection(newValue);
                        ((Button)control).notifyListeners(13, new Event());
                    }
                }
            } else if (control instanceof Scale) {
                if (isConflictingValue) {
                    EditTemplateDialog.highlight(control, 4);
                } else {
                    Integer newValue = Integer.valueOf(value);
                    if (((Scale)control).getSelection() != newValue.intValue()) {
                        ((Scale)control).setSelection(newValue);
                    }
                }
            } else if (control instanceof Spinner) {
                if (isConflictingValue) {
                    EditTemplateDialog.highlight(control, 4);
                } else {
                    Integer newValue = Integer.valueOf(value);
                    if (((Spinner)control).getSelection() != newValue.intValue()) {
                        ((Spinner)control).setSelection(newValue);
                    }
                }
            }
        }
    }

    protected static void setFieldIfEnabled(SectionsWrapper conf, String section, String item, Control control) {
        EditTemplateDialog.setFieldIfEnabled(conf.getValue(section, item), conf.isConflictingValue(section, item), control);
    }

    protected static void setFieldIfEnabled(SectionsWrapper conf, String section, String item, Control control1, Control control2) {
        if (conf.isConflictingValue(section, item)) {
            EditTemplateDialog.setFieldIfEnabled(conf.getValue(section, item), conf.isConflictingValue(section, item), control1);
            EditTemplateDialog.setFieldIfEnabled(conf.getValue(section, item), conf.isConflictingValue(section, item), control2);
        } else {
            String value = conf.getValue(section, item);
            String[] seperatedValues = value.split(",");
            if (seperatedValues != null && seperatedValues.length >= 2) {
                EditTemplateDialog.setFieldIfEnabled(seperatedValues[0], false, control1);
                EditTemplateDialog.setFieldIfEnabled(seperatedValues[1], false, control2);
            }
        }
    }

    protected static void setFieldIfEnabled(SectionsWrapper conf, String section, String oldItem, String newItem, Control control) {
        if (conf.hasValue(section, newItem)) {
            EditTemplateDialog.setFieldIfEnabled(conf, section, newItem, control);
        } else {
            EditTemplateDialog.setFieldIfEnabled(conf, section, oldItem, control);
        }
    }

    protected boolean isMultiEdit() {
        return this.multiProfileList.size() > 1;
    }

    protected String fetch(Text t) {
        return (Boolean)t.getData() != false ? t.getText() : null;
    }

    protected String fetch(Combo t) {
        return (Boolean)t.getData() != false ? t.getText() : null;
    }

    protected String fetch(AutoSelectCombo t) {
        return (Boolean)t.getData() != false ? t.getText() : null;
    }

    protected Boolean fetch(Button t) {
        return (Boolean)t.getData() != false ? Boolean.valueOf(t.getSelection()) : null;
    }

    protected int fetch(Scale t) {
        return (Boolean)t.getData() != false ? t.getSelection() : -1;
    }

    protected int fetch(Spinner t) {
        return (Boolean)t.getData() != false ? t.getSelection() : -1;
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.template.required.title"), this.title, this.infoTabItem);
        }
        if (this.setButton.isEnabled()) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.template.required.dosboxassociation"), this.setButton, this.generalTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DosboxConfAction {
        SET,
        SWITCH,
        RELOAD,
        RELOAD_TEMPLATE;

    }
}

